package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TriggerTips;
import com.xunlei.niux.data.vipgame.vo.TriggerTipsUid;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.json.JSONObject;

import javax.faces.context.FacesContext;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TriggerTipsManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TriggerTipsManagedBean.class.getName());
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
	private BaseSo baseSo;
	private int rownum = 0;
	private UploadedFile upfile;
	private String tmid = "";

    public String getTmid() {
		return tmid;
	}
	public void setTmid(String tmid) {
		this.tmid = tmid;
	}
	public UploadedFile getUpfile() {
        return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	public TriggerTipsManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	

	/**
	 * 查询触达系统消息
	 * @return
	 */
	public String getQueryTriggerTipsList(){
		logger.info("start trigger message query");
        this.authenticateRun();//验证运行权限
        TriggerTips message = findBean(TriggerTips.class, "triggertips");

        if(StringUtils.isNotEmpty(message.getLikeTitle())){
            message.setLikeTitle("%"+message.getLikeTitle()+"%");
        }

        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(message);
        pagedFliper.setRecordCount(count);
        List<TriggerTips> list = new ArrayList<TriggerTips>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(message, page);
        }
        Sheet<TriggerTips> sheet = new Sheet<TriggerTips>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增触达系统消息
	 * @return
	 */
	public String add(){
		logger.info("开始触达系统消息添加");		
		TriggerTips message = this.findBean(TriggerTips.class,"triggertips");
		try{
            check(message);
            String displayPage = Arrays.toString(findParameters("sel_displayPage"));
            message.setDisplayPage(displayPage);
            if("1".equals(findParameter("sel_tipstype"))) {
                String jinzuanLevel = Arrays.toString(findParameters("sel_jinzuanLevel"));
                message.setJinzuanLevel(jinzuanLevel);
            }else{
                message.setJinzuanLevel("uid");
            }

            String now = now();
            message.setInputBy(this.currentUserLogo());
            message.setInputTime(now);


            List<Long> uidList = new ArrayList<Long>();
            if("2".equals(findParameter("sel_tipstype"))) {//for uid
                String[] sel_tipstype_uid_tx = findParameter("sel_tipstype_uid_tx").split("\\|");
                for (String uid : sel_tipstype_uid_tx) {
                    if ("".equals(uid)) continue;
                    try {
                        uidList.add(Long.valueOf(uid));
                    } catch (NumberFormatException e) {
                        logger.error(e);
                        throw new XLRuntimeException("uid格式错误");
                    }
                }
                FacadeFactory.INSTANCE.getTriggerMessageBo().saveTriggertipsUid(uidList, message);
            }else {
                baseSo.addObject(message);
            }

            if(message.getDisplayPage().contains("2")){
                syncBox(message);
            }
        }catch(Exception e){
			logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}

    private void saveTriggerTipWithUid(TriggerTips message) throws Exception{
        TriggerTips query = baseSo.findObject(message);
        if(query==null)throw new XLRuntimeException("新增消息为空");
        String[] sel_tipstype_uid_tx = findParameter("sel_tipstype_uid_tx").split("\\|");
        for(String uid:sel_tipstype_uid_tx){
            if("".equals(uid))continue;
            TriggerTipsUid ttu = new TriggerTipsUid();
            ttu.setUid(Long.valueOf(uid));
            ttu.setTriggertipsid(query.getSeqid());
            baseSo.addObject(ttu);
        }
    }

    private void syncBox(TriggerTips message) throws Exception{
//        String url = "http://10.10.10.199:4401/notify/message_server/push_info/distBroadcast?broadcastInfo=%7b%22path%22%3a%22notify.newmessage%22%7d";
        String url = "http://10.1.3.45:4401/notify/message_server/push_info/distBroadcast?broadcastInfo=%7b%22path%22%3a%22notify.newmessage%22%7d";
        logger.info("同步触达tips到盒子url："+url);
        String resp = HttpClientUtil.get(url);
        logger.info("同步触达tips到盒子结果："+resp);
        if(!resp.contains("result=1")){
            throw new XLRuntimeException("推送盒子失败");
        }
    }

    /**
	 * 修改触达系统消息
	 * @return
	 */
	public String edit(){
		logger.info("开始触达系统消息修改");
		this.authenticateEdit();//编辑权限
        if("2".equals(findParameter("sel_tipstype"))) {
            throw new XLRuntimeException("uid推送的触达消息不能修改只能删除！");
        }
		TriggerTips message = this.findBean(TriggerTips.class,"triggertips");
		try{
			check(message);
            if(message.getSeqid()==null||message.getSeqid()==0){
                throw new XLRuntimeException("触达系统序号为空");
            }
            TriggerTips query = new TriggerTips();
            query.setSeqid(message.getSeqid());
            TriggerTips data = baseSo.findObject(query);
            if(data==null){
                throw new XLRuntimeException("找不到该条数据");
            }
            if("uid".equals(data.getJinzuanLevel())){
                throw new XLRuntimeException("uid推送的触达消息不能修改只能删除！");
            }
            data.setTitle(message.getTitle());
            data.setContent(message.getContent());
            String displayPage = Arrays.toString(findParameters("sel_displayPage"));
            data.setDisplayPage(displayPage);
            if("1".equals(findParameter("sel_tipstype"))) {
                String jinzuanLevel = Arrays.toString(findParameters("sel_jinzuanLevel"));
                data.setJinzuanLevel(jinzuanLevel);
            }
            data.setTriggerType(message.getTriggerType());
            data.setStartTime(message.getStartTime());
            data.setEndTime(message.getEndTime());
            data.setLinkUrl(message.getLinkUrl());
            data.setBgPicUrl(message.getBgPicUrl());
			data.setEditBy(this.currentUserLogo());
			data.setEditTime(now());
			baseSo.updateObjectById(data);
            if(data.getDisplayPage().contains("2")){
                syncBox(message);
            }
		}catch(Exception e){
			logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}

    private void check(TriggerTips message) throws Exception{
        if(message==null){
            logger.info("触达系统消息为空");
            throw new XLRuntimeException("触达系统消息为空");

        }
        System.out.println("###trigger###"+BeanUtils.describe(message));
        if(StringUtils.isEmpty(message.getTitle())
                || StringUtils.isEmpty(message.getContent())
                || message.getTriggerType()==null
                || StringUtils.isEmpty(message.getStartTime())
                || StringUtils.isEmpty(message.getLinkUrl())
                || StringUtils.isEmpty(message.getBgPicUrl())
                ){
            throw new XLRuntimeException("标题、内容、触发方式、开始时间、跳转链接和图片不能为空！");
        }

        String[] displayPageArr = findParameters("sel_displayPage");
        if(displayPageArr==null || displayPageArr.length==0){
            throw new XLRuntimeException("显示页面为空");
        }

        if("1".equals(findParameter("sel_tipstype"))){
            String[] jinzuanLevelArr = findParameters("sel_jinzuanLevel");
            if(jinzuanLevelArr==null || jinzuanLevelArr.length==0) {
                throw new XLRuntimeException("金钻等级为空");
            }
        }else if("2".equals(findParameter("sel_tipstype"))){
            if(StringUtils.isEmpty(findParameter("sel_tipstype_uid_tx"))&&
            upfile==null){
                throw new XLRuntimeException("uid为空");
            }
        }

    }

	/**
	 * 删除触达系统消息
	 * @return
	 */
	public String delete(){	
		logger.info("开始触达系统消息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(TriggerTips.class,id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}


}
