package com.xunlei.niux.manager.web.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.TriggerMessage;
import com.xunlei.niux.data.vipgame.vo.TriggerUser;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 触达系统消息业务处理类
 * @author lisu
 *  2013-08-17
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TRIGGERMESSAGE)
public class TriggerMessageManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(TriggerMessageManagedBean.class.getName());
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
	private BaseSo baseSo;
	private int rownum = 0;
	private UploadedFile upfile;
	private String text = "";
	private String tmid = "";
	
	
	public String getTmid() {
		return tmid;
	}
	public void setTmid(String tmid) {
		this.tmid = tmid;
	}
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	public String getText() {
		return text;
	}
	public void setText(String text) {
		this.text = text;
	}
	public TriggerMessageManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 文件上传
	 * @return
	 */
	public String uploadFile(){     		
        String tmid = this.findParameter("tmid");
        System.out.println("tmid:"+tmid);
        this.tmid = tmid;
		if(upfile!=null){
			try {
				String filename=FileUploadUtil.upLoadFile(upfile);
				if(filename != null&& !"".equals(filename)){
					if(filename.indexOf(".txt")!=-1){
						importTxt(filename);
					}else if(filename.indexOf(".xls")!=-1){
						importExcel(filename);
					}
				}
			} catch (Exception e) {
				mergeJsmessage("上传失败，原因：" + e.getMessage());
			}
		}
		System.out.println("text:"+text);
		return text;
	}
	
	/**
	 * 导入txt文件
	 */
	private void importTxt(String filename) throws Exception{
		FileInputStream fis = null;
		BufferedReader br = null;
		try{
			filename = FILEPATH+filename;
			fis = new FileInputStream(filename);
			br = new BufferedReader(new InputStreamReader(fis));
			String readline = br.readLine();
			while(readline != null){
				String uid = readline.trim();
				text +=(uid+"\n");
				readline = br.readLine();
			}			
		}catch(Exception e){
			throw e;
		}finally{
			try{
				if(br != null){
					br.close();
					br = null;
				}
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		
	}
	
	/**
	 * 导入excel文件
	 */
	private void importExcel(String filename) throws Exception{
		FileInputStream fis = null;
		Workbook wb = null;
		org.apache.poi.ss.usermodel.Sheet sheet = null;
		Row row = null;
		try {			
			filename = FILEPATH+filename;
            fis = new FileInputStream(new File(filename));
            wb = WorkbookFactory.create(fis);
            sheet = wb.getSheetAt(0);
        	row = sheet.getRow(0);// 得到标题的内容对象。
			int colNum = row.getPhysicalNumberOfCells(); // 得到标题总列数
			int rowNum = sheet.getLastRowNum(); // 得到总行数
			for (int i = 0; i <= rowNum; i++) { // 正文内容应该从第二行开始,第一行为表头的标题
				row = sheet.getRow(i);
				int j = 0;
				while (j < colNum) {    
					text += ((long)(row.getCell(j).getNumericCellValue())+"\n");
					j++;
				}
			}         
		} catch (Exception e) {
			throw e;
		}finally{
			try{
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}		
	}
	
	public String updateUsers(){
		try{
			String tmid = this.findParameter("seqid");	
			String mytmid = this.findParameter("mytmid");
			String downurl = findParameter("downurl");
			if(mytmid != null && !"".equals(mytmid)){
				tmid = mytmid;
			}
			if(tmid == null||"".equals(tmid)){
				throw new XLRuntimeException("触达系统编号为空");
			}
			if(downurl != null && !"".equals(downurl)){//如果是需要下载
				down(downurl,tmid);
				return "";
			}			
			String showuids = this.findParameter("showuids");
			String ids[] = showuids.split("\n");
			String nowtime = now();
		    for(String id:ids){
		    	id = id.trim();
		    	TriggerUser user = new TriggerUser();
		    	user.setTmid(Long.parseLong(tmid));
		    	user.setUid(id);		    	
		    	TriggerUser tu = baseSo.findObject(user);
		    	if(tu != null){
		    		continue;
		    	}
		    	user.setTime(nowtime);
		    	baseSo.addObject(user);
		    }
		    if(ids != null && ids.length>0){
			    TriggerMessage message =  baseSo.findById(TriggerMessage.class, tmid);
			    message.setIsUser(true);
			    baseSo.updateObjectById(message);
		    }
		}catch(Exception e){
			logger.error("更新失败", e);
			mergeJsmessage("更新失败，原因：" + e.getMessage());
		}				
		return "";
	}
	
	
	/**
	 * 下载地址
	 * @param downurl
	 * @throws Exception
	 */
	private void down(String downurl,String tmid) throws Exception{
		URL url = null;	
		HttpURLConnection httpUrl = null;
		BufferedReader br = null;
		try{
			url = new URL(downurl);			
			httpUrl = (HttpURLConnection) url.openConnection(); 
			httpUrl.connect();
			//获取网络输入流 
			br = new BufferedReader(new InputStreamReader((httpUrl.getInputStream()))); 	
			String uid = br.readLine();
			String nowtime = now();
			while(uid != null){
				uid = uid.trim();
				if("null".equals(uid)){
					uid = br.readLine();
					continue;
				}
				System.out.println("uid:"+uid);
				TriggerUser user = new TriggerUser();
		    	user.setTmid(Long.parseLong(tmid));
		    	user.setUid(uid);		    	
		    	TriggerUser tu = baseSo.findObject(user);
		    	if(tu != null){
		    		uid = br.readLine();
		    		continue;
		    	}
		    	user.setTime(nowtime);
		    	baseSo.addObject(user);
		    	uid = br.readLine();
			}
		}catch(Exception e){
			throw e;
		}finally{
			try{
				if(br !=null){
					br.close();
					br = null;
				}
				if(httpUrl != null){
					httpUrl.disconnect();
					httpUrl = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		
	}
	
	/**
	 * 查询触达系统消息
	 * @return
	 */
	public String getQueryTriggerMessageList(){
		logger.info("start trigger message query");
        this.authenticateRun();//验证运行权限
        TriggerMessage message = findBean(TriggerMessage.class, "triggermessage");
        if(message != null){
        	 Integer locationType = message.getLocationType();
              if(locationType!=null&& locationType.intValue()==-1){
              	message.setLocationType(null);
              }
        }      
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(message);
        pagedFliper.setRecordCount(count);
        List<TriggerMessage> list = new ArrayList<TriggerMessage>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(message, page);
        }
        Sheet<TriggerMessage> sheet = new Sheet<TriggerMessage>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增触达系统消息
	 * @return
	 */
	public String add(){
		logger.info("开始触达系统消息添加");		
		TriggerMessage message = this.findBean(TriggerMessage.class,"triggermessage");	
		try{
			if(message==null){
				logger.info("触达系统消息为空");
				throw new XLRuntimeException("触达系统消息为空");
			}		
			String one_isUser = findParameter("one_isUser");
			System.out.println("one_isUser=======>"+one_isUser);
			if("true".equals(one_isUser)){
				message.setIsUser(true);
			}else{
				message.setIsUser(false);
			}
			String now = now();
			message.setInputBy(this.currentUserLogo());
			message.setInputTime(now);					
			baseSo.addObject(message);		
						
			TriggerMessage tm = new TriggerMessage();
			tm.setInputBy(this.currentUserLogo());
			tm.setInputTime(now);
			TriggerMessage tmessage = baseSo.findObject(tm);
			if(tmessage == null){
				logger.info("触达系统消息为空");
				throw new XLRuntimeException("触达系统消息为空");
			}	
			if(message.getIsUser()){//只有选择的不是所有用户时，才能导入对应vip等级的uid
				Integer vipgrade = tmessage.getVipGrade();
				if(vipgrade != null && vipgrade.intValue()>0){//如果是按vip等级发消息				
					CustomerDetailQuery cdq = new CustomerDetailQuery();
					cdq.setLiveVipGrade(vipgrade);
					List<CustomerDetailQuery> cdqlist = baseSo.findObjects(cdq, new Page());
					for(CustomerDetailQuery cu:cdqlist){
						TriggerUser user = new TriggerUser();
						user.setUid(cu.getUid());
						user.setTmid(tmessage.getSeqid());
						TriggerUser tu = baseSo.findObject(user);
						if(tu != null){
							continue;
						}
						user.setTime(now());
						System.out.println("uid=========>"+cu.getUid());
						baseSo.addObject(user);
					}
				}
			}			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改触达系统消息
	 * @return
	 */
	public String edit(){
		logger.info("开始触达系统消息修改");
		this.authenticateEdit();//编辑权限
		TriggerMessage message = this.findBean(TriggerMessage.class,"triggermessage");	
		try{
			if(message==null){
				logger.info("触达系统消息为空");
				throw new XLRuntimeException("触达系统消息为空");
			}		
			message.setEditBy(this.currentUserLogo());
			message.setEditTime(now());
			baseSo.updateObjectById(message);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除触达系统消息
	 * @return
	 */
	public String delete(){	
		logger.info("开始触达系统消息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(TriggerMessage.class,id);			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
