package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.businesss.TestAcountBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.business.TestAcount;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_TESTACOUNT)
public class TestAcountManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(TestAcountManagedBean.class);

    public String getQueryList() {
        this.authenticateRun();//验证运行权限

        TestAcount testAcount = findBean(TestAcount.class, "testacount");
        if(testAcount.getGameid() == null) {
            testAcount.setGameid(GameCache.getInstance().getGameIdSelectItemList().get(0).getValue().toString());
        }

        final TestAcountBo testAcountBo = FacadeFactory.INSTANCE.getTestAcountBo();
        int count = testAcountBo.count(testAcount);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<TestAcount> list = new ArrayList<TestAcount>();
        if (count > 0) {
            list = testAcountBo.find(testAcount, pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<TestAcount> sheet = new Sheet<TestAcount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public String add() {
        this.authenticateAdd();//验证运行权限

        TestAcount testAcount = findBean(TestAcount.class, "testacount");
        if (testAcount == null) {
            logger.debug("添加内容为空");
            mergeJsmessage("添加失败，原因：编辑内容为空");
            return "";
        }

        try {
            final TestAcountBo testAcountBo = FacadeFactory.INSTANCE.getTestAcountBo();

            UserInfo user=this.currentUserInfo();
            testAcount.setInputby(user.getTrueName());
            testAcount.setInputtime(DateUtil.formatNowByDefault());

            if(!testAcount.getGameid().equals("000000")) {
                testAcount.setGamepayid(testAcount.getGameid().substring(1));

                if(hasAdd(testAcount.getGameid(), testAcount.getCustomerno())) {
                    mergeJsmessage("已经添加过了");
                    return "";
                }

                testAcountBo.insert(testAcount);
            } else {
                //所有游戏添加

                for(Games game : GameCache.getInstance().getAllGames()) {
                    testAcount.setGameid(game.getGameId());
                    testAcount.setGamepayid(game.getGameId().substring(1));

                    if(!hasAdd(testAcount.getGameid(), testAcount.getCustomerno())) {
                        testAcountBo.insert(testAcount);
                    }

                }

            }
        } catch (Exception e) {
            logger.debug("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }


        return "";
    }


    private boolean hasAdd(String gameId, String account) {
        TestAcount testAcount = new TestAcount();
        testAcount.setGameid(gameId);
        testAcount.setCustomerno(account);

        return FacadeFactory.INSTANCE.getTestAcountBo().find(testAcount, 0, 0).size() > 0;
    }

    public String edit() {
        this.authenticateEdit();//

        TestAcount testAcount = findBean(TestAcount.class, "testacount");
        if (testAcount == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            final TestAcountBo testAcountBo = FacadeFactory.INSTANCE.getTestAcountBo();

            TestAcount temp = testAcountBo.findById(testAcount.getSeqid());
            if(temp == null) {
                logger.debug("编辑内容为空");
                mergeJsmessage("编辑失败，原因：编辑内容为空");
                return "";
            }

            temp.setCustomerno(testAcount.getCustomerno());
            temp.setTesttype(testAcount.getTesttype());
            temp.setUserid(testAcount.getUserid());

            UserInfo user=this.currentUserInfo();
            temp.setEditby(user.getTrueName());
            temp.setEdittime(DateUtil.formatNowByDefault());

            testAcountBo.update(testAcount);
        } catch (Exception e) {
            logger.debug("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }

    public String delete() {
        this.authenticateDel();// 添加权限

        long seqids[] = this.findParamSeqids();

        try {
            for (Long seqId : seqids) {
                logger.debug("=======seqId" + seqId);
                FacadeFactory.INSTANCE.getTestAcountBo().delete(seqId.intValue());
            }

            alertJS("删除成功");
        } catch (Exception e) {
            logger.info("删除失败", e);
            alertJS("删除失败，原因：" + e.getMessage());
        }

        return "";
    }


}
