package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.SpreadInfoTimeBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.SpreadInfoTime;
import com.xunlei.niux.data.vipgame.vo.Spreadinfo;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 专题活动业务定时切量控制
 *
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_SPREADINFO_TIME)
public class SpreadInfoTimeManagedBean extends BaseManagedBean {


    public String getQuerySpreadInfoTimeList() {
        this.authenticateRun();//验证运行权限

        SpreadInfoTime spreadInfoTime = findBean(SpreadInfoTime.class, "spreadinfotime");
        if (spreadInfoTime.getSpreadid() == null) {
            spreadInfoTime.setSpreadid(getSpreadId());
        }

        PagedFliper pagedFliper = this.getFliper();
        SpreadInfoTimeBo spreadInfoTimeBo = FacadeFactory.INSTANCE.getSpreadInfoTimeBo();
        int count = spreadInfoTimeBo.count(spreadInfoTime);
        pagedFliper.setRecordCount(count);

        List<SpreadInfoTime> list = new ArrayList<SpreadInfoTime>();
        if (count > 0) {
            list = spreadInfoTimeBo.find(spreadInfoTime,
                    pagedFliper.getPageNo(), pagedFliper.getPageSize());
        }
        Sheet<SpreadInfoTime> sheet = new Sheet<SpreadInfoTime>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    public String edit() {
        this.authenticateRun();

        SpreadInfoTime spreadInfoTime = findBean(SpreadInfoTime.class, "spreadinfotime");

        if (spreadInfoTime == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            SpreadInfoTimeBo spreadInfoTimeBo = FacadeFactory.INSTANCE.getSpreadInfoTimeBo();

            SpreadInfoTime temp = spreadInfoTimeBo.find(spreadInfoTime.getSeqid());
            if (temp == null) {
                logger.debug("编辑内容为空");
                mergeBean("编辑失败，原因：编辑内容为空", "jsmessage");
                return "";
            }


            spreadInfoTimeBo.update(spreadInfoTime);

            getQuerySpreadInfoTimeList();
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeBean("编辑失败，原因：" + e.getMessage(), "jsmessage");
        }

        return "";
    }

    public String add() {
        this.authenticateRun();

        SpreadInfoTime spreadInfoTime = findBean(SpreadInfoTime.class, "spreadinfotime");
        if (spreadInfoTime == null) {
            logger.debug("添加内容为空");
            mergeBean("添加失败，原因：添加内容为空", "jsmessage");
            return "";
        }
        try {

            FacadeFactory.INSTANCE.getSpreadInfoTimeBo().insert(spreadInfoTime);
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeBean("添加失败，原因：" + e.getMessage(), "jsmessage");
        }


        return "";
    }


    public int getSpreadId() {
        String spreadId = findParameter("spreadid");

        return Integer.parseInt(spreadId);

    }

    public String delete() {
        this.authenticateRun();

        String paramseqids = findParameter("delseqids");
        String[] params = paramseqids.split(",");

        try{
            for(String id : params) {

                FacadeFactory.INSTANCE.getSpreadInfoTimeBo().delete(Integer.parseInt(id));
            }
            alertJS("删除成功!");
        } catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e);
        }

        getQuerySpreadInfoTimeList();

        return "";
    }

    public String back() {
        SpreadInfoTime spreadInfoTime = findBean(SpreadInfoTime.class, "spreadinfotime");
        Spreadinfo spreadInfo = new Spreadinfo();
        spreadInfo.setSeqId( Long.parseLong(spreadInfoTime.getSpreadid().toString()));

        mergeBean(spreadInfo, "spreadinfo");


        return "spreadInfoTimeReturn";

    }

    public Map<Boolean, String> getStatusMap() {
        Map<Boolean, String> statusMap = new HashMap<Boolean, String>();

        statusMap.put(Boolean.TRUE, "是");
        statusMap.put(Boolean.FALSE, "否");
        return statusMap;
    }

}
