package com.xunlei.niux.manager.web.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.SeoAdvice;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.template.builder.ITemplateBuilder;
import com.xunlei.niux.manager.web.util.DateUtil;


/**
 * Seo文章业务处理类
 * @author lisu
 *  2013-09-04
 */
public class SeoAdviceManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(SeoAdviceManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	private static final String templateid = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("seoTemplateid");//;
	//private static final String templateid = "000038";
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("advicePhotoPath");//
    private static final String REMOREFILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("remoteAdvicePicPath");
    /**
	   *同步图片命令
	  */
   private static final String SYNCPICCOMMOND = "sync_advice_photo.sh";
	  
	public SeoAdviceManagedBean(){
		baseBo = FacadeFactory.INSTANCE.getBaseSo();

		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
   public void download (){	   
		FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_seolinks.txt"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		FileInputStream fis  = null;
		try {
			fis = new FileInputStream(new File("/tmp/seolinks.txt"));
			ouputStream = response.getOutputStream();
			int ch = fis.read();
			while(ch != -1){
				ouputStream.write(ch);
				ch = fis.read();
			}			   
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try{
				if(fis != null){
					fis.close();
					fis = null;
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		FacesContext.getCurrentInstance().responseComplete();	   
	   
   }
	
	/**
	 * 查询Seo文章
	 * @return
	 */
	public String getQuerySeoAdviceList(){
		logger.info("开始Seo文章查询");
        this.authenticateRun();//验证运行权限
        SeoAdvice advice = findBean(SeoAdvice.class, "seoadvice");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(advice);
        pagedFliper.setRecordCount(count);
        List<SeoAdvice> list = new ArrayList<SeoAdvice>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseBo.findObjects(advice, page);
        }
        Sheet<SeoAdvice> sheet = new Sheet<SeoAdvice>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增Seo文章
	 * @return
	 */
	public String add(){
		logger.info("开始Seo文章添加");		
		SeoAdvice advice = this.findBean(SeoAdvice.class,"seoadvice");	
		try{
			if(advice==null){
				logger.info("Seo文章为空");
				throw new XLRuntimeException("Seo文章为空");
			}		
			advice.setInputBy(this.currentUserLogo());
			String now = now();
			advice.setInputTime(now);
			baseBo.addObject(advice);
			
			//同步图片 
			sync();
	
			//生成模版
			build(advice.getGameId(),templateid);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public String deploy(){
		return "";
	}
	
	/**
	 * 修改Seo文章
	 * @return
	 */
	public String edit(){
		logger.info("开始Seo文章修改");
		this.authenticateEdit();//编辑权限
		SeoAdvice advice = this.findBean(SeoAdvice.class,"seoadvice");	
		try{
			if(advice==null){
				logger.info("Seo文章为空");
				throw new XLRuntimeException("Seo文章为空");
			}	
			advice.setEditBy(this.currentUserLogo());
			advice.setEditTime(now());
			baseBo.updateObjectById(advice);
			
			//同步图片 
			sync();
			
			//生成模版
			build(advice.getGameId(),templateid);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	 /**
	  * 将图片从本地服务器同步到文件服务器上
	  */
	 public void sync(){
		 try {
			 logger.info("开始同步图片,地址:/usr/local/bin/"+SYNCPICCOMMOND);
			 Runtime.getRuntime().exec("/usr/local/bin/"+SYNCPICCOMMOND);			
		} catch (IOException e) {
			logger.info(e.getMessage());
		}
	 }
	 
	
	/**
	 * 删除Seo文章
	 * @return
	 */
	public String delete(){	
		logger.info("开始Seo文章删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseBo.deleteById(SeoAdvice.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 生成模版
	 * @param gameid
	 * @param templdateid
	 * @throws Exception
	 */
	public void build(String gameId,String templateid) throws Exception{
        TemplateSchema templateSchema = new TemplateSchema();
        templateSchema.setTemplateid(templateid);
        templateSchema.setExt1(gameId);
        templateSchema.setIspreview(false);
        final String now = DateUtil.formatNowByDefault();
        templateSchema.setSchematime(now);
        UserInfo user=this.currentUserInfo();
        templateSchema.setInputby(user.getTrueName());
        templateSchema.setInputtime(now);
        templateSchema.setIsexecuted(false);
System.out.println("templateid:"+templateid);      
        HtmlTemplate ht=FacadeFactory.INSTANCE.getHtmlTemplateBo().find(templateid);
System.out.println("getExecclass:"+ht.getExecclass());      
        Class<?> clazz = Class.forName(ht.getExecclass());
        ITemplateBuilder builder = (ITemplateBuilder)clazz.newInstance();
        builder.manualAddTemplateSchema(ht, templateSchema);
	}
}
