package com.xunlei.niux.manager.web.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameContent;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.gameofficial.ArticleBuilder;
import com.xunlei.niux.manager.web.util.Base64Util;

/**
 * 同步旧公告
 * @author Administrator
 *
 */
public class RsyncOldAdvice extends BaseManagedBean{
	private static Set<String> gameSet=new HashSet<String>();
	private static Object lock=new Object();
	public String rsyncadvice(){
		String gameId=this.findParameter("gameId");
		boolean flag=addGame(gameId);
		if(flag==false){
			return "";
		}
		try{
			Games qg=new Games();
			qg.setGameId(gameId);
			List<Games> glist=FacadeFactory.INSTANCE.getGamesBo().findGames(qg, new Page());
			for(Games game:glist){
				rsyncgameadvice(game);
			}
			removeGame(gameId);
			alertJS("同步成功");
			return "";
		}catch(Exception e){
			removeGame(gameId);
			throw new RuntimeException(e);
		}
		
	}
	private  static boolean addGame(String gameId){
		synchronized (lock) {
			if(gameSet.contains(gameId)){
				return false;
			}
			gameSet.add(gameId);
			return true;
		}
	}
	private static void removeGame(String gameId){
		synchronized (lock) {
			if(gameSet.contains(gameId)){
				gameSet.remove(gameId);
			}
		}
	}
	/**
	 * 同步游戏的公告
	 * @param game
	 */
	private void rsyncgameadvice(final Games game)throws Exception{
		GameContent qgc=new GameContent();
		qgc.setGameFK(game.getSeqId());
		List<GameContent> gclist=FacadeFactory.INSTANCE.getGameContentBo().findGameContent(qgc, new Page());
		for(GameContent gc:gclist){
			try{
				copycoldadvice(game, gc);
			}catch(Exception e){
				logger.error(e);
			}
		
		}
	}
	/**
	 * 旧公告拷贝为新公告
	 * @param game
	 * @param gc
	 */
	private void copycoldadvice(final Games game,final GameContent gc)throws Exception{
		if(gc.getAlreadyDelete()){
			return ;
		}
		Advice qa=new Advice();
		qa.setRemark("oldadvice"+gc.getSeqId());
		int count=FacadeFactory.INSTANCE.getAdviceBo().count(qa);
		if(count>0){
			return ;
		}
		Advice advice=new Advice();
		advice.setAdviceType("3");//游戏官网
		advice.setBold(gc.getBold());
		advice.setTitle(gc.getTitle());
		advice.setRed(gc.getRed());
		advice.setPublishDate(gc.getPublishDate().substring(0, 19));
		advice.setDisplayOrder(100);
		advice.setEditBy(gc.getEditBy());
		advice.setEditTime(gc.getEditTime().substring(0,19));
		advice.setInputBy(gc.getInputBy());
		advice.setInputTime(gc.getInputTime().substring(0,19));
		advice.setContent(decodecontent(gc.getContent()));
		advice.setPlatformno(changeoldadvicetype(gc.getContentType()));
		advice.setJump(gc.getJump());
		advice.setJumpUrl(gc.getJumpUrl());
		advice.setGameId(game.getGameId());
		advice.setRemark("oldadvice"+gc.getSeqId());
		advice.setExt1(changeoldadviceext1(gc.getContentType()));
		if(!advice.getJump()){
			//生成公告
			String jumpUrl=new ArticleBuilder().buildArticleBuilder(advice);
			advice.setContenturl(jumpUrl);
			advice.setJumpUrl(jumpUrl);
		}
		FacadeFactory.INSTANCE.getAdviceBo().insert(advice);
	}
	private String changeoldadvicetype(String contentType){
		if("LastNotice".equals(contentType)){
			return "gonggao";
		}
		if("GameMaterial".equals(contentType)){
			return "xinshou";
		}
		if("GameCharacter".equals(contentType)){
			return "tese";
		}
		if("GameStrategy".equals(contentType)){
			return "gonglue";
		}
		throw new RuntimeException("未知类型："+contentType);
	}
	private String changeoldadviceext1(String contentType){
		if("LastNotice".equals(contentType)){
			return "zonghe";
		}
		if("GameMaterial".equals(contentType)){
			return "ziliao";
		}
		if("GameCharacter".equals(contentType)){
			return "tese";
		}
		if("GameStrategy".equals(contentType)){
			return "gonglue";
		}
		throw new RuntimeException("未知类型："+contentType);
	}
	/**
	 * 解码加密内容
	 * @param encodecontent
	 * @return
	 * @throws Exception 
	 */
	private String decodecontent(String encodecontent) throws Exception{
		if(encodecontent==null||"".equals(encodecontent)){
			return "";
		}
		String content=Base64Util.decode(encodecontent);
		content=content.replaceAll("/xlniumanager/fastddd/ueditor/jsp/upload", "http://img.smxj.webgame.kanimg.com/upload");
		content=content.replaceAll("http://http://niuadmin.xunlei.com:8080//xlniuxmanager/fastddd/ueditor/jsp/upload", "http://img.smxj.webgame.kanimg.com/upload");
		return content;
	}
}
