package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.pay.RechargeRecordBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PAYORDER)
public class RechargeRecordManagedBean extends BaseManagedBean {

    public String getQueryList(){
        this.authenticateRun();//验证运行权限

        RechargeRecord rechargeRecord = findBean(RechargeRecord.class, "rechargerecord");

        final RechargeRecordBo rechargeRecordBo = FacadeFactory.INSTANCE.getRechargeRecordBo();
        int count = rechargeRecordBo.count(rechargeRecord);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<RechargeRecord> list = new ArrayList<RechargeRecord>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("rechargeTime", OrderType.DESC);

            list = rechargeRecordBo.find(rechargeRecord, page);
        }
        Sheet<RechargeRecord> sheet = new Sheet<RechargeRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


    public Map<String, String> getStatusRechargeMap() {
        Map<String, String> orderMap = new HashMap<String, String>();

        orderMap.put("0", "待发放");
        orderMap.put("1", "发放中");
        orderMap.put("2", "发放失败");
        orderMap.put("3", "发放成功");

        return orderMap;
    }

    public Object getRechargeTypeMap() {
        Map<String, String> orderMap = new HashMap<String, String>();

        orderMap.put("1", "订单白金会员");
        orderMap.put("2", "订单赠送白金会员");
        orderMap.put("3", "订单赠送游戏币");
        orderMap.put("4", "升级白金会员");

        return orderMap;
    }
}
