package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.RebateType;
import com.xunlei.niux.manager.web.model.BaseManagedBean;


/**
 * 返利申请单处理类
 * @author lisu
 * 2014-10-28
 */
public class RebateTypeManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(RebateTypeManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String,String> rebateTypeMap;
    private static List<SelectItem> rebateTypeList;
      	
	public RebateTypeManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		page.setPageNo(1);
		page.setPageSize(1);
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	public Map<String, String> getRebateTypeMap() {
		if(rebateTypeMap == null){
			initRebateTypeMap();
		}
      
		return rebateTypeMap;
	}
	
	public void initRebateTypeMap(){
		   Map<String,String> tempMap=new HashMap<String,String>();
		   RebateType query=new RebateType();
	        Page mypage = new Page();
	        mypage.addOrder("inputTime", OrderType.DESC);
			List<RebateType> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,mypage);
	        if(bplist!=null){
	        	for(RebateType type:bplist){
	        		tempMap.put(type.getRtypeNo(), type.getRtypeName()); 	
				}
	        }
	        rebateTypeMap=tempMap;
	}
	
	public List<SelectItem> getRebateTypeList(){
		if(rebateTypeList == null){
			initRebateTypeList();
		}		
		return rebateTypeList;
	}
	
	private void initRebateTypeList(){		
		RebateType query=new RebateType();
		query.setIsValid(true);
		List<RebateType> bplist=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,new Page());
		List<SelectItem> siList=new ArrayList<SelectItem>();
		for(RebateType type:bplist){
			siList.add(new SelectItem(type.getRtypeNo(), type.getRtypeName())); 	
		}
		rebateTypeList = siList;
	}
	
	/**
	 * 查询返利申请类型
	 * @return
	 */
	public String getQueryRebateTypeList(){		
	    logger.info("开始返利申请类型查询");
        this.authenticateRun();//验证运行权限
        RebateType query = findBean(RebateType.class, "rebatetype");
        PagedFliper pagedFliper = this.getFliper();    
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<RebateType> list = new ArrayList<RebateType>();  
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        } 
        Sheet<RebateType> sheet = new Sheet<RebateType>(count, list);     
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增返利申请类型
	 * @return
	 */
	public String add(){
		logger.info("开始返利申请类型信息添加");
		this.authenticateAdd();//添加权限
		 RebateType type = findBean(RebateType.class, "rebatetype");
		try{
			if(type==null){
				logger.info("返利申请类型信息为空");
				throw new XLRuntimeException("返利申请类型信息为空");
			}		
			RebateType query = new RebateType();
            query.setRtypeNo(type.getRtypeNo());
            RebateType rtype = baseSo.findObject(query);
            if(rtype != null){
            	logger.info("该返利申请类型已经存在");
				throw new XLRuntimeException("该返利申请类型已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(this.currentUserLogo());
			baseSo.addObject(type);
			initRebateTypeMap();
			initRebateTypeList();
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改返利申请类型
	 * @return
	 */
	public String edit(){
		logger.info("开始返利申请类型信息修改");
		this.authenticateEdit();//编辑权限
		 RebateType type = findBean(RebateType.class, "rebatetype");
		try{
			if(type==null){
				logger.info("返利申请类型信息为空");
				throw new XLRuntimeException("返利申请类型信息为空");
			}
			RebateType query = new RebateType();
			query.setRtypeNo(type.getRtypeNo());
            RebateType myprice = baseSo.findObject(query);
            if(myprice != null){
            	if(myprice.getSeqId() != type.getSeqId()){
                	logger.info("该返利申请类型已经存在");
    				throw new XLRuntimeException("该返利申请类型已经存在");
            	}
            }
            type.setEditTime(now());
            type.setEditBy(this.currentUserLogo());
			baseSo.updateObjectById(type);		
			initRebateTypeMap();
			initRebateTypeList();
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除返利申请类型
	 * @return
	 */
	public String delete(){
		logger.info("开始返利申请类型信息删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");				
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids){
				 baseSo.deleteById(RebateType.class, id);
			}			   
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
