package com.xunlei.niux.manager.web.model;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.xunlei.niux.manager.web.model.lychat.LyChatEmailSender;
import com.xunlei.niux.manager.web.model.tasks.ConcurrentExecutor;
import com.xunlei.niux.manager.web.util.*;
import com.xunlei.niux.manager.web.vo.NiuxEmailVo;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.pay.bo.PayDetailOkBo;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.RebateOrderBo;
import com.xunlei.niux.data.vipgame.dto.RebateOrderGroupByApOrderIdDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CallRecord;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.RebateApply;
import com.xunlei.niux.data.vipgame.vo.RebateOrder;
import com.xunlei.niux.data.vipgame.vo.RebateOrderPhoto;
import com.xunlei.niux.data.vipgame.vo.RebateVoucher;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.model.thread.RebateOrderPassBatchThread;
import com.xunlei.niux.manager.web.model.thread.RebateTask;
import com.xunlei.niux.manager.web.model.thread.RebateThreadPool;
import com.xunlei.niux.manager.web.proxy.BaseAuthFactory;
import com.xunlei.niux.manager.web.proxy.CheckGiftMoneyProxy;
import com.xunlei.niux.manager.web.proxy.IBaseAuth;
import com.xunlei.niux.manager.web.proxy.RebateApplyProxy;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;

/**
 * 返利原始订单业务处理类
 * @author lisu
 *  2013-11-07
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_REBATEAPPLY)
public class RebateOrderManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(RebateOrderManagedBean.class.getName());
	private BaseSo baseSo;
	private PayDetailOkBo payDetailOkBo;
	private RebateOrderBo rebateOrderBo;
	private int rownum = 0;
	private static final String VOUCHERURL = EnvPropertyUtil.loadProperty("niux","voucherurl");
	private static final String LIMITCHECKERS = EnvPropertyUtil.loadProperty("niux","limitcheckers");
	private static final String MAXMONEYCHECKERS = EnvPropertyUtil.loadProperty("niux","maxmoneycheckers");
	private static final String MAXMONEY = EnvPropertyUtil.loadProperty("niux","maxmoney");
	private static final String bizNo = "dkhfdjq";//大客户返代金券业务编号
	private static final String actNo = "customercash";//大客户返代金券活动编号
	private static String generatePrivateKey="wlssfldflinlfslfs";
	private static final SimpleDateFormat DAYSDF = new SimpleDateFormat("yyyy-MM-dd");
	private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");
	private static final  Random RD = new Random();	   
	private static Map<Integer,String> typeMap = RebateApplyManagedBean.typeMap;
	private static String yuanbaourl="http://paysvr.niu.xunlei.com:8090";
	private static String privateKey="89oi8=9kmikmnjjdls;dkkks-xkkoldl";
	private Map<String,Object> resultMap;
	private static final List<Object> queryList = new ArrayList<Object>();
	private static final Page queryPage = new Page();
	
	public RebateOrderManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		payDetailOkBo = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo();
		rebateOrderBo = FacadeFactory.INSTANCE.getRebateOrderBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(final int rownum) {
		this.rownum = rownum;
	}
	
	
    private String getOrderId(){
	   Calendar cal =  Calendar.getInstance();
	   String orderid = SDF.format(cal.getTime());	  
	   return orderid+RD.nextInt(100);
    } 
   
	 /**
	  * 获得该uid 实时的vip等级
	  * @param uid
	  * @return
	  */
	 private int getVipGrade(final String uid){
		 CustomerDetailQuery query = new CustomerDetailQuery();
		 query.setUid(uid);
		 CustomerDetailQuery cdq = baseSo.findObject(query);
		 if(cdq == null)return 0;
		 return cdq.getLiveVipGrade();
	 }
    
	public String getQueryRebateVoucherList(){
		logger.info("开始返利申请单代金券查询");
        this.authenticateRun();//验证运行权限
        RebateVoucher voucher = findBean(RebateVoucher.class, "rebatevoucher");
        String aporderid = this.findParameter("one_aporderid");
        if(voucher != null){
        	if(aporderid == null){
        		voucher.setAporderid("-1");
            }else{
            	voucher.setAporderid(aporderid);
            }
            Long seqid = voucher.getSeqid();
            if(seqid != null && seqid.longValue()==0){
            	voucher.setSeqid(null);
            }
        }        
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(voucher);
        pagedFliper.setRecordCount(count);
        List<RebateVoucher> list = new ArrayList<RebateVoucher>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
            list = baseSo.findObjects(voucher, page);
        }
        Sheet<RebateVoucher> sheet = new Sheet<RebateVoucher>(count, list);
        if(sheet.getRowcount() > 0){
			double price = 0;
			double minMoney = 0;
            for(RebateVoucher rv:list){
            	price += rv.getPrice();
            	minMoney += rv.getMinMoney();
            }
            RebateVoucher sum = new RebateVoucher();
            sum.setBatid("总计");
            sum.setPrice(price);
            sum.setMinMoney(minMoney);
			sheet.getDatas().add(sum);
		}
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}			
	public static long compareTime(final String fromtime,final String totime) throws Exception{
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");  
        Date one = null;
        Date two = null;
        long days=0;  
    	one = df.parse(fromtime);  
    	two = df.parse(totime); 
    	long time1 = one.getTime();  
    	long time2 = two.getTime();  
    	long diff = time1 - time2;       	
    	days = diff / (1000 * 60 * 60 * 24*31);      
		return days;
	}
	
	/**
	 * 充值成功订单查询
	 * @return
	 */
	public String getQueryPayDetailOkList() throws Exception{
		logger.info("开始充值成功订单查询");
        this.authenticateRun();//验证运行权限
        PayDetailOK query = findBean(PayDetailOK.class, "paydetailok");
        if(query == null){
            return "";
        }
        String aporderid = this.findParameter("one_aporderid");
        if(aporderid == null){
            query.setFrominneruserid("-1");
        }
        if(StringTools.isEmpty(query.getFromSuccessTime())
        		&&StringTools.isEmpty(query.getToSuccessTime())){//默认只能查当天的
            Calendar cal = Calendar.getInstance();
            String fromday = DAYSDF.format(cal.getTime());//今天日期
            cal.add(Calendar.DAY_OF_MONTH, 1);
            String today = DAYSDF.format(cal.getTime());//明天日期
            query.setFromSuccessTime(fromday + " 00:00:00");
            query.setToSuccessTime(today + " 00:00:00");
        }
        if(StringTools.isEmpty(query.getFromSuccessTime())){
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.MONTH, -6);
            String fromday = DAYSDF.format(cal.getTime());//最近6个月
            if(compareTime(query.getFromSuccessTime(),fromday)<0){
                query.setFromSuccessTime(fromday);
            }
        }
        if(StringTools.isEmpty(query.getToinneruserid())){
            query.setToinneruserid("-1");
        }
        query.setGiftFlag("0");//目前只支持查询原始订单
        query.setNiuxactno("niuxzfzx");
        PagedFliper pagedFliper = this.getFliper();
        int count = payDetailOkBo.count(query);
        pagedFliper.setRecordCount(count);

        List<PayDetailOK> list = new ArrayList<PayDetailOK>();
        if (count > 0) {
        	Page page=new Page();
//        	page.setPageNo(1);
//        	page.setPageSize(20);
        	page.addOrder("successtime", OrderType.DESC);
            list = payDetailOkBo.findPayDetailOk(query, page);
        }
        List<PayDetailOK> list2 = new ArrayList<PayDetailOK>();
        for(PayDetailOK pdo:list){
        	pdo.setGameid("0"+pdo.getGameid());
            RebateOrder ro = new RebateOrder();
            ro.setOrderid(pdo.getOrderid());
            ro.setIsvalid(true);
            if(baseSo.countObject(ro)==0){
                list2.add(pdo);
            }
        }
        Sheet<PayDetailOK> sheet;
        int listSize =list2.size();
        if (listSize>20) {
            sheet = new Sheet<PayDetailOK>(20, list2.subList(0,20));
        } else {
            sheet = new Sheet<PayDetailOK>(listSize, list2);
        }
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}			
	
	/**
	 * 返利申请单上传图片查询
	 * @return
	 */
	public String getQueryRebateOrderPhotoList(){
		logger.info("开始返利图片查询");
        this.authenticateRun();//验证运行权限
        RebateOrderPhoto photo = findBean(RebateOrderPhoto.class, "rebateorderphoto");
        String aporderid = this.findParameter("one_aporderid");
        if(photo != null){
        	if(aporderid == null){
            	photo.setAporderid("-1");
            }else{
            	photo.setAporderid(aporderid);
            }
            Long seqid = photo.getSeqid();
            if(seqid != null && seqid.longValue()==0){
            	photo.setSeqid(null);
            }
        }       
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(photo);
        pagedFliper.setRecordCount(count);
        List<RebateOrderPhoto> list = new ArrayList<RebateOrderPhoto>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
            list = baseSo.findObjects(photo, page);
        }
        Sheet<RebateOrderPhoto> sheet = new Sheet<RebateOrderPhoto>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}			
	
	
	/**
	 * 查询返利订单
	 * @return
	 */
	public String getQueryRebateOrderList(){
		logger.info("开始返利订单查询");
        this.authenticateRun();//验证运行权限
        RebateOrder apply = findBean(RebateOrder.class, "rebateorder");
        String aporderid = this.findParameter("one_aporderid");
        if(aporderid == null){
        	apply.setAporderid("-1");
        }
        Long seqid = apply.getSeqid();
        String orderid = apply.getOrderid();
        Integer percent = apply.getPercent();
        Integer consumepercent = apply.getConsumePercent();
        if(seqid != null && seqid.longValue()==0){
        	apply.setSeqid(null);
        }
        if(percent != null && percent.intValue()==0){
        	apply.setPercent(null);
        }
        if(consumepercent != null&& consumepercent.intValue()==0){
        	apply.setConsumePercent(null);
        }
        if(orderid != null && "".equals(orderid)){
        	apply.setOrderid(null);
        }
        if(aporderid != null&& !"".equals(aporderid)){
        	apply.setAporderid(aporderid);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(apply);
        pagedFliper.setRecordCount(count);
        List<RebateOrder> list = new ArrayList<RebateOrder>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(1);
        	page.setPageSize(100);
        	page.addOrder("seqid", OrderType.DESC);
            list = baseSo.findObjects(apply, page);
        }
        Sheet<RebateOrder> sheet = new Sheet<RebateOrder>(count, list);
        if(sheet.getRowcount() > 0){
			double consumeMoney = 0;
			double rebateMoney = 0;
			double payMoney = 0;
            for(RebateOrder ro:list){
            	consumeMoney += ro.getConsumeMoney();
            	rebateMoney += ro.getRebateMoney();
            	payMoney += ro.getPayMoney();
            }
            RebateOrder sum = new RebateOrder();
            sum.setOrderid("总计");
            sum.setConsumeMoney(new Double(consumeMoney).intValue()+0.0);
            sum.setRebateMoney(new Double(rebateMoney).intValue()+0.0);
            sum.setPayMoney(new Double(payMoney).intValue()+0.0);
			sheet.getDatas().add(sum);
		}
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}			
	
	
	/**
	 * 根据账号查询uid
	 * @param account
	 * @return
	 */
	private String getUidByAccount(final String account){
		return findUidByName(account);
	}
	
	public Map<String,Object>  getInitOrderMap(){
		Map<String,Object>  orderMap = new HashMap<String,Object>();
		String one_aporderid = this.findParameter("one_aporderid");//返利申请单号
		String one_orderid = this.findParameter("one_orderid");//订单号
		String one_percent = this.findParameter("one_percent");//返利比例
		String one_consumePercent = this.findParameter("one_consumePercent");//消耗比例
		String one_applyType = this.findParameter("one_applyType");//返利类型
		System.out.println("one_aporderid:"+one_aporderid);
		if(StringTools.isEmpty(one_aporderid)){
			orderMap.put("orderTime", "");
			orderMap.put("money", "");
			orderMap.put("payMoney", "");
			orderMap.put("rebatemoney", "");
			orderMap.put("consumeMoney", "0");
			orderMap.put("uid", "");
			orderMap.put("vipGrade", "");
			orderMap.put("toaccount", "");
			orderMap.put("serverid", "");
			orderMap.put("gameid", "");
			orderMap.put("gameName", "");
			return orderMap;
		}
		
		if(one_applyType != null&&"4".equals(one_applyType)){//如果是赠送补偿返利
			    String accountstatus = this.findParameter("accountstatus");
			    if("1".equals(accountstatus)){
			    	String toaccount = this.findParameter("one_toaccount");//账号
			    	Map<String,Object> map = resultMap;
			    	if(map != null){
			    		String mytoaccount = (String)map.get("toaccount");
			    		String my_aporderid = (String)map.get("one_aporderid");
			    		if(toaccount.trim().equals(mytoaccount)&&my_aporderid.equals(one_aporderid)){
			    			return map;
			    		}
			    	}			    	

					String uid = getUidByAccount(toaccount);
					CustomerDetailQuery  query = new CustomerDetailQuery();
					query.setUid(uid);
					CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
					orderMap.put("uid", uid);
					orderMap.put("vipGrade", cdq.getLiveVipGrade());
					orderMap.put("toaccount", toaccount);
					orderMap.put("gameid", "");
					orderMap.put("gameName", "");
					RebateOrder order = new RebateOrder();
					order.setAporderid(one_aporderid);
					List<RebateOrder> rolist = baseSo.findObjects(order, queryPage);
					double consumeMoney = 0;
					double rebateMoney = 0;
					double totalMoney = 0;
					for(RebateOrder ro:rolist){
						rebateMoney += ro.getRebateMoney();
						consumeMoney += ro.getConsumeMoney();
						totalMoney += ro.getPayMoney();
					}
					int abc = new Double(rebateMoney).intValue()+new Double(consumeMoney).intValue();
					orderMap.put("allpaymoney",abc );//支付总金额
					orderMap.put("allmoney",totalMoney );//支付总金额
					orderMap.put("allconsumemoney",new Double((int)consumeMoney) );//支付总金额
					orderMap.put("allrebatemoney",new Double((int)rebateMoney) );//支付总金额
					orderMap.put("one_aporderid", one_aporderid);
					resultMap = orderMap;
					return orderMap;
			    }				
		}
		
		/**
		 * 如果输入了订单号
		 */
		if(!StringTools.isEmpty(one_orderid)){//如果输入订单号，需要动态查询出结果
			PayDetailOK payDetailOk = new PayDetailOK();
			payDetailOk.setOrderid(one_orderid);
			payDetailOk.setGiftFlag("0");//只有原始订单可以添加
			Page page = new Page();
			List<PayDetailOK> pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
			if(pdoklist==null || pdoklist.size()==0){
				payDetailOk.setGiftFlag("2");//查询是否是代金券订单
			    pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
				if(pdoklist==null || pdoklist.size()==0){
					orderMap.put("orderTime", "");
					orderMap.put("money", "");
					orderMap.put("payMoney", "");
					orderMap.put("rebatemoney", "");
					orderMap.put("consumeMoney", "0");
					orderMap.put("uid", "");
					orderMap.put("vipGrade", "");
					orderMap.put("toaccount", "");
					orderMap.put("serverid", "");
					orderMap.put("gameid", "");
					orderMap.put("gameName", "");
					orderMap.put("message", "该订单非充值订单");
					return orderMap;
				}				
			}
			PayDetailOK pdok = pdoklist.get(0);

            //非充值中心活动编号
            if(!"niuxzfzx".equals(pdok.getNiuxactno())
                    && !"cqbymrt".equals(pdok.getNiuxactno())){//
                orderMap.put("orderTime", "");
                orderMap.put("money", "");
                orderMap.put("payMoney", "");
                orderMap.put("rebatemoney", "");
                orderMap.put("consumeMoney", "0");
                orderMap.put("uid", "");
                orderMap.put("vipGrade", "");
                orderMap.put("toaccount", "");
                orderMap.put("serverid", "");
                orderMap.put("gameid", "");
                orderMap.put("gameName", "");
                orderMap.put("message", "非活动编号niuxzfzx|cqbymrt，该订单编号为:"+pdok.getNiuxactno());
                return orderMap;
            }


			if("2".equals(pdok.getGiftFlag())){//如果是代金券订单
				if(pdok.getPayMondey()==null||pdok.getPayMondey().intValue()==0){
					orderMap.put("orderTime", "");
					orderMap.put("money", "");
					orderMap.put("payMoney", "");
					orderMap.put("rebatemoney", "");
					orderMap.put("consumeMoney", "0");
					orderMap.put("uid", "");
					orderMap.put("vipGrade", "");
					orderMap.put("toaccount", "");
					orderMap.put("serverid", "");
					orderMap.put("gameid", "");
					orderMap.put("gameName", "");
					orderMap.put("message", "该代金券订单的充值金额为0");
					return orderMap;
				}
			}
			/**
			 * 如果输入了返利比例
			 */
			if(!StringTools.isEmpty(one_percent)){//如果输入了返利比例		
				int rebatemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_percent)/100);
				orderMap.put("rebateMoney",rebatemoney);//返利金额
				orderMap.put("message","");
				RebateOrder order = new RebateOrder();
				order.setAporderid(one_aporderid);
				List<RebateOrder> orderlist = baseSo.findObjects(order, page);
				if(orderlist == null||orderlist.size()==0){
					orderMap.put("allrebatemoney", rebatemoney);//返利总金额
					orderMap.put("allmoney", pdok.getPayMondey());//充值总金额
					if(!StringTools.isEmpty(one_consumePercent)){
						int consumemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_consumePercent)/100);
						orderMap.put("allconsumemoney", consumemoney);//消耗总金额
						orderMap.put("allpaymoney", consumemoney+rebatemoney);//支付总金额
					}else{
						orderMap.put("allconsumemoney", 0);//消耗总金额
						orderMap.put("allpaymoney",rebatemoney);//支付总金额
					}
				}else{
					double  allmoney = 0;
					double  allrebatemoney = 0;
					double allconsumemoney = 0;
					for(RebateOrder ro:orderlist){
						allmoney += ro.getPayMoney();
						allrebatemoney += ro.getRebateMoney();
						allconsumemoney += ro.getConsumeMoney();
					}
					orderMap.put("allrebatemoney", new Double(allrebatemoney+rebatemoney).intValue());//返利总金额
					orderMap.put("allmoney", new Double(allmoney+pdok.getPayMondey()).intValue());//充值总金额
					if(!StringTools.isEmpty(one_consumePercent)){
						int consumemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_consumePercent)/100);
						orderMap.put("allconsumemoney", new Double(allconsumemoney+consumemoney).intValue());//消耗总金额
						orderMap.put("allpaymoney",new Double(allconsumemoney+consumemoney+allrebatemoney+rebatemoney).intValue());//支付总金额
					}else{
						orderMap.put("allconsumemoney", new Double(allconsumemoney).intValue());//消耗总金额
						orderMap.put("allpaymoney",new Double(allrebatemoney+allrebatemoney+rebatemoney).intValue());//支付总金额
					}
				}
			/**
			 * 如果只输入了订单号，没有输入返利比例	
			 */
			}else{
				orderMap.put("rebateMoney","");//返利金额
				RebateOrder order = new RebateOrder();
				order.setAporderid(one_aporderid);
				List<RebateOrder> orderlist = baseSo.findObjects(order, page);
				if(orderlist == null||orderlist.size()==0){
					orderMap.put("allrebatemoney", 0);//返利总金额
					orderMap.put("allmoney", new Double(pdok.getPayMondey()).intValue());//充值总金额
				}else{
					double  allmoney = 0;
					double  allrebatemoney = 0;
					for(RebateOrder ro:orderlist){
						allmoney += ro.getPayMoney();
						allrebatemoney += ro.getRebateMoney();
					}
					orderMap.put("allrebatemoney", new Double(allrebatemoney).intValue());//返利总金额
					orderMap.put("allmoney", new Double(allmoney+pdok.getPayMondey()).intValue());//充值总金额
				}				
			}
			/**
			 * 如果输入了消耗比例
			 */
			if(!StringTools.isEmpty(one_consumePercent)){//如果输入了消耗比例
				int consumemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_consumePercent)/100);
				orderMap.put("consumeMoney",consumemoney);//消耗金额
				orderMap.put("message","");
				RebateOrder order = new RebateOrder();
				order.setAporderid(one_aporderid);
				List<RebateOrder> orderlist = baseSo.findObjects(order, page);
				if(orderlist == null||orderlist.size()==0){
					orderMap.put("allconsumemoney", consumemoney);//消耗总金额
					if(!StringTools.isEmpty(one_percent)){
						int rebatemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_percent)/100);
						orderMap.put("rebateMoney",rebatemoney);//返利金额
						orderMap.put("allpaymoney",consumemoney+rebatemoney);//支付总金额
					}else{
						orderMap.put("rebateMoney", 0);//消耗总金额
						orderMap.put("allpaymoney",consumemoney);//支付总金额
					}
				}else{
					double  allmoney = 0;
					double  allrebatemoney = 0;
					double allconsumemoney = 0;
					for(RebateOrder ro:orderlist){
						allmoney += ro.getPayMoney();
						allrebatemoney += ro.getRebateMoney();
						allconsumemoney += ro.getConsumeMoney();
					}
					orderMap.put("allconsumemoney", allconsumemoney+consumemoney);//消耗总金额
					orderMap.put("allmoney", allmoney+pdok.getPayMondey());//充值总金额
					if(!StringTools.isEmpty(one_percent)){
						int rebatemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_percent)/100);
						orderMap.put("allrebatemoney", new Double(allrebatemoney+rebatemoney).intValue());//返利总金额
						orderMap.put("allpaymoney",new Double(allrebatemoney+allconsumemoney+consumemoney+rebatemoney).intValue());//支付总金额
					}else{
						orderMap.put("allrebatemoney", new Double(allrebatemoney).intValue());//返利总金额
						orderMap.put("allpaymoney",new Double(allrebatemoney+allconsumemoney+consumemoney).intValue());//支付总金额
					}					
				}
				if(!StringTools.isEmpty(one_percent)){//如果同时也输入了返利比例
					int rebatemoney = (int)(pdok.getPayMondey()*Double.parseDouble(one_percent)/100);
					orderMap.put("rebateMoney",rebatemoney);//返利金额
				}		
			}
			
			/**
			 * 查询订单号是否存在
			 */
			RebateOrder order = new RebateOrder();
			order.setOrderid(one_orderid);//原始订单号
			order.setIsvalid(true);//有效的订单		
			RebateOrder ra = baseSo.findObject(order);
			orderMap.put("message", "");
			if(ra == null){//如果是新增
				RebateOrder order2 = new RebateOrder();
		        order2.setOrderid(one_orderid);//同一个原始订单
		        order2.setAporderid(one_aporderid);//同一个返利申请单
		        RebateOrder ra2 = this.baseSo.findObject(order2);
		        if (ra2 == null) {				
					orderMap.put("orderTime", pdok.getSuccesstime());
					orderMap.put("payMoney",pdok.getPayMondey());//单次充值金额
				}else{					
					if(isExist3(one_applyType, one_orderid)){//如果已经存在
						orderMap.put("message", "该订单已经存在");
						orderMap.put("orderTime", "");
						orderMap.put("payMoney","");//单次充值金额
						orderMap.put("allrebatemoney", "");//返利总金额
						orderMap.put("allpaymoney", "");//支付总金额
						orderMap.put("consumeMoney", "0");
						orderMap.put("allmoney", "");//充值总金额
						return orderMap;
					}else{
						orderMap.put("orderTime", pdok.getSuccesstime());
						orderMap.put("payMoney",pdok.getPayMondey());//单次充值金额
					}
				}
			}else{//如果不是新增		
				if(isExist3(one_applyType, one_orderid)){//如果已经存在
					orderMap.put("message", "该订单已经存在");
					orderMap.put("orderTime", "");
					orderMap.put("payMoney","");//单次充值金额
					orderMap.put("allrebatemoney", "");//返利总金额
					orderMap.put("allpaymoney", "");//支付总金额
					orderMap.put("consumeMoney", "0");
					orderMap.put("allmoney", "");//充值总金额
					return orderMap;
				}else{
					orderMap.put("orderTime", pdok.getSuccesstime());
					orderMap.put("payMoney",pdok.getPayMondey());//单次充值金额
				}				
			}
			orderMap.put("uid",pdok.getToinneruserid());
			orderMap.put("vipGrade",getVipGrade(pdok.getToinneruserid()));
			orderMap.put("toaccount", pdok.getTousername());
			orderMap.put("serverid", pdok.getServerid());
			String gameid = pdok.getGameid();
			if(gameid != null&&gameid.length()==5){
				gameid = "0"+gameid;
			}
			orderMap.put("gameid",gameid);
			Games games = GameCache.getInstance().getGameByGameId(gameid);
			orderMap.put("gameName", games.getGameName());		
		}else{//如果没有输入了订单号，只需查询部分数据
			RebateApply apply = new RebateApply();
			apply.setAporderid(one_aporderid);
			RebateApply ra = baseSo.findObject(apply);
			orderMap.put("message", "");
			if(ra != null){//如果是修改操作
				if("4".equals(one_applyType)){//如果赠送补偿返利
					orderMap.put("uid",ra.getUid());
					orderMap.put("vipGrade",ra.getVipGrade());
					orderMap.put("toaccount",ra.getToaccount());
					orderMap.put("serverid", ra.getServerid());
					String gameid = ra.getGameid();
					if(gameid != null&&gameid.length()==5){
						gameid = "0"+gameid;
					}
					orderMap.put("gameid",gameid);
					Games games = GameCache.getInstance().getGameByGameId(gameid);
					orderMap.put("gameName", games.getGameName());		
					orderMap.put("allmoney", ra.getMoney());//充值总金额
					orderMap.put("allconsumemoney", ra.getConsumemoney());//支付总金额
					orderMap.put("allrebatemoney", ra.getRebatemoney());//返利总金额			
					orderMap.put("allpaymoney", new Double(ra.getPaymoney()).intValue());
					return orderMap;
				}
				
				RebateOrder order = new RebateOrder();
				order.setAporderid(one_aporderid);
				List<RebateOrder> rolist = baseSo.findObjects(order, queryPage);
				if(rolist==null||rolist.size()==0){
					orderMap.put("orderTime", "");
					orderMap.put("payMoney", "");//单次充值
					orderMap.put("rebatemoney", "");//返利金额
					orderMap.put("uid",ra.getUid());
					orderMap.put("vipGrade",getVipGrade(ra.getUid()));
					orderMap.put("toaccount",ra.getToaccount());
					orderMap.put("serverid", ra.getServerid());
					String gameid = ra.getGameid();
					if(gameid != null&&gameid.length()==5){
						gameid = "0"+gameid;
					}
					orderMap.put("gameid",gameid);
					Games games = GameCache.getInstance().getGameByGameId(gameid);
					orderMap.put("gameName", games.getGameName());		
					orderMap.put("allmoney", "");//充值总金额
					orderMap.put("allpaymoney", "");//支付总金额
					orderMap.put("allrebatemoney", "");//返利总金额			
					
				}else{
					double payMoney = 0;
					double consumeMoney = 0;
					double rebateMoney = 0;
					for(RebateOrder ro:rolist){
						payMoney += ro.getPayMoney();
						rebateMoney += ro.getRebateMoney();
						consumeMoney += ro.getConsumeMoney();
					}
					RebateOrder ro = rolist.get(0);
					PayDetailOK payDetailOk = new PayDetailOK();
					payDetailOk.setOrderid(ro.getOrderid());
					payDetailOk.setGiftFlag("0");//只有原始订单可以添加
					Page page = new Page();
					List<PayDetailOK> pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
					if(pdoklist == null||pdoklist.size()==0){
						payDetailOk.setGiftFlag("2");//返利订单
						pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
					}
					if(pdoklist == null||pdoklist.size()==0){
						orderMap.put("uid","");
						orderMap.put("vipGrade","");
						orderMap.put("toaccount", "");
						orderMap.put("serverid", "");
						orderMap.put("gameid","");
						orderMap.put("gameName", "");		
						orderMap.put("allmoney","");//充值总金额
						orderMap.put("allrebatemoney", "");//返利总金额
						orderMap.put("allconsumemoney", "");//消耗总金额
						orderMap.put("allpaymoney", "");//支付总金额	
						return orderMap;
					}
					PayDetailOK odo = pdoklist.get(0);
					if(odo == null){
						orderMap.put("uid","");
						orderMap.put("vipGrade","");
						orderMap.put("toaccount", "");
						orderMap.put("serverid", "");
						orderMap.put("gameid","");
						orderMap.put("gameName", "");		
						orderMap.put("allmoney","");//充值总金额
						orderMap.put("allrebatemoney", "");//返利总金额
						orderMap.put("allconsumemoney", "");//消耗总金额
						orderMap.put("allpaymoney", "");//支付总金额			
					}else{
						orderMap.put("uid",odo.getToinneruserid());
						orderMap.put("vipGrade",getVipGrade(odo.getToinneruserid()));
						orderMap.put("toaccount", odo.getTousername());
						orderMap.put("serverid", odo.getServerid());
						String gameid = odo.getGameid();
						if(gameid != null&&gameid.length()==5){
							gameid = "0"+gameid;
						}
						orderMap.put("gameid",gameid);
						Games games = GameCache.getInstance().getGameByGameId(gameid);
						orderMap.put("gameName", games.getGameName());		
						orderMap.put("allmoney",new Double(payMoney).intValue());//充值总金额
						orderMap.put("allrebatemoney", new Double(rebateMoney).intValue());//返利总金额
						orderMap.put("allconsumemoney", new Double(consumeMoney).intValue());//消耗总金额
						orderMap.put("allpaymoney", new Double(consumeMoney+rebateMoney).intValue());//支付总金额			
					}							
				}				
			}else{//如果是新增操作	
				RebateOrder order = new RebateOrder();
				order.setAporderid(one_aporderid);
				List<RebateOrder> rolist = baseSo.findObjects(order, queryPage);
				double payMoney = 0;
				double consumeMoney = 0;
				double rebateMoney = 0;
				for(RebateOrder ro:rolist){
					payMoney += ro.getPayMoney();
					rebateMoney += ro.getRebateMoney();
					consumeMoney += ro.getConsumeMoney();
				}
				if(rolist != null&&rolist.size()>0){
					RebateOrder ro = rolist.get(0);
					PayDetailOK payDetailOk = new PayDetailOK();
					payDetailOk.setOrderid(ro.getOrderid());
					payDetailOk.setGiftFlag("0");//只有原始订单可以添加
					Page page = new Page();
					List<PayDetailOK> pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
					if(pdoklist == null||pdoklist.size()==0){
						payDetailOk.setGiftFlag("2");//返利订单
						pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, page);
					}
					PayDetailOK odo = pdoklist.get(0);
					orderMap.put("uid",odo.getToinneruserid());
					orderMap.put("vipGrade",getVipGrade(odo.getToinneruserid()));
					orderMap.put("toaccount", odo.getTousername());
					orderMap.put("serverid", odo.getServerid());
					String gameid = odo.getGameid();
					if(gameid != null&&gameid.length()==5){
						gameid = "0"+gameid;
					}
					orderMap.put("gameid",gameid);
					Games games = GameCache.getInstance().getGameByGameId(gameid);
					orderMap.put("gameName", games.getGameName());		
					orderMap.put("allmoney",new Double(payMoney).intValue());//充值总金额
					orderMap.put("allrebatemoney", new Double(rebateMoney).intValue());//返利总金额
					orderMap.put("allconsumemoney", new Double(consumeMoney).intValue());//消耗总金额
					orderMap.put("allpaymoney", new Double(consumeMoney+rebateMoney).intValue());//支付总金额
				}else{
					orderMap.put("orderTime", "");
					orderMap.put("payMoney", "");//单次充值
					orderMap.put("rebatemoney", "");//返利金额
					orderMap.put("uid","");
					orderMap.put("vipGrade","");
					orderMap.put("toaccount","");
					orderMap.put("serverid", "");
					orderMap.put("gameid","");
					orderMap.put("gameName", "");	
					orderMap.put("allmoney","");//充值总金额
					orderMap.put("allrebatemoney", "");//返利总金额
					orderMap.put("allconsumemoney", "");//消耗总金额
					orderMap.put("allpaymoney", "");//支付总金额
				}
			}
		}
		return orderMap;
	}	
	
	public Map<String,Object> getPayTotal(){
		String one_aporderid = this.findParameter("one_aporderid");//返利申请单号
		RebateOrder order = new RebateOrder();
		order.setAporderid(one_aporderid);
		List<RebateOrder> rolist = baseSo.findObjects(order, queryPage);
		Map<String,Object>  orderMap = new HashMap<String,Object>();
		double consumeMoney = 0;
		double rebateMoney = 0;
		for(RebateOrder ro:rolist){
			rebateMoney += ro.getRebateMoney();
			consumeMoney += ro.getConsumeMoney();
		}
		orderMap.put("allpaymoney", new Double(rebateMoney+consumeMoney).intValue());//支付总金额
		return orderMap;
	}
	
	
	 private void checkOrderStatus(final int checkstatus) throws Exception{
		 if(checkstatus != -2&&checkstatus !=2){
			 throw new XLRuntimeException("该申请单非修改中和不通过的状态，无法修改");
		 }
	 }
	 
	
	 public  String findUidByName(final String name){
		  UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
		  String userid = null;
	        try
	        {
	            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(name, (byte)-1);
	            if(userInfo.isOk())
	                userid = String.valueOf(userInfo.getUserno());
	        }
	        catch(Exception e)
	        {
	            logger.error((new StringBuilder()).append("getUserIdByUserName exception:").append(e).toString());
	            throw new XLRuntimeException(e);
	        }
	        return userid;
	}
	
	/**
	 * 新增返利订单
	 * @return
	 */
	public String add(){
		logger.info("开始返利订单添加");		
		RebateOrder rebateOrder = this.findBean(RebateOrder.class,"rebateorder");	
		String aporderid = this.findParameter("one_aporderid");
		String percent = this.findParameter("one_percent");
		String orderTime = this.findParameter("one_orderTime");
		String payMoney = this.findParameter("one_payMoney");
		String consumePercent = this.findParameter("one_consumePercent");
		String orderid = this.findParameter("one_orderid");
		String applyType = this.findParameter("one_applyType");
		String checkradio = this.findParameter("serverradio");//是否限制区服
		System.out.println("checkradio:"+checkradio);
		try{	
			RebateOrder order = new RebateOrder();
			order.setAporderid(aporderid);
			Page page = new Page();
			page.addOrder("orderTime", OrderType.ESC);
			List<RebateOrder> rolist = baseSo.findObjects(order, page);		
			if(rolist != null && rolist.size()>0){
				RebateOrder ro = rolist.get(0);
				String lastorderid = ro.getOrderid();
				if(checkradio != null&&"1".equals(checkradio))//如果不限制区服
				      checkDiff(orderid,lastorderid);
			}						
			if(rebateOrder==null){
				rebateOrder = new RebateOrder();
			}		
			if(isExist(applyType, orderid)){
				logger.info("已经存在"+typeMap.get(Integer.parseInt(applyType))+"类型的订单，请不要重复添加");
				throw new XLRuntimeException("已经存在"+typeMap.get(Integer.parseInt(applyType))+"类型的订单，请不要重复添加");
			}		
			if(isExist2(applyType, orderid, aporderid)){
				logger.info("已经存在"+typeMap.get(Integer.parseInt(applyType))+"类型的订单，请不要重复添加");
				throw new XLRuntimeException("已经存在"+typeMap.get(Integer.parseInt(applyType))+"类型的订单，请不要重复添加");
			}
			String one_aporderid = this.findParameter("one_aporderid");
			if(!StringTools.isEmpty(one_aporderid)){
				RebateApply apply = new RebateApply();
				apply.setAporderid(one_aporderid);
				List<RebateApply> ralist = baseSo.findObjects(apply,queryPage);
				if(ralist != null&& ralist.size()>0){
					RebateApply ra = ralist.get(0);
					checkOrderStatus(ra.getCheckstatus());//检查申请单状态
					String account = this.currentUserLogo();
					if(!ra.getInputBy().trim().equals(account.trim())){
						logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
					}
				}
			}
			order.setAporderid(aporderid);
			order.setApplyType(applyType);
			rebateOrder.setAporderid(aporderid);			
			rebateOrder.setOrderid(orderid);
			rebateOrder.setOrderTime(orderTime);
			rebateOrder.setPayMoney(Double.parseDouble(payMoney));
			rebateOrder.setRebateMoney(((rebateOrder.getPayMoney()*Integer.parseInt(percent))/100));
			rebateOrder.setRebateMoney(new Double(rebateOrder.getRebateMoney().intValue()));
			rebateOrder.setConsumeMoney((rebateOrder.getPayMoney()*Integer.parseInt(StringTools.isEmpty(consumePercent)?"0":consumePercent))/100);
			rebateOrder.setConsumeMoney(new Double(rebateOrder.getConsumeMoney().intValue()));
			rebateOrder.setConsumePercent(Integer.parseInt(consumePercent));
			rebateOrder.setPercent(Integer.parseInt(percent));
			rebateOrder.setIsvalid(false);
		   if("1".equals(applyType)){
	    	  rebateOrder.setApplyType("r");
	       }else if("2".equals(applyType)){
	    	   rebateOrder.setApplyType("rc");
	       }else if("3".equals(applyType)){
	    	   rebateOrder.setApplyType("c");
	       }
			PayDetailOK payDetailOk = new PayDetailOK();
			payDetailOk.setOrderid(orderid);
			//payDetailOk.setGiftFlag("0");//只有原始订单可以添加
			List<PayDetailOK> pdoklist = payDetailOkBo.findPayDetailOk(payDetailOk, queryPage);
			if(pdoklist == null||pdoklist.size()==0){
				throw new XLRuntimeException("原始订单不存在");
			}
			PayDetailOK pdok = pdoklist.get(0);
			if("1".equals(pdok.getGiftFlag())){
				throw new XLRuntimeException("不能添加返利订单");
			}
			rebateOrder.setUid(pdok.getToinneruserid());
			rebateOrder.setAccount(pdok.getTousername());
			rebateOrder.setGameid("0"+pdok.getGameid());
			rebateOrder.setServerid(pdok.getServerid());
			rebateOrder.setActNo(pdok.getNiuxactno());
			int giftFlag = Integer.parseInt(pdok.getGiftFlag());
			rebateOrder.setOrderType(giftFlag==0?1:giftFlag);
			baseSo.addObject(rebateOrder);					
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public void checkDiff(final String orderid,final String lastorderid) throws Exception{
		Page page = new Page();
		PayDetailOK detail = new PayDetailOK();
		detail.setOrderid(orderid);
		List<PayDetailOK> pdolist = payDetailOkBo.findPayDetailOk(detail,page);
		if(pdolist == null||pdolist.size()==0){
			throw new XLRuntimeException("该订单非充值成功订单");
		}
		PayDetailOK newdetail = pdolist.get(0);
		detail.setOrderid(lastorderid);
		List<PayDetailOK> lastpdolist = payDetailOkBo.findPayDetailOk(detail,page);
		PayDetailOK olddetail = lastpdolist.get(0);
		
		if(!newdetail.getToinneruserid().equals(olddetail.getToinneruserid())){
			throw new XLRuntimeException("该订单与其他订单充值的是不同的uid");
		}
		//同一个uid 也可能有多个不同的账号
//		if(!newdetail.getTousername().equals(olddetail.getTousername())){
//			throw new XLRuntimeException("该订单与其他订单充值的是不同的账号");
//		}
		if(!newdetail.getGameid().equals(olddetail.getGameid())){
			throw new XLRuntimeException("该订单与其他订单充值的是不同的游戏");
		}
		if(!newdetail.getServerid().equals(olddetail.getServerid())){
			throw new XLRuntimeException("该订单与其他订单充值的是不同的区服");
		}	
	}
	
	
	  private boolean isExist3(final String applyType,final String orderid){
		   StringBuffer sqlbuffer = new StringBuffer("select * from rebateorder where isvalid = 1 ")
		   .append("  and orderid = '").append(orderid).append("'").append("  and  ");
	       if("1".equals(applyType)){
	    	   sqlbuffer.append(" applyType like '%r%'");
	       }else if("2".equals(applyType)){
	    	   sqlbuffer.append(" applyType like '%r%' or applyType like '%c%' ");
	       }else if("3".equals(applyType)){
	    	   sqlbuffer.append(" applyType like '%c%'");
	       }
		   List rolist = rebateOrderBo.executeQuery(RebateOrder.class, sqlbuffer.toString(), queryList);
		   if(rolist != null&&rolist.size()>0)return true;
		   return false;
	   }
	
	/**
	 *  查询指定的订单号是否已经存在
	 * @param applyType
	 * @param orderid
	 * @return
	 */
   private boolean isExist(final String applyType,final String orderid){
	   StringBuffer sqlbuffer = new StringBuffer("select * from rebateorder where isvalid = 1 ")
	   .append("  and orderid = '").append(orderid).append("'").append("  and  ");
       if("1".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%r%'");
       }else if("2".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%rc%'");
       }else if("3".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%c%'");
       }
	   List rolist = rebateOrderBo.executeQuery(RebateOrder.class, sqlbuffer.toString(), queryList);
	   if(rolist != null&&rolist.size()>0)return true;
	   return false;
   }

   private boolean isExist2(final String applyType,final String orderid,final String aporderid){
	   StringBuffer sqlbuffer = new StringBuffer("select * from rebateorder where isvalid = 0 ")
	   .append("  and orderid = '").append(orderid).append("'").append("  and  aporderid='").append(aporderid).append("'").append("  and ");
       if("1".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%r%'");
       }else if("2".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%rc%'");
       }else if("3".equals(applyType)){
    	   sqlbuffer.append(" applyType like '%c%'");
       }
	   List rolist = rebateOrderBo.executeQuery(RebateOrder.class, sqlbuffer.toString(), queryList);
	   if(rolist != null&&rolist.size()>0)return true;
	   return false;
   }
	
	/**
	 * 修改返利订单
	 * @return
	 */
	public String edit(){
		logger.info("开始返利订单信息修改");
		this.authenticateEdit();//编辑权限
		RebateOrder apply = this.findBean(RebateOrder.class,"rebateorder");	
		try{
			if(apply==null){
				logger.info("返利订单信息为空");
				throw new XLRuntimeException("返利订单信息为空");
			}		
			baseSo.updateObjectById(apply);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}		
	
	
	/**
	 * 限制审核人可审核的最大返利金额
	 * @param account
	 * @param payMoney
	 * @return
	 */
	private boolean limitCheckMoney(String account,double payMoney){
		if(checkMoney(payMoney)){
			if(StringTools.isEmpty(MAXMONEYCHECKERS))return false;
			if(MAXMONEYCHECKERS.indexOf(",")==-1){
				if(MAXMONEYCHECKERS.trim().equals(account)){
					return true;
				}
			}else{
				String checkers [] = MAXMONEYCHECKERS.split(",");
				for(String checker:checkers){
					if(StringTools.isEmpty(checker)) continue;
					if(checker.trim().equals(account)) return true;
				}
			}
		}	
		return false;
	}
	
	
	private boolean checkMoney(double payMoney){
		if(StringTools.isEmpty(MAXMONEY))return false;
		if(Double.parseDouble(MAXMONEY)<payMoney)return true;
		return false;
	}
	
	/**
	 * 审核通过
	 * @return
	 */
	public String doPass(){
		logger.info("开始审核返利订单");
		String aporderid = this.findParameter("one_aporderid");//返利申请单号
		String applyType = this.findParameter("one_applyType");//返利类型
		String rebateType = this.findParameter("one_rebateType");//返利形式
		String yuanbao = this.findParameter("yuanbao");
		String FLOWNO = (yuanbao!=null&&yuanbao.equals("on"))?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
		String nowtime = now();
		boolean opflag = false;//操作状态
		try {					
			String account = this.currentUserLogo();//获得当前登录账号
			//检查审核人权限
			if(yuanbao!=null&&yuanbao.equals("on")){//如果返利申请单中包含返元宝
				if(!StringTools.isEmpty(LIMITCHECKERS)){
					if(LIMITCHECKERS.indexOf(account) != -1){//限制审核人不能审核返元宝的订单
						throw new XLRuntimeException("该返利申请单中包含返元宝，您没有审核权限");
					}
				}
			}			
			if("4".equals(applyType)){//如果是赠送补偿返利
				if(yuanbao!=null&&yuanbao.equals("on")){//如果包含返元宝
					FLOWNO = Constant.ORDERFLOWNO;
				}else{
					FLOWNO = Constant.GIFTFLOWNO;
				}				
			}
			//检查用户权限
			IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
			auth.checkUser(FLOWNO, aporderid,account);						
	    	RebateApply apply = new RebateApply();
	    	apply.setAporderid(aporderid);
	    	RebateApply ra = baseSo.findObject(apply);

            //审核时间与申请时间比较，一级审核人不超过6天，二级审核人不超7天
            String applyTimeStr = ra.getApplyTime();
            if(applyTimeStr==null||applyTimeStr.isEmpty()){
                throw new XLRuntimeException(aporderid+" 申请时间为空，无法审核！");
             }
            String nowStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            long daysBetween = DateUtil.compareTime(nowStr,applyTimeStr);
            boolean isSecChecker = BaseAuthFactory.getBaseAuth("001").isSpecialDisplayOrder("001",2,this.currentUserLogo());
            if(!rebateType.contains("d") && isSecChecker && daysBetween > 11){
                throw new XLRuntimeException("无法审核，距离申请时间已超过11天！");
            }
            if(!rebateType.contains("d") && !isSecChecker && daysBetween > 10){
                throw new XLRuntimeException("无法审核，距离申请时间已超过10天！");
            }
	    	if(StringTools.isEmpty(aporderid)||StringTools.isEmpty(applyType)||StringTools.isEmpty(rebateType)){
	    		throw new XLRuntimeException("参数不能为空");
	    	}
	    	int checkstatus = ra.getCheckstatus().intValue();
	    	if(checkstatus>=1){
	    		throw new XLRuntimeException("该申请单已经结束审核流程了");
	    	}
	    	if(checkstatus==1){
	    		throw new XLRuntimeException("该申请单已经审核通过了，请不要重复审核");
	    	}
	    	if(checkstatus!=-1&&checkstatus!=0){//如果返利申请单非待审核和审核中的状态
	    		throw new XLRuntimeException("该申请单非待审核和审核中的状态");
	    	}
	    	PayDetailOK paydetailok = new PayDetailOK();
	    	List<PayDetailOK> pdolist = null;
	    	
	    	if(limitCheckMoney(this.currentUserLogo(),ra.getPaymoney())){
	    		throw new XLRuntimeException("您没有审核该订单的权限");
	    	}
	    	/**
	    	 * 如果不是赠送补偿订单	
	    	 */
	    	if(!"4".equals(applyType)){//    		
	    		RebateOrder order =new RebateOrder();
		    	order.setAporderid(aporderid);
		    	List<RebateOrder> orderlist = baseSo.findObjects(order, queryPage);
		    	if(orderlist == null||orderlist.size()==0){
		    		throw new XLRuntimeException("该申请单的返利订单不存在，请拒绝");
		    	}
		    	double realMoney = 0;
		    	double consumeMoney = 0;
		    	double rebateMoney = 0;
		    	for(RebateOrder broder:orderlist){
		    		realMoney += broder.getPayMoney();
		    		consumeMoney += broder.getConsumeMoney();
		    		rebateMoney += broder.getRebateMoney();
		    	}
		    	if(realMoney != ra.getMoney()){
		    		throw new XLRuntimeException("返利申请单总金额和订单中总金额不一致，请拒绝");
		    	}
		    	if(rebateMoney != ra.getRebatemoney()){
		    		throw new XLRuntimeException("返利申请单充值返利总金额和订单中充值返利总金额不一致，请拒绝");
		    	}
		    	if(consumeMoney != ra.getConsumemoney()){
		    		throw new XLRuntimeException("返利申请单消耗返利总金额和订单中消耗返利总金额不一致，请拒绝");
		    	}
		    	if(consumeMoney+rebateMoney != ra.getPaymoney()){
		    		throw new XLRuntimeException("返利申请单返利总金额和订单中返利总金额不一致，请拒绝");
		    	}
		    	RebateOrder ro = orderlist.get(0);
		    	String srcorderid = ro.getOrderid();
		    	PayDetailOK pdo = new PayDetailOK();
		    	pdo.setOrderid(srcorderid);
		    	pdolist = payDetailOkBo.findPayDetailOk(pdo, queryPage);
		    	if(pdolist == null||pdolist.size()==0){
		    		throw new XLRuntimeException("该申请单的充值原始订单不存在，请拒绝");
		    	}
		    	if("1".equals(applyType)||"2".equals(applyType)){//如果是充值返利
			    	PayDetailOK pdo2 = new PayDetailOK();
			    	pdo2.setOriginalOrderid(srcorderid);
			    	pdo2.setGiftFlag("1");
			    	List<PayDetailOK> pdolist2 = payDetailOkBo.findPayDetailOk(pdo2, queryPage);
			    	if(pdolist2 != null&& pdolist2.size()>0){
			    		throw new XLRuntimeException("订单号为:"+srcorderid+"原始订单已经返利过了，不能重复返利，请拒绝");
			    	}
		    	}else if("3".equals(applyType)){//如果是消耗返利
		    		PayDetailOK pdo2 = new PayDetailOK();
			    	pdo2.setOriginalOrderid(srcorderid+"_c");
			    	pdo2.setGiftFlag("1");
			    	List<PayDetailOK> pdolist2 = payDetailOkBo.findPayDetailOk(pdo2, queryPage);
			    	if(pdolist2 != null&& pdolist2.size()>0){
			    		throw new XLRuntimeException("订单号为:"+srcorderid+"原始订单已经返利过了，不能重复返利，请拒绝");
			    	}
		    	}	    		
	    	}	    	

	    	
	    	String gameId = ra.getGameid();
	    	if(gameId != null&&"000001".equals(gameId)){//如果是魔域
	    		int money = new Double(ra.getPaymoney()).intValue();
	    		if(money%10 != 0){
	    			throw new XLRuntimeException("魔域的返利总金额必须是10的倍数，请拒绝");
	    		}
	    	}
	    	Games games = GameCache.getInstance().getGameByGameId(ra.getGameid());
		    if(auth.isLastChecker(FLOWNO, aporderid, account)){//如果是最后一个审核人审核   	
		    	ra.setCheckstatus(new Integer(1));//审核通过
		    	ra.setLastChecker(account);
		    	ra.setLastCheckTime(nowtime);
	    	
		    	StringBuffer content = new StringBuffer();				    	
		    	if("4".equals(applyType)){//如果返利类型是赠送补偿返利		
		    		String orderid = "20"+Utility.createApplyId();	
		    		String gameid = ra.getGameid();
		    		if(StringTools.isEmpty(gameid)){
		    			gameid = gameid.substring(1);//充值接口游戏编号为5位的
		    		}
		    		if(ra.getPaymoney()>0){		    			
		    			//判断是否达到每日每月最大返利金额限制
		    			int status =  CheckGiftMoneyProxy.getInstance().checkMoney(ra.getPaymoney());
		                if(status == 0){
				    		giveOutYuanBao(ra.getToaccount(),  //调用直冲接口
				    				gameid,
				    				ra.getServerid(),
				    				ra.getRoleid(),
				    				orderid,
				    				"applySystem",
				    				new Double(ra.getPaymoney()).intValue());		
		                }else if(status == 1){
		                	throw new XLRuntimeException("当日返利总金额超过最大额度");
		                }else if(status == 2){
		                	throw new XLRuntimeException("当月返利总金额超过最大额度");
		                }else{
		                	throw new XLRuntimeException("每日每月最大额度查询失败");
		                }		    			
		    		}
		    		
		    		//更新返利笔数和返利总金额
			    	CustomerDetailQuery cdq = new CustomerDetailQuery();
			    	cdq.setUid(ra.getUid());
			    	CustomerDetailQuery customer = baseSo.findObject(cdq);

			    	if(customer != null){
				    	customer.setRebateCount(customer.getRebateCount()+1);
				    	long cmoney = customer.getRebateMoney()==null?0:customer.getRebateMoney().longValue();
				    	long rmoney = ra.getPaymoney()==null?0:ra.getPaymoney().longValue();
				    	customer.setRebateMoney(cmoney+rmoney);
				    	baseSo.updateObjectById(customer);
			    	}					    				    	
			    	//更新外呼记录中的充值总金额
			    	RebateApply rebateApply  = new RebateApply();
			    	rebateApply.setCrid(ra.getCrid());
			    	rebateApply.setCheckstatus(new Integer(1));//审核通过的订单
			    	List<RebateApply> ralist = baseSo.findObjects(rebateApply, queryPage);
			    	double allmoney = 0;
			    	double rebatemoney = 0;
			    	for(RebateApply raa:ralist){
			    		allmoney +=raa.getMoney();
			    		rebatemoney += raa.getPaymoney();
			    	}
			    	CallRecord call = new CallRecord();
			    	call.setSeqid(Long.parseLong(ra.getCrid()));
			    	CallRecord callRecord = baseSo.findObject(call);
			    	if(callRecord != null){
			    		callRecord.setMoney(new Double(allmoney+ra.getMoney()).longValue());
			    		callRecord.setRebateMoney(new Double(rebatemoney+ra.getPaymoney()).longValue());
			    		callRecord.setRebateCount((ralist==null?0:ralist.size())+1);
				    	baseSo.updateObjectById(callRecord);
			    	}				    	
			    	ra.setOrderid(orderid);//更新充值订单号		 
		    	}else{
		    		if(rebateType .indexOf("y")!=-1){//如果返利形式包含元宝
				    	//自动生成一个订单
				    	String orderid = "20"+Utility.createApplyId();			    	
				    	PayDetailOK pay = pdolist.get(0);
				    	Utility.copyProperties(paydetailok, pay);
				    	paydetailok.setSeqid(null);
				    	paydetailok.setOrderid(orderid);	
				    	paydetailok.setOrderidstatus("Y");
						paydetailok.setNoticeVip("Y");
						paydetailok.setNiuxactno("by_hand");
						paydetailok.setGiftFlag("1");
						paydetailok.setPaycode("03");
						paydetailok.setGoodstimes("1");
						paydetailok.setServerid(ra.getServerid());
						paydetailok.setUnitprice(ra.getPaymoney()+"");
						paydetailok.setPayMondey(new Double(0));
						paydetailok.setTotalmoney(ra.getPaymoney()+"");
						paydetailok.setSuccesstime("");
						paydetailok.setEditby(currentUserLogo());
						paydetailok.setEdittime(now());
						paydetailok.setVouchers("");
						paydetailok.setVouchersMoney(new Double(0));
						paydetailok.setOrdertime(com.xunlei.common.util.DatetimeUtil.now());
						paydetailok.setChargeSuccessTime(com.xunlei.common.util.DatetimeUtil.now());
						
						if("3".equals(applyType)){//消耗返利
							paydetailok.setOriginalOrderid(paydetailok.getOriginalOrderid()+"_c");//消耗返利
						}else {//充值返利
							//按默认的规则
						}
						
						//如果是魔域，则必须分为50 、10份
						if("00001".equals(paydetailok.getGameid())||"000001".equals(paydetailok.getGameid())){
							double total = Double.parseDouble(paydetailok.getTotalmoney());
							if(total%50==0){
								paydetailok.setGoodstimes(new Double((total/50)).intValue()+"");
								paydetailok.setUnitprice("50");
							}else{
								paydetailok.setGoodstimes(new Double((total/10)).intValue()+"");
								paydetailok.setUnitprice("10");
							}
						}     
						payDetailOkBo.insert(paydetailok);
						
				    	//更新返利笔数和返利总金额
				    	CustomerDetailQuery cdq = new CustomerDetailQuery();
				    	cdq.setUid(ra.getUid());
				    	CustomerDetailQuery customer = baseSo.findObject(cdq);

				    	if(customer != null){
					    	customer.setRebateCount(customer.getRebateCount()+1);
					    	long cmoney = customer.getRebateMoney()==null?0:customer.getRebateMoney().longValue();
					    	long rmoney = ra.getPaymoney()==null?0:ra.getPaymoney().longValue();
					    	customer.setRebateMoney(cmoney+rmoney);
					    	baseSo.updateObjectById(customer);
				    	}					    				    	
				    	//更新外呼记录中的充值总金额
				    	RebateApply rebateApply  = new RebateApply();
				    	rebateApply.setCrid(ra.getCrid());
				    	rebateApply.setCheckstatus(new Integer(1));
				    	List<RebateApply> ralist = baseSo.findObjects(rebateApply, queryPage);
				    	double allmoney = 0;
				    	double rebatemoney = 0;
				    	for(RebateApply raa:ralist){
				    		allmoney +=raa.getMoney();
				    		rebatemoney += raa.getPaymoney();
				    	}
				    	CallRecord call = new CallRecord();
				    	call.setSeqid(Long.parseLong(ra.getCrid()));
				    	CallRecord callRecord = baseSo.findObject(call);
				    	if(callRecord != null){
				    		callRecord.setMoney(new Double(allmoney+ra.getMoney()).longValue());
				    		callRecord.setRebateMoney(new Double(rebatemoney+ra.getPaymoney()).longValue());
				    		callRecord.setRebateCount((ralist==null?0:ralist.size())+1);
					    	baseSo.updateObjectById(callRecord);
				    	}				    	
				    	ra.setOrderid(orderid);//更新充值订单号		    			    		
			    	}else{		    	
			    		//更新返利笔数和返利总金额
				    	CustomerDetailQuery cdq = new CustomerDetailQuery();
				    	cdq.setUid(ra.getUid());
				    	CustomerDetailQuery customer = baseSo.findObject(cdq);

				    	if(customer != null){
					    	customer.setRebateCount(customer.getRebateCount()+1);
					    	baseSo.updateObjectById(customer);
				    	}					    				    	
				    	//更新外呼记录中的充值总金额
				    	RebateApply rebateApply  = new RebateApply();
				    	rebateApply.setCrid(ra.getCrid());
				    	List<RebateApply> ralist = baseSo.findObjects(rebateApply,queryPage);
				    	double allmoney = 0;
				    	for(RebateApply raa:ralist){
				    		allmoney +=raa.getMoney();
				    	}
				    	CallRecord call = new CallRecord();
				    	call.setSeqid(Long.parseLong(ra.getCrid()));
				    	CallRecord callRecord = baseSo.findObject(call);
				    	if(callRecord != null){
				    		callRecord.setMoney(new Double(allmoney).longValue());
				    		callRecord.setRebateCount(ralist==null?0:ralist.size());
					    	baseSo.updateObjectById(callRecord);
				    	}					    				    	
			    	}		    				    		
		    	}		    	
		    
		    			    			    			    	
		    	//更新审核状态为已审核		    	
		    	baseSo.updateObjectById(ra);	
		    	
		    	RebateThreadPool.getInstance().execute(new RebateTask(ra));//更新同一个uid每月申请次数
		    	
		    	content.append("恭喜您，申请单号为："+aporderid+"的"+typeMap.get(Integer.parseInt(applyType))+"订单,已经审核通过了");		    	
		    	auth.record(FLOWNO, aporderid, account, nowtime, 1, "");
		    	opflag = true;
		    	String[] receivers = new String[1];
				//发送邮件通知申请者		
				StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(Integer.parseInt(applyType))).append("审核结果】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());
                receivers[0]=ra.getInputBy()+"@cc.sandai.net";
                NiuxEmailVo emailVo = new NiuxEmailVo();
                emailVo.setSubject(titleBuffer.toString());
                emailVo.setContent(content.toString());
                emailVo.setAddrs(receivers);
                ConcurrentExecutor.getInstance().execute(new LyChatEmailSender(emailVo));
		    	logger.info("send dopass mail success to applyer:"+auth.getEmailFromName(ra.getInputBy()));
		    	
		    	 if(rebateType.indexOf("D")!=-1){//如果有申请代金券，则发放代金券
		    		 RebateVoucher voucher = new RebateVoucher();
		    		 voucher.setAporderid(aporderid);
		    		 List<RebateVoucher> rvlist = baseSo.findObjects(voucher, queryPage);
		    		 if(rvlist== null||rvlist.size()==0){
		    			 throw new XLRuntimeException("代金券为空，代金券发放失败");
		    		 }
		    		 int index = 1;
		    		 for(RebateVoucher rv:rvlist){
		    			 String cdkey = getVoucher(index,ra.getUid(),rv.getBatid());//调用接口生成代金券
		    			 rv.setCdkey(cdkey);
		    			 baseSo.updateObjectById(rv);
		    			 index++;
		    		 }
		    		 ra.setIsSuccess(true);//代金券发放成功
		    	 }
		    	 baseSo.updateObjectById(ra);	 
		    }else{//如果不是最后一个审核人审核		    			    	
		    	ra.setCheckstatus(new Integer(0));//审核通过
		    	ra.setLastChecker(account);
		    	ra.setLastCheckTime(nowtime);
		    	//更新审核状态为已审核
		    	baseSo.updateObjectById(ra);
		    	
		    	auth.record(FLOWNO, aporderid, account, now(), 1, "");
		    	//String lastchecker = auth.getLastChecker(FLOWNO, ra.getAporderid());
		    	String nextchecker = auth.getNextChecker(FLOWNO, ra.getAporderid());
		    	
		    	opflag = true;
		    	
		    	//发送邮件给申请人
//		    	List<String> receivers2 = new ArrayList<String>();		
//		    	List<String> receivers = new ArrayList<String>();		
////		    	receivers2.add(nextchecker);
////				//发送邮件通知下一个审核人		
////				StringBuffer titleBuffer2 = new StringBuffer("【").append(typeMap.get(Integer.parseInt(applyType))).append("申请】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());
////				RebateApplyProxy.getInstance().sendMail(ra.getAporderid(), titleBuffer2.toString(), "", receivers2);
//				
//				//发送邮件通知申请者		
//				StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(Integer.parseInt(applyType))).append("审核结果】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());
//				StringBuffer content = new StringBuffer();				
//				content.append("订单号为：" + ra.getAporderid() + "的订单，" + lastchecker + "已经审核通过了，下一个审核人是：" + nextchecker);
//				receivers.add(auth.getEmailFromName(ra.getInputBy()));				
//				RebateApplyProxy.getInstance().sendMail(ra.getAporderid(), titleBuffer.toString(), content.toString(), receivers);
				logger.info("send dopass mail success to nextchecker:"+nextchecker);
		    }		    		    
		} catch (Exception e) {
			if(opflag){
				logger.error("审核成功，邮件发送失败", e);
				mergeJsmessage("审核成功，邮件发送失败，原因：" + e.getMessage());
			}else{
				logger.error("审核失败", e);
				mergeJsmessage("审核失败，原因：" + e.getMessage());
			}
		}
		return "";		
	}


	/**
	 * 批量返利审核 */
    public String doPassSelected(){
        logger.info("开始批量审核返利订单");
        String rebateApplySeqids = this.findParameter("rebateApplySeqids");
        String[] seqIdArr = rebateApplySeqids.split(",");
        if(seqIdArr.length==0){
            mergeJsmessage("未选中任何订单");
            return "";
        }

        //审核人验证
        String currentUser = this.currentUserLogo().trim();

        //审核流程001,2级审核人
        boolean isSecChecker = false;
        try {
            isSecChecker = BaseAuthFactory.getBaseAuth("001").isSpecialDisplayOrder("001",2,currentUser);
        } catch (Exception e) {
            logger.error("审核失败", e);
            mergeJsmessage("审核失败，审核人数据异常！");
            return "";
        }


        //审核准备工作
        String nowtime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        List<RebateApplyItem> raList = new ArrayList<RebateApplyItem>();
        List<RebateApplyItem> failedList = new ArrayList<RebateApplyItem>();

        for(String seqid : seqIdArr){
            RebateApply tmpRa = new RebateApply();
            tmpRa.setSeqid(Long.parseLong(seqid));
            RebateApplyItem rai = new RebateApplyItem();
            rai.setRebateApply(tmpRa);
            rai.setStatus(-1);
            rai.setMsg("Unknown Error未知错误");
            raList.add(rai);
        }

        List<RebateApply> debugAllList = new ArrayList<RebateApply>();
        //加载所有审核返利订单数据
        for(RebateApplyItem rai : raList){
                RebateApply theRa =  FacadeFactory.INSTANCE.getBaseSo().findObject(rai.getRebateApply());
                if(theRa==null){
                    rai.setFailedMsg("not found 不存在seqid:");
                }else{
                    debugAllList.add(theRa);
                    boolean hasYuanBao = theRa.getRebateType()!=null && theRa.getRebateType().contains("y");
                    boolean isZengSongBuChang = theRa.getApplyType()==4;
                    String FLOWNO = (hasYuanBao)?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
                    if(isZengSongBuChang){
                        if(hasYuanBao){
                            FLOWNO = Constant.ORDERFLOWNO;
                        }else{
                            FLOWNO = Constant.GIFTFLOWNO;
                        }
                    }
                    theRa.setLastChecker(currentUser);
                    theRa.setLastCheckTime(nowtime);
                    String orderid = "";
                    if(theRa.getApplyType()==4 || (theRa.getRebateType()!=null&&theRa.getRebateType().contains("y"))){
                        orderid = "20"+Utility.createApplyId();
                    }
                    theRa.setOrderid(orderid);
                    rai.setFlowNo(FLOWNO);
                    rai.setRebateApply(theRa);
                }
            }


        /**
         * ********************** 审核1 **********************
         */
        List<RebateApplyItem> firstFailedList = getFirstFailedList(raList, isSecChecker, currentUser);
        raList.removeAll(firstFailedList);
        failedList.addAll(firstFailedList);
        firstFailedList.clear();


        /**
         * ********************** 审核2 **********************
         */
        //拿到所有非赠送补偿订单
        List<RebateApplyItem> fzsbcddList = new ArrayList<RebateApplyItem>();
        for(RebateApplyItem rai : raList) {
            RebateApply ra = rai.getRebateApply();
            Integer applyType = ra.getApplyType();
            if (rai.getStatus() != 3 && applyType!=null && applyType != 4) {
                fzsbcddList.add(rai);
            }
        }
        if(!fzsbcddList.isEmpty()){
            List<RebateApplyItem> fzsbcddFailedList = getFatalFeiZengSongBuChangDingDang(fzsbcddList);
            raList.removeAll(fzsbcddFailedList);
            failedList.addAll(fzsbcddFailedList);
            fzsbcddList.clear();
            fzsbcddFailedList.clear();
        }



        /**
         * ********************** 审核3 **********************
         */
        List<RebateApplyItem> fatalLastCheckerdList = new ArrayList<RebateApplyItem>();
        for(RebateApplyItem rai: raList){
            boolean isLastChecker = false;
            try {
                isLastChecker = BaseAuthFactory.getBaseAuth(rai.getFlowNo()).isLastChecker(rai.getFlowNo(), "", currentUser);
            } catch (Exception e) {
                rai.setFailedMsg("获取最后审核人异常");
                fatalLastCheckerdList.add(rai);
                continue;
            }

            if(isLastChecker){
                rai.getRebateApply().setCheckstatus(1);
            }else{
                rai.getRebateApply().setCheckstatus(0);
            }
        }
        raList.removeAll(fatalLastCheckerdList);
        failedList.addAll(fatalLastCheckerdList);
        fatalLastCheckerdList.clear();

        /**
         * ********************** 审核完成，更新数据 **********************
         */
        List<RebateApply> raParam = new ArrayList<RebateApply>();
        for(RebateApplyItem rai:raList){
            baseSo.updateObjectById(rai.getRebateApply());
            raParam.add(rai.getRebateApply());
        }

        /**
         * ********************** 异步更新相关数据 **********************
         */
        RebateThreadPool.getInstance().execute(new RebateOrderPassBatchThread(raParam,currentUser));

        /**
         * ********************** 日志 **********************
         */
        //所有订单
        StringBuilder all = new StringBuilder();
        for(RebateApply ra:debugAllList){
            all.append(ra.getAporderid()).append("\n");
        }
        logger.info("All rebate apply 所有订单：" + debugAllList.size() + "\n" + all.toString());

        //成功订单
        StringBuilder success = new StringBuilder();
        for(RebateApplyItem rai:raList){
            success.append(rai.getRebateApply().getAporderid()).append("\n");
        }
        logger.info("Successful rebate apply 成功订单：" + raList.size() + "\n" + success.toString());

        //失败订单
        StringBuilder failure = new StringBuilder();
        for(RebateApplyItem rai:failedList){
            failure.append(rai.getRebateApply().getAporderid() + " : " + rai.getMsg() + "\n");
        }
        logger.info("Failed rebate apply 失败订单：" + failedList.size() + "\n" + failure.toString());

        String resultMsg = String.format("审核%d个，成功%d个，失败%d个。",seqIdArr.length, raList.size(), failedList.size());
		mergeJsmessage(resultMsg);
        return resultMsg;
	}


    private List<RebateApplyItem> getFirstFailedList(final List<RebateApplyItem> raList,boolean isSecChecker, String currentUser) {
        String nowStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        List<RebateApplyItem> raFailedList = new ArrayList<RebateApplyItem>();
        //遍历检查所有返利申请单
        for(RebateApplyItem rai : raList){

            final RebateApply theRa = rai.getRebateApply();

            if(theRa == null || theRa.getAporderid() == null || StringTools.isEmpty(theRa.getAporderid())){
                rai.setFailedMsg("该申请单不存在");
                raFailedList.add(rai);
                continue;
            }
            if(StringTools.isEmpty(theRa.getAporderid())||theRa.getApplyType()==null||StringTools.isEmpty(theRa.getRebateType())){
                rai.setFailedMsg("参数不能为空");
                raFailedList.add(rai);
                continue;
            }
            int checkStatus = theRa.getCheckstatus();
            if(checkStatus==1){
                rai.setFailedMsg("该申请单已经审核通过了，请不要重复审核");
                raFailedList.add(rai);
                continue;
            }
            if(checkStatus>1){
                rai.setFailedMsg("该申请单已经结束审核流程了");
                raFailedList.add(rai);
                continue;
            }
            if(checkStatus!=-1&&checkStatus!=0){
                rai.setFailedMsg("该申请单非待审核和审核中的状态");
                raFailedList.add(rai);
                continue;
            }


            //检查申请时间
            String applyTimeStr = theRa.getApplyTime();
            if(applyTimeStr==null||applyTimeStr.isEmpty()){
                rai.setFailedMsg("申请时间为空，无法审核！");
                raFailedList.add(rai);
                continue;
            }

            //一级审核人间隔时间
            long daysBetween = DateUtil.compareTime(nowStr,applyTimeStr);
            if(!theRa.getRebateType().contains("d") && isSecChecker && daysBetween > 11){
                rai.setFailedMsg("无法审核，距离申请时间已超过11天！");
                raFailedList.add(rai);
                continue;
            }
            //二级审核人间隔时间
            if(!theRa.getRebateType().contains("d") && !isSecChecker && daysBetween > 10){
                rai.setFailedMsg("无法审核，距离申请时间已超过10天！");
                raFailedList.add(rai);
                continue;
            }

            //返利申请单包含元宝，检查审核权限
            if(theRa.getRebateType().contains("y")
                    && StringTools.isEmpty(LIMITCHECKERS)
                    && LIMITCHECKERS.contains(currentUser)){
                rai.setFailedMsg("该返利申请单中包含返元宝，您没有审核权限");
                raFailedList.add(rai);
                continue;
            }

            //检查用户权限
            try{
                BaseAuthFactory.getBaseAuth(rai.getFlowNo()).checkUser(rai.getFlowNo(), theRa.getAporderid(), currentUser);
            }catch (Exception e){
                rai.setFailedMsg(e.getMessage());
                raFailedList.add(rai);
                continue;
            }

        }

        return raFailedList;
    }

    private List<RebateApplyItem> getFatalFeiZengSongBuChangDingDang(List<RebateApplyItem> fzsbcddList) {

        List<RebateApplyItem> fatalList = new ArrayList<RebateApplyItem>();

        //把所有非返利订单号保存集合set，作为之后的查询参数
        Set<String> fzsbcddAporderidSet = new HashSet<String>();
        for(RebateApplyItem rai: fzsbcddList){
            fzsbcddAporderidSet.add(rai.getRebateApply().getAporderid());
        }

        //非赠送补偿订单和原始订单
        Map<String, RebateOrderGroupByApOrderIdDTO> roMap = rebateOrderBo.getRebateOrderMapGroupByApOrderId(fzsbcddAporderidSet);

        //遍历检查所有 非 赠送补偿订单
        for(RebateApplyItem rai : fzsbcddList){
            final RebateApply ra = rai.getRebateApply();

            if(!roMap.containsKey(ra.getAporderid())){
                rai.setFailedMsg("该申请单的返利订单不存在，请拒绝");
                fatalList.add(rai);
                continue;
            }

            RebateOrderGroupByApOrderIdDTO roDto = roMap.get(ra.getAporderid());

            if(roDto.getTotalPayMoney().compareTo(ra.getMoney()) != 0){
                rai.setFailedMsg("返利申请单总金额和订单中总金额不一致，请拒绝");
                fatalList.add(rai);
                continue;
            }
            if(roDto.getTotalRebateMoney().compareTo(ra.getRebatemoney()) != 0 ){
                rai.setFailedMsg("返利申请单充值返利总金额和订单中充值返利总金额不一致，请拒绝");
                fatalList.add(rai);
                continue;
            }
            if(roDto.getTotalConsumeMoney().compareTo(ra.getConsumemoney()) != 0){
                rai.setFailedMsg("返利申请单消耗返利总金额和订单中消耗返利总金额不一致，请拒绝");
                fatalList.add(rai);
                continue;
            }
            if( roDto.getTotalConsumeMoney()+roDto.getTotalRebateMoney()!= ra.getPaymoney()){
                rai.setFailedMsg("返利申请单返利总金额和订单中返利总金额不一致，请拒绝");
                fatalList.add(rai);
                continue;
            }

            String orderid = roDto.getOrderId();
            PayDetailOK pdo1 = new PayDetailOK();
            pdo1.setOrderid(orderid);
            if(payDetailOkBo.count(pdo1)==0){
                rai.setFailedMsg("该申请单的充值原始订单不存在，请拒绝");
                fatalList.add(rai);
                continue;
            }

            Integer applyType = ra.getApplyType();

            //如果是充值返利
            PayDetailOK pdo2 = new PayDetailOK();
            pdo2.setOriginalOrderid(orderid);
            pdo2.setGiftFlag("1");
            if((1 == applyType||2==applyType)
                    && payDetailOkBo.count(pdo2)>0){
                rai.setFailedMsg("订单号为:" + orderid + "原始订单已经返利过了，不能重复返利，请拒绝");
                fatalList.add(rai);
                continue;
            }
            //如果是消耗返利
            PayDetailOK pdo3 = new PayDetailOK();
            pdo3.setOriginalOrderid(orderid+"_c");
            pdo3.setGiftFlag("1");
            if(3 == applyType
                    && payDetailOkBo.count(pdo3)>0){
                rai.setFailedMsg("订单号为:" + orderid + "原始订单已经返利过了，不能重复返利，请拒绝");
                fatalList.add(rai);
                continue;
            }

            String gameId = ra.getGameid();
            if(gameId != null&&"000001".equals(gameId)){//如果是魔域
                int money = new Double(ra.getPaymoney()).intValue();
                if(money%10 != 0){
                    rai.setFailedMsg("魔域的返利总金额必须是10的倍数，请拒绝");
                    fatalList.add(rai);
                }
            }
        }

        return fatalList;
    }

    /**
	  * 生成代金券
	  * @param one_uid
	  * @param generateNo
	  * @return
	  */
	 private String getVoucher(final int index,final String one_uid,final String generateNo) throws Exception{
		 StringBuffer params = new StringBuffer();
		 params.append("generateNo=").append(generateNo)
		 .append("&receiveUserId=").append(one_uid)
		 .append("&bizNo=").append(bizNo)
		 .append("&orderid=").append(getOrderId())
		 .append("&actNo=").append(actNo)
		 .append("&isReport=true");
		 
		 //验证数字签名是否ok
		Map<String,String> signMap=new HashMap<String, String>();
		signMap.put("generateNo", generateNo);
		signMap.put("receiveUserId", one_uid);
		signMap.put("bizNo", bizNo);
		String sign= SignUtil.sign(signMap,generatePrivateKey);
		params.append("&sign=").append(sign);
		System.out.println("getVoucher:"+VOUCHERURL+"?"+params);
		String responseText = HttpClientUtil.get(VOUCHERURL+"?"+params);
		System.out.println("getVoucher responseText:"+responseText);
		if(responseText != null){
			if(responseText.indexOf("(") !=-1){
				responseText = responseText.substring(responseText.indexOf("(")+1);
			}
			if(responseText.indexOf(")") !=-1){
				responseText = responseText.substring(0,responseText.indexOf(")"));
			}
		}
		JSONObject returnObject = new JSONObject(responseText);
		String rtn = returnObject.getString("rtn");
		if(!"0".equals(rtn)){
			throw new XLRuntimeException("从第"+index+"个代金券开始发放失败");
		}
		JSONObject dataObject = returnObject.getJSONObject("data");
		String cashNo = dataObject.getString("cashNo");
		System.out.println("responseText:"+responseText);
		 return cashNo;
	 }
	 

	 /**
	  * 代金券补发
	  * @return
	  */
	 public String replay(){
		 String aporderid = this.findParameter("one_aporderid");//返利申请单号
		 try{
			 RebateApply apply = new RebateApply();
			 apply.setAporderid(aporderid);
			 RebateApply ra = baseSo.findObject(apply);
			 if(ra == null){
				 throw new XLRuntimeException("该返利申请单不存在");				 
			 }
			 if(ra.getCheckstatus().intValue() != 1){//如果非审核通过的返利申请单
				 throw new XLRuntimeException("只有审核通过的返利申请单才能补发代金券");			
			 }
			 if(ra.getRebateType().indexOf("D")==-1){
				 throw new XLRuntimeException("该返利申请单返利形式不包含返代金券");				
			 }
			 RebateVoucher voucher = new RebateVoucher();
			 voucher.setAporderid(aporderid);
			 List<RebateVoucher> rvlist = baseSo.findObjects(voucher,queryPage);			 
			 if(rvlist == null||rvlist.size()==0){
				 throw new XLRuntimeException("该返利申请单没有需要补发的代金券");			
			 }
			 int index = 1;
			 for(RebateVoucher rv:rvlist){
				 if(StringTools.isEmpty(rv.getCdkey())){//如果没有发放过代金券
					 String cdkey = getVoucher(index,ra.getUid(),rv.getBatid());//调用接口生成代金券
					 rv.setCdkey(cdkey);
					 baseSo.updateObjectById(rv);					
				 }
				 index++;
			 }
			 ra.setIsSuccess(true);
			 baseSo.updateObjectById(ra);//更新发放状态
		 }catch(Exception e){
			   logger.error("补发失败", e);
				mergeJsmessage("补发失败，原因：" + e.getMessage());
		 }
		 return "";
	 }
	
	/**
	 * 审核拒绝
	 * @return
	 */
	public String doFail(){
		logger.info("开始拒绝返利订单");
		String reason = this.findParameter("reason");
		String aporderid = this.findParameter("one_aporderid");//返利申请单号
		String applyType = this.findParameter("one_applyType");//返利类型
		String yuanbao = this.findParameter("yuanbao");
		String FLOWNO = (yuanbao!=null&&yuanbao.equals("on"))?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
		String nowtime = now();
        boolean opflag = false;
		try{
			String account = this.currentUserLogo();//获得当前登录账号
			//检查审核人权限
			if(yuanbao!=null&&yuanbao.equals("on")){//如果返利申请单中包含返元宝
				if(!StringTools.isEmpty(LIMITCHECKERS)){
					if(LIMITCHECKERS.indexOf(account) != -1){//限制审核人不能审核返元宝的订单
						throw new XLRuntimeException("该返利申请单中包含返元宝，您没有审核权限");
					}
				}
			}	
			if("4".equals(applyType)){//如果是赠送补偿返利
				if(yuanbao!=null&&yuanbao.equals("on")){
					FLOWNO = Constant.ORDERFLOWNO;
				}else{
					FLOWNO = Constant.GIFTFLOWNO;
				}				
			}
			IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
			auth.checkUser(FLOWNO, aporderid,account);
			if(StringTools.isEmpty(reason)){
				throw new XLRuntimeException("拒绝理由不能为空");
			}
	    	RebateApply apply = new RebateApply();
	    	apply.setAporderid(aporderid);
	    	RebateApply ra = baseSo.findObject(apply);
	    	if(ra == null){
	    		throw new XLRuntimeException("该返利申请单不存在");
	    	}
	    	int checkstatus = ra.getCheckstatus().intValue();
	    	if(checkstatus>=1){
	    		throw new XLRuntimeException("该订单已经审核过了，请不要重复审核");
	    	}
	    	if(checkstatus!=-1&&checkstatus!=0){//如果返利申请单非待审核和审核中的状态
	    		throw new XLRuntimeException("该申请单非待审核和审核中的状态");
	    	}
	    	Games games = GameCache.getInstance().getGameByGameId(ra.getGameid());
	    	ra.setCheckstatus(new Integer(2));//审核不通过
	    	ra.setLastChecker(account);
	    	ra.setLastCheckTime(nowtime);
	    	//更新审核状态为不通过，结束整个流程
	    	baseSo.updateObjectById(ra);
	    	
	    	//记录审核不通过的记录
	    	auth.record(FLOWNO, aporderid, account, now(), 0, reason);	   
	    	//把之前的审核状态设置为无效
	    	auth.invalidRecord(FLOWNO, aporderid);	    		    	 	
	    	opflag = true;
	    	//发送邮件给申请者	    	
	    	StringBuffer content = new StringBuffer();
			content.append("非常遗憾，您的订单："+ra.getAporderid()+"，未能审核通过，原因："+reason);
			
			List<String> receivers = new ArrayList<String>();						
			//发送邮件通知申请者		
			StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(Integer.parseInt(applyType))).append("审核结果】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());
			//发送邮件给申请人			
			receivers.add(auth.getEmailFromName(ra.getInputBy()));			
			RebateApplyProxy.getInstance().sendMail(ra.getAporderid(), titleBuffer.toString(), content.toString(), receivers);
			logger.info("send dofail mail success to applyer:"+auth.getEmailFromName(ra.getInputBy()));
		}catch(Exception e){
			if(opflag){
				logger.error("审核成功，邮件发送失败", e);
				mergeJsmessage("审核成功，邮件发送失败，原因：" + e.getMessage());
			}else{
				logger.error("审核失败", e);
				mergeJsmessage("审核失败，原因：" + e.getMessage());
			}
		}
		return "";
	}

    public String doFailSelected(){
        String rebateApplySeqids = this.findParameter("rebateApplySeqids");
        String[] seqIdArr = rebateApplySeqids.split(",");
        if(seqIdArr.length==0){
            mergeJsmessage("未选中任何订单");
            return "";
        }
        String currentUser = this.currentUserLogo().trim();
        List<RebateApply> raList = new ArrayList<RebateApply>();
        List<RebateApply> failedList = new ArrayList<RebateApply>();
        for(String seqid:seqIdArr){
            RebateApply ra = FacadeFactory.INSTANCE.getBaseSo().findById(RebateApply.class, seqid);
            if(ra==null){
                RebateApply fra = new RebateApply();
                fra.setSeqid(Long.valueOf(seqid));
                failedList.add(ra);
                logger.error("批量返利拒绝：找不到订单seqid:"+seqid);
            }else{
                raList.add(ra);
            }
        }

        for(RebateApply theRa:raList){
            //返利申请单包含元宝，检查审核权限
            if(theRa.getRebateType().contains("y")
                    && StringTools.isEmpty(LIMITCHECKERS)
                    && LIMITCHECKERS.contains(currentUser)){
                failedList.add(theRa);
                logger.error("批量返利拒绝：该返利申请单中包含返元宝，您没有审核权限:"+theRa.getAporderid());
                continue;
            }
            String flowNo = (theRa.getRebateType().contains("y"))?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
            try {
                IBaseAuth auth = BaseAuthFactory.getBaseAuth(flowNo);
                auth.checkUser(flowNo, theRa.getAporderid(), currentUser);
            }catch (Exception e){
                failedList.add(theRa);
                logger.error("批量返利拒绝："+theRa.getAporderid(),e);
                continue;
            }
            if(theRa.getCheckstatus()>=1){
                failedList.add(theRa);
                logger.error("批量返利拒绝：已审核:"+theRa.getAporderid());
                continue;
            }
            if(theRa.getCheckstatus()!=-1&&theRa.getCheckstatus()!=0){//如果返利申请单非待审核和审核中的状态
                failedList.add(theRa);
                logger.error("批量返利拒绝：返利申请单非待审核和审核中的状态:"+theRa.getAporderid());
                continue;
            }
        }

        raList.removeAll(failedList);

        ExecutorService executor = Executors.newCachedThreadPool();
        for(RebateApply ra:raList) {
            Games games = GameCache.getInstance().getGameByGameId(ra.getGameid());
            ra.setCheckstatus(new Integer(2));//审核不通过
            ra.setLastChecker(currentUser);
            ra.setLastCheckTime(now());
            //更新审核状态为不通过，结束整个流程
            baseSo.updateObjectById(ra);
            try {
                String flowNo = (ra.getRebateType().contains("y")) ? Constant.ORDERFLOWNO : Constant.GIFTFLOWNO;
                IBaseAuth auth = BaseAuthFactory.getBaseAuth(flowNo);
                //记录审核不通过的记录
                auth.record(flowNo, ra.getAporderid(), currentUser, now(), 0, "批量拒绝");
                //把之前的审核状态设置为无效
                auth.invalidRecord(flowNo, ra.getAporderid());

                StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(Integer.valueOf(ra.getApplyType()))).append("审核结果】").append(games.getGameName()).append("(").append(ra.getServerid()).append(")|").append(ra.getMoney()).append("|").append(ra.getUsername()).append("|").append(ra.getApplyTime());

                NiuxEmailVo email = new NiuxEmailVo();
                email.setSubject(titleBuffer.toString());
                email.setContent("非常遗憾，您的订单："+ra.getAporderid()+"，未能审核通过");
                email.setAddrs(auth.getEmailFromName(ra.getInputBy()));
                AsynEmailSender sender = new AsynEmailSender(email);
                executor.submit(sender);

            }catch (Exception e) {
                logger.error("批量返利拒绝异常："+ra.getAporderid(),e);
            }
        }

        mergeJsmessage("成功:"+raList.size()+", 失败:"+failedList.size());
        return "";
    }


	/**
	 * 删除返利图片
	 * @return
	 */
	public String delete(){	
		logger.info("开始返利图片信息删除");
		String delseqids = findParameter("delseqids");				
		try{
			if(StringTools.isEmpty(delseqids)){
				throw new XLRuntimeException("请选择要删除的数据");
			}
			String one_aporderid = this.findParameter("one_aporderid");
			if(!StringTools.isEmpty(one_aporderid)){
				RebateApply apply = new RebateApply();
				apply.setAporderid(one_aporderid);
				List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
				if(ralist != null&& ralist.size()>0){
					RebateApply ra = ralist.get(0);
					checkOrderStatus(ra.getCheckstatus());//检查申请单状态
					String account = this.currentUserLogo();
					if(!ra.getInputBy().trim().equals(account.trim())){
						logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
					}
				}
			}
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(RebateOrderPhoto.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 选中订单
	 * @return
	 */
	public String selecta(){	
		logger.info("开始添加选中的订单");
		String orderselectids = findParameter("orderselectids");				
		try{
			if(StringTools.isEmpty(orderselectids)){
				throw new XLRuntimeException("请选择要删除的数据");
			}
			String one_aporderid = this.findParameter("one_aporderid");
			String applyType = this.findParameter("one_applyType");
			String paypercent = this.findParameter("paypercentall");
			String consumepercent = this.findParameter("consumepercentall");
			if(StringTools.isEmpty(paypercent)){
				throw new XLRuntimeException("充值返利总比例不能为空");
			}
			if(StringTools.isEmpty(consumepercent)){
				throw new XLRuntimeException("消耗返利总比例不能为空");
			}
			if(!StringTools.isEmpty(one_aporderid)){
				RebateApply apply = new RebateApply();
				apply.setAporderid(one_aporderid);
				List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
				if(ralist != null&& ralist.size()>0){
					RebateApply ra = ralist.get(0);
					checkOrderStatus(ra.getCheckstatus());//检查申请单状态
					String account = this.currentUserLogo();
					if(!ra.getInputBy().trim().equals(account.trim())){
						logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
					}
				}
			}
			String ids[] = orderselectids.split(",");
			PayDetailOK pdok = new PayDetailOK();
			Page page = new Page();
			page.setPageNo(1);
			page.setPageSize(1);
			List<PayDetailOK> pdolist = new ArrayList<PayDetailOK>();
			
			for(String id:ids){
				checkOrder(one_aporderid,id,pdok,page,pdolist);
			}
			for(PayDetailOK pdo:pdolist){
				saveOrder(one_aporderid,applyType,paypercent,consumepercent,pdo);	
			}
				
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	private void checkOrder(final String one_aporderid,final String id,final PayDetailOK pdok,final Page page,final List<PayDetailOK> pdolist) throws Exception {
		if(StringTools.isEmpty(id)||"null".equals(id))return;
		pdok.setSeqid(Long.parseLong(id.trim()));
		List<PayDetailOK> list =  payDetailOkBo.findPayDetailOk(pdok, page);
		if(list==null||list.size()==0){
			throw new XLRuntimeException("原始订单不存在");
		}		
		PayDetailOK pdo = list.get(0);
		
		//检查订单是否已经使用过
		RebateOrder query = new RebateOrder();
		query.setAporderid(one_aporderid);
		query.setOrderid(pdo.getOrderid());
		RebateOrder myro = baseSo.findObject(query);
		if(myro != null){
			throw new XLRuntimeException("本次返利申请单中，订单号："+pdo.getOrderid()+"已经使用过了");
		}
		query = new RebateOrder();
		query.setOrderid(pdo.getOrderid());
		query.setIsvalid(true);
		myro = baseSo.findObject(query);
		if(myro != null){
			throw new XLRuntimeException("其他返利申请单中，订单号："+pdo.getOrderid()+"已经使用过了");
		}
		pdolist.add(pdo);
	}
	
	private void saveOrder(final String one_aporderid,final String applyType
			,final String paypercent,final String consumepercent,final PayDetailOK pdo) throws Exception{
		RebateOrder rorder = new RebateOrder();
		rorder.setOrderid(pdo.getOrderid());
		rorder.setAccount(pdo.getTousername());
		rorder.setAporderid(one_aporderid);
		rorder.setApplyType(applyType);
		rorder.setOrderTime(pdo.getSuccesstime());
		rorder.setGameid(pdo.getGameid());
		rorder.setIsvalid(false);
		rorder.setUid(pdo.getToinneruserid());
		rorder.setServerid(pdo.getServerid());
		rorder.setPayMoney(pdo.getPayMondey());
        Double cm = pdo.getPayMondey()*Integer.parseInt(consumepercent)/100;
		rorder.setConsumeMoney((double)cm.intValue());
		rorder.setConsumePercent(Integer.parseInt(consumepercent));
        Double rm = pdo.getPayMondey()*Integer.parseInt(paypercent)/100;
		rorder.setRebateMoney((double)rm.intValue());
		rorder.setPercent(Integer.parseInt(paypercent));
        rorder.setActNo(pdo.getNiuxactno());
        int giftFlag = Integer.parseInt(pdo.getGiftFlag());
        rorder.setOrderType(giftFlag==0?1:giftFlag);
		FacadeFactory.INSTANCE.getBaseSo().addObject(rorder);
	}
	
	/**
	 * 删除返利订单
	 * @return
	 */
	public String deleteOrder(){	
		logger.info("开始返利订单信息删除");
		String delseqids = findParameter("delseqids");	
		String one_aporderid = this.findParameter("one_aporderid");
		try{
			if(StringTools.isEmpty(delseqids)){
				throw new XLRuntimeException("请选择要删除的数据");
			}
			if(!StringTools.isEmpty(one_aporderid)){
				RebateApply apply = new RebateApply();
				apply.setAporderid(one_aporderid);
				List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
				if(ralist != null&& ralist.size()>0){
					RebateApply ra = ralist.get(0);
					checkOrderStatus(ra.getCheckstatus());//检查申请单状态
					String account = this.currentUserLogo();
					if(!ra.getInputBy().trim().equals(account.trim())){
						logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
					}
				}
			}
			String ids[] = delseqids.split(",");
			for(String id:ids){
				baseSo.deleteById(RebateOrder.class, id);		
			}
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public static void giveOutYuanBao(final String userName,final String gameId,final String serverId,final String roleId,final String orderNo,final String actNo,final Integer unitprice){
		//签名
		Map<String,String> paramMap=new HashMap<String,String>();
		paramMap.put("gameid", gameId);
		paramMap.put("getusername", userName);
		paramMap.put("goodstimes", "1");
		paramMap.put("niuxactno", actNo);
		paramMap.put("originalorderid", orderNo);
		paramMap.put("unitprice",unitprice+"");
		paramMap.put("roleid", roleId==null?"":roleId);
		paramMap.put("serverid",serverId);
		String content=SignUtil.getSignatureContent(paramMap);
		String signMsg=SignUtil.sign(content, privateKey);
		StringBuilder sb=new StringBuilder();
		sb.append(yuanbaourl).append("/gamepaycenter/genorder?action=genorder")
		  .append("&gameid=").append(gameId)
		  .append("&getusername=").append(twoEncode(userName))
		  .append("&serverid=").append(serverId)
		  .append("&servername=").append(twoEncode(""))
		  .append("&roleid=").append(twoEncode(roleId==null?"":roleId))
		  .append("&rolename=").append(twoEncode(""))
		  .append("&paybiz=0&chargetype=").append("S")
		  .append("&unitprice=").append(unitprice).append("&goodstimes=1").append("&bankno=")
		  .append("&niuxactno=").append(actNo)
		  .append("&originalorderid=").append(orderNo)
		  .append("&signMsg=").append(signMsg);
		String respUrl=HttpClientUtil.get(sb.toString());
		if(!(respUrl.contains("code:0")||respUrl.contains("code:1"))){
			String msg=respUrl.substring(respUrl.indexOf("'"),respUrl.lastIndexOf("'"));
			try {
				msg=URLDecoder.decode(msg, "UTF-8");
				if(msg.contains("充值账号非游戏用户")){
					throw new NiuRuntimeException("1030", msg);
				}
			} catch (UnsupportedEncodingException e) {
				throw new NiuRuntimeException("99","字符集转换失败");
			}
			throw new NiuRuntimeException("99",msg);
		}
	}
	
	private static String twoEncode(String value){
		if(value==null||"".equals(value)){
			return "";
		}
		try {
			value=URLEncoder.encode(value, "UTF-8");
			return value;
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException();
		}
	}
}

class RebateApplyItem{
    private int status;// -1=未完成可执行状态, 0=完成且邮件已发送, 1=完成但邮件未发送, 3审核失败
    private RebateApply rebateApply;

    public void setMsg(String msg) {
        this.msg = msg;
    }

    private String msg;//失败原因
    private String flowNo;

    public String getFlowNo() {
        return flowNo;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public String getMsg() {
        return msg;
    }

    public void setFailedMsg(String msg) {
        this.msg = msg;
        this.status = 3;
    }

    public RebateApply getRebateApply() {
        return rebateApply;
    }

    public void setRebateApply(RebateApply rebateApply) {
        this.rebateApply = rebateApply;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}
