package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import com.xunlei.niux.manager.web.proxy.BaseAuthFactory;
import com.xunlei.niux.manager.web.proxy.IBaseAuth;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.league.bo.NiuxCashGenerateRecordBo;
import com.xunlei.niux.data.league.vo.NiuxCashGenerateRecord;
import com.xunlei.niux.data.league.vo.NiuxCashLotGroup;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CallEffect;
import com.xunlei.niux.data.vipgame.vo.CallRecord;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.RebateApply;
import com.xunlei.niux.data.vipgame.vo.RebateOrder;
import com.xunlei.niux.data.vipgame.vo.RebateOrderPhoto;
import com.xunlei.niux.data.vipgame.vo.RebateVoucher;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.RebateApplyProxy;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.util.StringTools;
import org.aspectj.weaver.ast.Call;

/**
 * 返利申请业务处理类
 * @author lisu
 *  2013-11-07
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_REBATEAPPLY)
public class RebateApplyManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(RebateApplyManagedBean.class.getName());
	private static final String VOUCHERACCOUNT = EnvPropertyUtil.loadProperty("niux","voucheraccount");
	public static Map<Integer,String> typeMap;
	private static Map<Integer,String> checkMap;
	private static Map<String,String> rebateMap;
	private BaseSo baseSo;
	private int rownum = 0;
	private boolean isAdd;
	private boolean isDel;
	private static Map<Long,String> personMap = null;
	private static InterfaceManManagedBean man = new InterfaceManManagedBean();
    private static final Page queryPage = new Page();
    private boolean isSecChecker;

    public boolean getIsSecChecker() {
        return isSecChecker;
    }

    public void setIsSecChecker(boolean isSecChecker) {
        this.isSecChecker = isSecChecker;
    }

    static {
		if(typeMap == null){
			typeMap = new HashMap<Integer,String>();
			typeMap.put(new Integer(1), "充值返利");
			typeMap.put(new Integer(2), "充值消耗返利");
			typeMap.put(new Integer(3), "消耗返利");			
			typeMap.put(new Integer(4), "赠送补偿返利");		
		}
		if(checkMap == null){
			checkMap = new HashMap<Integer,String>();
			checkMap.put(new Integer(-1), "待审核");
			checkMap.put(new Integer(0), "审核中");
			checkMap.put(new Integer(1), "通过");
			checkMap.put(new Integer(2), "不通过");
			checkMap.put(new Integer(-2), "修改中");
		}
		if(rebateMap == null){
			rebateMap = new HashMap<String,String>();
			rebateMap.put("y", "元宝");
			rebateMap.put("d", "道具");
			rebateMap.put("D", "代金券");
			rebateMap.put("yd", "元宝|道具");
			rebateMap.put("yD", "元宝|代金券");
			rebateMap.put("dD", "道具|代金券");
			rebateMap.put("ydD", "元宝|道具|代金券");
		}
	}
	
	public RebateApplyManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
		isAdd = super.isEnableAdd();
        isDel = super.isEnableDel();
        isSecondChecker();
    }

    private void isSecondChecker(){
        try {
            isSecChecker = BaseAuthFactory.getBaseAuth("001").isSpecialDisplayOrder("001",2,this.currentUserLogo());
        } catch (Exception e) {
            logger.error("获取审核人排序出错",e);
        }
    }

	public boolean isAdd() {
		return isAdd;
	}
	public void setAdd(boolean isAdd) {
		this.isAdd = isAdd;
	}
	public boolean isDel() {
		return isDel;
	}
	public void setDel(boolean isDel) {
		this.isDel = isDel;
	}
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	private Map<Object,String> getNiuxCashLotGroup(){
		   NiuxCashLotGroup query=new NiuxCashLotGroup();
			List<NiuxCashLotGroup> list=com.xunlei.niux.data.league.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects( query, queryPage);
			Map<Object,String> map=new HashMap<Object,String>();
			for(int i=0;i<list.size();i++){
				NiuxCashLotGroup group=list.get(i);
				map.put(group.getLotGroupId(), group.getGroupName());
			}
			return map;
	}
	
	 public List<SelectItem> getVoucherInfoList() {
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        Map<Object,String> map = getNiuxCashLotGroup();
	        NiuxCashGenerateRecord record = new NiuxCashGenerateRecord();
	        record.setIsDynamicGenerate(true);
	        record.setPromoterAccount(VOUCHERACCOUNT);
	        NiuxCashGenerateRecordBo recordBo = com.xunlei.niux.data.league.facade.FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo();
	        Page page = new Page();
	        page.addOrder("generateTime", OrderType.ESC);
	        List<NiuxCashGenerateRecord> ncgrlist = recordBo.finds(record,page);
	        for(NiuxCashGenerateRecord ncgr:ncgrlist){
	        	tempList.add(new SelectItem(ncgr.getSeqId(),"批次号"+ncgr.getGenerateNo()+" |面值"+ncgr.getParValue()+"  |使用最小金额"+ncgr.getMinPayMoney()+"   |"+map.get(ncgr.getLotGroupId())));
	        }
	        return tempList;
	 }
	
	 private void checkOrderStatus(int checkstatus) throws Exception{
		 if(checkstatus != -2&&checkstatus !=2){
			 throw new XLRuntimeException("该申请单非修改中和不通过的状态，无法修改");
		 }
	 }
	 
	 /**
	  * 添加代金券
	  * @return
	  */
	 public String addVoucher(){
		 logger.info("开始添加返利申请单的代金券");
		 this.authenticateAdd();//新增权限
		 String one_uid = findParameter("one_uid");
		 String one_aporderid = findParameter("one_aporderid");
		 String one_voucherId = findParameter("one_voucherId");
		 String one_amount = findParameter("one_amount");
		 String one_equalMoney = findParameter("one_equalMoney");
		 try{
			 if(StringTools.isEmpty(one_aporderid)){
				    logger.info("参数为空，返利申请单号不能为空");
					throw new XLRuntimeException("参数为空，返利申请单号不能为空");
			 }
			 if(StringTools.isEmpty(one_voucherId)){
				    logger.info("参数为空，代金券批次号不能为空");
					throw new XLRuntimeException("参数为空，代金券批次号不能为空");
			 }
			 if(StringTools.isEmpty(one_amount)){
				    logger.info("参数为空，数量不能为空");
					throw new XLRuntimeException("参数为空，数量不能为空");
			 }
			 if(StringTools.isEmpty(one_uid)){
				    logger.info("参数为空，迅雷uid不能为空，请添加正确的订单");
					throw new XLRuntimeException("参数为空，迅雷uid不能为空，请添加正确的订单");
			 }
			 if(StringTools.isEmpty(one_equalMoney)){
				    logger.info("参数为空，代金券等价金额不能为空");
					throw new XLRuntimeException("参数为空，代金券等价金额不能为空");
			 }

			 if(!StringTools.isEmpty(one_aporderid)){
					RebateApply apply = new RebateApply();
					apply.setAporderid(one_aporderid);
					List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
					if(ralist != null&& ralist.size()>0){
						RebateApply ra = ralist.get(0);
						checkOrderStatus(ra.getCheckstatus());//检查申请单状态
						String account = this.currentUserLogo();
						if(!ra.getInputBy().trim().equals(account.trim())){
							logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
							throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						}
					}
			 }
			 int amount = Integer.parseInt(one_amount);
			 if(amount <= 0){
				 logger.info("数量必须大于0");
				 throw new XLRuntimeException("数量必须大于0");
			 }
			 double equalMoney = Double.parseDouble(one_equalMoney);
			 if(equalMoney <= 0){
				 logger.info("代金券等价金额必须大于0");
				 throw new XLRuntimeException("代金券等价金额必须大于0");
			 }
			 //获得该代金券详情
			 NiuxCashGenerateRecord record = new NiuxCashGenerateRecord();
			 record.setSeqId(Long.parseLong(one_voucherId));
			 List<NiuxCashGenerateRecord> recordlist = com.xunlei.niux.data.league.facade.FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().finds(record,queryPage);
			 if(recordlist == null||recordlist.size()==0){
				 logger.info("该类型的代金券不存在");
				 throw new XLRuntimeException("该类型的代金券不存在");
			 }
			 NiuxCashGenerateRecord ncgr = recordlist.get(0);
			 double totalmoney = 0;
			 for(int i=0;i<amount;i++){
				 totalmoney += ncgr.getParValue().intValue();
			 }
			 RebateVoucher voucher = new RebateVoucher();
			 voucher.setAporderid(one_aporderid);
			 List<RebateVoucher> voucherlist = baseSo.findObjects(voucher, queryPage);
			 if(voucherlist != null){
				 for(RebateVoucher rv:voucherlist){
					 totalmoney += rv.getPrice();
				 }				 
			 }
			 if(totalmoney>equalMoney){
				 logger.info("代金券等价金额小于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为："+totalmoney);
				 throw new XLRuntimeException("代金券等价金额小于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为："+totalmoney);
			 }
			 //获得代金券组
			 Map<Object,String> map = getNiuxCashLotGroup();
			 
			 //添加代金券
			 for(int i=0;i<amount;i++){				 
				 RebateVoucher rv = new RebateVoucher();
				 rv.setAporderid(one_aporderid);
				 rv.setBatid(ncgr.getGenerateNo());
				 rv.setCdkey("");
				 rv.setCountLimit(map.get(ncgr.getLotGroupId()));
				 rv.setMinMoney(ncgr.getMinPayMoney());
				 rv.setPrice(ncgr.getParValue());
				 baseSo.addObject(rv);
			 }			 
		 }catch(Exception e){
			    logger.error("代金券添加失败", e);
				mergeJsmessage("代金券添加失败，原因：" + e.getMessage());
		 }				 
		 return  "";
	 }
	  
	 /**
	  * 删除代金券
	  * @return
	  */
	 public String deleteVoucher(){
		    logger.info("开始返利申请单代金券删除");
		    String delseqids = findParameter("delseqids");	
			String one_aporderid = this.findParameter("one_aporderid");
			try{
				if(StringTools.isEmpty(delseqids)){
					throw new XLRuntimeException("请选择要删除的数据");
				}
				if(!StringTools.isEmpty(one_aporderid)){
					RebateApply apply = new RebateApply();
					apply.setAporderid(one_aporderid);
					List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
					if(ralist != null&& ralist.size()>0){
						RebateApply ra = ralist.get(0);
						checkOrderStatus(ra.getCheckstatus());//检查申请单状态
						String account = this.currentUserLogo();

						if(!this.currentUserInfo().isSuperman() && !ra.getInputBy().trim().equals(account.trim())){
							logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
							throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
						}
					}
				}
				String ids[] = delseqids.split(",");
				for(String id:ids){
					baseSo.deleteById(RebateVoucher.class, id);		
				}
			}catch(Exception e){
				logger.error("删除失败", e);
				mergeJsmessage("删除失败，原因：" + e.getMessage());
			}
		 return "";
	 }
	 
	 
	 /**
	  * 判断是否专属客服
	  */
	 @Deprecated
	 private void checkCustomerService(String uid,String reason) throws XLRuntimeException {
		 CustomerDetailQuery cdq = new CustomerDetailQuery();
		 cdq.setUid(uid);
		 CustomerDetailQuery customer = baseSo.findObject(cdq);
		 String username = this.currentUserInfo().getTrueName();
		 String customerService = customer.getCustomerService();
		 if(StringTools.isEmpty(customerService))return;
		 if(!username.trim().equals(customerService.trim())){//如果当前用户非专属客服
			 if(StringTools.isEmpty(reason)||reason.indexOf("个性化_")==-1){
				 throw new XLRuntimeException("非该用户的专属客服，只能申请个性化道具");
			 }
		 }
		 
	 }
	 
	/**
	 * 查询返利申请
	 * @return
	 */
	public String getQueryRebateApplyList(){
		logger.info("开始返利申请查询");
        this.authenticateRun();//验证运行权限
        RebateApply apply = findBean(RebateApply.class, "rebateapply");
        if(apply != null){
        	if(apply.getCheckstatus() != null&& apply.getCheckstatus().intValue()==0){
        		apply.setCheckstatus(null);
        	}
        	if(apply.getCheckstatus()!=null&&apply.getCheckstatus().intValue()==3){
        		apply.setCheckstatus(new Integer(0));
        	}
        	if(apply.getApplyType()!=null&&apply.getApplyType().intValue()==0){
        		apply.setApplyType(null);
        	}
        	if(apply.getWorkType()!=null&&apply.getWorkType().intValue()==0){
        		apply.setWorkType(null);
        	}
        	if(apply.getVipGrade()!=null&&apply.getVipGrade().intValue()==0){
        		apply.setVipGrade(null);
        	}
        }
        String qapplytype = findParameter("qapplytype");
        String persons = findParameter("persons");
        StringBuffer sb = new StringBuffer();       
        if(!StringTools.isEmpty(persons)&&!"0,".equals(persons)){
    		personMap = man.getPersonMap();
    		System.out.println("personMap:"+personMap);
        	String usernames[] = persons.split(",");
        	if(usernames != null){
        		 sb.append(" and  username in (");
        		for(String username:usernames){
        			 if(!StringTools.isEmpty(username)){
        				sb.append("'").append(personMap.get(Long.parseLong(username.replaceAll(",", "").trim()))).append("',");
        			 }
        		}
        		sb.append("'a')");
        	}
        }        
        if(!StringTools.isEmpty(qapplytype)){
        	apply.setRebateType(qapplytype);
        }
        PagedFliper pagedFliper = this.getFliper();
        System.out.println("sb:"+sb);
        int count = FacadeFactory.INSTANCE.getRebateOrderBo().count(RebateApply.class, sb.toString(), apply);
        pagedFliper.setRecordCount(count);
        List<RebateApply> list = new ArrayList<RebateApply>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("applyTime", OrderType.DESC);
            list = FacadeFactory.INSTANCE.getRebateOrderBo().findByObject(RebateApply.class, sb.toString(), apply, page);
        }
        Sheet<RebateApply> sheet = new Sheet<RebateApply>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	
	
	 /**
	  * 获得该uid 实时的vip等级
	  * @param uid
	  * @return
	  */
	 private int getVipGrade(String uid){
		 CustomerDetailQuery query = new CustomerDetailQuery();
		 query.setUid(uid);
		 CustomerDetailQuery cdq = baseSo.findObject(query);
		 if(cdq == null)return 0;
		 return cdq.getLiveVipGrade();
	 }
	
	/**
	 * 新增返利申请
	 * @return
	 */
	public String add(){
		logger.info("开始返利申请添加");		
		this.authenticateAdd();//新增权限
		RebateApply apply = this.findBean(RebateApply.class,"rebateapply");	
		String one_aporderid = this.findParameter("one_aporderid");
		String one_username = this.findParameter("one_username");
		String one_applyTime = this.findParameter("one_applyTime");
		String one_toaccount = this.findParameter("one_toaccount");
		String one_gameid = this.findParameter("one_gameid");
		String one_serverid = this.findParameter("one_serverid");
		String one_uid = this.findParameter("one_uid");
		String one_crid = this.findParameter("one_crid");
		//String one_money = this.findParameter("one_money");
		String one_rebatemoney = this.findParameter("one_rebatemoney");
		String one_consumemoney = this.findParameter("one_consumemoney");
		String one_workType = this.findParameter("one_workType");
		String yuanbao = this.findParameter("yuanbao");
		String daoju = this.findParameter("daoju");
		String daijinquan = this.findParameter("daijinquan");
		String one_paymoney = this.findParameter("one_paymoney");
		String one_receiver = this.findParameter("one_receiver");
		String one_equalMoney = this.findParameter("one_equalMoney");
		String checkradio = this.findParameter("serverradio");//是否限制区服
		boolean addflag = false;		
		try{
			if(StringTools.isEmpty(one_aporderid)){
				logger.info("返利申请单号为空");
				throw new XLRuntimeException("返利申请单号为空");
			}
			if(StringTools.isEmpty(one_crid)){
				logger.info("外呼单号为空");
				throw new XLRuntimeException("外呼单号为空");
			}
			if(apply==null){
				logger.info("返利申请信息为空");
				throw new XLRuntimeException("返利申请信息为空");
			}		
			int applyType = apply.getApplyType();
			//String FLOWNO = (yuanbao!=null&&yuanbao.equals("on"))?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
			CallRecord record = new CallRecord();
			record.setSeqid(Long.parseLong(one_crid));
			CallRecord callrecord = baseSo.findObject(record);
			if(callrecord == null){
				logger.info("外呼单号为空");
				throw new XLRuntimeException("外呼单号为空");
			}
//			if(daoju!=null&&daoju.equals("on")){
//				checkCustomerService(one_uid,apply.getReason());
//			}
			Page commonpage = new Page();
			RebateOrder order = new RebateOrder();
			order.setAporderid(one_aporderid);
			List<RebateOrder> rolist = baseSo.findObjects(order, commonpage);

			if(applyType!=4){//如果不是赠送补偿返利，则需要录入订单
				if(rolist == null||rolist.size()==0){
					logger.info("请至少添加一个返利订单");
					throw new XLRuntimeException("请至少添加一个返利订单");	
				}		
			}	
			
		   if(daijinquan != null &&daijinquan.equals("on")){//如果返利形式包含 代金券
			   RebateVoucher voucher = new RebateVoucher();
			   voucher.setAporderid(one_aporderid);
			   List<RebateVoucher> rvlist = baseSo.findObjects(voucher,commonpage);
			   if(rvlist == null||rvlist.size()==0){
					logger.info("返利形式包含代金券，请至少添加一个代金券");
					throw new XLRuntimeException("返利形式包含代金券，请至少添加一个代金券");	
			   }
		   }			
		 RebateApply ra = new RebateApply();
		 ra.setAporderid(one_aporderid);
		 RebateApply rapply= baseSo.findObject(ra);
		 if(rapply != null){
			logger.info("请不要重复提交申请单");
			throw new XLRuntimeException("请不要重复提交申请单");
		  }
		   if(yuanbao != null&&yuanbao.equals("on")){//如果返利形式 是返元宝
			   if(!(daoju != null&&daoju.equals("on"))&&!(daijinquan != null&&daijinquan.equals("on"))){//如果不包含其他返利形式
				   if(applyType==1){//如果是充值返利
						String message= applyType ==1?"充值返利":"充值返利及返道具";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() != null&&reorder.getConsumePercent().intValue()!=0 ){
								logger.info("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须为0");	
							}
							if(reorder.getPercent()==null||reorder.getPercent().intValue()==0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须大于0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须大于0");	
							}
						}
						if(StringTools.isEmpty(one_rebatemoney)|Double.parseDouble(one_rebatemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}else if(applyType==2){//如果是充值消耗返利
						String message= applyType ==2?"充值及消耗返利":"充值及消耗返利及返道具";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() == null||reorder.getConsumePercent().intValue()==0 ){
								if(reorder.getPercent()==null||reorder.getPercent().intValue()==0){
									logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例和消耗返利比例不能同时为0");
									throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例和消耗返利比例不能同时为0");	
								}

							}							
						}
						if(StringTools.isEmpty(one_rebatemoney)||Double.parseDouble(one_rebatemoney)==0){
							if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额和消耗返利总金额不能同时为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额和消耗返利总金额不能同时为0");	
							}							
						}						
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}else if(applyType==3){//如果是消耗返利
						String message= applyType ==3?"消耗返利":"充值返道具及消耗返利";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() == null||reorder.getConsumePercent().intValue()==0 ){
								logger.info("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须大于0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须大于0");	
							}
							if(reorder.getPercent()!=null&&reorder.getPercent().intValue()!=0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须为0");	
							}
						}
						if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}			   		   				   		   
			   }else{//如果包含其他返利形式
				   boolean flag = false;
				   for(RebateOrder reorder:rolist){
						double remoney = reorder.getRebateMoney()==null?0:reorder.getRebateMoney();
						double conmoney = reorder.getConsumeMoney()==null?0:reorder.getConsumeMoney();
						if(remoney+conmoney>0){
							flag = true;
						}
					}
				   if(!flag&&applyType!=4){
						logger.info("返利形式包含返元宝，返利总金额必须大于0");
						throw new XLRuntimeException("返利形式包含返元宝，返利总金额必须大于0");	
				   }
			   }			  
		   }else{			   
			   String message= (daoju!=null&&daoju.equals("on"))?"道具":"代金券";
			   for(RebateOrder reorder:rolist){
				   if(reorder.getPercent()!=null&&reorder.getPercent().intValue()!=0){
						logger.info("返利形式为："+message+"的订单，充值返利比例必须为0");
						throw new XLRuntimeException(message+"类型的订单，充值返利比例必须为0");	
					}
				   if(reorder.getConsumePercent() != null&&reorder.getConsumePercent().intValue()!=0 ){
						logger.info("返利形式为："+message+"的订单，消耗返利比例必须为0");
						throw new XLRuntimeException(message+"类型的订单，消耗返利比例必须为0");	
					}
				   if(StringTools.isEmpty(one_rebatemoney)&&Double.parseDouble(one_rebatemoney)!=0){
						logger.info("返利形式为："+message+"的订单，充值返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，充值返利总金额必须为0");	
					}
					if(StringTools.isEmpty(one_consumemoney)&&Double.parseDouble(one_consumemoney)!=0){
						logger.info("返利形式为："+message+"的订单，消耗返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，消耗返利总金额必须为0");	
					}
					if(StringTools.isEmpty(one_paymoney)&&Double.parseDouble(one_paymoney)!=0){
						logger.info("返利形式为："+message+"的订单，返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，返利总金额必须为0");	
					}
				} 				   
		   }
		   if(daijinquan != null&&daijinquan.equals("on")){
			   checkVoucherMoney(one_aporderid,Double.parseDouble(one_equalMoney));
		   }		
		   if(checkradio!=null&&"0".equals(checkradio)){
			   apply.setIsServer(false);
		   }else{
			   apply.setIsServer(true);
		   }
			apply.setApplyTime(one_applyTime);
			apply.setUsername(one_username);
			apply.setUid(one_uid);
			apply.setToaccount(one_toaccount);
			apply.setGameid(one_gameid);
			if(applyType==4){
				String one_gameid_a = this.findParameter("one_gameid_a");
				apply.setGameid(one_gameid_a);
			}
			apply.setServerid(one_serverid);
			apply.setCrid(one_crid);
			CallRecord callRecord = FacadeFactory.INSTANCE.getBaseSo().findById(CallRecord.class, one_crid);
			if(callRecord == null){
				logger.info("外呼记录不存在");
				throw new XLRuntimeException("外呼记录不存在");	
			}
			apply.setCallTime(callRecord.getCallTime());
			apply.setWorkType(Integer.parseInt(one_workType));
			apply.setVipGrade(getVipGrade(one_uid));
			//apply.setMoney(Double.parseDouble(one_money));
			//apply.setRebatemoney(Double.parseDouble(one_rebatemoney));
			//apply.setConsumemoney(Double.parseDouble(one_consumemoney));
			//apply.setPaymoney(apply.getRebatemoney()+apply.getConsumemoney());
			apply.setCheckstatus(new Integer(-1));//设置审核状态为待审核
			apply.setInputBy(this.currentUserLogo());		
			apply.setAporderid(one_aporderid);
			String rebatetype = "";
			if(yuanbao != null&&yuanbao.equals("on")){
				rebatetype += "y";
				apply.setIsSuccess(true);
			}
			if(daoju != null&&daoju.equals("on")){
				rebatetype += "d";
				apply.setIsSuccess(true);
			}
			if(daijinquan != null&&daijinquan.equals("on")){
				rebatetype += "D";
				apply.setIsSuccess(false);
			}
			apply.setRebateType(rebatetype);
			if(!StringTools.isEmpty(one_receiver))
			    apply.setReceiver(one_receiver);
															
			addflag = true;
			Map<String,Double> map  = updateOrder(one_aporderid);//更新返利订单状态为有效
			//这个操作时为了确保金额的正确性
			double consumeMoney = map.get("consumeMoney");
			double payMoney = map.get("payMoney");
			double rebateMoney = map.get("rebateMoney");
			double totalMoney = map.get("totalMoney");			
			apply.setRebatemoney(new Double((int)rebateMoney));
			apply.setConsumemoney(new Double((int)consumeMoney));
			if(applyType!=4){
				apply.setPaymoney(new Double((int)payMoney));
			}else{//如果是充值赠送返利
				double mypaymoney = new Double(Double.valueOf(StringTools.isEmpty(one_paymoney)?"0":one_paymoney).intValue());				
				if(payMoney>0){//如果有充值订单，则按照充值订单的金额
					apply.setPaymoney(apply.getRebatemoney()+apply.getConsumemoney());
				}else{//如果没有充值订单，则按照输入的金额
					apply.setPaymoney(mypaymoney);
				}				
			}

            //获取改用户当月最大申请次数
            String getMonthCountsql = " SELECT count(*)  FROM rebateapply WHERE checkstatus =1 and aporderid <> ? and uid=? AND DATE_FORMAT(applytime,'%Y-%m') = DATE_FORMAT(now(),'%Y-%m')";
            int monthCount = FacadeFactory.INSTANCE.getBaseSo().count(getMonthCountsql, new String[]{apply.getAporderid(),apply.getUid()});
            apply.setMonthCount(monthCount);

            //获取改用户历史最大申请次数
            String sql="select count(*) from rebateapply where checkstatus=1 and aporderid<> ? and uid=?";
            int totalCount = FacadeFactory.INSTANCE.getBaseSo().count(sql, new String[]{apply.getAporderid(), apply.getUid()});
            apply.setTotalCount(totalCount);

			apply.setMoney(new Double((int)totalMoney));

			baseSo.addObject(apply);

            //申请返利订单时，自动新增申请时间为外呼时间的一条外呼记录
            CallRecord newcr = new CallRecord();
            newcr.setCallType(7);
            newcr.setUid(apply.getUid());
            newcr.setGameId(apply.getGameid());
            newcr.setCallTime(apply.getApplyTime());
            newcr.setListenStatus(1);
            newcr.setCustomerServiceName(currentUserInfo().getTrueName());
            newcr.setInputby(currentUserLogo());
            newcr.setInputtime(now());
            newcr.setRebateCount(0);
            newcr.setMoney(0L);
            newcr.setRebateMoney(0L);
            baseSo.addObject(newcr);

            //更新CustomerDetailQuery
            CustomerDetailQuery cdqQuery = new CustomerDetailQuery();
            cdqQuery.setUid(apply.getUid());
            CustomerDetailQuery cdq = baseSo.findObject(cdqQuery);
            if(cdq!=null){
                ////专属客服自动默认为对当前账号有3个外呼记录且最后外呼人的客服所有
                CallRecord crQuery = new CallRecord();
                crQuery.setUid(apply.getUid());
                crQuery.setCustomerServiceName(currentUserInfo().getTrueName());
                if(baseSo.countObject(crQuery)>=3){
                    cdq.setCustomerService(currentUserInfo().getTrueName());
                }
                cdq.setLastCallTime(now());
                baseSo.updateObjectById(cdq);
            }

			//操作成功后处理脏数据
			if(!(yuanbao != null&&yuanbao.equals("on"))){
				RebateOrder order2 = new RebateOrder();
				order2.setAporderid(one_aporderid);
				List<RebateOrder> rolist2 = baseSo.findObjects(order2,queryPage);
				for(RebateOrder ro:rolist2){
					ro.setRebateMoney(new Double(0));
					ro.setPercent(new Integer(0));
					ro.setConsumePercent(new Integer(0));
					ro.setConsumeMoney(new Double(0));
					baseSo.updateObjectById(ro);
				}
				apply.setRebatemoney(new Double(0));
				apply.setConsumemoney(new Double(0));
				apply.setPaymoney(new Double(0));
			}
			if(!(daoju != null&&daoju.equals("on"))){				
				apply.setPropName("");
				apply.setReceiver("");				
			}
			if(!(daijinquan != null&&daijinquan.equals("on"))){				
				RebateVoucher voucher2 = new RebateVoucher();	
				voucher2.setAporderid(one_aporderid);
				List<RebateVoucher> rvlist2 = baseSo.findObjects(voucher2,queryPage);
				for(RebateVoucher rv:rvlist2){
					baseSo.deleteById(RebateVoucher.class, rv.getSeqid());
				}
				apply.setEqualMoney(new Double(0));
				
			}
			baseSo.updateObjectById(apply);
						
//			IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
//			String account = auth.getFirstChecker(FLOWNO, one_aporderid);		
			Games games = GameCache.getInstance().getGameByGameId(apply.getGameid());
			List<String> receivers = new ArrayList<String>();						
			//发送邮件通知申请者		
			StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(applyType)).append("申请】").append(games.getGameName()).append("(").append(apply.getServerid()).append(")|").append(apply.getMoney()).append("|").append(apply.getUsername()).append("|").append(apply.getApplyTime());
//			if(!StringTools.isEmpty(account))	//发送邮件给审核			
//			   receivers.add(auth.getEmailFromName(account));
			if(!StringTools.isEmpty(one_receiver)){//如果配置了通知收件人
				 String receiver[] = one_receiver.split(",");			
				 for(String rec:receiver){
					 if(!StringTools.isEmpty(rec)){
						 receivers.add(rec);
					 }
				 }
			}
			RebateApplyProxy.getInstance().sendMail(one_aporderid, titleBuffer.toString(), "", receivers);
						
		}catch(Exception e){
			if(addflag){
				logger.error("添加成功，邮件发送失败", e);
				mergeJsmessage("添加成功，邮件发送失败，原因：" + e.getMessage());
			}else{
				//deleteOrder(one_aporderid);//删除无效的返利订单
				deletePhoto(one_aporderid);//删除无效的图片
				logger.error("添加失败", e);
				mergeJsmessage("添加失败，原因：" + e.getMessage());
			}
		}
		return "";
	}
	
	
	   private void checkVoucherMoney(String aporderid,double equalMoney) throws Exception{
		    RebateVoucher voucher = new RebateVoucher();
		    voucher.setAporderid(aporderid);
		    List<RebateVoucher> rvlist =  baseSo.findObjects(voucher, queryPage);
		    if(rvlist == null||rvlist.size()==0){
		    	if(equalMoney > 0){
		    		 logger.info("代金券等价金额不等于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为：0");
					 throw new XLRuntimeException("代金券等价金额不等于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为：0");
		    	}
		    }else{
		    	double totalMoney = 0D;
		    	for(RebateVoucher rv:rvlist){
		    		totalMoney += rv.getPrice();		    		
		    	}
		    	if(equalMoney != totalMoney){
		    		 logger.info("代金券等价金额不等于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为："+totalMoney);
					 throw new XLRuntimeException("代金券等价金额不等于实际添加的代金券总金额,代金券等价金额为："+equalMoney+"，实际添加总金额为："+totalMoney);
		    	}
		    }
	   }
	
    public Map<String,Double> updateOrder(String aporderid){
	    RebateOrder order = new RebateOrder();
		order.setAporderid(aporderid);
		List<RebateOrder> rolist = baseSo.findObjects(order,queryPage);
		double consumeMoney = 0;
		double payMoney = 0;
		double rebateMoney = 0;
		double totalMoney = 0;
		Map<String,Double> map = new HashMap<String,Double>();
		for(RebateOrder ro:rolist){
			ro.setIsvalid(true);
			baseSo.updateObjectById(ro);
			consumeMoney += ro.getConsumeMoney();
			rebateMoney += ro.getRebateMoney();
			totalMoney += ro.getPayMoney();
			payMoney = consumeMoney+rebateMoney;
		}
		payMoney = (int)consumeMoney+(int)rebateMoney;
		map.put("consumeMoney", consumeMoney);
		map.put("payMoney", payMoney);
		map.put("rebateMoney", rebateMoney);
		map.put("totalMoney", totalMoney);
		return map;
   }
   

	
	public String addPhoto(){
		String one_aporderid = this.findParameter("one_aporderid");
		String one_urls = this.findParameter("one_urls");		
         try{
     		if(!StringTools.isEmpty(one_aporderid)){
     			RebateApply apply = new RebateApply();
     			apply.setAporderid(one_aporderid);
     			List<RebateApply> ralist = baseSo.findObjects(apply, queryPage);
     			if(ralist != null&& ralist.size()>0){
     				RebateApply ra = ralist.get(0);
     				checkOrderStatus(ra.getCheckstatus());//检查申请单状态
     				String account = this.currentUserLogo();
     				if(!ra.getInputBy().trim().equals(account.trim())){
     					logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
     					throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+ra.getInputBy());
     				}
     			}
     		}
	    	   if(!StringTools.isEmpty(one_urls)){
		   			if(one_urls.indexOf(",")!=-1){
		   				String urls[] = one_urls.split(",");
		   				for(String url:urls){
		   					if(StringTools.isEmpty(url))continue;
		   					RebateOrderPhoto rop = new RebateOrderPhoto();
		   					rop.setAporderid(one_aporderid);
		   					rop.setPhoto(url);
		   				    baseSo.addObject(rop);
		   				}
		   			}else{
		   				RebateOrderPhoto rop = new RebateOrderPhoto();
		   				rop.setAporderid(one_aporderid);
		   				rop.setPhoto(one_urls);
		   			    baseSo.addObject(rop);
		   			}
	   		}
       }catch(Exception e){
    	   logger.error("图片添加失败", e);
			mergeJsmessage("图片添加失败，原因：" + e.getMessage());
       }
		
		return "";
	}
	
	public void deleteOrder(String aporderid){
		RebateOrder order = new RebateOrder();
		order.setAporderid(aporderid);
		order.setIsvalid(false);
		List<RebateOrder> rolist = baseSo.findObjects(order,queryPage);
		for(RebateOrder ro:rolist){
			baseSo.deleteById(RebateOrder.class, ro.getSeqid());
		}
	}
	public void deletePhoto(String aporderid){
		RebateOrderPhoto photo = new RebateOrderPhoto();
		photo.setAporderid(aporderid);
		List<RebateOrderPhoto> rolist = baseSo.findObjects(photo,queryPage);
		for(RebateOrderPhoto ph:rolist){
			baseSo.deleteById(RebateOrderPhoto.class, ph.getSeqid());
		}
	}
	
	/**
	 * 修改返利申请
	 * @return
	 */
	public String edit(){
		logger.info("开始返利申请信息修改");
		this.authenticateEdit();//编辑权限
		RebateApply apply = this.findBean(RebateApply.class,"rebateapply");	
		String one_aporderid = this.findParameter("one_aporderid");
		String one_username = this.findParameter("one_username");
		String one_applyTime = this.findParameter("one_applyTime");
		String one_toaccount = this.findParameter("one_toaccount");
		String one_gameid = this.findParameter("one_gameid");
		String one_serverid = this.findParameter("one_serverid");
		String one_workType = this.findParameter("one_workType");	
		String one_uid = this.findParameter("one_uid");
		String one_crid = this.findParameter("one_crid");
		String one_money = this.findParameter("one_money");
		String one_checkstatus = this.findParameter("one_checkstatus");
		String one_rebatemoney = this.findParameter("one_rebatemoney");
		String one_consumemoney = this.findParameter("one_consumemoney");
		String one_inputBy = this.findParameter("one_inputBy");
		String one_receiver = this.findParameter("one_receiver");
		String one_paymoney = this.findParameter("one_paymoney");
		String yuanbao = this.findParameter("yuanbao");
		String daoju = this.findParameter("daoju");
		String daijinquan = this.findParameter("daijinquan");		
		String one_equalMoney = this.findParameter("one_equalMoney");
		String one_isSuccess = this.findParameter("one_isSuccess");
		String checkradio = this.findParameter("serverradio");//是否限制区服
		boolean editflag = false;
		try{			
			if(one_checkstatus!=null){
				if("1".equals(one_checkstatus)){
					logger.info("该返利申请单已经审核通过了，请不要再提交");
					throw new XLRuntimeException("该返利申请单已经审核通过了，请不要再提交");
				}
			}
			if(one_inputBy==null||!one_inputBy.trim().equals(this.currentUserLogo())){
				logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+one_inputBy);
				throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+one_inputBy);
			}
			if(StringTools.isEmpty(one_aporderid)){
				logger.info("返利申请单号为空");
				throw new XLRuntimeException("返利申请单号为空");
			}
//			if(daoju!=null&&daoju.equals("on")){
//				checkCustomerService(one_uid,apply.getReason());
//			}
			RebateApply queryApply = new RebateApply();
			queryApply.setAporderid(one_aporderid);
			RebateApply  rapply = baseSo.findObject(queryApply);
			if(rapply == null){
				logger.info("返利申请信息为空");
				throw new XLRuntimeException("返利申请信息为空");
			}
			int checkstatus = rapply.getCheckstatus().intValue();
			if(checkstatus != -2&&checkstatus != 2){
				logger.info("该返利申请单非修改中或不通过的状态");
				throw new XLRuntimeException("该返利申请单非修改中或不通过的状态");
			}
			if(StringTools.isEmpty(one_crid)){
				logger.info("外呼单号为空");
				throw new XLRuntimeException("外呼单号为空");
			}
			if(apply==null){
				logger.info("返利申请信息为空");
				throw new XLRuntimeException("返利申请信息为空");
			}		
			int applyType = apply.getApplyType();
			//String FLOWNO = (yuanbao!=null&&yuanbao.equals("on"))?Constant.ORDERFLOWNO:Constant.GIFTFLOWNO;
			Page commonpage = new Page();
			RebateOrder order = new RebateOrder();
			order.setAporderid(one_aporderid);
			List<RebateOrder> rolist = baseSo.findObjects(order,commonpage );
			if(applyType != 4){
					if(rolist == null||rolist.size()==0){
						rapply.setRebatemoney(new Double(0));
						rapply.setConsumemoney(new Double(0));
						rapply.setPaymoney(new Double(0));
						baseSo.updateObjectById(rapply);
						logger.info("请至少添加一个返利订单");
						throw new XLRuntimeException("请至少添加一个返利订单");	
					}		
			}
		   if(daijinquan !=null&&daijinquan.equals("on")){//如果返利形式包含 代金券
			   RebateVoucher voucher = new RebateVoucher();
			   voucher.setAporderid(one_aporderid);
			   List<RebateVoucher> rvlist = baseSo.findObjects(voucher,commonpage);
			   if(rvlist == null||rvlist.size()==0){
					logger.info("返利形式包含代金券，请至少添加一个代金券");
					throw new XLRuntimeException("返利形式包含代金券，请至少添加一个代金券");	
			   }
		   }
		  
		   
		   if(yuanbao != null&&yuanbao.equals("on")){//如果返利形式 是返元宝
			   if(!(daoju != null&&daoju.equals("on"))&&!(daijinquan != null&&daijinquan.equals("on"))){//如果是返元宝
				   if(applyType==1){//如果是充值返利
						String message= applyType ==1?"充值返利":"充值返利及返道具";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() != null&&reorder.getConsumePercent().intValue()!=0 ){
								logger.info("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须为0");	
							}
							if(reorder.getPercent()==null||reorder.getPercent().intValue()==0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须大于0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须大于0");	
							}
						}
						if(StringTools.isEmpty(one_rebatemoney)|Double.parseDouble(one_rebatemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					   rapply.setConsumemoney(0D);
					   rapply.setPaymoney(rapply.getRebatemoney());
					}else if(applyType==2){//如果是充值消耗返利
						String message= applyType ==2?"充值及消耗返利":"充值及消耗返利及返道具";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() == null||reorder.getConsumePercent().intValue()==0 ){
								if(reorder.getPercent()==null||reorder.getPercent().intValue()==0){
									logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例和消耗返利比例不能同时为0");
									throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例和消耗返利比例不能同时为0");	
								}
							}		
						}
						if(StringTools.isEmpty(one_rebatemoney)||Double.parseDouble(one_rebatemoney)==0){
							if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额和消耗返利总金额不能同时为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额和消耗返利总金额不能同时为0");	
							}							
						}			
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}else if(applyType==3){//如果是消耗返利
						String message= applyType ==3?"消耗返利":"充值返道具及消耗返利";
						for(RebateOrder reorder:rolist){
							if(reorder.getConsumePercent() == null||reorder.getConsumePercent().intValue()==0 ){
								logger.info("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须大于0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，消耗返利比例必须大于0");	
							}
							if(reorder.getPercent()!=null&&reorder.getPercent().intValue()!=0){
								logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须为0");
								throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利比例必须为0");	
							}
						}
						if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}	
				   rapply.setRebatemoney(0D);
				   rapply.setPaymoney(rapply.getConsumemoney());
			   }else{//如果还返其他的
				   if(applyType != 4){
					   boolean flag = false;
						for(RebateOrder reorder:rolist){
							double remoney = reorder.getRebateMoney()==null?0:reorder.getRebateMoney();
							double conmoney = reorder.getConsumeMoney()==null?0:reorder.getConsumeMoney();
							if(remoney +conmoney >0)flag = true;
						}
						if(!flag){
							throw new XLRuntimeException("返利形式包含返元宝，订单中的实际返利总金额必须大于0");	
						}					   					   
				   }
				   
				   if(applyType==1){//如果是充值返利
						String message= applyType ==1?"充值返利":"充值返利及返道具";						
						if(StringTools.isEmpty(one_rebatemoney)|Double.parseDouble(one_rebatemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}else if(applyType==2){//如果是充值消耗返利
						String message= applyType ==2?"充值及消耗返利":"充值及消耗返利及返道具";
//						if(StringTools.isEmpty(one_rebatemoney)||Double.parseDouble(one_rebatemoney)==0){
//							logger.info("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");
//							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值返利总金额必须大于0");	
//						}
//						if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
//							logger.info("返利形式为返元宝，"+message+"类型的订单，消耗返利总金额必须大于0");
//							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，消耗返利总金额必须大于0");	
//						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}else if(applyType==3){//如果是消耗返利
						String message= applyType ==3?"消耗返利":"充值返道具及消耗返利";
						if(StringTools.isEmpty(one_consumemoney)||Double.parseDouble(one_consumemoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，充值消耗总金额必须大于0");	
						}
						if(StringTools.isEmpty(one_paymoney)||Double.parseDouble(one_paymoney)==0){
							logger.info("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");
							throw new XLRuntimeException("返利形式为返元宝，"+message+"类型的订单，返利总金额必须大于0");	
						}
					}			   		   
			   }			  
		   }else{			   
			   String message= (daoju!=null&&daoju.equals("on"))?"道具":"代金券";
			   for(RebateOrder reorder:rolist){
				   if(reorder.getPercent()!=null&&reorder.getPercent().intValue()!=0){
						logger.info("返利形式为："+message+"的订单，充值返利比例必须为0");
						throw new XLRuntimeException(message+"类型的订单，充值返利比例必须为0");	
					}
				   if(reorder.getConsumePercent() != null&&reorder.getConsumePercent().intValue()!=0 ){
						logger.info("返利形式为："+message+"的订单，消耗返利比例必须为0");
						throw new XLRuntimeException(message+"类型的订单，消耗返利比例必须为0");	
					}
				   if(StringTools.isEmpty(one_rebatemoney)&&Double.parseDouble(one_rebatemoney)!=0){
						logger.info("返利形式为："+message+"的订单，充值返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，充值返利总金额必须为0");	
					}
					if(StringTools.isEmpty(one_consumemoney)&&Double.parseDouble(one_consumemoney)!=0){
						logger.info("返利形式为："+message+"的订单，消耗返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，消耗返利总金额必须为0");	
					}
					if(StringTools.isEmpty(one_paymoney)&&Double.parseDouble(one_paymoney)!=0){
						logger.info("返利形式为："+message+"的订单，返利总金额必须为0");
						throw new XLRuntimeException(message+"类型的订单，返利总金额必须为0");	
					}
				} 			   
		   }
		   if(daijinquan != null&&daijinquan.equals("on")){
			   checkVoucherMoney(one_aporderid,Double.parseDouble(one_equalMoney));
		   }	
		   if(checkradio!=null&&"0".equals(checkradio)){
			   apply.setIsServer(false);
		   }else{
			   apply.setIsServer(true);
		   }
			apply.setAporderid(one_aporderid);
			apply.setApplyTime(one_applyTime);
			apply.setUsername(one_username);
			apply.setUid(one_uid);
			apply.setToaccount(one_toaccount);
			apply.setGameid(one_gameid);
			apply.setWorkType(Integer.parseInt(one_workType));
			if(applyType==4){
				String one_gameid_a = this.findParameter("one_gameid_a");
				apply.setGameid(one_gameid_a);
			}
			apply.setServerid(one_serverid);
			apply.setCrid(one_crid);
			apply.setVipGrade(getVipGrade(one_uid));
			apply.setReceiver(one_receiver);
			apply.setIsSuccess(Boolean.parseBoolean(one_isSuccess));
			apply.setMoney(Double.parseDouble(StringTools.isEmpty(one_money)?"0":one_money));
			apply.setMoney(new Double(apply.getMoney().intValue()));
			apply.setRebatemoney(Double.parseDouble(StringTools.isEmpty(one_rebatemoney)?"0":one_rebatemoney));
			apply.setRebatemoney(new Double(apply.getRebatemoney().intValue()));
			apply.setConsumemoney(Double.parseDouble(StringTools.isEmpty(one_consumemoney)?"0":one_consumemoney));
			apply.setConsumemoney(new Double(apply.getConsumemoney().intValue()));
			apply.setPaymoney(Double.parseDouble(one_paymoney));
			apply.setPaymoney(new Double(apply.getPaymoney().intValue()));
			apply.setEditBy(this.currentUserLogo());
			apply.setEditTime(now());
						
			if(apply.getMoney() != null&&apply.getMoney().doubleValue()==0){
				if(applyType != 4){//如果不是赠送补偿返利
					logger.info("充值总金额必须大于0");
					throw new XLRuntimeException("充值总金额必须大于0");	
				}
			}
			apply.setCheckstatus(new Integer(-1));//设置审核状态为待审核			
			
			Map<String,Double> map  = updateOrder(one_aporderid);//更新返利订单状态为有效
			double consumeMoney = map.get("consumeMoney");			
			double rebateMoney = map.get("rebateMoney");
			double totalMoney = map.get("totalMoney");			

			String rebatetype = "";
			if(yuanbao != null&&yuanbao.equals("on")){
				rebatetype += "y";
				apply.setIsSuccess(true);
			}
			if(daoju != null&&daoju.equals("on")){
				rebatetype += "d";
				apply.setIsSuccess(true);
			}
			if(daijinquan != null&&daijinquan.equals("on")){
				rebatetype += "D";
				apply.setIsSuccess(false);
			}
			double payMoney = map.get("payMoney");
			if(applyType != 4){//如果不是赠送补偿返利				
				if(yuanbao != null&&yuanbao.equals("on")){//如果包含返元宝
					if(payMoney==0){
						throw new XLRuntimeException("订单中的实际返利总金额必须大于0");	
					}   
				}
				apply.setPaymoney(payMoney);
			}
			apply.setRebatemoney(new Double((int)rebateMoney));
			apply.setConsumemoney(new Double((int)consumeMoney));			
			if(applyType!=4){
				apply.setPaymoney(new Double((int)payMoney));
			}else{//如果是充值赠送返利
				double mypaymoney = new Double(Double.valueOf(StringTools.isEmpty(one_paymoney)?"0":one_paymoney).intValue());				
				if(payMoney>0){//如果有充值订单，则按照充值订单的金额
					apply.setPaymoney(apply.getRebatemoney()+apply.getConsumemoney());					
				}else{//如果没有充值订单，则按照输入的金额
					apply.setPaymoney(mypaymoney);
				}				
			}			
			apply.setRebateType(rebatetype);			
			apply.setMoney(totalMoney);
			//baseSo.updateObjectById(apply);	
			
			//操作成功后处理脏数据
			if(!(yuanbao != null&&yuanbao.equals("on"))){
				RebateOrder order2 = new RebateOrder();
				order2.setAporderid(one_aporderid);
				List<RebateOrder> rolist2 = baseSo.findObjects(order2,queryPage);
				for(RebateOrder ro:rolist2){
					ro.setRebateMoney(new Double(0));
					ro.setPercent(new Integer(0));
					ro.setConsumePercent(new Integer(0));
					ro.setConsumeMoney(new Double(0));
					baseSo.updateObjectById(ro);
				}
				apply.setRebatemoney(new Double(0));
				apply.setConsumemoney(new Double(0));
				apply.setPaymoney(new Double(0));
			}
			if(!(daoju != null&&daoju.equals("on"))){				
				apply.setPropName("");
				apply.setReceiver("");				
			}
			if(!(daijinquan != null&&daijinquan.equals("on"))){				
				RebateVoucher voucher2 = new RebateVoucher();	
				voucher2.setAporderid(one_aporderid);
				List<RebateVoucher> rvlist2 = baseSo.findObjects(voucher2,queryPage);
				for(RebateVoucher rv:rvlist2){
					baseSo.deleteById(RebateVoucher.class, rv.getSeqid());
				}
				apply.setEqualMoney(new Double(0));				
			}
			 baseSo.updateObjectById(apply);//更新数据
			 editflag = true;
//			IBaseAuth auth = BaseAuthFactory.getBaseAuth(FLOWNO);
//			String account = auth.getFirstChecker(FLOWNO, one_aporderid);		
			
			List<String> receivers = new ArrayList<String>();						
			//发送邮件通知申请者		
			Games games = GameCache.getInstance().getGameByGameId(apply.getGameid());
			StringBuffer titleBuffer = new StringBuffer("【").append(typeMap.get(applyType)).append("申请】").append(games.getGameName()).append("(").append(apply.getServerid()).append(")|").append(apply.getMoney()).append("|").append(apply.getUsername()).append("|").append(apply.getApplyTime());
//			if(!StringTools.isEmpty(account))	//发送邮件给审核			
//			   receivers.add(auth.getEmailFromName(account));
			if(!StringTools.isEmpty(one_receiver)){//如果配置了通知收件人
				 String receiver[] = one_receiver.split(",");			
				 for(String rec:receiver){
					 if(!StringTools.isEmpty(rec)){
						 receivers.add(rec);
					 }
				 }
			}
			RebateApplyProxy.getInstance().sendMail(one_aporderid, titleBuffer.toString(), "", receivers);			
		}catch(Exception e){
			if(editflag){
				logger.error("修改成功，邮件发送失败", e);
				mergeJsmessage("修改成功，邮件发送失败，原因：" + e.getMessage());
			}else{
				logger.error("修改失败", e);
				mergeJsmessage("修改失败，原因：" + e.getMessage());
			}
		}
		return "";
	}
	
	/**
	 * 删除返利申请
	 * @return
	 */
	public String delete(){	
		logger.info("开始返利申请信息删除");
		String delseqids = findParameter("delseqids1");		
		System.out.println("delseqids========>"+delseqids);
		try{
			if(StringTools.isEmpty(delseqids)){
				throw new XLRuntimeException("请选择要删除的数据");
			}
			String ids[] = delseqids.split(",");
			
			Page page = new Page();
            if(delseqids.indexOf(",")==-1){
				ids = new String[1];
				ids[0] = delseqids.trim();
			}
            
            for(String id:ids){
            	RebateApply apply = baseSo.findById(RebateApply.class, id);	
            	if(apply != null){
					if(apply.getCheckstatus().intValue()!=-2&&apply.getCheckstatus().intValue()!=2){//只
						throw new XLRuntimeException("您选择的返利申请单中，有部分非“修改中”的状态");
					}				
     				String account = this.currentUserLogo();
     				if(!apply.getInputBy().trim().equals(account.trim())){
     					logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+apply.getInputBy());
     					throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+apply.getInputBy());    						     			
		     		}
            	}
            }
			for(String id:ids){
				RebateApply apply = baseSo.findById(RebateApply.class, id);	
				if(apply != null){
					if(apply.getCheckstatus().intValue()==-2||apply.getCheckstatus().intValue()==2){//只有修改中或不通过的状态才能删除
						String aporderid = apply.getAporderid();
						RebateOrder queryOrder = new RebateOrder();
						queryOrder.setAporderid(aporderid);
						List<RebateOrder> rolist = baseSo.findObjects(queryOrder, page);
						for(RebateOrder ro:rolist){
							baseSo.deleteById(RebateOrder.class, ro.getSeqid());
						}
						RebateOrderPhoto rebateOrderPhotoQuery = new RebateOrderPhoto();
						rebateOrderPhotoQuery.setAporderid(aporderid);
						List<RebateOrderPhoto> roplist = baseSo.findObjects(rebateOrderPhotoQuery, page);
						for(RebateOrderPhoto rop:roplist){
							baseSo.deleteById(RebateOrderPhoto.class, rop.getSeqid());
						}
						baseSo.deleteById(RebateApply.class, apply.getSeqid());
					}else{
						throw new XLRuntimeException("您选择的返利申请单中，有部分非“修改中”的状态");
					}
				}				
			}				
		}catch(Exception e){
			logger.error("删除失败", e);
			alertJS("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	 /**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始返利申请单导出到excel文件");    	
    	//获得页面查询的数据
    	RebateApply apply = findBean(RebateApply.class, "rebateapply");	
        if(apply != null){
        	if(apply.getCheckstatus() != null&& apply.getCheckstatus().intValue()==0){
        		apply.setCheckstatus(null);
        	}
        	if(apply.getCheckstatus()!=null&&apply.getCheckstatus().intValue()==3){
        		apply.setCheckstatus(new Integer(0));
        	}
        	if(apply.getApplyType()!=null&&apply.getApplyType().intValue()==0){
        		apply.setApplyType(null);
        	}
        	if(apply.getWorkType()!=null&&apply.getWorkType().intValue()==0){
        		apply.setWorkType(null);
        	}
        	if(apply.getVipGrade()!=null&&apply.getVipGrade().intValue()==0){
        		apply.setVipGrade(null);
        	}
        }
        String qapplytype = findParameter("qapplytype");
        if(!StringTools.isEmpty(qapplytype)){
        	apply.setRebateType(qapplytype);
        }
        String persons = findParameter("persons");
        StringBuffer sb = new StringBuffer();
        
        if(!StringTools.isEmpty(persons)&&!"0,".equals(persons)){
    		personMap = man.getPersonMap();
    		System.out.println("personMap:"+personMap);
        	String usernames[] = persons.split(",");
        	if(usernames != null){
        		 sb.append(" and  username in (");
        		for(String username:usernames){
        			 if(!StringTools.isEmpty(username)){
        				sb.append("'").append(personMap.get(Long.parseLong(username.replaceAll(",", "").trim()))).append("',");
        			 }
        		}
        		sb.append("'a')");
        	}
        }        
        if(!StringTools.isEmpty(qapplytype)){
        	apply.setRebateType(qapplytype);
        }
        Map<String,String> rebateTypeMap = new RebateTypeManagedBean ().getRebateTypeMap();
    	List<RebateApply> crlist =  FacadeFactory.INSTANCE.getRebateOrderBo().findByObject2(RebateApply.class, sb.toString(), apply, queryPage);
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "返利申请单";	    
 	    Games games = new Games();
 	    Page page = new Page();
 	    List<Games> gamelist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page);
 	    List datas = new ArrayList();
	     	    
 	   RebateOrder queryOrder = new RebateOrder();
 	   CallEffect queryEffect = new CallEffect();
 	    for(RebateApply cr:crlist){	    	
 	    	queryOrder.setAporderid(cr.getAporderid());
 	         List<RebateOrder> orderlist = FacadeFactory.INSTANCE.getBaseSo().findObjects(queryOrder, page);
 	    	queryEffect.setAporderid(cr.getAporderid());
 	    	CallEffect effect = FacadeFactory.INSTANCE.getBaseSo().findObject(queryEffect);
 	    	if(orderlist == null||orderlist.size()==0){
 	    		List list = new ArrayList();
 	    		list.add(cr.getAporderid());
 	    		for(int i=0;i<7;i++){
 	    			list.add(""); 	    			
 	    		}
 	    		list.add(typeMap.get(cr.getApplyType()));
 	    		list.add(rebateMap.get(cr.getRebateType()));
    	    	list.add(cr.getUid());
    	    	list.add(cr.getToaccount());
    	    	list.add(cr.getWorkType().intValue()==1?"日常":(cr.getWorkType().intValue()==2?"业绩":""));
    	    	list.add(cr.getVipGrade());
    	    	list.add(getGameName(cr.getGameid(),gamelist));
    	    	list.add(cr.getServerid());
    	    	list.add(cr.getRoleid());
    	    	list.add(cr.getMoney());
    	    	list.add(cr.getRebatemoney());
    	    	list.add(cr.getConsumemoney());
    	    	list.add(cr.getPaymoney());
    	    	list.add(cr.getEqualMoney());
    	    	list.add(cr.getPropName());
    	    	list.add(cr.getUsername());
    	    	list.add(cr.getCallTime());
	    	    list.add(rebateTypeMap.get(cr.getRtypeNo()));
    	    	list.add(cr.getInputBy());
    	    	list.add(cr.getApplyTime());
    	    	list.add(cr.getLastCheckTime());
    	    	list.add(checkMap.get(cr.getCheckstatus()));
    	    	list.add(cr.getReason()); 	   
    	    	if(effect == null){
	    	    		for(int i=0;i<10;i++){
	    	    			list.add("");
	    	    		}
    	    	}else{
    	    		list.add(effect.getBeforeCallLoginTime()); 	   
    	    		list.add(effect.getBeforeCallPayTime()); 	 
    	    		list.add(getGameName(effect.getBeforeGameId(),gamelist)); 	 
    	    		list.add(effect.getBeforeServerId()); 	 
    	    		list.add(effect.getBeforeFlag()?"是":"否"); 	 
    	    		list.add(effect.getBeforeVipGrade()); 	 
    	    		list.add(getGameName(effect.getAfterGameId(),gamelist)); 
    	    		list.add(effect.getAfterServerId()); 	 
    	    		list.add(effect.getAfterFlag()?"是":"否"); 	 
    	    		list.add(effect.getAfterVipGrade()); 	 
    	    	}	
    	    	datas.add(list);
 	    	}
 	    	int index = 1;
 	    	for(RebateOrder order:orderlist){
 	    		List list = new ArrayList();
 	    		list.add(cr.getAporderid());
 	    		list.add(order.getOrderid());
 	    		list.add(order.getOrderTime());
 	    		list.add(order.getPayMoney());
 	    		list.add(order.getUid());
 	    		list.add(order.getAccount());
 	    		list.add(order.getGameid());
 	    		list.add(order.getServerid());
 	    		if(index == 1){
 	    			list.add(typeMap.get(cr.getApplyType()));
 	    			list.add(rebateMap.get(cr.getRebateType()));
 	    	    	list.add(cr.getUid());
 	    	    	list.add(cr.getToaccount());
 	    	    	list.add(cr.getWorkType().intValue()==1?"日常":(cr.getWorkType().intValue()==2?"业绩":""));
 	    	    	list.add(cr.getVipGrade());
 	    	    	list.add(getGameName(cr.getGameid(),gamelist));
 	    	    	list.add(cr.getServerid());
 	    	    	list.add(cr.getRoleid());
 	    	    	list.add(cr.getMoney());
 	    	    	list.add(cr.getRebatemoney());
 	    	    	list.add(cr.getConsumemoney());
 	    	    	list.add(cr.getPaymoney());
 	    	    	list.add(cr.getEqualMoney());
 	    	    	list.add(cr.getPropName());
 	    	    	list.add(cr.getUsername());
 	    	    	list.add(cr.getCallTime());
 	    	    	list.add(rebateTypeMap.get(cr.getRtypeNo()));
 	    	    	list.add(cr.getInputBy());
 	    	    	list.add(cr.getApplyTime());
 	    	    	list.add(cr.getLastCheckTime());
 	    	    	list.add(checkMap.get(cr.getCheckstatus()));
 	    	    	list.add(cr.getReason()); 	   
 	    	    	if(effect == null){
 	    	    		for(int i=0;i<10;i++){
 	    	    			list.add("");
 	    	    		}
 	    	    	}else{
 	    	    		list.add(effect.getBeforeCallLoginTime()); 	   
 	    	    		list.add(effect.getBeforeCallPayTime()); 	 
 	    	    		list.add(getGameName(effect.getBeforeGameId(),gamelist)); 	 
 	    	    		list.add(effect.getBeforeServerId()); 	 
 	    	    		list.add(effect.getBeforeFlag()?"是":"否"); 	 
 	    	    		list.add(effect.getBeforeVipGrade()); 	 
 	    	    		list.add(getGameName(effect.getAfterGameId(),gamelist)); 
 	    	    		list.add(effect.getAfterServerId()); 	 
 	    	    		list.add(effect.getAfterFlag()?"是":"否"); 	 
 	    	    		list.add(effect.getAfterVipGrade()); 	 
 	    	    	}
 	    		}else{
 	    			for(int i=0;i<30;i++){
 	    				list.add("");
 	    			}	    	
 	    		}
 	    		datas.add(list);
 	    		index++;
 	    	} 	    	 	
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"返利申请单号","充值订单号","充值时间","充值金额","迅雷uid","迅雷账号","游戏编号","区服编号","返利类型","返利形式","UID", "迅雷账号", "业绩类型","vip等级", "游戏", "区服","角色ID","订单总金额","充值返利总金额","消耗返利总金额","返利总金额","返代金券总金额","返道具名称","外呼人","外呼时间","申请类型","申请人","申请时间","审核通过时间","审核状态","申请事由","外呼前最后登录时间","外呼前最后充值时间","外呼前玩的游戏","外呼前玩的区服","外呼前的数据是否有效","外呼前vip等级","外呼后玩的游戏","外呼后玩的区服","外呼后的数据是否有效","外呼后vip等级"};
		String filePath = "/tmp/rebateapply.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("返利申请单",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_rebateapplydata.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
			if(crlist != null){
				crlist.clear();
				crlist = null;
			}
			if(datas != null){
				datas.clear();
				datas = null;
			}
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    /**
     * 根据游戏id查询游戏名称
     * @param gameId
     * @param gameList
     * @return
     */
    private String getGameName(String gameId,List<Games> gameList){
    	if(gameId == null||gameList==null)return "";
    	for(Games games:gameList){
    		if(games.getGameId().trim().equals(gameId.trim())){
    			return games.getGameName();
    		}
    	}
    	return "";
    }
    
    /**
     * 撤销返利申请单
     * @return
     */
    public String cancel(){   	
    	try{
    		String one_aproderid = this.findParameter("one_aporderid");
    		if(StringTools.isEmpty(one_aproderid)){
    			throw new XLRuntimeException("请选择要撤销的返利申请单");
        	}
    		RebateApply query = new RebateApply();
    		query.setAporderid(one_aproderid);
    		RebateApply apply = baseSo.findObject(query);
    		if(apply == null){
    			throw new XLRuntimeException("您选择的返利申请单，在系统中已经不存在了");
    		}
    		//checkOrderStatus(apply.getCheckstatus());//检查申请单状态
			String account = this.currentUserLogo();
			if(!apply.getInputBy().trim().equals(account.trim())){
				logger.info("对不起，只有该申请单的申请人，才有权限修改，申请人是："+apply.getInputBy());
				throw new XLRuntimeException("对不起，只有该申请单的申请人，才有权限修改，申请人是："+apply.getInputBy());
			}
    		if(apply.getCheckstatus().intValue()!=-1){//如果返利申请单不是 待审核的状态
    			throw new XLRuntimeException("该返利申请单不是待审核的状态，无法撤销");
    		}
    		apply.setCheckstatus(new Integer(-2));//订单状态变为修改状态
    		apply.setEditBy(this.currentUserLogo());
    		apply.setEditTime(now());
    		baseSo.updateObjectById(apply);
    	}catch(Exception e){
    		logger.error("撤销失败", e);
			mergeJsmessage("撤销失败，原因：" + e.getMessage());
    	} 	
    	return "";
    }
}
