package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.QuestionSettingsBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.ChargeAmountProfileSettings;
import com.xunlei.niux.data.vipgame.vo.QuestionSettings;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 客服工单设置业务处理类
 * @author lisu
 *  2012-12-11
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_QUESTIONSETTINGS)
public class QuestionSettingsManagedBean extends BaseManagedBean {

	private static final Logger logger = Logger.getLogger(QuestionSettingsManagedBean.class.getName());
	private QuestionSettingsBo questionSettingsBo = null;	
	private int rownum = 0;
	
	public  QuestionSettingsManagedBean(){
		questionSettingsBo = FacadeFactory.INSTANCE.getQuestionSettingsBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 获得基础数组中配置的游戏信息
	 * @return
	 */
	 public List<SelectItem> getGameList() {
        List<SelectItem> tempList = new ArrayList<SelectItem>();
        SelectItem sm = new SelectItem();
        sm.setLabel("全部");
        sm.setValue(0);
        tempList.add(sm);
        tempList.addAll(getGameCollection());
        return tempList;
	 }
	 
	 public List<SelectItem> getGameCollectionList() {
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        SelectItem sm = new SelectItem();
	        sm.setLabel("=请选择=");
	        sm.setValue(0);
	        tempList.add(sm);
	        tempList.addAll(getGameCollection());
	        return tempList;
		 }
	 
	 /**
	 * 获得基础数组中配置的问题类型
	 * @return
	 */
	 public List<SelectItem> getQuestionTypeList() {
        List<SelectItem> tempList = new ArrayList<SelectItem>();
        SelectItem sm = new SelectItem();
        sm.setLabel("=请选择=");
        sm.setValue(0);
        tempList.add(sm);
        tempList.addAll(getQuestionType());
        return tempList;
	}
	 /**
		 * 获得基础数组中配置的问题类型
		 * @return
		 */
		 public List<SelectItem> getQueryQuestionTypeList() {
	        List<SelectItem> tempList = new ArrayList<SelectItem>();
	        SelectItem sm = new SelectItem();
	        sm.setLabel("全部");
	        sm.setValue(0);
	        tempList.add(sm);
	        tempList.addAll(getQuestionType());
	        return tempList;
		} 
	
	 public List<SelectItem> getAddGameList() {
        List<ChargeAmountProfileSettings> list = FacadeFactory.INSTANCE.getChargeAmountProfileSettingsBo().findChargeAmountProfileSettingsList();
        List<SelectItem> tempList = new ArrayList<SelectItem>();
        for (ChargeAmountProfileSettings flat : list) {
            SelectItem si = new SelectItem();
            si.setValue(flat.getAmount());
            si.setLabel(flat.getAmount()+"");
            tempList.add(si);
        }
        return tempList;
	 }
	 
	 
	 
	 
	 /**
	  * 获得基础数组中配置的游戏信息
	  * @return
	  */
	 public List getGameCollection(){
	        List list = (List)getRequestAttribute("gameCollection");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("GameCollection");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("gameCollection", list);
	        }
	        return list;
	 }
	 
	 /**
	  * 获得基础数组中配置的问题类型
	  * @return
	  */
	 public List getQuestionType(){
	        List list = (List)getRequestAttribute("questionType");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("QuestionType");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("questionType", list);
	        }
	        return list;
	  }
	 
	 /**
	  * 获得基础数组中配置的必填项
	  * @return
	  */
	 public List getRequiredItem(){
	        List list = (List)getRequestAttribute("requiredItem");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("RequiredItem");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	Map map = new HashMap();
	            	map.put("itemid", ((LibClassD)datas.get(i)).getItemno());
	            	map.put("itemname", ((LibClassD)datas.get(i)).getItemname());	            	
	            	list.add(map); 	
	            }	                
	            setRequestAttribute("requiredItem", list);
	        }
	        return list;
	 }
	 
	 /**
	  * 获得基础数组中配置的必填项
	  * @return
	  */
	 public List getOptionalItem(){
	        List list = (List)getRequestAttribute("optionalItem");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("OptionalItem");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	Map map = new HashMap();
	            	map.put("itemid", ((LibClassD)datas.get(i)).getItemno());
	            	map.put("itemname", ((LibClassD)datas.get(i)).getItemname());	            	
	            	list.add(map);	
	            }	                
	            setRequestAttribute("optionalItem", list);
	        }
	        return list;
	 }
	 
	 
	/**
	 * 客服工单查询
	 * @return
	 */
	public String getQueryQuestionSettingsList(){
		logger.info("开始客服工单查询");
        this.authenticateRun();//验证运行权限
        QuestionSettings question = findBean(QuestionSettings.class, "questionsettings");
        PagedFliper pagedFliper = this.getFliper();
        if(question.getGameid()!=null){
        	Long gameid =  question.getGameid();
        	if(gameid.longValue()==0){
        		question.setGameid(null);
        	}
        }
        int count = questionSettingsBo.count(question);  
       
        pagedFliper.setRecordCount(count);    
        List<QuestionSettings> list = new ArrayList<QuestionSettings>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = questionSettingsBo.find(question,page.getPageNo(),page.getPageSize());
        }
        Sheet<QuestionSettings> sheet = new Sheet<QuestionSettings>(count, list);
        /**
         * 获得游戏和类型名
         */
        List<Object> rlist = new ArrayList<Object>();
        for(QuestionSettings qs:sheet.getDatas()){
        	rlist.add(qs);

        }
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	
	/**
	 * 新增客服工单
	 * @return
	 */
	public String add(){
		logger.info("开始客服工单设置添加");
		this.authenticateAdd();//添加权限
		String requireditemids = this.findParameter("requireditemids");
		String optionalitemids = this.findParameter("optionalitemids");
		QuestionSettings job=this.findBean(QuestionSettings.class,"questionsettings");				
		try{
			if(job==null){
				logger.info("客服工单为空");
				throw new XLRuntimeException("客服工单为空");
			}	
			String gameid = String.valueOf(job.getGameid());
			Integer categoryid = job.getQuestioncategoryid();
			if(isExist(gameid,categoryid)){
				logger.info("该类设置已存在，不能重复添加");
				throw new XLRuntimeException("该游戏类别已存在，不能重复添加");
			}
            List requiredDatas = LibClassM.getLibClassDList("RequiredItem");
            List optionalDatas = LibClassM.getLibClassDList("OptionalItem");
            String requiredItem = "";
            String optionalItem = "";
            String itemids [] = requireditemids.split(",");
            if(itemids==null||itemids.length<=0){
            	logger.info("添加失败，必填项为空");
            	throw new XLRuntimeException("添加失败，必填项为空");
            }
            for(int j=0;j<itemids.length;j++){
            	for(int i = 0; i < requiredDatas.size(); i++){	
                	if(Integer.parseInt(itemids[j])==Integer.parseInt(((LibClassD)requiredDatas.get(i)).getItemno())){//如果有相等的
                		requiredItem +=(j+1)+"."+((LibClassD)requiredDatas.get(i)).getItemname()+";";
                	}
                }
            }
            if(optionalitemids != null && !"".equals(optionalitemids)){
            	 String oitemids[] = optionalitemids.split(",");
                 for(int j=0;j<oitemids.length;j++){
                 	for(int i = 0; i < optionalDatas.size(); i++){	
                     	if(Integer.parseInt(oitemids[j])==Integer.parseInt(((LibClassD)optionalDatas.get(i)).getItemno())){//如果有相等的
                     		optionalItem +=(j+1)+"."+((LibClassD)optionalDatas.get(i)).getItemname()+";";
                     	}
                     }
                 }	
                job.setOptionalitemids(optionalitemids);
     			job.setOptionalitems(optionalItem);
            }else{
            	job.setOptionalitemids("");
     			job.setOptionalitems("");
            }
            
            job.setRequireditemids(requireditemids);
			job.setRequireditems(requiredItem);			
			job.setInputtime(now());
			job.setInputby(this.currentUserLogo());
			questionSettingsBo.insert(job);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改客服工单
	 * @return
	 */
	public String edit(){
		logger.info("开始客服工单修改");
		this.authenticateEdit();//编辑权限
		String requireditemids = this.findParameter("requireditemids");
		String optionalitemids = this.findParameter("optionalitemids");
		QuestionSettings job = this.findBean(QuestionSettings.class,"questionsettings");	
		try{
			if(job == null){
				logger.info("客服工单为空");
				throw new XLRuntimeException("客服工单为空");
			}
			String gameid = String.valueOf(job.getGameid());
			Integer categoryid = job.getQuestioncategoryid();
			if(isExiste(gameid,categoryid,job.getSeqid())){
				logger.info("该游戏类别已存在，不能重复添加");
				throw new XLRuntimeException("该游戏类别已存在，不能重复添加");
			}
			List requiredDatas = LibClassM.getLibClassDList("RequiredItem");
            List optionalDatas = LibClassM.getLibClassDList("OptionalItem");
            String requiredItem = "";
            String optionalItem = "";
            String itemids [] = requireditemids.split(",");
            if(itemids==null||itemids.length<=0){
            	logger.info("添加失败，必填项为空");
            	throw new XLRuntimeException("添加失败，必填项为空");
            }
            for(int j=0;j<itemids.length;j++){
            	for(int i = 0; i < requiredDatas.size(); i++){	
                	if(Integer.parseInt(itemids[j])==Integer.parseInt(((LibClassD)requiredDatas.get(i)).getItemno())){//如果有相等的
                		requiredItem +=(j+1)+"."+((LibClassD)requiredDatas.get(i)).getItemname()+";";
                	}
                }
            }
            if(optionalitemids!=null && !"".equals(optionalitemids)){
            	 String oitemids[] = optionalitemids.split(",");
                 for(int j=0;j<oitemids.length;j++){
                 	for(int i = 0; i < optionalDatas.size(); i++){	
                     	if(Integer.parseInt(oitemids[j])==Integer.parseInt(((LibClassD)optionalDatas.get(i)).getItemno())){//如果有相等的
                     		optionalItem +=(j+1)+"."+((LibClassD)optionalDatas.get(i)).getItemname()+";";
                     	}
                     }
                 }	
     			job.setOptionalitemids(optionalitemids);
    			job.setOptionalitems(optionalItem); 
            }else{
            	job.setOptionalitemids("");
     			job.setOptionalitems("");
            }
           
            job.setRequireditemids(requireditemids);
			job.setRequireditems(requiredItem);
			job.setEdittime(now());
			job.setEditby(this.currentUserLogo());
			questionSettingsBo.update(job);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExist(String gameid,Integer categoryid){
		String sql = "select count(*) from questionsettings where gameid=? and questioncategoryid=?";		
		int count = questionSettingsBo.count(sql, new Object[]{gameid,categoryid});
		return count>0?true:false;
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExiste(String gameid,Integer categoryid,long seqid){
		String sql = "select count(*) from questionsettings where gameid=? and questioncategoryid=? and seqid <> ?";		
		int count = questionSettingsBo.count(sql, new Object[]{gameid,categoryid,seqid});
		return count>0?true:false;
	}
	
	/**
	 * 删除客服工单
	 * @return
	 */
	public String delete(){
		logger.info("开始客服工单删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");			
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				questionSettingsBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
