package com.xunlei.niux.manager.web.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.QuestionBo;
import com.xunlei.niux.data.vipgame.bo.QuestionReplyBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Question;
import com.xunlei.niux.data.vipgame.vo.QuestionReply;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 客服工单回复处理类
 * @author lisu
 *  2012-12-11
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_QUESTIONREPLY)
public class QuestionReplyManagedBean extends BaseManagedBean {

	private static final Logger logger = Logger.getLogger(QuestionReplyManagedBean.class.getName());
	private QuestionReplyBo questionReplyBo = null;	
	private QuestionBo questionBo = null;
	private int rownum = 0;
	
	public  QuestionReplyManagedBean(){
		questionReplyBo = FacadeFactory.INSTANCE.getQuestionReplyBo();
		questionBo = FacadeFactory.INSTANCE.getQuestionBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	 
	/**
	 * 客服问题回复查询
	 * @return
	 */
	public List getQueryQuestionReplyList(){
		logger.info("开始客服问题回复查询");
        this.authenticateRun();//验证运行权限
        String questionid = findParameter("questionid");       
        QuestionReply reply = findBean(QuestionReply.class, "questionreply");
        if(questionid != null && !"".equals(questionid))
           reply.setQuestionid(Long.parseLong(questionid));
        PagedFliper pagedFliper = this.getFliper();
        int count = questionReplyBo.count(reply);        
        pagedFliper.setRecordCount(count);    
        List<QuestionReply> list = new ArrayList<QuestionReply>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = questionReplyBo.find(reply,1,100);
        }
        
        Sheet<QuestionReply> sheet = new Sheet<QuestionReply>(count, list);
        List datalist = new ArrayList();      
        for(QuestionReply qr:sheet.getDatas()){
        	Map map = new HashMap();
        	String image = qr.getImage();       	
        	if(image == null || "".equals(image.trim())){
        		qr.setImage(null);
        		qr.setRemark(null);
        	}else{
        		if(image.indexOf(",")!=-1){
        			String imgs [] = image.trim().split(",");       			
            		qr.setImage(imgs[0]);
            		qr.setRemark(imgs[1]);
        		}else{
            		qr.setImage(image);
            		qr.setRemark(null);
        		}
        		
        	}      	
        	map.put("replyid", qr.getReplyid());
        	map.put("dealtime", qr.getDealtime());
        	map.put("replytype", qr.getReplytype());
        	map.put("dealtype", qr.getDealtype());
        	map.put("customername", qr.getCustomername());
        	map.put("image", qr.getImage());
        	map.put("replycontent", qr.getReplycontent());	            	
        	datalist.add(map);	
        }
        return list;
	}
	
	
	/**
	 * 客服新增问题回复
	 * @return
	 */
	public String add(){
		logger.info("开始客服问题回复添加");
		this.authenticateAdd();//添加权限
		String qid = findParameter("qid");
		String status = findParameter("status");
		int upgradeStatus = findParamInt("upgradestatus");		
		String replycontent = findParameter("replycontent");
		String image = findParameter("image");
		QuestionReply reply = this.findBean(QuestionReply.class,"questionreply");	
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String nowtime = sdf.format(new Date());	
		try{
			if(upgradeStatus == 1){//如果是升级工单，则不需新增数据，不需要下面的操作
				upGradeQuestionStatus(Long.parseLong(qid));
				return "";
			}
			if(reply==null){
				logger.info("客服问题回复为空");
				throw new XLRuntimeException("客服问题回复为空");
			}	
            if(qid == null||"".equals(qid)){
            	logger.info("问题编号为空");
				throw new XLRuntimeException("问题编号为空");
            }	
            
            reply.setReplycontent(replycontent);
            reply.setDealtype(Integer.parseInt(status));
            reply.setQuestionid(Long.parseLong(qid));
            reply.setCustomername(this.currentUserLogo());
            reply.setDealtime(now());
            reply.setImage(image==null?"":image);
            reply.setReplytype(2);            
            //限制不能回复过快，避免重复提交的情况
            //检查2秒钟里不能重复添加
			 String csql = "SELECT * FROM questionreply WHERE questionid = ? and customername=? ORDER BY dealtime DESC LIMIT 0,1";
			 List<String> paramList = new ArrayList<String>();
			 paramList.add(qid);
			 paramList.add(currentUserLogo());
			 List qqlist  = FacadeFactory.INSTANCE.getQuestionReplyBo().findBySql(QuestionReply.class, csql, paramList);
			 if(qqlist != null&& qqlist.size()==1){
				 String time1 = nowtime;
				 QuestionReply qr = (QuestionReply)qqlist.get(0);
				 String time2 = qr.getDealtime();
				 if(compareTime(time1,time2) <= 3){
					logger.info("问题的回复重复提交");
				   	throw new XLRuntimeException("该问题的回复重复提交了");
				 }
			 }	
//			 //如果该工单别的客服已经回复过了，则不需要重复回复
//			if(findCustomer(Long.parseLong(qid),this.currentUserInfo().getTrueName())){
//				logger.info("该问题其他客服已经回复了");
//			   	throw new XLRuntimeException("该问题其他客服已经回复了");
//			}			
            questionReplyBo.insert(reply);
            
            //更新最后处理方式 和 工单状态
            Question question = questionBo.findById(Long.parseLong(qid));
            boolean flag = false;
            if(question.getQuestionstatus()==3||question.getQuestionstatus()==4){//如果是强制关闭或者已完成状态
            	flag = true;
            }
            updateReplyType(qid,status,flag);
            
            //更新客服人员
            updateCustomerName(Long.parseLong(qid),this.currentUserInfo().getTrueName());
            
            //更新阅读状态
            
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 升级工单
	 * @param questionid
	 * @throws Exception
	 */
	public void upGradeQuestionStatus(long questionid) throws Exception{
		logger.info("开始升级工单");
		Question question = questionBo.findById(questionid);
		if(question.getUpgradestatus()==1){
			logger.info("此工单已经升级，不可重复升级");
			throw new XLRuntimeException("此工单已经升级，不可重复升级");
		}
		question.setUpgradestatus(1);
		questionBo.update(question);
	}
	
	
	/**
	 * 更新客服人员名称
	 * @param questionid
	 * @param name
	 */
	public void updateCustomerName(long questionid,String name) throws Exception{
		logger.info("开始更新客服人员");
		Question question = questionBo.findById(questionid);
		String customername = question.getCustomername();
		if(customername != null&&!"".equals(customername)){
			if(customername.indexOf(name) == -1)
			   customername = customername+"、"+name;
		}else{
			customername = name;
		}
		question.setCustomername(customername);
		questionBo.update(question);
	}
	
	/**
	 * 查询该工单是否有其他人回复
	 * @param questionid
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public boolean findCustomer(long questionid,String name) throws Exception {
		logger.info("开始查询客服人员");
		Question question = questionBo.findById(questionid);
		String customername = question.getCustomername();
		if(customername==null||customername.trim().equals(name.trim()))return false;
		return true;
	}
	
	/**
	 * 更新工单中客服最后处理方式
	 * @param status
	 */
	public void updateReplyType(String questionid,String status,boolean flag){
		String sql = null;
		if(!flag){			
			sql = "update question set isnew=0,readStatus=0, lastdealtype = "+status+",lastdealtime='"+now()+"',questionstatus=2 where questionid='"+questionid+"'";			
		}else{
			sql = "update question set isnew=0,readStatus=0, lastdealtype = "+status+",lastdealtime='"+now()+"' where questionid='"+questionid+"'";
		}
		questionBo.execute(sql, new ArrayList());
	}
	
	 /**
	  * 比较两个时间相隔多少秒
	  * @param time1
	  * @param time2
	  * @return
	  */
	 public long compareTime(String time1,String time2){
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date d1 = null;
		Date d2 = null;
		try {
			d1 = df.parse(time1);
			d2 = df.parse(time2);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		long diff = d1.getTime() - d2.getTime();
       return diff/1000; 
        
	 }
	
}
