package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.QuestionItemBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.QuestionItem;
import com.xunlei.niux.data.vipgame.vo.QuestionSettings;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 问题选项业务处理类
 * @author lisu
 *  2012-12-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_QUESTIONITEM)
public class QuestionItemManagedBean extends BaseManagedBean {

	private static final Logger logger = Logger.getLogger(QuestionItemManagedBean.class.getName());
	private QuestionItemBo questionItemBo = null;	
	
	public  QuestionItemManagedBean(){
		questionItemBo = FacadeFactory.INSTANCE.getQuestionItemBo();
	}
    
	
	 
	/**
	 * 问题必填项查询
	 * @return
	 */
	public List getQueryQuestionRequiredItemList(){
		logger.info("开始问题选项查询");
        this.authenticateRun();//验证运行权限
        String questionid = findParameter("questionid");
        String sql = "select * from questionitem where type = 1 and questionid=?";
        List paramList = new ArrayList();
        paramList.add(questionid);     
        List result = questionItemBo.findBySql(QuestionItem.class, sql, paramList);
        List list = new ArrayList();

        /**
         * 取得必填项
         */
        List rdatas = LibClassM.getLibClassDList("RequiredItem");                        
        for(Object obj:result){
        	QuestionItem item = (QuestionItem)obj;
        	Map map = new HashMap();
        		 for(int i = 0; i < rdatas.size(); i++){
        			 LibClassD lcd = (LibClassD)rdatas.get(i);
        			 if(lcd.getItemno().equals(item.getItemid())){
        				 map.put("itemname", lcd.getItemname());
        				 break;
        			 }
        		 }  
        	String content = item.getItemcontent();	 
    		 if(content.indexOf(".jpg")>-1||content.indexOf(".png")>-1||content.indexOf(".gif")>-1||content.indexOf(".bmp")>-1){
    			 if(content.indexOf(",")>-1){
    				 String str[] = content.split(",");
    				 content = "<img width='130' height='70'  onclick=\"location.href='http://img.smxj.webgame.kanimg.com/question/"+str[0]+"'\"  src='http://img.smxj.webgame.kanimg.com/question/"+str[0]+"' />&nbsp;";
    				 content += "<img width='130' height='70'  onclick=\"location.href='http://img.smxj.webgame.kanimg.com/question/"+str[1]+"'\"  src='http://img.smxj.webgame.kanimg.com/question/"+str[1]+"' />";
    			 }else{
    				 content = "<img width='130' height='70'  onclick=\"location.href='http://img.smxj.webgame.kanimg.com/question/"+content+"'\"  src='http://img.smxj.webgame.kanimg.com/question/"+content+"' />";     		
    			 }
    			 	 
    		 }
    		 System.out.println("content================>"+content);
        	map.put("itemcontent", content);
        	list.add(map);
        }
        return list;
	}
	
	/**
	 * 问题选填项查询
	 * @return
	 */
	public List getQueryQuestionOptionalItemList(){
		logger.info("开始问题选项查询");
        this.authenticateRun();//验证运行权限
        String questionid = findParameter("questionid");
        String sql = "select * from questionitem where type = 2 and questionid=?";
        List paramList = new ArrayList();
        paramList.add(questionid);     
        List result = questionItemBo.findBySql(QuestionItem.class, sql, paramList);
        List list = new ArrayList();
        /**
         * 取得选填项
         */
        List odatas = LibClassM.getLibClassDList("OptionalItem");
        for(Object obj:result){
        	QuestionItem item = (QuestionItem)obj;
        	Map map = new HashMap();
        	for(int i = 0; i < odatas.size(); i++){
      			 LibClassD lcd = (LibClassD)odatas.get(i);
      			 if(lcd.getItemno().equals(item.getItemid())){
      				 map.put("itemname", lcd.getItemname());
      				 break;
      			 }
  		    }
        	map.put("itemcontent", item.getItemcontent());
        	list.add(map);
        }
        return list;
	}
	
	/**
	 * 新增客服工单
	 * @return
	 */
	public String add(){
		logger.info("开始问题选项添加");
		this.authenticateAdd();//添加权限
		String requireditemids = this.findParameter("requireditemids");
		String optionalitemids = this.findParameter("optionalitemids");
		QuestionSettings job=this.findBean(QuestionSettings.class,"questionsettings");				
		try{
			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改问题
	 * @return
	 */
	public String edit(){
		logger.info("开始问题选项修改");
		this.authenticateEdit();//编辑权限
		try{
			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
