package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.league.bo.PromoterBo;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.Promoter;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 推广联盟推广员业务处理类
 * @author lisu
 *  2013-07-16
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PROMOTER)
public class PromoterManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(PromoterManagedBean.class.getName());
	private PromoterBo promoterBo;
	private int rownum = 0;
	
	
	public PromoterManagedBean(){
		promoterBo = FacadeFactory.INSTANCE.getPromoterBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询推广员
	 * @return
	 */
	public String getQueryPromoterList(){
		logger.info("开始推广员查询");
       // this.authenticateRun();//验证运行权限
        Promoter promoter = findBean(Promoter.class, "promoter");
        PagedFliper pagedFliper = this.getFliper();
        int count = promoterBo.count(promoter);
        pagedFliper.setRecordCount(count);
        List<Promoter> list = new ArrayList<Promoter>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("effectiveDate", OrderType.DESC);
            list = promoterBo.findPromoter(promoter, page);
        }
        Sheet<Promoter> sheet = new Sheet<Promoter>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增推广员
	 * @return
	 */
	public String add(){
		logger.info("开始推广员添加");		
		Promoter promoter = findBean(Promoter.class, "promoter");
		try{
			if(promoter==null){
				logger.info("推广员为空");
				throw new XLRuntimeException("推广员为空");
			}		
			Promoter autoCount = new Promoter();
			autoCount.setPromoterAccount(promoter.getPromoterAccount());
			List<Promoter> aclist = promoterBo.findPromoter(autoCount,new Page());
			if(aclist != null && aclist.size()>0){
				logger.info("已添加过账号为:"+promoter.getPromoterAccount()+"的相关记录，不能重复添加");
				throw new XLRuntimeException("已添加过账号为:"+promoter.getPromoterAccount()+"的相关记录，不能重复添加");
			}
			promoter.setInputBy(this.currentUserLogo());
			promoter.setInputTime(now());
			promoterBo.insert(promoter);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改推广员
	 * @return
	 */
	public String edit(){
		logger.info("开始推广员修改");
		this.authenticateEdit();//编辑权限
		Promoter promoter = findBean(Promoter.class, "promoter");
		try{
			if(promoter==null){
				logger.info("推广员为空");
				throw new XLRuntimeException("推广员为空");
			}	
            promoter.setEditBy(this.currentUserLogo());
            promoter.setEditTime(now());
			promoterBo.update(promoter);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除推广员
	 * @return
	 */
	public String delete(){	
		logger.info("开始推广员删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				promoterBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
