package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.pay.PayOrderBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PAYORDER)
public class PayOrderManagedBean extends BaseManagedBean {

    public String getQueryList(){
        this.authenticateRun();//验证运行权限

        PayOrder payorder = findBean(PayOrder.class, "payorder");

        final PayOrderBo payOrderBo = FacadeFactory.INSTANCE.getPayOrderBo();
        int count = payOrderBo.count(payorder);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<PayOrder> list = new ArrayList<PayOrder>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("orderTime", OrderType.DESC);

            list = payOrderBo.find(payorder, page);
        }
        Sheet<PayOrder> sheet = new Sheet<PayOrder>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }

    public Map<String, String> getStatusOrderMap() {
        Map<String, String> orderMap = new HashMap<String, String>();
        orderMap.put("0", "未支付");
        orderMap.put("1", "支付中");
        orderMap.put("2", "支付失败");
        orderMap.put("3", "支付成功");

        return orderMap;
    }

    public Map<String, String> getStatusRechargeMap() {
        Map<String, String> orderMap = new HashMap<String, String>();

        orderMap.put("0", "未发放");
        orderMap.put("1", "发放中");
        orderMap.put("2", "发放失败");
        orderMap.put("3", "发放成功");

        return orderMap;
    }
}
