package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.model.SelectItem;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;

public class ParamCacheManagedBean extends BaseManagedBean {
	//广告类型
	private static Map<String, String> broadcastTypeMap;
	//YES和no
	private static Map<String,String> yesOrNoMap;
	//上次图片存储路径 
	private static String uploadPicStorePath;
	//上次图片类型
	private static String uploadPicTypeMap;
	//牛X平台显示状态
	private static Map<String,String> niuxShowStatusMap;
	//游戏状态
	private static Map<String,String> gameStatusMap;
	//游戏运营类型
	private Map<String,String>  gameRunStatusMap;
	//游戏类型
	private Map<String,String>  gameTypeMap;
	//开区状态
	private Map<String,String> fenquOpenStautsMap;

    //游戏端类型
    private Map<Integer, String> clientType;

    //载入游戏端类型
    private Map<Integer, String> loadClientType;
    
    //客服系统中游戏分类
    private Map<Long,String> gameCollection;    
    //客服系统中问题分类
    private Map<Integer,String> questionType;    
    //工单进度
    private Map<Integer,String> questionStatus;    
    //用户评分
    private Map<Integer,String> estimate;
    //客服MM处理方式
    private Map<Integer,String> dealtype;
    //工单回复类型
    private Map<Integer,String> replytype;
    
    //官网首页游戏分类
    private Map<String,String> gameCategoryMap;   
    
    private Map<String,String> adviceType;
    
    //积分产品类别
    private Map<String,String> bonusProductType;   
    //积分金卡特权
    private Map<String,String> jinKaTeQuanMap;
    private List<SelectItem> jinKaTeQuanList;
    
    public Map<String, String> getJinKaTeQuanMap() {
    	if(jinKaTeQuanMap==null){
            Map<String,String> tempMap=new HashMap<String,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("jinkatequan");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(libClassD.getItemno(), libClassD.getItemname());
                }
            }
            jinKaTeQuanMap=tempMap;

        }
		return jinKaTeQuanMap;
	}

	public void setJinKaTeQuanMap(Map<String, String> jinKaTeQuanMap) {
		this.jinKaTeQuanMap = jinKaTeQuanMap;
	}

	public List<SelectItem> getJinKaTeQuanList() {
		if(jinKaTeQuanList==null){
			List<SelectItem> tempList=new ArrayList<SelectItem>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("JinKaTeQuan");
            if(list!=null){
                for(LibClassD libClassD:list){
                	SelectItem si=new SelectItem();
                	si.setValue(libClassD.getItemno());
                	si.setLabel(libClassD.getItemname());
                	tempList.add(si);
                }
            }
            jinKaTeQuanList=tempList;
        }
		return jinKaTeQuanList;
	}

	public void setJinKaTeQuanList(List<SelectItem> jinKaTeQuanList) {
		this.jinKaTeQuanList = jinKaTeQuanList;
	}

	public void setClientType(Map<Integer, String> clientType) {
        this.clientType = clientType;
    }

    public void setLoadClientType(Map<Integer, String> loadClientType) {
        this.loadClientType = loadClientType;
    }

    public Map<Integer, String> getClientType() {

        if(clientType==null){
            Map<Integer,String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("clientType");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            clientType=tempMap;

        }
        return clientType;

    }
    
    public Map<String, String> getAdviceType() {

        if(adviceType==null){
            Map<String,String> tempMap=new HashMap<String,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("advicetype");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(libClassD.getItemno(), libClassD.getItemname());
                }
            }
            adviceType=tempMap;

        }
        return adviceType;

    }


	 /**
    * 从基础数组数据中取得游戏集合
    * @return
    */
   public Map<String, String> getGameCategoryMap() {
       if(gameCategoryMap==null){
           Map<String, String> tempMap=new HashMap<String,String>();
           List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("gamecategory");
           if(list!=null){           	
               for(LibClassD libClassD:list){
                   tempMap.put(libClassD.getItemno(), libClassD.getItemname());
               }
           }
           gameCategoryMap=tempMap;
       }
       return gameCategoryMap;

   }
   
   public void setGameCategoryMap(Map<String, String> gameCategoryMap) {
		this.gameCategoryMap = gameCategoryMap;
	}

    public Map<Integer, String> getLoadClientType() {
        if(loadClientType==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("loadClientType");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            loadClientType=tempMap;

        }
        return loadClientType;

    }

    /**
     * 从基础数组数据中取得游戏集合
     * @return
     */
    public Map<Long, String> getGameCollection() {
        if(gameCollection==null){
            Map<Long, String> tempMap=new HashMap<Long,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("GameCollection");
            if(list!=null){           	
                for(LibClassD libClassD:list){
                    tempMap.put(Long.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            gameCollection=tempMap;
        }
        return gameCollection;

    }

    public void setGameCollection(Map<Long, String> gameCollection){
    	this.gameCollection = gameCollection;
    }
    
    /**
     * 从基础数组数据中取得工单进度
     * @return
     */
    public Map<Integer, String> getQuestionStatus() {
        if(questionStatus==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("questionstatus");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            questionStatus=tempMap;
        }
        return questionStatus;

    }
    public void setQuestionStatus(Map<Integer, String> questionStatus){
    	this.questionStatus = questionStatus;
    }

    /**
     * 从基础数组数据中取得工单进度
     * @return
     */
    public Map<Integer, String> getEstimate() {
        if(estimate==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("estimate");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            estimate=tempMap;
        }
        return estimate;

    }
    public void setEstimate(Map<Integer, String> estimate){
    	this.estimate = estimate;
    }
    
    /**
     * 从基础数组数据中取得客服MM处理方式
     * @return
     */
    public Map<Integer, String> getDealType() {
        if(dealtype==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("dealtype");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            dealtype=tempMap;
        }
        return dealtype;

    }
    public void setDealType(Map<Integer, String> dealtype){
    	this.dealtype = dealtype;
    }
    
    /**
     * 从基础数组数据中取得工单回复类型
     * @return
     */
    public Map<Integer, String> getReplyType() {
        if(replytype==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("replytype");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            replytype=tempMap;
        }
        return replytype;

    }
    public void setReplyType(Map<Integer, String> replytype){
    	this.replytype = replytype;
    }
    
    public void setQuestionType(Map<Integer, String> questionType){
    	this.questionType = questionType;
    }
    /**
     * 从基础数组数据中取得问题分类
     * @return
     */
    public Map<Integer, String> getQuestionType() {
        if(questionType==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("QuestionType");
            if(list!=null){
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            questionType=tempMap;
        }
        return questionType;

    }

    public Map<String, String> getFenquOpenStautsMap() {
		if(fenquOpenStautsMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("fenquopenstatus");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			fenquOpenStautsMap=tempMap;
			
		}
		return fenquOpenStautsMap;
	}
	public void setFenquOpenStautsMap(Map<String, String> fenquOpenStautsMap) {
		this.fenquOpenStautsMap = fenquOpenStautsMap;
	}
	public Map<String, String> getGameTypeMap() {
		if(gameTypeMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("gameType");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			gameTypeMap=tempMap;
		}
		return gameTypeMap;
	}
	public void setGameTypeMap(Map<String, String> gameTypeMap) {
		this.gameTypeMap = gameTypeMap;
	}
	public Map<String, String> getGameRunStatusMap() {
		if(gameRunStatusMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("gameRunStatus");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			gameRunStatusMap=tempMap;
		}
		return gameRunStatusMap;
	}
	public void setGameRunStatusMap(Map<String, String> gameRunStatusMap) {
		this.gameRunStatusMap = gameRunStatusMap;
	}
	
	public  Map<String, String> getGameStatusMap() {
		if(gameStatusMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("gameStatus");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			gameStatusMap=tempMap;
		}
		return gameStatusMap;
	}
	public  void setGameStatusMap(Map<String, String> gameStatusMap) {
		ParamCacheManagedBean.gameStatusMap=gameStatusMap;
	}
	public  Map<String, String> getNiuxShowStatusMap() {
		if(niuxShowStatusMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("niuxShowStatus");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			niuxShowStatusMap=tempMap;
		}
		return niuxShowStatusMap;
	}
	public  void setNiuxShowStatusMap(Map<String, String> niuxShowStatusMap) {
		ParamCacheManagedBean.niuxShowStatusMap = niuxShowStatusMap;
	}
	public  Map<String, String> getYesOrNoMap() {
		if(yesOrNoMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("yesorno");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			yesOrNoMap=tempMap;
		}
		return yesOrNoMap;
	}
	public  void setYesOrNoMap(Map<String, String> yesOrNoMap) {
		ParamCacheManagedBean.yesOrNoMap = yesOrNoMap;
	}
	public  Map<String, String> getBroadcastTypeMap() {
		if(broadcastTypeMap==null){
			Map<String,String> tempMap=new HashMap<String,String>();
			List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("broadcasttype");
			if(list!=null){
				for(LibClassD libClassD:list){
					tempMap.put(libClassD.getItemno(), libClassD.getItemname());
				}
			}
			broadcastTypeMap=tempMap;
		}
		return broadcastTypeMap;
	}
	public  void setBroadcastTypeMap(Map<String, String> advTypeMap) {
		ParamCacheManagedBean.broadcastTypeMap = advTypeMap;
	}
	public static String getUploadPicStorePath() {
		if(uploadPicStorePath==null||"".equals(uploadPicStorePath)){
			uploadPicStorePath=IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");
		}
		return uploadPicStorePath;
	}
	public static void setUploadPicStorePath(String uploadPicStorePath) {
		ParamCacheManagedBean.uploadPicStorePath = uploadPicStorePath;
	}
	public static String getUploadPicTypeMap() {
		return uploadPicTypeMap;
	}
	public static void setUploadPicTypeMap(String uploadPicTypeMap) {
		ParamCacheManagedBean.uploadPicTypeMap = uploadPicTypeMap;
	}
   public List<SelectItem> getSelectItemList(Map<String,String> map){
	   List<SelectItem> list=new ArrayList<SelectItem>();
	   if(map==null||map.isEmpty()){
		   return list;
	   }
	   Set<String>  keySet= map.keySet();
	   Iterator<String> it=keySet.iterator();
	   map.entrySet();
	   while(it.hasNext()){
		   String keyStr=it.next();
		   SelectItem si=new SelectItem();
		   si.setValue(keyStr);
		   si.setLabel(map.get(keyStr));
		   list.add(si);
	   }
	   return list;
   }

	public void setAdviceType(Map<String, String> adviceType) {
		this.adviceType = adviceType;
	}

	public Map<String, String> getBonusProductType() {
		 if(bonusProductType==null){
	            Map<String,String> tempMap=new HashMap<String,String>();
	            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("bonusproducttype");
	            if(list!=null){
	                for(LibClassD libClassD:list){
	                    tempMap.put(libClassD.getItemno(), libClassD.getItemname());
	                }
	            }
	            bonusProductType=tempMap;

	        }
		 return bonusProductType;
	}

	public void setBonusProductType(Map<String, String> bonusProductType) {
		this.bonusProductType = bonusProductType;
	}
}
