package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.PageStatisticsJs;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 游戏统计代码管理
 *
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PAGESTATISTICSJS)
public class PageStatisticsJsManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(BaseManagedBean.class.getName());

    /**
     * 查询统计代码
     *
     * @return
     */
    public String getQueryStatisticsJsList() {
        logger.info("开始统计代码查询");
        this.authenticateRun();//验证运行权限

        PageStatisticsJs pageStatisticsJs = findBean(PageStatisticsJs.class, "pagestatisticsjs");
        if (pageStatisticsJs != null) {
            logger.debug(pageStatisticsJs.getGameId());
            if(pageStatisticsJs.getSeqId() != null && pageStatisticsJs.getSeqId() == 0) {
                pageStatisticsJs = new PageStatisticsJs();
            }
        }

        int count = FacadeFactory.INSTANCE.getPageStatisticsJsBo().count(pageStatisticsJs);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);

        List<PageStatisticsJs> list = new ArrayList<PageStatisticsJs>();
        if(count > 0) {
        	Page page=PageUtil.formatPage(pagedFliper, "editTime","desc");
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
            list = FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(pageStatisticsJs,page);
        }

        Sheet<PageStatisticsJs> sheet=new Sheet<PageStatisticsJs>(count,list);
        this.mergePagedDataModel(sheet, pagedFliper);

        return "";
    }

    public String edit() {
        this.authenticateEdit();

        PageStatisticsJs pageStatisticsJs = findBean(PageStatisticsJs.class, "pagestatisticsjs");
        if (pageStatisticsJs == null) {
            logger.debug("统计代码为空");
            mergeBean("编辑失败，原因：统计代码为空", "jsmessage");
            return "";
        }

        try{
            PageStatisticsJs psjs = FacadeFactory.INSTANCE.getPageStatisticsJsBo().findById(pageStatisticsJs.getSeqId());
            if(psjs==null){
                logger.debug("统计代码为空");
                mergeBean("编辑失败，原因：统计代码为空", "jsmessage");
                return "";
            }
            
        	//验证是否已经使用
        	PageStatisticsJs ps=new PageStatisticsJs();
        	ps.setGameId(pageStatisticsJs.getGameId());
        	List<PageStatisticsJs> templist=FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(ps, 0, 0);
        	if(templist!=null&&templist.size()>1){
        		throw new Exception("该游戏已经添加");
        	}
        	if(templist!=null&&templist.size()==1){
        		PageStatisticsJs tempps=templist.get(0);
        		if(!psjs.getSeqId().equals(tempps.getSeqId())){
        			throw new Exception("该游戏已添加");
        		}
        	}
            
            pageStatisticsJs.setInputBy(psjs.getInputBy());
            pageStatisticsJs.setInputTime(psjs.getInputTime());
            UserInfo user=this.currentUserInfo();
            pageStatisticsJs.setEditBy(user.getTrueName());
            pageStatisticsJs.setEditTime(new Date());

            FacadeFactory.INSTANCE.getPageStatisticsJsBo().update(pageStatisticsJs);
            //mergeBean("编辑成功", "jsmessage");
        }catch(Exception e){
            logger.error("编辑失败", e);
            mergeBean("编辑失败，原因：" + e.getMessage(), "jsmessage");
        }

        //getQueryStatisticsJsList();

        return "";
    }

    public String add() {
        this.authenticateAdd();//添加权限

        PageStatisticsJs pageStatisticsJs = findBean(PageStatisticsJs.class, "pagestatisticsjs");
        if (pageStatisticsJs == null) {
            logger.debug("添加代码为空");
            mergeBean("添加失败，原因：添加代码为空", "jsmessage");
            return "";
        }

        try{
        	//验证是否已经使用
        	PageStatisticsJs ps=new PageStatisticsJs();
        	ps.setGameId(pageStatisticsJs.getGameId());
        	List<PageStatisticsJs> templist=FacadeFactory.INSTANCE.getPageStatisticsJsBo().findPageStatisticsJss(ps, 0, 0);
        	if(templist!=null&&templist.size()>0){
        		throw new Exception("该游戏已经添加");
        	}
            UserInfo user=this.currentUserInfo();
            pageStatisticsJs.setInputBy(user.getTrueName());
            pageStatisticsJs.setEditBy(user.getTrueName());
            Date now =new Date();
            pageStatisticsJs.setInputTime(now);
            pageStatisticsJs.setEditTime(now);

            FacadeFactory.INSTANCE.getPageStatisticsJsBo().insert(pageStatisticsJs);
            //mergeBean("添加成功", "jsmessage");
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeBean("编添加失败，原因：" + e.getMessage(), "jsmessage");
        }

        //getQueryStatisticsJsList();

        return "";
    }
}


