package com.xunlei.niux.manager.web.model;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.Activity;
import com.xunlei.niux.data.manager.vo.AdvSeat;
import com.xunlei.niux.data.manager.vo.Advertisement;
import com.xunlei.niux.data.manager.vo.Game;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;


/**
 * 
 * @author lin
 * @date 2012-8-17
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_STATIC_FILE)
public class NiuxManagedBean extends BaseManagedBean {
	private static final Logger logger=Logger.getLogger(NiuxManagedBean.class.getName());
	private static final String advStaticPath=ApplicationConfigUtil.WEBROOT+"niuxstatic/adv_js/";
	private static  boolean advstaticflag=false;
	private static boolean gamestaticflag=false;
	private static boolean activitystaticflag=false;
	private static final String gameStaticPath=ApplicationConfigUtil.WEBROOT+"niuxstatic/game_js/";
	private static final String activityStaticPath=ApplicationConfigUtil.WEBROOT+"niuxstatic/activity_js/";
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
	private static boolean copypicflag=false;
	public String copyPic(){
		try{
			if(copypicflag){
				alertJS("其他用户正在同步图片，请稍后！");
				 return "";
			}
			copypicflag=true;
			Runtime.getRuntime().exec("syn_niuxpic.sh");
			copypicflag=false;
			alertJS("同步成功！");
			return "";
		}catch(Exception e){
			logger.error("生成专题活动静态页面出现异常",e);
			copypicflag=false;
			alertJS("同步失败，原因："+e.getMessage());
			return "";
		}
	}
	public String createActivityStaticFile(){
		try{
			if(activitystaticflag){
				 alertJS("其他用户正在生成专题活动静态页面，请稍后！");
				 return "";
			}
			activitystaticflag=true;
			Activity act=new Activity();
			act.setHomePageShow("1");
			String nowDate=sdf.format(new Date());
			act.setToshowBeginDate(nowDate);//小于showbegindate<=nowdate;
			act.setFromshowEndDate(nowDate);//大于
			//正在进行的活动
			act.setToactBeginDate(nowDate);
			act.setFromactEndDate(nowDate);
			PagedFliper pf=new PagedFliper();
			pf.setPageNo(1);
			pf.setPageSize(3);
			pf.setSortColumn(" displayorder desc ");
			Sheet<Activity> sheet=FacadeFactory.INSTANCE.getActivityBo().queryActivities(act, pf);
			if(sheet==null||sheet.getRowcount()<=0){
				logger.info("需要生成专题活动的游戏位数目：0");
				activitystaticflag=false;
				alertJS("没有专题活动");
				return "";
			}
			String actpicpath="http://niu.xunlei.com/niuxstatic/img/";
			Map<String,Object> map=new HashMap<String,Object>();
			List<Map<String,String>> list=new ArrayList<Map<String,String>>();
			List<Activity> aList=(List<Activity>) sheet.getDatas();
			for(Activity act1:aList){
				Map<String,String> m1=new HashMap<String,String>();
				m1.put("actpic",actpicpath+act1.getPicPath());
				m1.put("actname",act1.getActName());
				m1.put("actlink", act1.getLinkPath());
				list.add(m1);
			}
			map.put("data", list);
			String json=JsonObjectUtil.getRtnAndDataJsonObject(0, map);
			json="var data="+json;
			logger.info("json内容："+json);
			File file=new File(activityStaticPath+"hotact.js");
			FileUploadUtil.write(file, json);
			Runtime.getRuntime().exec("syn_niuxactivitystatic.sh");
			activitystaticflag=false;
			alertJS("生成成功");
			return "";
		}catch(Exception e){
			logger.error("生成专题活动静态页面出现异常",e);
			activitystaticflag=false;
			alertJS("生成失败，原因："+e.getMessage());
			return "";
		}
	}
	public String createGameStaticFile(){
		try{
			if(gamestaticflag){
				 alertJS("其他用户正在生成游戏静态页面，请稍后！");
				 return "";
			}
			gamestaticflag=true;
			logger.info("删除"+gameStaticPath);
			FileUploadUtil.delete(new File(gameStaticPath));
			logger.info("创建文件夹");
			Game game=new Game();
			game.setShowStatus("02");
			Sheet<Game> sheet=FacadeFactory.INSTANCE.getGameBo().queryGames(game, null);
			if(sheet==null||sheet.getRowcount()<=0){
				logger.info("需要生成静态页面的游戏位数目：0");
				gamestaticflag=false;
				alertJS("没有游戏");
				return "";
			}
			String gamepicpath="http://niu.xunlei.com/niuxstatic/img/";
			Map<String,Object> map=new HashMap<String,Object>();
			List<Map<String,String>> list=new ArrayList<Map<String,String>>();
			List<Game> gList=(List<Game>) sheet.getDatas();
			for(Game g:gList){
				Map<String,String> m1=new HashMap<String,String>();
				m1.put("gamepic", gamepicpath+g.getPicPath());
				m1.put("gamename", g.getGameNo());
				m1.put("gamedesc", g.getGameDesc());
				list.add(m1);
			}
			map.put("data", list);
			String json=JsonObjectUtil.getRtnAndDataJsonObject(0, map);
			json="var data="+json;
			logger.info("json内容："+json);
			File file=new File(gameStaticPath+"hotgame.js");
			FileUploadUtil.write(file, json);
			Runtime.getRuntime().exec("syn_niuxgamestatic.sh");
			gamestaticflag=false;
			alertJS("生成成功");
			return "";
		}catch(Exception e){
			logger.error("生成游戏静态页面出现异常",e);
			gamestaticflag=false;
			alertJS("生成失败，原因："+e.getMessage());
			return "";
		}
	}
	/**
	 * 创建广告静态页面，然后将页面同步到牛平台
	 * @return
	 */
	public String createAdvStaticFile(){
		try{
			if(advstaticflag){
				 alertJS("其他用户正在生成广告，请稍后！");
				 return "";
			}
			advstaticflag=true;
			logger.info("开始生成广告静态页面");
			AdvSeat as=new AdvSeat();
			as.setSeatStatus("1");//正在使用的广告位置
		    Sheet<AdvSeat> sheet=FacadeFactory.INSTANCE.getAdvertisementBo().queryAdvSeats(as, null);
			if(sheet==null||sheet.getRowcount()<=0){
				logger.info("需要生成静态页面的广告位数目：0");
				advstaticflag=false;
				alertJS("没有广告位");
				return "";
			}
		    logger.info("需要生成静态页面的广告位数目："+sheet.getRowcount());
			List<AdvSeat> asList=(List<AdvSeat>) sheet.getDatas();
			if(asList==null||asList.size()<=0){
				logger.info("需要生成静态页面的广告位数目：0");
				alertJS("没有广告位生成成功");
				advstaticflag=false;
				return "";
			}
			for(AdvSeat as1:asList){
				String nowDate=sdf.format(new Date());
				Advertisement adv=new Advertisement();
				adv.setSeatNo(as1.getSeatNo());
				adv.setToshowBeginDate(nowDate);//小于showbegindate<=nowdate;
				adv.setFromshowEndDate(nowDate);//大于
				Sheet<Advertisement> aSheet=FacadeFactory.INSTANCE.getAdvertisementBo().queryAdv(adv, null);
				List<Advertisement> list=new ArrayList<Advertisement>();
				if(aSheet!=null&&aSheet.getDatas()!=null){
					list=(List<Advertisement>) aSheet.getDatas();
					list=list==null?new ArrayList<Advertisement>():list;
				}
				createAdvJs(as1, list);
			}
		    Runtime.getRuntime().exec("syn_niuxadvstatic.sh");
		    advstaticflag=false;
		    alertJS("生成成功");
			return "";
		}catch(Exception e){
			logger.error("生成广告静态页面出现异常",e);
			advstaticflag=false;
			alertJS("生成失败，原因："+e.getMessage());
			return "";
		}
	}
	private void createAdvJs(AdvSeat as,List<Advertisement> advList)throws Exception{
		String seatNo=as.getSeatNo();
		Map<String,Object> m1=new HashMap<String,Object>();
		String advpicpath="http://niu.xunlei.com/niuxstatic/img/";
		if("02".equals(as.getAdvType())){
			logger.info("生成轮播广告静态文件，广告位编号："+seatNo);
			m1.put("intersec", as.getLoopTime());
			List<Map<String,String>> l1=new ArrayList<Map<String,String>>();
			for(Advertisement adv:advList){
				Map<String,String> tm=new HashMap<String,String>();
				tm.put("gamename", ""+adv.getAdvTitle());
				tm.put("gamedesc", adv.getRemark()==null?"":adv.getRemark());
				tm.put("bigpic", advpicpath+adv.getBigPicPath());
				tm.put("smallpic", advpicpath+adv.getSmallPicPath());
				tm.put("link", adv.getLinkPath());
				l1.add(tm);
			}
			m1.put("data", l1);
		}else{
			logger.info("生成单播广告静态文件，广告位编号："+seatNo);
			if(advList!=null&&advList.size()>0){
				Advertisement adv=advList.get(0);
				m1.put("pic", advpicpath+adv.getBigPicPath());
				m1.put("link", adv.getLinkPath());
				if(adv.getBigPicPath()!=null&&(!"".equals(adv.getBigPicPath()))){
					FileUploadUtil.copy(new File(ParamCacheManagedBean.getUploadPicStorePath()+adv.getBigPicPath()), new File(advStaticPath+"img/"+adv.getBigPicPath()));
				}
			}else{
				m1.put("pic", "");
				m1.put("link", "");
			}
		}
		String json=JsonObjectUtil.getRtnAndDataJsonObject(0, m1);
		json="var data="+json;
		logger.info("json内容："+json);
		File file=new File(advStaticPath+as.getSeatNo()+".js");
		FileUploadUtil.write(file, json);
	}
}
