package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import com.xunlei.niux.manager.web.util.EmailSender;
import org.apache.poi.ss.usermodel.Workbook;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxCashGenerateRecord;
import com.xunlei.niux.data.league.vo.WarnEmail;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;

@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PROMOTER)
public class NiuxCashManagedBean extends BaseManagedBean {
	private static String generatePrivateKey="niucash123";
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	public String getQueryNiuxCashList(){
		NiuxCash query=this.findBean(NiuxCash.class, "niuxcash");
		String generateNo=this.findParameter("generateNo");
		if(generateNo!=null&&!"".equals(generateNo)){
			query.setGenerateNo(generateNo);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getNiuxCashBo().count(query);
		List<NiuxCash> niuxCashList=new ArrayList<NiuxCash>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "generateNo","desc");
			 niuxCashList=FacadeFactory.INSTANCE.getNiuxCashBo().finds(query, page);
		}
		Sheet<NiuxCash> sheet=new Sheet<NiuxCash>(count, niuxCashList);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryNiuxCashGenerateRecordList(){
		NiuxCashGenerateRecord query=this.findBean(NiuxCashGenerateRecord.class,"niuxcashgeneraterecord");
		String generateNo=this.findParameter("generateNo");
		if(generateNo!=null&&!"".equals(generateNo)){
			query.setGenerateNo(generateNo);
		}
		String lotGroupId=this.findParameter("lotGroupId");
		if(lotGroupId!=null&&!"".equals(lotGroupId)){
			query.setLotGroupId(Long.valueOf(lotGroupId));
		}
		if(query.getLotGroupId()!=null&&query.getLotGroupId()==0){
			query.setLotGroupId(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count=FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().count(query);
		List<NiuxCashGenerateRecord> records=new ArrayList<NiuxCashGenerateRecord>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "inputTime","desc");
			 records=FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().finds(query, page);
		}
		Sheet<NiuxCashGenerateRecord> sheet=new Sheet<NiuxCashGenerateRecord>(count, records);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String add(){
		this.authenticateAdd();//添加权限
		String key=this.findParameter("generatePrivateKey");
		if(!key.equals(generatePrivateKey)){
			mergeJsmessage("添加失败，原因：密钥"+key+"不正确");
			return "";
		}
		NiuxCashGenerateRecord record=this.findBean(NiuxCashGenerateRecord.class,"niuxcashgeneraterecord");
		
		String one_type = this.findParameter("one_type");//代金券还是现金券
		String one_parValue_type = this.findParameter("one_parValue_type");
		if("false".equals(one_type)){//现金券
			if(!"".equals(one_parValue_type)){
				record.setParValue(Double.valueOf(one_parValue_type.trim()));
			}else{
				record.setParValue(0D);
			}
		}
		
		UserInfo user=this.currentUserInfo();
		record.setInputBy(user.getTrueName());
		record.setInputTime(sdf.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().insert(record);
			emailwarn(record);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	public void emailwarn(NiuxCashGenerateRecord record){
		try{
			List<WarnEmail> emailList=FacadeFactory.INSTANCE.getBaseSo().findObjects(new WarnEmail(), new Page());
			if(emailList.size()==0){
				return;
			}
			String[] emails=new String[emailList.size()];
			for(int i=0;i<emailList.size();i++){
				emails[i]=emailList.get(i).getEmail();
			}
			
			String content="推广员["+record.getPromoterAccount()+"]生成了"+record.getParValue()+"元牛X代金券"+record.getGenerateNum()
					+"张。使用最小金额"+record.getMinPayMoney()+"元。（录入人["+
					record.getInputBy()+"],生成时间"+record.getInputTime()+"）";
			if(record.getIsDynamicGenerate()){
				content=content+"该批代金券支持接口自动生成";
			}
            com.xunlei.niux.manager.web.util.EmailSender.sendMail(emails, "牛X代金券生成通知", content);
        }catch(Exception e){
			logger.error("生成激活码邮件发送失败", e);
		}
	}
	public void export(){
		this.authenticateRun();
		String generateNo=this.findParameter("generateNo");
		NiuxCash query=new NiuxCash();
		query.setGenerateNo(generateNo);
		List<NiuxCash> cashList=FacadeFactory.INSTANCE.getNiuxCashBo().finds(query, new Page());
		cashList=cashList==null?new ArrayList<NiuxCash>():cashList;
		@SuppressWarnings("rawtypes")
		List<List> execlList=new ArrayList<List>();
		for(int i=0;i<cashList.size();i++){
			NiuxCash cash=cashList.get(i);
			List<String> list=new ArrayList<String>();
			NiuxCashGenerateRecord genRecord=FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().findOneByGenerateNo(cash.getGenerateNo());
			list.add(cash.getCashNo());
			list.add(cash.getParValue()+"");
			list.add(cash.getExpireDate());
			list.add(cash.getCashStatus());
			list.add(genRecord.getPromoterAccount());
			list.add(cash.getReceiveUserId()==null?"":cash.getReceiveUserId());
			list.add(cash.getReceiveTime()==null?"":cash.getReceiveTime());
			execlList.add(list);
		}
		String[] columnName = {"激活码", "面值", "到期日期", "使用状态","推广员账号","领取人","领取时间"};
		String filePath = "/tmp/niuxcashexport/"+generateNo+".xls";
		String title = "批号"+generateNo+"的代金券";	
		Workbook wb = ExcelUtil.create("牛X代金券",title,columnName,filePath,execlList);

        //弹出下载窗口
		FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		response.setHeader("Content-disposition", "attachment;filename="+generateNo+".xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	
	}
}
