package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.league.vo.NiuxCashGenerateRecord;
import com.xunlei.niux.data.league.vo.NiuxCashHandout;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.StringUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_PROMOTER)
public class NiuxCashHandoutManagedBean extends BaseManagedBean {
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat yyyy_MM_dd =new SimpleDateFormat("yyyy-MM-dd");
    private String pchmsgid;
    private String pchmsgtext;
    private String pchmsggenno;

	public String getQueryNiuxCashHandout(){
        this.authenticateRun();
        NiuxCashHandout param=this.findBean(NiuxCashHandout.class, "niuxcashhandout");
        NiuxCashHandout query = new NiuxCashHandout();
        if(StringUtils.isNotEmpty(param.getUserid())){
            query.setUserid(param.getUserid());
        }
        if(StringUtils.isNotEmpty(param.getGenerateNo())){
            query.setGenerateNo(param.getGenerateNo());
        }
        if(StringUtils.isNotEmpty(param.getCashNo())){
            query.setCashNo(param.getCashNo());
        }
        if(StringUtils.isNotEmpty(param.getHandoutBy())){
            query.setHandoutBy(param.getHandoutBy());
        }
        if(param.getHandoutid()!=null&&param.getHandoutid()!=0){
            query.setHandoutid(param.getHandoutid());
        }
        PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        pagedFliper.setRecordCount(count);
		List<NiuxCashHandout> niuxCashList=new ArrayList<NiuxCashHandout>();
		if(count>0){
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
			niuxCashList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query,page);
		}
		Sheet<NiuxCashHandout> sheet=new Sheet<NiuxCashHandout>(count, niuxCashList);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}

    public String findNiuxCashGeneratenoRecord(){
        this.authenticateRun();
        if(StringUtils.isEmpty(pchmsggenno)||StringUtils.isEmpty(pchmsgid))return "";
        NiuxCashGenerateRecord query = new NiuxCashGenerateRecord();
        query.setGenerateNo(pchmsggenno);
        NiuxCashGenerateRecord gen = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if(gen==null){
            pchmsgtext = "null";
        }else{
            int sy = gen.getGenerateSum() - gen.getGenerateNum();
            pchmsgtext=gen.getMinPayMoney()+"-"+gen.getParValue()+", 余"+sy;
        }
        return "";
    }

    public String add(){
        this.authenticateAdd();//添加权限
        String[] uids = findParameters("niuxcashsd_uid");
        String[] gennos = findParameters("niuxcashsd_genno");
        String reason = findParameter("niuxcashsd_reason");
        if(uids==null||uids.length==0){
            mergeJsmessage("添加失败，原因：uid为空" );
            return "";
        }
        if(gennos==null||gennos.length==0){
            mergeJsmessage("添加失败，原因：代金券批次号为空" );
            return "";
        }
        if(StringUtils.isEmpty(reason)){
            mergeJsmessage("添加失败，原因：理由为空" );
            return "";
        }
        for(String uid:uids){
            if(StringUtils.isEmpty(uid)){
                mergeJsmessage("添加失败，原因：uid为空" );
                return "";
            }
        }
        for(String genno:gennos){
            if(StringUtils.isEmpty(genno)){
                mergeJsmessage("添加失败，原因：代金券批次号为空" );
                return "";
            }
        }
        try{
//            System.out.println("uids:"+Arrays.toString(uids)+uids.length);
//            System.out.println("gennos:"+Arrays.toString(gennos)+gennos.length);
//            System.out.println("reason:"+reason);
            check(uids, gennos);
            FacadeFactory.INSTANCE.getNiuxCashGenerateRecordBo().handoutNiuxCash(uids,gennos,this.currentUserInfo().getTrueName(),reason);
        }catch(Exception e){
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    private void check(String[] uids, String[] gennos) throws Exception{
        int uidLen = uids.length;

        for(String generateNo:gennos){
            //是否存在代金券批次
            NiuxCashGenerateRecord hasgen = new NiuxCashGenerateRecord();
            hasgen.setGenerateNo(generateNo);
            NiuxCashGenerateRecord genRecord=FacadeFactory.INSTANCE.getBaseSo().findObject(hasgen);
            if(genRecord==null){
                throw new XLRuntimeException("不存在该批次号："+generateNo);
            }

            //是否发放uid数量超过代金券剩余数量
            int sy =genRecord.getGenerateSum()-genRecord.getGenerateNum();
            if(sy<uidLen){
                throw new XLRuntimeException("剩余量不足："+generateNo+", 剩余："+sy);
            }

            //判断是否超过最大值
            String nowDate=yyyy_MM_dd.format(new Date());
            NiuxCash cashQuery=new NiuxCash();
            cashQuery.setFromReceiveTime(nowDate+" 00:00:00");
            cashQuery.setToReceiveTime(nowDate+" 23:59:59");
            cashQuery.setGenerateNo(generateNo);
            int count=FacadeFactory.INSTANCE.getBaseSo().countObject(cashQuery);
            if(genRecord.getOneDayMaxGenerateNum()>0&&count>=genRecord.getOneDayMaxGenerateNum()){
                throw new XLRuntimeException("牛X代金券批号[" + generateNo + "]已达到最大发放限制");
            }

            //判断是否达到单个用户的最大限制
            for(String receiveUserId:uids){
                cashQuery.setUserId(receiveUserId);
                count=FacadeFactory.INSTANCE.getBaseSo().countObject(cashQuery);
                if(genRecord.getOneUserMaxGenerateNum()>0&&count>=genRecord.getOneUserMaxGenerateNum()){
                    throw new XLRuntimeException("牛X代金券批号["+generateNo+"]已达到该用户的最大发放限制");
                }
            }
        }


    }

    public String getPchmsgid() {
        return pchmsgid;
    }

    public void setPchmsgid(String pchmsgid) {
        this.pchmsgid = pchmsgid;
    }

    public String getPchmsgtext() {
        return pchmsgtext;
    }

    public void setPchmsgtext(String pchmsgtext) {
        this.pchmsgtext = pchmsgtext;
    }

    public String getPchmsggenno() {
        return pchmsggenno;
    }

    public void setPchmsggenno(String pchmsggenno) {
        this.pchmsggenno = pchmsggenno;
    }
}
