package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.MultimediaTips;
import com.xunlei.niux.manager.web.cache.GameCache;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.util.*;

public class MultimediaTipsManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MultimediaTipsManagedBean.class.getName());
	private BaseSo baseSo;

    public Map<String, Object> getNotYetUsedGamesMap() {
        return notYetUsedGamesMap;
    }

    public void setNotYetUsedGamesMap(Map<String, Object> notYetUsedGamesMap) {
        this.notYetUsedGamesMap = notYetUsedGamesMap;
    }

    private Map<String, Object> notYetUsedGamesMap = new HashMap<String, Object>();

    public void reflashNotYetUsedGamesMap() {
        System.out.println("sssseqid:"+findParameter("one_seqid"));
        Long one_seqid = findParamLong("one_seqid");
        List<Object> list = new ArrayList<Object>();
        list.add(one_seqid);

        notYetUsedGamesMap.clear();
        //已经投放的所有游戏ID
        Set<String> gameIdSet = new HashSet<String>();
        String sql = "SELECT * FROM multimedia_tips WHERE gamesIndexPage IS NOT NULL AND gamesIndexPage<>'' AND seqid <> ? ";
        List<MultimediaTips> hasGamesList = baseSo.executeQuery(MultimediaTips.class,sql,list);
        for(MultimediaTips mt : hasGamesList){
            String[] gameIdArr = mt.getGamesIndexPage().split(",");
            for(String gameId:gameIdArr){
                gameIdSet.add(gameId.trim());
            }
        }

        List<Games> gamesList = GameCache.getInstance().getAllGames();
        for(Games games:gamesList) {
            if (games.getClientType() != null && games.getClientType().intValue() == 3) continue;//除手游之外其他的游戏
            if ("0".equals(games.getStatus())) continue;//去掉 未接入的游戏
            if(gameIdSet.contains(games.getGameId()))continue;//去掉已投放游戏
            notYetUsedGamesMap.put(games.getGameName(),games.getGameId());
        }
    }


    public MultimediaTipsManagedBean(){
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
	}

	public String getQueryDateList(){
        this.authenticateRun();
        MultimediaTips query = findBean(MultimediaTips.class, "multimediatipsvo");
        if(StringUtils.isNotEmpty(query.getLikeTitle())){
            query.setLikeTitle("%"+query.getLikeTitle()+"%");
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List<MultimediaTips> list = new ArrayList<MultimediaTips>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = baseSo.findObjects(query, page);
        }
        Sheet<MultimediaTips> sheet = new Sheet<MultimediaTips>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}

    private void check(MultimediaTips data) throws Exception{
        if(data==null){
            throw new XLRuntimeException("数据为空");
        }
        System.out.println(BeanUtils.describe(data));
        if(StringUtils.isEmpty(data.getTitle())
                || StringUtils.isEmpty(data.getStartTime().trim())
                || StringUtils.isEmpty(data.getEndTime().trim())
                || StringUtils.isEmpty(data.getJumpToUrl())
                || StringUtils.isEmpty(data.getSucai())
                || StringUtils.isEmpty(data.getNeirong())
                ){
            throw new XLRuntimeException("标题，开始时间，结束时间，跳转链接，素材和内容不能为空！");
        }


        if(data.getStartTime().length()!=19){
            throw new XLRuntimeException("开始时间格式错误！");
        }
        if(data.getEndTime().length()!=19){
            throw new XLRuntimeException("结束时间格式错误！");
        }

        //显示页面
        String[] displayPageArr = findParameters("mt_displayPage");
        if(displayPageArr==null||displayPageArr.length==0){
            throw new XLRuntimeException("显示页面为空！");
        }
        String displayPage = Arrays.toString(displayPageArr);
        displayPage = displayPage.substring(1,displayPage.length()-1);
        data.setDisplayPage(displayPage);

        //游戏列表
        String gamesIndexPage = "";
        if(displayPage.contains("4")){//如果游戏官网显示
            String[] gamesIndexPageArr = findParameters("mt_gamesIndexPage");
            if(gamesIndexPageArr==null||gamesIndexPageArr.length==0){
                throw new XLRuntimeException("请选择游戏！");
            }
            gamesIndexPage = Arrays.toString(gamesIndexPageArr);
            gamesIndexPage=gamesIndexPage.substring(1,gamesIndexPage.length()-1);
            data.setGamesIndexPage(gamesIndexPage);
        }

        System.out.println("displayPage:"+ displayPage);
        System.out.println("gamesIndexPage:"+gamesIndexPage);
    }

	public String add(){
        this.authenticateAdd();
        MultimediaTips data = this.findBean(MultimediaTips.class,"multimediatipsvo");
		try{
            check(data);

            String sel_tipstype_uid_tx = findParameter("sel_tipstype_uid_tx");
            List<Long> uidList = new ArrayList<Long>();
            if(StringUtils.isEmpty(sel_tipstype_uid_tx)){
                data.setForUidGroupId(0L);
            }else{
                data.setForUidGroupId(System.currentTimeMillis());
                for (String uid : sel_tipstype_uid_tx.split("\\|")) {
                    if ("".equals(uid)) continue;
                    try {
                        uidList.add(Long.valueOf(uid));
                    } catch (NumberFormatException e) {
                        logger.error(e);
                        throw new XLRuntimeException("uid格式错误");
                    }
                }
            }
            data.setInputBy(this.currentUserLogo());
            data.setInputTime(now());

            FacadeFactory.INSTANCE.getTriggerMessageBo().saveMultimediaTips(uidList, data);

		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public String edit(){
		this.authenticateEdit();
        MultimediaTips data = this.findBean(MultimediaTips.class,"multimediatipsvo");
		try{
            if(data.getSeqid()==null){
                throw new XLRuntimeException("参数错误");
            }
            MultimediaTips query = new MultimediaTips();
            query.setSeqid(data.getSeqid());
            MultimediaTips oriMt = baseSo.findObject(query);
            if(oriMt==null){
                throw new XLRuntimeException("不存在该数据");
            }
            check(data);
            data.setEditBy(this.currentUserLogo());
            data.setEditTime(now());
			baseSo.updateObjectById(data);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	public String delete(){
		this.authenticateDel();
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseSo.deleteById(MultimediaTips.class,id);
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
