package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuTotalReportBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuTotalReport;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MOYUREPORT)
public class MoyuTotalReportManagedBean extends BaseManagedBean {
    private static final Logger logger = Logger.getLogger(MoyuTotalReportManagedBean.class);

    public String getQueryList(){
        logger.info("魔域汇总查询");
        this.authenticateRun();//验证运行权限

        MoyuTotalReport moyuTotalReport = findBean(MoyuTotalReport.class, "moyutotalreport");

        final MoyuTotalReportBo moyuTotalReportBo = FacadeFactory.INSTANCE.getMoyuTotalReportBo();
        int count = moyuTotalReportBo.count(moyuTotalReport);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<MoyuTotalReport> list = new ArrayList<MoyuTotalReport>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            list = moyuTotalReportBo.find(moyuTotalReport, page);
        }
        Sheet<MoyuTotalReport> sheet = new Sheet<MoyuTotalReport>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }
}
