package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyoServerBo;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuActBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.LinkLocation;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuAct;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuServer;
import com.xunlei.niux.manager.web.util.Constant;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 运营服务器业务逻辑类
 * @author lisu
 * 2012-11-14
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MYSERVER)
public class MoyuServerManagedBean extends BaseManagedBean {
	
	private static final Logger logger = Logger.getLogger(MoyuServerManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private int rownum = 0;
	MoyoServerBo serverBo =  null;
	
	public MoyuServerManagedBean(){
		serverBo = FacadeFactory.INSTANCE.getMoyoServerBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询运营服务器
	 * @return
	 */
	public String getQueryMoyuServerList(){
		  logger.info("开始运营服务器查询");
	        this.authenticateRun();//验证运行权限
	        MoyuServer myserver = findBean(MoyuServer.class, "myserver");
	        PagedFliper pagedFliper = this.getFliper();
	        int count = serverBo.count(myserver);
	        pagedFliper.setRecordCount(count);
	        List<MoyuServer> list = new ArrayList<MoyuServer>();
	        if (count > 0) {
	        	rownum = 1;
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("opentime", OrderType.DESC);
	            list = serverBo.find(myserver,page.getPageNo(),page.getPageSize());
	        }
	        Sheet<MoyuServer> sheet = new Sheet<MoyuServer>(count, list);
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
	/**
	 * 新增运营服务器
	 * @return
	 */
	public String add(){
		logger.info("开始运营服务器添加");
		this.authenticateAdd();//添加权限
		MoyuServer myserver=this.findBean(MoyuServer.class,"myserver");
		if(myserver==null){
			logger.info("运营服务器为空");
			alertJS("添加失败，原因：运营服务器为空");
			return "";
		}
		
		try{
			//checkGameUnique(myserver);
			myserver.setOpentime(this.checkTime(myserver.getOpentime()));	
			/**
			List clist = serverBo.executeQuery("SELECT MAX(displayorder) as mcount FROM myserver ", new ArrayList());	
			if(clist != null && clist.size() ==1){
				int priority = (Integer)clist.get(0);
				priority++;
				myserver.setDisplayorder(priority);
			}**/				
			serverBo.insert(myserver);
			alertJS("添加成功");
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改运营服务器
	 * @return
	 */
	public String edit(){
		logger.info("开始运营服务器修改");
		this.authenticateEdit();//编辑权限
		MoyuServer myserver=this.findBean(MoyuServer.class,"myserver");
		if(myserver==null){
			logger.info("运营服务器为空");
			alertJS("修改失败，原因：运营服务器为空");
			return "";
		}
		try{
			myserver.setOpentime(this.checkTime(myserver.getOpentime()));
			serverBo.update(myserver);			
			alertJS("修改成功");
		}catch(Exception e){
			logger.error("修改失败", e);
            alertJS("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 检查时间格式
	 * @param time
	 * @param type
	 * @return
	 */
	 private String checkTime(String time){

	     try{
            if(time==null||"".equals(time)){
                return "";
            }
            
            Date d=sdf.parse(time);
            return sdf.format(d);
        }catch(Exception e){
            throw new RuntimeException("开区时间格式不正确，格式：yyyy-MM-dd HH:mm:ss");
       }
   }
	 
	 /**
	     * 检验数据的唯一性
	     * @param linkinfo
	     * @return
	     */
	   private void checkGameUnique(MoyuServer myserver){
		   MoyuServer server=serverBo.findById(myserver.getServerid());				   
		   //插入验证
		   if(server!=null){
			   throw new RuntimeException("服务器id："+myserver.getServerid()+"已插入,不能重复");
		   }
		   
	   }
	   
	  
	    /**
		 * 设置显示顺序
		 * @return
		 */
		public String setDisplayorder() {		
			try {
				String seqid_priority = findParameter("seqid_displayorder");
				if (isEmpty(seqid_priority)) {
					return "";
				}
				String[] value = seqid_priority.split("_");
				long seqid = Long.parseLong(value[0]);
				long priority = Long.parseLong(value[1]);
				if (seqid <= 0 || priority < 0) {
					alertJS("优先级设置失败！");
					return "";
				}
				if(priority > Constant.RECOMMEND_IS_TOP){
					priority = Constant.RECOMMEND_IS_TOP;
				}
				String sql = "update myserver set displayorder=" + priority + " where seqid=" + seqid;		
				serverBo.execute(sql, new ArrayList());			
			} catch (Exception e) {
				e.printStackTrace();
			}
			return "";
		}
		
		
		/**
		 * 删除接口人信息
		 * @return
		 */
		public String delete(){
			logger.info("开始运营服务器删除");
			this.authenticateDel();//删除权限
			String delseqids = findParameter("delseqids");				
			try{			
				String ids[] = delseqids.split(",");
				for(String id:ids)
					serverBo.deleteById(new Long(id));			
			}catch(Exception e){
				logger.error("删除失败", e);
				alertJS("删除失败，原因：" + e.getMessage());
			}
			return "";
		}
}
