package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuDayReportBo;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuTotalReportBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuDayReport;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuTotalReport;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MOYUREPORT)
public class MoyuDayReportManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(MoyuDayReportManagedBean.class);


    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public String getQueryList(){
        logger.info("魔域每日统计查询");
        this.authenticateRun();//验证运行权限

        MoyuDayReport moyuDayReport = findBean(MoyuDayReport.class, "moyudayreport");

        if(moyuDayReport.getFromReporttime() == null) {
            moyuDayReport.setFromReporttime(DATE_FORMAT.format(DateUtil.yesterday()));
        }

        final MoyuDayReportBo moyuDayReportBo = FacadeFactory.INSTANCE.getMoyuDayReportBo();
        int count = moyuDayReportBo.count(moyuDayReport);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);


        List<MoyuDayReport> list = new ArrayList<MoyuDayReport>();
        if (count > 0) {
            Page page=new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("reporttime", OrderType.ESC);

            list = moyuDayReportBo.find(moyuDayReport, page);
        }
        Sheet<MoyuDayReport> sheet = new Sheet<MoyuDayReport>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
    }


}
