package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuActBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuAct;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 运营活动业务逻辑类
 * @author lisu
 * 2012-11-14
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MYACT)
public class MoyuActManagedBean extends BaseManagedBean {
	
	private static final Logger logger = Logger.getLogger(MoyuActManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/**
	 * 查询运营活动
	 * @return
	 */
	public String getQueryMoyuActList(){
		  logger.info("开始运营活动查询");
	        this.authenticateRun();//验证运行权限
	        MoyuAct myact = findBean(MoyuAct.class, "myact");
	        PagedFliper pagedFliper = this.getFliper();
	        MoyuActBo moyuActBo = FacadeFactory.INSTANCE.getMoyuActBo();
	        int count = moyuActBo.count(myact);
	        pagedFliper.setRecordCount(count);
	        List<MoyuAct> list = new ArrayList<MoyuAct>();
	        if (count > 0) {
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("displayorder", OrderType.ESC);
	        	page.addOrder("validdatetime", OrderType.DESC);
	            list = moyuActBo.find(myact,page.getPageNo(),page.getPageSize());
	        }
	        Sheet<MoyuAct> sheet = new Sheet<MoyuAct>(count, list);
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
	/**
	 * 新增运营活动
	 * @return
	 */
	public String add(){
		logger.info("开始运营活动添加");
		this.authenticateAdd();//添加权限
		MoyuAct myAct=this.findBean(MoyuAct.class,"myact");
		if(myAct==null){
			logger.info("运营活动为空");
			alertJS("添加失败，原因：运营活动为空");
			return "";
		}
		
		try{
			checkGameUnique(myAct);
			myAct.setValidtime(this.checkTime(myAct.getValidtime(),0));
			myAct.setInvalidtime(this.checkTime(myAct.getInvalidtime(),1));
			//myAct.setIsinvalid(false);
			FacadeFactory.INSTANCE.getMoyuActBo().insert(myAct);
			alertJS("添加成功");
		}catch(Exception e){
			logger.error("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改运营活动
	 * @return
	 */
	public String edit(){
		logger.info("开始运营活动修改");
		this.authenticateEdit();//编辑权限
		MoyuAct myAct=this.findBean(MoyuAct.class,"myact");
		if(myAct==null){
			logger.info("运营活动为空");
			alertJS("修改失败，原因：运营活动为空");
			return "";
		}
		try{
			myAct.setValidtime(this.checkTime(myAct.getValidtime(),0));
			myAct.setInvalidtime(this.checkTime(myAct.getInvalidtime(),1));
			//myAct.setIsinvalid(false);
			FacadeFactory.INSTANCE.getMoyuActBo().update(myAct);			
			alertJS("修改成功");
		}catch(Exception e){
			logger.error("修改失败", e);
            alertJS("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 检查时间格式
	 * @param time
	 * @param type
	 * @return
	 */
	 private String checkTime(String time,int type){
         String typeStr = type==0?"生效":"失效";
	     try{
            if(time==null||"".equals(time)){
                return "";
            }
            
            Date d=sdf.parse(time);
            return sdf.format(d);
        }catch(Exception e){
            throw new RuntimeException(typeStr+"时间格式不正确，格式：yyyy-MM-dd HH:mm:ss");
       }
   }
	 
	 /**
	     * 检验数据的唯一性
	     * @param linkinfo
	     * @return
	     */
	   private void checkGameUnique(MoyuAct myAct){
		   MoyuAct act=FacadeFactory.INSTANCE.getMoyuActBo().findById(myAct.getActno());		  
		   //插入验证
		   if(act!=null){
			   throw new RuntimeException("活动id："+myAct.getActno()+"已插入,不能重复");
		   }
		   
	   }
}
