package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.MessageBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Message;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;

/**
 * 常用语业务处理类
 * @author lisu
 *  2013-03-06
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MESSAGE)
public class MessageManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MessageManagedBean.class.getName());
	private MessageBo messageBo;
	private int rownum = 0;
	
	
	public MessageManagedBean(){
		messageBo = FacadeFactory.INSTANCE.getMessageBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询VIP特权消息
	 * @return
	 */
	public String getQueryMessageList(){
		logger.info("开始VIP特权消息查询");
        this.authenticateRun();//验证运行权限
        Message message = findBean(Message.class, "message");
        PagedFliper pagedFliper = this.getFliper();
        String messageType = findParameter("messageType");       
        if(messageType != null ){
        	if("".equals(messageType.trim())){
            	message.setMessageType(null);
            }else{
            	message.setMessageType(Integer.parseInt(messageType.trim()));
            }
        	
        }
        if(message.getVipGrade() != null ){
        	if(message.getVipGrade().intValue()==0)
        	message.setVipGrade(null);
        }
        if(message.getStatus() != null){
        	if(message.getStatus().intValue() == -1){
        		message.setStatus(null);
        	}
        }
        int count = messageBo.count(message);
        pagedFliper.setRecordCount(count);
        List<Message> list = new ArrayList<Message>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
        	page.addOrder("status", OrderType.ESC);
        	page.addOrder("vipGrade", OrderType.DESC);
            list = messageBo.findMessage(message,page);
        }
        Sheet<Message> sheet = new Sheet<Message>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增VIP特权消息
	 * @return
	 */
	public String add(){
		logger.info("开始VIP特权消息添加");		
		Message message = this.findBean(Message.class,"message");	
		try{
			if(message == null){
				logger.info("VIP特权消息为空");
				throw new XLRuntimeException("VIP特权消息为空");
			}		
			message.setInputBy(this.currentUserLogo());
			message.setInputTime(now());
			message.setStatus(0);
			//if(message.getMessageType()==3){//如果是发消息给指定UID用户
				
			//}

			String one_uid = message.getUid();
			message.setMessageType(1);
			if(one_uid != null && one_uid.indexOf("，")>-1){
				one_uid = one_uid.replaceAll("，", ",");
			}
			if(one_uid != null && one_uid.indexOf(",")>-1){
				String uids[] = one_uid.split(",");
				for(String uid:uids){
					if(uid == null || "".equals(uid))continue;
					message.setUid(uid);		
					UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
					Resp_getuserinfo_base userbaseinfo = getUserBaseInfo(userInfoProxy,message.getUid());
					message.setAccount(userbaseinfo.getUserAccount()==null?"":userbaseinfo.getUserAccount());
					messageBo.insert(message);
				}
			}else{
				messageBo.insert(message);
			}			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 调用远程接口查询用户基本信息
	 * @param userInfoProxy
	 * @param account
	 * @return
	 */
	public static Resp_getuserinfo_base getUserBaseInfo(UserInfoProxy userInfoProxy,String uid){
		Resp_getuserinfo_base userinfobase = userInfoProxy.getuserinfo_base(uid, (byte)2);
		return userinfobase;
	}
	
	
	/**
	 * 修改VIP特权消息
	 * @return
	 */
	public String edit(){
		logger.info("开始VIP特权消息修改");
		this.authenticateEdit();//编辑权限
		Message message = this.findBean(Message.class,"message");
		try{
			if(message == null){
				logger.info("VIP特权消息为空");
				throw new XLRuntimeException("VIP特权消息为空");
			}
			message.setEditBy(this.currentUserLogo());
			message.setEditTime(now());
			messageBo.update(message);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}	
	
}
