package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.MemberGiftBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.MemberGift;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 会员专属礼包业务处理类
 * @author lisu
 *  2013-05-20
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_MEMBERGIFT)
public class MemberGiftManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(MemberGiftManagedBean.class.getName());
	private MemberGiftBo memberGiftBo;
	private int rownum = 0;

	
	public MemberGiftManagedBean(){
		memberGiftBo = FacadeFactory.INSTANCE.getMemberGiftBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询会员专属礼包
	 * @return
	 */
	public String getQueryMemberGiftList(){
		logger.info("开始会员专属礼包查询");
        this.authenticateRun();//验证运行权限
        MemberGift mg = findBean(MemberGift.class, "membergift");
        PagedFliper pagedFliper = this.getFliper();
        int count = memberGiftBo.count(mg);
        pagedFliper.setRecordCount(count);
        List<MemberGift> list = new ArrayList<MemberGift>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
            list = memberGiftBo.find(mg,page.getPageNo(),page.getPageSize());
        }
        Sheet<MemberGift> sheet = new Sheet<MemberGift>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增会员专属礼包
	 * @return
	 */
	public String add(){
		logger.info("开始会员专属礼包添加");		
		MemberGift mg = this.findBean(MemberGift.class,"membergift");	
		try{
			if(mg==null){
				logger.info("会员专属礼包为空");
				throw new XLRuntimeException("会员专属礼包为空");
			}		
			mg.setInputBy(this.currentUserLogo());
			mg.setInputTime(now());
			memberGiftBo.insert(mg);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改会员专属礼包
	 * @return
	 */
	public String edit(){
		logger.info("开始会员专属礼包修改");
		this.authenticateEdit();//编辑权限
		MemberGift mg =this.findBean(MemberGift.class,"membergift");
		try{
			if(mg==null){
				logger.info("会员专属礼包为空");
				throw new XLRuntimeException("会员专属礼包为空");
			}			
			mg.setEditBy(this.currentUserLogo());
			mg.setEditTime(now());
			memberGiftBo.update(mg);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除会员专属礼包
	 * @return
	 */
	public String delete(){	
		logger.info("开始会员专属礼包删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				memberGiftBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}	
}
