package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.LeagueDayStat;
import com.xunlei.niux.data.league.vo.LeagueDayStatDetail;
import com.xunlei.niux.data.league.vo.LeagueMonthStat;
import com.xunlei.niux.data.league.vo.LeagueMonthStatDetail;
import com.xunlei.niux.data.league.vo.LeagueWeekStat;
import com.xunlei.niux.data.league.vo.LeagueWeekStatDetail;
import com.xunlei.niux.data.league.vo.Promoter;
import com.xunlei.niux.manager.web.util.PageUtil;

public class LeagueStatManaged extends BaseManagedBean {
	public String getQueryDayStatDetail(){
		LeagueDayStatDetail query=this.findBean(LeagueDayStatDetail.class, "leagueDayStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}

		List<LeagueDayStatDetail> list=new ArrayList<LeagueDayStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueDayStatDetail> sheet=new Sheet<LeagueDayStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryDayStatDetailFixed(){
		LeagueDayStatDetail query=this.findBean(LeagueDayStatDetail.class, "leagueDayStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		List<LeagueDayStatDetail> list=new ArrayList<LeagueDayStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueDayStatDetail> sheet=new Sheet<LeagueDayStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryMonthStatDetail(){
		LeagueMonthStatDetail query=this.findBean(LeagueMonthStatDetail.class,"leagueMonthStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}
		
		List<LeagueMonthStatDetail> list=new ArrayList<LeagueMonthStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueMonthStatDetail> sheet=new Sheet<LeagueMonthStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryMonthStatDetailFixed(){
		LeagueMonthStatDetail query=this.findBean(LeagueMonthStatDetail.class,"leagueMonthStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		List<LeagueMonthStatDetail> list=new ArrayList<LeagueMonthStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueMonthStatDetail> sheet=new Sheet<LeagueMonthStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryWeekStatDetail(){
		LeagueWeekStatDetail query=this.findBean(LeagueWeekStatDetail.class,"leagueWeekStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}
		
		List<LeagueWeekStatDetail> list=new ArrayList<LeagueWeekStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueWeekStatDetail> sheet=new Sheet<LeagueWeekStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryWeekStatDetailFixed(){
		LeagueWeekStatDetail query=this.findBean(LeagueWeekStatDetail.class,"leagueWeekStatDetail");
		String fdate=this.findParameter("fdate");
		String promoteraccount=this.findParameter("promoteraccount");
		if(fdate!=null&&!"".equals(fdate)){
			query.setFromfdate(Integer.valueOf(fdate));
			query.setTofdate(Integer.valueOf(fdate));
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		if(promoteraccount!=null&&!"".equals(promoteraccount)){
			query.setPromoteraccount(promoteraccount);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		List<LeagueWeekStatDetail> list=new ArrayList<LeagueWeekStatDetail>();
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper);
			list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueWeekStatDetail> sheet=new Sheet<LeagueWeekStatDetail>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryDayStat(){
		LeagueDayStat query=this.findBean(LeagueDayStat.class, "leaguedaystat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueDayStat> list=new ArrayList<LeagueDayStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getLeagueStatSo().finds(query, page);
		}
		Sheet<LeagueDayStat> sheet=new Sheet<LeagueDayStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryWeekStat(){
		LeagueWeekStat query=this.findBean(LeagueWeekStat.class, "leagueweekstat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueWeekStat> list=new ArrayList<LeagueWeekStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getLeagueStatSo().finds(query, page);
		}
		Sheet<LeagueWeekStat> sheet=new Sheet<LeagueWeekStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryMonthStat(){
		LeagueMonthStat query=this.findBean(LeagueMonthStat.class, "leaguemonthstat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueMonthStat> list=new ArrayList<LeagueMonthStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueMonthStat> sheet=new Sheet<LeagueMonthStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	private String getPromoterByNiuxAccount(){
		UserInfo user=this.currentUserInfo();
		String niuxaccount=user.getUserlogno();
		Promoter query=new Promoter();
		query.setNiuxaccount(niuxaccount);
		Promoter promoter=FacadeFactory.INSTANCE.getBaseSo().findObject(query);
		return promoter==null?"":promoter.getPromoterAccount();
	}
	public String getQueryDayStatFixed(){
		LeagueDayStat query=this.findBean(LeagueDayStat.class, "leaguedaystat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueDayStat> list=new ArrayList<LeagueDayStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getLeagueStatSo().finds(query, page);
		}
		Sheet<LeagueDayStat> sheet=new Sheet<LeagueDayStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryWeekStatFixed(){
		LeagueWeekStat query=this.findBean(LeagueWeekStat.class, "leagueweekstat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueWeekStat> list=new ArrayList<LeagueWeekStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getLeagueStatSo().finds(query, page);
		}
		Sheet<LeagueWeekStat> sheet=new Sheet<LeagueWeekStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String getQueryMonthStatFixed(){
		LeagueMonthStat query=this.findBean(LeagueMonthStat.class, "leaguemonthstat");
		if(query.getFdate()!=null&&query.getFdate()==0){
			query.setFdate(null);
		}
		if(query.getFromfdate()!=null&&query.getFromfdate()==0){
			query.setFromfdate(null);
		}
		if(query.getTofdate()!=null&&query.getTofdate()==0){
			query.setTofdate(null);
		}
		query.setPromoteraccount(getPromoterByNiuxAccount());
		if(query.getPromoteraccount()==null||"".equals(query.getPromoteraccount())){
			throw new RuntimeException("非法访问");
		}
		PagedFliper pagedFliper = this.getFliper();
		int count =FacadeFactory.INSTANCE.getLeagueStatSo().count(query);
		List<LeagueMonthStat> list=new ArrayList<LeagueMonthStat>();
		if(count>0){
			 Page page=PageUtil.formatPage(pagedFliper, "fdate","desc");
			 list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		Sheet<LeagueMonthStat> sheet=new Sheet<LeagueMonthStat>(count, list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
}
