package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.model.SelectItem;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.vip.JinKaTask;
import com.xunlei.niux.manager.web.util.PageUtil;

public class JinKaTaskManagedBean extends BaseManagedBean{
	public List<SelectItem> getJinKaTaskGiftList(){
		Gift query=new Gift();
		query.setIsValid(true);
		List<SelectItem> silist=new ArrayList<SelectItem>();
		List<Gift> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
		for(int i=0;i<list.size();i++){
			Gift g=list.get(i);
			if("|niuxgift|bonus|cash|".indexOf("|"+g.getGiftType()+"|")<0){
				continue;
			}
			SelectItem si=new SelectItem();
			si.setValue(g.getGiftId());
			si.setLabel(g.getGiftId()+"-"+g.getGiftName());
			silist.add(si);
		}
		return silist;
	}
	public String getQueryLevelingTasks(){
		JinKaTask query=this.findBean(JinKaTask.class, "jinKaTask");
		query.setTaskType("LEVELING");
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count==0){
			return mergePagedDataModel(count, new ArrayList<JinKaTask>());
		}
		Page page=PageUtil.formatPage(this.getFliper(),"taskDate","desc");
		List<JinKaTask> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		return mergePagedDataModel(count, list);
	}
	public String getQueryRechargeTasks(){
		JinKaTask query=this.findBean(JinKaTask.class, "jinKaTask");
		query.setTaskType("RECHARGE");
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		if(count==0){
			return mergePagedDataModel(count, new ArrayList<JinKaTask>());
		}
		Page page=PageUtil.formatPage(this.getFliper(),"taskDate","desc");
		List<JinKaTask> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		return mergePagedDataModel(count, list);
	}
	public String add(){
		JinKaTask task=this.findBean(JinKaTask.class, "jinKaTask");
		UserInfo userInfo=this.currentUserInfo();
		task.setInputBy(userInfo.getTrueName());
		task.setInputTime(sdf_time.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(task);
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	public String edit(){
		JinKaTask task=this.findBean(JinKaTask.class, "jinKaTask");
		UserInfo userInfo=this.currentUserInfo();
		task.setEditBy(userInfo.getTrueName());
		task.setEditTime(sdf_time.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(task);
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
}
