package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.businesss.IntoSystemBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.IntoSystem;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_INTOSYSTEM)
public class IntoSystemManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(IntoSystemManagedBean.class);

    private Ponit ponit1 = new Ponit();

    private Ponit ponit2 = new Ponit();

    private Ponit ponit3 = new Ponit();

    private Ponit ponit4 = new Ponit();

    private Ponit ponit5 = new Ponit();

    private Integer num = 1;

    private Boolean editStatus;

    public Boolean getEditStatus() {
        return editStatus;
    }

    public void setEditStatus(Boolean editStatus) {
        this.editStatus = editStatus;
    }

    public Integer getNum() {
        return num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Ponit getPonit1() {
        return ponit1;
    }

    public void setPonit1(Ponit ponit1) {
        this.ponit1 = ponit1;
    }

    public Ponit getPonit2() {
        return ponit2;
    }

    public void setPonit2(Ponit ponit2) {
        this.ponit2 = ponit2;
    }

    public Ponit getPonit3() {
        return ponit3;
    }

    public void setPonit3(Ponit ponit3) {
        this.ponit3 = ponit3;
    }

    public Ponit getPonit4() {
        return ponit4;
    }

    public void setPonit4(Ponit ponit4) {
        this.ponit4 = ponit4;
    }

    public Ponit getPonit5() {
        return ponit5;
    }

    public void setPonit5(Ponit ponit5) {
        this.ponit5 = ponit5;
    }

    public String getQueryList() {
        this.authenticateRun();//验证运行权限

        IntoSystem intoSystem = findBean(IntoSystem.class, "intosystem");
        if(intoSystem.getGameid() == null) {
            GamesManagedBean gamesmb = findBean(GamesManagedBean.class, "gamesmb");
            intoSystem.setGameid(gamesmb.getWebGamesList().get(0).getValue().toString());
        } else {
            String gameid = intoSystem.getGameid();
            intoSystem = new IntoSystem();
            intoSystem.setGameid(gameid);
        }

        doQueryList(intoSystem);
        return "";
    }

    public String getQueryListApp() {
        this.authenticateRun();//验证运行权限

        IntoSystem intoSystem = findBean(IntoSystem.class, "intosystem");
        if(intoSystem.getGameid() == null) {
            GamesManagedBean gamesmb = findBean(GamesManagedBean.class, "gamesmb");
            intoSystem.setGameid(gamesmb.getAllAppGamesList().get(0).getValue().toString());
        } else {
            String gameid = intoSystem.getGameid();
            intoSystem = new IntoSystem();
            intoSystem.setGameid(gameid);
        }

        doQueryList(intoSystem);
        return "";
    }

    /**
     * @param intoSystem
     */
    private void doQueryList(IntoSystem intoSystem) {
        final IntoSystemBo intoSystemBo = FacadeFactory.INSTANCE.getIntoSystemBo();
        int count = intoSystemBo.count(intoSystem);

        List<IntoSystem> outList = new ArrayList<IntoSystem>();
        IntoSystem one;
        if (count > 0) {
            List<IntoSystem> list = intoSystemBo.find(intoSystem, 0, 0);
            count = 1;
            one = list.get(0);
            IntoSystem intoSystem1 = new IntoSystem();
            intoSystem1.setGameid(one.getGameid());

            final Integer systype = one.getSystype();
            intoSystem1.setSystype(systype);

            final Boolean noregulartype = one.getNoregulartype();
            intoSystem1.setNoregulartype(noregulartype);
            if(systype.intValue()==0) {//固定分成
                intoSystem1.setDesc("分成比例:迅雷方分成" + one.getIntoratio() + "%");
            }else if(systype.intValue()==2) {//固定分成(去除渠道成本)
                intoSystem1.setDesc("分成比例:渠道成本"+one.getQudao()+"%，迅雷方分成" + one.getIntoratio() + "%");
            } else if(systype.intValue()==3) {//不固定分成(去除渠道成本)
                StringBuilder desc = new StringBuilder("不固定类型:");
                if(!noregulartype) {//按区间值
                    desc.append("按区间值 ");
                    desc.append("，渠道成本：");
                    StringBuilder sb = new StringBuilder();
                    int qudao = 0;
                    for (IntoSystem temp : list) {
                        qudao = temp.getQudao().intValue();
                        sb.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                                .append(", 迅雷方分成 : ")
                                .append("收益*(1-"+qudao+"%)*").append(temp.getIntoratio()).append("% ;");
                    }
                    desc.append(qudao).append("%").append("。").append(sb);
                } else {//按区间增量值
                    desc.append("按区间增量值 ");
                    desc.append("，渠道成本：");
                    StringBuilder sb = new StringBuilder();
                    int qudao = 0;
                    int i = 0;
                    for (IntoSystem temp : list) {
                        qudao = temp.getQudao().intValue();
                        sb.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                                .append(", 迅雷方分成 : ( 收益*(1-"+qudao+"%) - ").append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                                .append("% ")
                                .append(descNoregulartype(list, i)).append(";");
                        i++;
                    }
                    desc.append(qudao).append("%").append("。").append(sb);
                }
                intoSystem1.setDesc(desc.toString());
            } else  {//不固定分成
                StringBuilder desc = new StringBuilder("不固定类型:");
                if(!noregulartype) {
                    desc.append("按区间值 ");

                    for (IntoSystem temp : list) {
                        desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                                .append(", 迅雷方分成 : ")
                                .append(temp.getIntoratio()).append("% ;");

                    }
                } else {
                    desc.append("按区间增量值 ");

                    int i = 0;
                    for (IntoSystem temp : list) {
                        desc.append("如果 ").append(changNum(temp.getBeginmoney())).append(" < 月收益 <= ").append(temp.getEndmoney() != 0 ? changNum(temp.getEndmoney()) : "+∞")
                                .append(", 迅雷方分成 : ( 收益 - ").append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                                .append("% ")
                                .append(descNoregulartype(list, i)).append(";");

                        i++;
                    }
                }

                intoSystem1.setDesc(desc.toString());
            }

            outList.add(intoSystem1);
        }

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(count);

        Sheet<IntoSystem> sheet = new Sheet<IntoSystem>(count, outList);
        this.mergePagedDataModel(sheet, pagedFliper);
    }

    private String descNoregulartype(List<IntoSystem> list, int i) {
        StringBuilder builder = new StringBuilder(" ");

        if (i == 0) {
            return builder.toString();
        } else {
            final IntoSystem temp = list.get(i - 1);
            builder.append(" + (").append(changNum(temp.getEndmoney())).append(" - ")
                    .append(changNum(temp.getBeginmoney())).append(") * ").append(temp.getIntoratio())
                    .append("% ");

            return builder.append(descNoregulartype(list, i - 1)).toString();
        }
    }

    private long changNum(int money) {
        return money * 10000L ;
    }

    public String add() {
        return "intosystemadd";
    }

    public String addApp() {
        return "intosystemappadd";
    }

    public String addInfo() {
        String returnStr = "success";

        this.authenticateAdd();//验证运行权限

        IntoSystem intoSystem = findBean(IntoSystem.class, "intosystem");
        if (intoSystem == null) {
            logger.debug("添加内容为空");
            alertJS("添加失败，原因：添加内容为空");
            return returnStr;
        }

        if(intoSystem.getGameid() == null || "".equals(intoSystem.getGameid())) {
            alertJS("添加失败，原因：添加内容为空");
            return returnStr;
        }

        //增加记录
        try {
            final IntoSystemBo intoSystemBo = FacadeFactory.INSTANCE.getIntoSystemBo();

            IntoSystem temp = new IntoSystem();
            temp.setGameid(intoSystem.getGameid());
            List<IntoSystem> list = intoSystemBo.find(temp, 0, 0);

            UserInfo user=this.currentUserInfo();

            if(list.size() > 0) {
                if (this.editStatus) {
                    intoSystem.setEditby(user.getTrueName());
                    intoSystem.setEdittime(DateUtil.formatNowByDefault());

                    intoSystem.setInputby(list.get(0).getInputby());
                    intoSystem.setInputtime(list.get(0).getInputtime());

                    for(IntoSystem is : list) {
                        intoSystemBo.delete(is.getSeqid());
                    }

                    //记录删除的数据信息，记载到日志中
                    StringBuilder deleteListGames = new StringBuilder();
                    for(IntoSystem i : list){
                        deleteListGames.append(i.getGameid() + ",");
                    }
                    logger.info("IntoSystemManagedBean, 增加intosystem信息， gameId:"  + intoSystem.getGameid()
                            + "，删除了之前的信息：" + deleteListGames.toString() + "delete by" + this.currentUserLogo());
                } else {
                    alertJS("添加失败，原因：此款游戏已经添加过了");
                    return returnStr;
                }
            }else{
                intoSystem.setInputby(user.getTrueName());
                intoSystem.setInputtime(DateUtil.formatNowByDefault());
            }

            if(intoSystem.getSystype().intValue()==1) {//如果是非固定分成
                int size = num;

                Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
                map.put(1,ponit1);
                map.put(2,ponit2);
                map.put(3,ponit3);
                map.put(4,ponit4);
                map.put(5,ponit5);

                for (int i = 1; i <= size; i++) {
                    Ponit ponit = map.get(i);

                    intoSystem.setBeginmoney(Integer.parseInt(ponit.getBegin()));

                    if(i != size) {
                        intoSystem.setEndmoney(Integer.parseInt(ponit.getEnd()));
                    }else {
                        intoSystem.setEndmoney(null);
                    }
                    intoSystem.setIntoratio(Integer.parseInt(ponit.getPonit()));

                    intoSystemBo.insert(intoSystem);
                }

            }else  if(intoSystem.getSystype().intValue()==3) {//如果是非固定分成去除渠道成本
                int size = num;
                Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
                map.put(1,ponit1);
                map.put(2,ponit2);
                map.put(3,ponit3);
                map.put(4,ponit4);
                map.put(5,ponit5);
                for (int i = 1; i <= size; i++) {
                    Ponit ponit = map.get(i);
                    intoSystem.setBeginmoney(Integer.parseInt(ponit.getBegin()));
                    if(i != size) {
                        intoSystem.setEndmoney(Integer.parseInt(ponit.getEnd()));
                    }else {
                        intoSystem.setEndmoney(null);
                    }
                    intoSystem.setIntoratio(Integer.parseInt(ponit.getPonit()));
                    intoSystemBo.insert(intoSystem);
                }
            } else {
                intoSystemBo.insert(intoSystem);
            }

        } catch (Exception e) {
            logger.debug("添加失败", e);
            alertJS("添加失败，原因：" + e.getMessage());
            return returnStr;
        }

        if(this.editStatus) {
            alertJS("修改成功");
        } else {
            alertJS("添加成功");
        }
        return returnStr;
    }


    public String edit() {
        List<IntoSystem> list = doEdit();
        if(list == null || list.isEmpty()){
            logger.debug("编辑内容为空");
            return "";
        }
        return "intosystemadd";
    }

    public String editApp() {
        List<IntoSystem> list = doEdit();
        if(list == null || list.isEmpty()){
            logger.debug("编辑内容为空");
            return "";
        }
        return "intosystemappadd";
    }

    /**
     *
     */
    private List<IntoSystem> doEdit() {
        List<IntoSystem> list = new ArrayList<IntoSystem>();
        this.authenticateEdit();//

        IntoSystem intoSystem = findBean(IntoSystem.class, "intosystem");
        if (intoSystem == null) {
            logger.debug("编辑内容为空");
            alertJS("编辑失败，原因：编辑内容为空");
            return list;
        }

        String gameid = intoSystem.getGameid();
        if (gameid == null) {
            logger.debug("编辑内容为空");
            alertJS("编辑失败，原因：编辑内容为空");
            return list;
        }

        final IntoSystemBo intoSystemBo = FacadeFactory.INSTANCE.getIntoSystemBo();

        IntoSystem queryIs = new IntoSystem();
        queryIs.setGameid(gameid);

        list =  intoSystemBo.find(queryIs, 0, 0);
        this.num = list.size();
        if(num < 1) {
            alertJS("编辑失败，原因：编辑内容为空");
            return list;
        }

        IntoSystem one = list.get(0);
        IntoSystem show = new IntoSystem();
        show.setGameid(gameid);
        show.setIntoratio(one.getIntoratio());
        show.setQudao(one.getQudao());
        show.setSystype(one.getSystype());
        show.setNoregulartype(one.getNoregulartype());

        mergeBean(show, "intosystem");

        if(show.getSystype().intValue()==1) {//如果是非固定分成

            Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
            map.put(1,ponit1);
            map.put(2,ponit2);
            map.put(3,ponit3);
            map.put(4,ponit4);
            map.put(5,ponit5);

            for (int i = 1; i <= list.size(); i++) {
                Ponit p = map.get(i);
                IntoSystem temp = list.get(i - 1);

                p.setBegin(String.valueOf(temp.getBeginmoney()));

                if(i == list.size()) {
                    p.setEnd("∞");
                } else {
                    p.setEnd(String.valueOf(temp.getEndmoney()));
                }
                p.setPonit(String.valueOf(temp.getIntoratio()));
            }
        }else  if(show.getSystype().intValue()==3) {//如果是非固定分成去除渠道成本

            Map<Integer, Ponit> map = new HashMap<Integer, Ponit>();
            map.put(1,ponit1);
            map.put(2,ponit2);
            map.put(3,ponit3);
            map.put(4,ponit4);
            map.put(5,ponit5);

            for (int i = 1; i <= list.size(); i++) {
                Ponit p = map.get(i);
                IntoSystem temp = list.get(i - 1);

                p.setBegin(String.valueOf(temp.getBeginmoney()));

                if(i == list.size()) {
                    p.setEnd("∞");
                } else {
                    p.setEnd(String.valueOf(temp.getEndmoney()));
                }
                p.setPonit(String.valueOf(temp.getIntoratio()));
            }
        }

        editStatus = true;

        return list;
    }


    public String delete() {
        this.authenticateDel();// 添加权限

        String gameid = this.findParameter("gameid");

        if(null == gameid || "".equals(gameid)){
            alertJS("删除失败，原因:gameid为空");
            return "删除失败，原因:gameid为空";
        }

        try {
            logger.debug("=======gameid" + gameid);
            IntoSystem intoSystem = new IntoSystem();
            intoSystem.setGameid(String.valueOf(gameid));


            IntoSystemBo intoSystemBo =  FacadeFactory.INSTANCE.getIntoSystemBo();
            for(IntoSystem temp : intoSystemBo.find(intoSystem, 0, 0)) {
                intoSystemBo.delete(temp.getSeqid());
            }

            logger.info("IntoSystemManagedBean删除了intosystem信息， gameId:"  + gameid + ",deleteBy: " + this.currentUserLogo());
            alertJS("删除成功");
        } catch (Exception e) {
            logger.info("删除失败", e);
            alertJS("删除失败，原因：" + e.getMessage());
        }

        return "";
    }

    public static class Ponit {
        private String begin = "0";

        private String end = "∞";

        private String ponit = "0";

        public String getBegin() {
            return begin;
        }

        public void setBegin(String begin) {
            this.begin = begin;
        }

        public String getEnd() {
            return end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getPonit() {
            return ponit;
        }

        public void setPonit(String ponit) {
            this.ponit = ponit;
        }
    }
}
