package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.HtmlTemplate;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.niux.manager.template.builder.fenqu.FenQuBuilder;
import com.xunlei.niux.manager.template.constant.TemplateIdConstant;
import com.xunlei.niux.manager.web.proxy.GameXmlProxy;
import com.xunlei.niux.manager.web.proxy.SynchBoxNewServerAdviceProxy;
import com.xunlei.niux.manager.web.util.HttpClientUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;


@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMESSERVER)
public class GamesServerManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GamesManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private List<SelectItem> fenQuStatusList;
	private Map<String,String> fenQuStatusMap;

	/**
	 * 查询游戏信息
	 * @return
	 */
	public String getQueryGameInfoList(){
		logger.debug("开始分区查询");
		this.authenticateRun();//验证运行权限
		GameServers server=this.findBean(GameServers.class,"gameservers");
		PagedFliper pagedFliper =this.getFliper();
		GameServers gs=new GameServers();
		if(server.getGameId()==null||"".equals(server.getGameId())){
			Sheet<GameServers> sheet=Sheet.EMPTY;
			this.mergePagedDataModel(sheet, pagedFliper);
			return "";
		}
		gs.setGameId(server.getGameId());
		if(server.getFenQuNum()!=0){
			gs.setFenQuNum(server.getFenQuNum());
		}
		int count=FacadeFactory.INSTANCE.getGameServersBo().count(gs);
		pagedFliper.setRecordCount(count);
		List<GameServers> list=new ArrayList<GameServers>();
		
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "fenQuNum","desc");
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
			list=FacadeFactory.INSTANCE.getGameServersBo().find(gs,page);
		}
		Sheet<GameServers> sheet=new Sheet<GameServers>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	public String delete(){
		 this.authenticateDel();
	     String paramseqids = findParameter("delseqids");
	     String[] params = paramseqids.split(",");
	     try{
	           for(String id : params) {
	        	   FacadeFactory.INSTANCE.getGameServersBo().delete(Long.valueOf(id));
	           }
	           alertJS("删除成功!");
	       } catch (Exception e) {
	           logger.error("删除失败", e);
	           alertJS("删除失败，原因：" + e);
	       }
	       return "";
	}
	public String edit(){
		this.authenticateEdit();
		logger.debug("开始编辑游戏分区");
		GameServers server=this.findBean(GameServers.class,"gameservers");
		if(server==null){
			logger.debug("游戏分区为空");
			alertJS("编辑失败，原因：游戏分区为空");
			return "";
		}
		try{
			GameServers gserver=FacadeFactory.INSTANCE.getGameServersBo().findGameServersById(server.getSeqId());
			if(gserver==null){
				logger.debug("游戏为空");
				alertJS("编辑失败，原因：分区为空");
				return "";
			}
			server.setInputBy(gserver.getInputBy());
			server.setInputTime(gserver.getInputTime());	
			Date now =new Date();
			UserInfo user=this.currentUserInfo();
			server.setEditBy(user.getTrueName());
			server.setEditTime(sdf.format(now));
			server.setOpenTime(checkTime(server.getOpenTime()));
			FacadeFactory.INSTANCE.getGameServersBo().update(server);
			addEnterGameTemplateSchema(server.getGameId());
			//通知更新
			noticeniuxupdatecache(server.getGameId());
			synchBox(server.getGameId());//同步到盒子
			noticexmp(gserver.getGameId(),gserver.getServerId(),server.getServerId());
			Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
			alertJS("编辑成功");
			logger.debug("编辑游戏分区成功");
			return "";
		}catch(Exception e){
			logger.info("编辑失败",e);
			alertJS("编辑失败，原因："+e.getMessage());
			return "";
		}
	}
	public String add(){
		this.authenticateAdd();//添加权限
		logger.debug("开始添加游戏分区");
		GameServers server=this.findBean(GameServers.class,"gameservers");
		if(server==null){
			logger.debug("游戏分区为空");
			alertJS("添加分区失败，原因：分区为空");
			return "";
		}
		try{
			Date now =new Date();
			UserInfo user=this.currentUserInfo();
			server.setInputBy(user.getTrueName());
			server.setInputTime(sdf.format(now));
			server.setOpenTime(checkTime(server.getOpenTime()));
			FacadeFactory.INSTANCE.getGameServersBo().insert(server);
			addEnterGameTemplateSchema(server.getGameId());
			//通知更新
			noticeniuxupdatecache(server.getGameId());
			Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
			
			synchBox(server.getGameId());//同步到盒子
			alertJS("添加成功");
			logger.debug("添加游戏分区成功");
			return "";
		}catch(Exception e){
			logger.info("添加失败",e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}
	}
	public List<SelectItem> getFenQuStatusList() {
		if(fenQuStatusList==null){
			Map<String,String> map=getFenQuStatusMap();
			List<SelectItem> silist=new ArrayList<SelectItem>();
			if(map!=null){
				Set<String> keySet=map.keySet();
				Iterator<String> it=keySet.iterator();
				while(it.hasNext()){
					String key=it.next();
					String value=map.get(key);
					SelectItem si=new SelectItem();
					si.setValue(key);
					si.setLabel(value);
					silist.add(si);
				}
			}
			silist=fenQuStatusList;
		}
		return fenQuStatusList;
	}
	public void setFenQuStatusList(List<SelectItem> fenQuStatusList) {
		this.fenQuStatusList = fenQuStatusList;
	}
	public Map<String, String> getFenQuStatusMap() {
		if(fenQuStatusMap==null){
			Map<String,String> map=new HashMap<String,String>();
			map.put("0", "未开区");
			map.put("1", "已开区");
			map.put("2", "已关闭");
			map.put("3", "维护中");
			map.put("4", "测试中");
			fenQuStatusMap=map;
		}
		return fenQuStatusMap;
	}
	public void setFenQuStatusMap(Map<String, String> fenQuStatusMap) {
		this.fenQuStatusMap = fenQuStatusMap;
	}
	/**
	 * 通知牛X平台更新分区缓存
	 * @param gameId
	 */
	private void noticeniuxupdatecache(String gameId){
		try{
//			String url="http://10.1.9.143:8080/cacheupdate.do?type=2&&gameId="+gameId;
		//	String url="http://twin08a43.sandai.net:8080/cacheupdate.do?type=2&&gameId="+gameId;
			//HttpClientUtil.get(url);
			//通知模板更新
			HtmlTemplate ht=new HtmlTemplate();
			ht.setTemplateid(TemplateIdConstant.TEMPLATE_GAME_FENQU);
			ht.setExt1(gameId);
			FenQuBuilder fqb=new FenQuBuilder();
			fqb.addTeamplateSchema(ht, false);
			//FenQuBuilder
		}catch(Exception e){
			logger.error("通知失败",e);
		}
	}
	private String checkTime(String time){
		try{
			if(time==null||"".equals(time)){
				return "";
			}
			Date d=sdf.parse(time);
			return sdf.format(d);
		}catch(Exception e){
			throw new RuntimeException("时间格式不正确，格式：yyyy-MM-dd hh:mm:ss");
		}
	}
	private void addEnterGameTemplateSchema(String gameId){
		String nowStr=sdf.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000027");
		ts.setSchematime(nowStr);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
	/**
	 * 添加游戏官网执行模板
	 * @param gameId
	 */
	private void addGameOfficialTemplateSchema(String gameId){
		GameVersion gameversion=FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
		if(gameversion==null){
			return;
		}
		VersionInfo versionInfo=FacadeFactory.INSTANCE.getVersionInfoBo().find(gameversion.getVersionNo());
		if(versionInfo==null){
			return;
		}
		UserInfo user=this.currentUserInfo();//获取用户信息
		TemplateSchema templateSchema=new TemplateSchema();
		templateSchema.setTemplateid(versionInfo.getTemplateId());
		templateSchema.setIspreview(false);
		templateSchema.setExecstatus(false);
		templateSchema.setSchematime(sdf.format(new Date()));
		templateSchema.setInputtime(sdf.format(new Date()));
		templateSchema.setInputby(user.getTrueName());
		templateSchema.setExt1(gameId);
		templateSchema.setExt2(versionInfo.getColorCode());
		templateSchema.setIsexecuted(false);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
		return;
	}
	/**
	 * 获取游戏的分区列表
	 * @return
	 */
	public List<SelectItem> getGameFenQuSIList(){
		String gameId=findParameter("gameId");
		List<SelectItem> silist=new ArrayList<SelectItem>();
		if(gameId==null||"".equals(gameId)){
			return silist;
		}
		//查询游戏分区
		GameServers qgs=new GameServers();
		qgs.setGameId(gameId);
		Page page=new Page();
		page.addOrder("fenQuNum", OrderType.DESC);
		List<GameServers> gslist=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
		//将分区转化为jsf的下拉列表
		for(GameServers gs:gslist){
			SelectItem si=new SelectItem();
			si.setValue(String.valueOf(gs.getFenQuNum()));
			si.setLabel(gs.getFenQuName());
			silist.add(si);
		}
		return silist;
	}

    public List<SelectItem> getGameFenQuOpenIn7DaysSIList(){
        String gameId=findParameter("gameId");
        List<SelectItem> silist=new ArrayList<SelectItem>();
        if(gameId==null||"".equals(gameId)){
            return silist;
        }

        Calendar endCalender = Calendar.getInstance();
        endCalender.add(Calendar.DAY_OF_YEAR,-8);
        Calendar openServerCalender = Calendar.getInstance();
        //查询游戏分区
        GameServers qgs=new GameServers();
        qgs.setGameId(gameId);
        Page page=new Page();
        page.addOrder("fenQuNum", OrderType.DESC);
        List<GameServers> gslist=FacadeFactory.INSTANCE.getGameServersBo().find(qgs, page);
        //将分区转化为jsf的下拉列表
        for(GameServers gs:gslist){

            try {
                openServerCalender.setTime(sdf_time.parse(gs.getOpenTime()));
            } catch (ParseException e) {
                logger.error("Date parse Exception",e);
                continue;
            }

            if(openServerCalender.before(endCalender)){
                continue;
            }
            SelectItem si=new SelectItem();
            si.setValue(String.valueOf(gs.getFenQuNum()));
            si.setLabel(gs.getFenQuName());
            silist.add(si);
        }
        return silist;
    }
	public String changeServerStatus(){
		String gameId=findParameter("gameid");
		String fenqustatus=findParameter("fenqustatus");
		if(!("3".equals(fenqustatus)||"1".equals(fenqustatus)||"2".equals(fenqustatus))){
			return "";
		}
		String seqIds=findParameter("seqIds");
		String[] seqIdArray=seqIds.split("\\|");
		Date now =new Date();
		UserInfo user=this.currentUserInfo();
		
		for(String seqId:seqIdArray){
			if(seqId==null||"".equals(seqId)){
				continue;
			}
			GameServers gs=FacadeFactory.INSTANCE.getGameServersBo().findGameServersById(Long.valueOf(seqId));
			if(gs==null){
				continue;
			}
			if(!gs.getGameId().equals(gameId)){
				continue;
			}
			gs.setOpenStatus(fenqustatus);
			gs.setEditBy(user.getTrueName());
			gs.setEditTime(sdf.format(now));
			FacadeFactory.INSTANCE.getGameServersBo().update(gs);
		}
		addEnterGameTemplateSchema(gameId);
		addGameOfficialTemplateSchema(gameId);
		//通知更新
		noticeniuxupdatecache(gameId);
		
		try {
			Runtime.getRuntime().exec("/usr/local/htdocs/JNetPayGenXml/startup.sh");
		} catch (IOException e) {
			logger.error(e);
		}
		return "";
	}
	private void noticexmp(String gameId,String oldserverId,String newServerId){
		if(oldserverId.equals(newServerId)){
			return;
		}
		StringBuilder sb=new StringBuilder();
		sb.append("http://10.1.5.139/index.php?apiname=update_serverid&");
		sb.append("gameid=").append(gameId).append("&old_serverid=").append(oldserverId).append("&new_serverid=")
		.append(newServerId);
		try{
			String resp=HttpClientUtil.get(sb.toString());
			if(resp.contains("result=0")){
				return;
			}
			throw new Exception("gameId["+gameId+"]oldserverId["+oldserverId+"]newServerId["+newServerId+"]error resp:"+resp);
		}catch(Exception e){
			logger.error(e);
		}
	}
	
	/**
	 * 生成xml文件
	 * @return
	 */
	public String makeXml(){
		try{
			logger.info("make game and server  xml");
			GameXmlProxy.getInstance().makeXml();
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	/**
	 * 生成sql文件
	 * @return
	 */
	public String makeSql(){
		try{
			logger.info("make game and server  sql");
			GameXmlProxy.getInstance().makeSql();
		}catch(Exception e){
			logger.error(e);
		}
		return "";
	}
	
	private void synchBox(String gameId){
		SynchBoxNewServerAdviceProxy.getInstance().makeServerAndAdvice(gameId);
	}
}
