package com.xunlei.niux.manager.web.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

import com.xunlei.niux.data.vipgame.vo.CpsGames;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.template.builder.gameofficial.thread.GameTask;
import com.xunlei.niux.manager.template.builder.gameofficial.thread.ThreadPoolGame;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import com.xunlei.niux.manager.web.util.PageUtil;

/**
 * 游戏信息操作
 * @author lin
 * @date 2012-9-6
 * @Descripter:
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEINFO)
public class GamesManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(GamesManagedBean.class.getName());
	private static final SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static final SimpleDateFormat sdf1=new SimpleDateFormat("yyMMddHHmmss");
	private Map<String,String> allGamesMap;
	private Map<String,String> gameNosMap;
	private List<SelectItem> allGamesList;
	private List<SelectItem> gameNosList;
	private List<SelectItem> allGamesListForPay;
	private List<SelectItem> allGamesListSeqId;
    private List<SelectItem> allClientGamesList;
    private List<SelectItem> allWebGamesList;
    private List<SelectItem> webGamesList;//包含下线的游戏
    private List<SelectItem> allAppGamesList;
    private List<SelectItem> appGamesList;

    private static Map<Integer,String> gameFeatureMap;//游戏特征
    private static List<SelectItem> gameFeatureList;
    
    
    
    public Map<Integer, String> getGameFeatureMap() {
		if(gameFeatureMap == null){
			initGameFeatureMap();
		}
      
		return gameFeatureMap;
	}
	
	public void initGameFeatureMap(){
		   Map<Integer,String> tempMap=new HashMap<Integer,String>();	     
            List datas = LibClassM.getLibClassDList("gameFeatures");	            
            for(int i = 0; i < datas.size(); i++){
            	tempMap.put(Integer.parseInt(((LibClassD)datas.get(i)).getItemno()), ((LibClassD)datas.get(i)).getItemname());	
            }	                
	        gameFeatureMap=tempMap;
	}
	
	public List<SelectItem> getGameFeatureList(){
		if(gameFeatureList == null){
			initGameFeatureList();
		}		
		return gameFeatureList;
	}
	
	private void initGameFeatureList(){		
		 List<SelectItem> siList=new ArrayList<SelectItem>();
		 List datas = LibClassM.getLibClassDList("gameFeatures");	            
         for(int i = 0; i < datas.size(); i++){
        	 siList.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname()));	
         }	
		gameFeatureList = siList;
	}
	
	/**
	 * 查询游戏信息
	 * @return
	 */
	public String getQueryGameInfoList(){
		logger.debug("开始游戏查询");
		this.authenticateRun();//验证运行权限
		Games gameInfo=this.findBean(Games.class,"games");
		if(gameInfo!=null){
			logger.debug(gameInfo.getGameNo());
		}
		PagedFliper pagedFliper =this.getFliper();
		int count=FacadeFactory.INSTANCE.getGamesBo().count(gameInfo);
		pagedFliper.setRecordCount(count);
		List<Games> list=new ArrayList<Games>();
		
		if(count>0){
			Page page=PageUtil.formatPage(pagedFliper, "displayOrder","desc");
			page.setPageNo(pagedFliper.getPageNo());
			page.setPageSize(pagedFliper.getPageSize());
			list=FacadeFactory.INSTANCE.getGamesBo().findGames(gameInfo, page);
		}
		Sheet<Games> sheet=new Sheet<Games>(count,list);
		this.mergePagedDataModel(sheet, pagedFliper);
		return "";
	}
	
	
	public String edit(){
		this.authenticateEdit();
		Games gameInfo=this.findBean(Games.class,"games");
		if(gameInfo==null){
			logger.debug("游戏为空");
			alertJS("编辑失败，原因：游戏为空");
			return "";
		}
        if(gameInfo.getGameNo().length() > 10){
            logger.debug("游戏编号不能超过10个字符");
            alertJS("添加失败，原因：游戏编号不能超过10个字符");
            return "";
        }
		try{
			Games gi=GameCache.getInstance().getGameBySeqid(gameInfo.getSeqId());
			if(gi==null){
				logger.debug("游戏为空");
				alertJS("编辑失败，原因：游戏为空");
				return "";
			}

			gameInfo.setInputBy(gi.getInputBy());
			gameInfo.setInputTime(gi.getInputTime());	
			Date now =new Date();
			UserInfo user=this.currentUserInfo();
			gameInfo.setEditBy(user.getTrueName());
			gameInfo.setEditTime(sdf.format(now));
			if(gameInfo.getDisplayOrder()==null||"".equals(gameInfo.getDisplayOrder())){
				gameInfo.setDisplayOrder(Long.valueOf(sdf1.format(now)));
			}
			FacadeFactory.INSTANCE.getGamesBo().updateGames(gameInfo);
			//操作成功之后同步数据
			addAfterTask(gameInfo,false);
			alertJS("编辑成功");
			return "";
		}catch(Exception e){
			logger.info("编辑失败",e);
			alertJS("编辑失败，原因："+e.getMessage());
			return "";
		}
	}
	
	
	public String add(){
		this.authenticateAdd();//添加权限
		Games gameInfo=this.findBean(Games.class,"games");
		if(gameInfo==null){
			logger.debug("游戏为空");
			alertJS("添加失败，原因：游戏为空");
			return "";
		}

        if(gameInfo.getGameNo().length() > 10){
            logger.debug("游戏编号不能超过10个字符");
            alertJS("添加失败，原因：游戏编号不能超过10个字符");
            return "";
        }
		try{
			Date now =new Date();
			UserInfo user=this.currentUserInfo();
			gameInfo.setInputBy(user.getTrueName());
			gameInfo.setInputTime(sdf.format(now));
			if(gameInfo.getDisplayOrder()==null||"".equals(gameInfo.getDisplayOrder())){
				gameInfo.setDisplayOrder(Long.valueOf(sdf1.format(now)));
			}
			FacadeFactory.INSTANCE.getGamesBo().insertGames(gameInfo);
			//操作成功之后同步数据
			addAfterTask(gameInfo,true);
			alertJS("添加成功");
			return "";
		}catch(Exception e){
			logger.info("添加失败",e);
			alertJS("添加失败，原因："+e.getMessage());
			return "";
		}
	}
	private void addAfterTask(Games game,boolean isAdd){
		//同步渠道
		GameTask task = new GameTask(game,isAdd);
		ThreadPoolGame.getInstance().execute(task);
	}
	
	public Map<String, String> getAllGamesMap() {
		return GameCache.getInstance().getGameIdNameMap();
	}
	public Map<String, String> getGameNosMap() {
		return GameCache.getInstance().getGameNoNameMap();
	}
	public void setGameNosMap(Map<String, String> gameNosMap) {
		this.gameNosMap = gameNosMap;
	}
	public void setAllGamesMap(Map<String, String> allGamesMap) {
		this.allGamesMap = allGamesMap;
	}
	public List<SelectItem> getAllGamesList() {
		return GameCache.getInstance().getGameIdSelectItemList();
	}
	
	public List<SelectItem> getGameNosList() {
		return GameCache.getInstance().getGameNoSelectItemList();
	}
	
	public List<SelectItem> getAllGamesListForPay() {
		List<SelectItem> list = GameCache.getInstance().getGameIdSelectItemList();
		List<SelectItem> result = new ArrayList<SelectItem>();
		for(SelectItem item:list){
			SelectItem myitem = new SelectItem();
			if(item.getValue().toString().trim().length()==6){
				myitem.setValue(item.getValue().toString().trim().substring(1));
				myitem.setLabel(item.getLabel().toString());
			}
				
			result.add(myitem);
		}
		return result;
	}
	
	public List<SelectItem> getAllGamesListSeqId() {
		if(allGamesListSeqId==null){
			List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(new Games(), 0, 0);
			List<SelectItem> tempList=new ArrayList<SelectItem>();
			for(Games games:gamesList){	
				SelectItem si=new SelectItem();
				si.setLabel(games.getGameName());
				si.setValue(games.getSeqId());
				tempList.add(si);
			}
			allGamesListSeqId=tempList;
		}
		return allGamesListSeqId;
	}
	public Map<Long,String> getAllGamesSeqidMap(){
		return GameCache.getInstance().getGameSeqIdNameMap();
	}
	public void setAllGamesList(List<SelectItem> allGamesList) {
		this.allGamesList = allGamesList;
	}
	public void setGameNosList(List<SelectItem> gameNosList) {
		this.gameNosList = gameNosList;
	}
	public void setAllGamesListForPay(List<SelectItem> allGamesListForPay) {
		this.allGamesListForPay = allGamesListForPay;
	}
	public void setAllGamesListSeqId(List<SelectItem> allGamesListSeqId) {
		this.allGamesListSeqId = allGamesListSeqId;
	}

	 /**
	  * 所有页游游戏列表，包含微端和端游
	  * @return
	  */
	 public List<SelectItem> getAllWebGamesList() {
            Games games1 = new Games();
            Page page = new Page();
            page.addOrder("simpleName", OrderType.ESC);
            List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, page);
            List<SelectItem> tempList=new ArrayList<SelectItem>();
            for(Games games:gamesList){
                if(games.getClientType()!=null&&games.getClientType().intValue()==3)continue;//除手游之外其他的游戏
                if(!"1".equals(games.getStatus()))continue;//去掉 未接入 和  已下线 的游戏
                SelectItem si=new SelectItem();
                si.setLabel(games.getSimpleName()+"-"+games.getGameName());
                si.setValue(games.getGameId());
                tempList.add(si);
            }
            return tempList;
	 }
	 
	 /**
	  * 所有页游游戏列表，包含微端和端游
	  * @return
	  */
	 public List<SelectItem> getWebGamesList() {
            Games games1 = new Games();
            Page page = new Page();
            page.addOrder("simpleName", OrderType.ESC);
            List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, page);
            List<SelectItem> tempList=new ArrayList<SelectItem>();
            for(Games games:gamesList){
                if(games.getClientType()!=null&&games.getClientType().intValue()==3)continue;//除手游之外其他的游戏
                if("0".equals(games.getStatus()))continue;//去掉 未接入的游戏
                SelectItem si=new SelectItem();
                si.setLabel(games.getSimpleName()+"-"+games.getGameName());
                si.setValue(games.getGameId());
                tempList.add(si);
            }
	        return tempList;
	 }
	 
	
	 /**
	  * 所有手游游戏列表
	  * @return
	  */
	 public List<SelectItem> getAllAppGamesList() {
	        if(allAppGamesList==null){
	            Games games1 = new Games();
	            games1.setClientType(3);//手游
	            Page page = new Page();
	            page.addOrder("gameNo", OrderType.ESC);
	            List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, page);
	            List<SelectItem> tempList=new ArrayList<SelectItem>();
	            for(Games games:gamesList){
	                SelectItem si=new SelectItem();
	                si.setLabel(games.getSimpleName()+"-"+games.getGameName());
	                si.setValue(games.getGameId());
	                tempList.add(si);
	            }

                CpsGames cpsquery = new CpsGames();
                Page page1 = new Page();
                page.addOrder("gameNo", OrderType.ESC);
                List<CpsGames> cpsList=FacadeFactory.INSTANCE.getBaseSo().findObjects(cpsquery, page1);
                for(CpsGames cpsGame : cpsList){
                    SelectItem si=new SelectItem();
                    si.setLabel(cpsGame.getSimpleName()+"-cps-"+cpsGame.getGameName());
                    si.setValue(cpsGame.getGameId());
                    tempList.add(si);
                }

	            allAppGamesList=tempList;
	        }

	        return allAppGamesList;
	 } 
	 
	 /**
	  * 所有手游游戏列表
	  * 去掉 未接入 的游戏
	  * @return
	  */
	 public List<SelectItem> getAppGamesList() {
		 if(appGamesList==null){
			 Games games1 = new Games();
			 games1.setClientType(3);//手游
			 Page page = new Page();
			 page.addOrder("gameNo", OrderType.ESC);
			 List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, page);
			 List<SelectItem> tempList=new ArrayList<SelectItem>();
			 for(Games games:gamesList){
				 if("0".equals(games.getStatus()))continue;//去掉 未接入的游戏
				 SelectItem si=new SelectItem();
				 si.setLabel(games.getSimpleName()+"-"+games.getGameName());
				 si.setValue(games.getGameId());
				 tempList.add(si);
			 }
			 
			 CpsGames cpsquery = new CpsGames();
			 Page page1 = new Page();
			 page.addOrder("gameNo", OrderType.ESC);
			 List<CpsGames> cpsList=FacadeFactory.INSTANCE.getBaseSo().findObjects(cpsquery, page1);
			 for(CpsGames cpsGame : cpsList){
				 if(0 == cpsGame.getStatus())continue;//去掉 未接入的游戏
				 SelectItem si=new SelectItem();
				 si.setLabel(cpsGame.getSimpleName()+"-cps-"+cpsGame.getGameName());
				 si.setValue(cpsGame.getGameId());
				 tempList.add(si);
			 }
			 
			 appGamesList=tempList;
		 }
		 
		 return appGamesList;
	 } 
	 
    public List<SelectItem> getAllClientGamesList() {
        if(allClientGamesList==null){
            Games games1 = new Games();
            games1.setClientType(1);

            List<Games> gamesList=FacadeFactory.INSTANCE.getGamesBo().findGames(games1, 0, 0);
            List<SelectItem> tempList=new ArrayList<SelectItem>();
            for(Games games:gamesList){
                SelectItem si=new SelectItem();
                si.setLabel(games.getGameName());
                si.setValue(games.getGameId());
                tempList.add(si);
            }
            allClientGamesList=tempList;
        }
        return allClientGamesList;
    }

    public void setAllClientGamesList(List<SelectItem> allClientGamesList) {
        this.allClientGamesList = allClientGamesList;
    }
	
}
