package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.GamesBo;
import com.xunlei.niux.data.vipgame.bo.TemplateSchemaBo;
import com.xunlei.niux.data.vipgame.bo.version.GameVersionBo;
import com.xunlei.niux.data.vipgame.bo.version.VersionInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.data.vipgame.vo.version.GameVersion;
import com.xunlei.niux.data.vipgame.vo.version.VersionInfo;
import com.xunlei.util.StringTools;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

public class GameVersionManagedBean extends BaseManagedBean
{
    private List<SelectItem> versionSIList;
    private static Map<String, String> versionMap;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Map<String, String> getVersionMap() {
        if (versionMap != null) {
            return versionMap;
        }
        VersionInfo vi = new VersionInfo();
        vi.setIsValid(Boolean.valueOf(true));
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<VersionInfo> list = FacadeFactory.INSTANCE.getVersionInfoBo().find(vi, page);
        list = list == null ? new ArrayList() : list;
        Map result = new HashMap();
        for (VersionInfo versionInfo : list) {
            result.put(versionInfo.getVersionNo(), versionInfo.getVersionCode() + "-" + versionInfo.getVersionName() + "-" + versionInfo.getColorName());
        }
        versionMap = result;
        return result;
    }

    public List<SelectItem> getVersionSIList()
    {
        if (this.versionSIList != null) {
            return this.versionSIList;
        }
        VersionInfo vi = new VersionInfo();
        vi.setIsValid(Boolean.valueOf(true));
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<VersionInfo> list = FacadeFactory.INSTANCE.getVersionInfoBo().find(vi, page);
        list = list == null ? new ArrayList() : list;
        List siList = new ArrayList();
        for (VersionInfo versionInfo : list) {
            SelectItem si = new SelectItem();
            si.setLabel(versionInfo.getVersionCode() + "-" + versionInfo.getVersionName() + "-" + versionInfo.getColorName());
            si.setValue(versionInfo.getVersionNo());
            siList.add(si);
        }
        this.versionSIList = siList;
        return this.versionSIList;
    }

    public String getQueryGameVersionList()
    {
        GameVersion queryGameVersion = (GameVersion)findBean(GameVersion.class, "gameversion");
        PagedFliper pagedFliper = getFliper();

        Games queryGame = new Games();
        queryGame.setGameId(queryGameVersion.getGameId());
        Page page = new Page();
        page.setPageNo(pagedFliper.getPageNo());
        page.setPageSize(pagedFliper.getPageSize());
        page.addOrder("simpleName", OrderType.ESC);
        List<Games> gameList = FacadeFactory.INSTANCE.getGamesBo().findGames(queryGame, page);

        List<GameVersion> gameVersionList = FacadeFactory.INSTANCE.getGameVersionBo().find(new GameVersion(), new Page());
        Map gameVersionMap = new HashMap();
        for (GameVersion gameVersion : gameVersionList) {
            gameVersionMap.put(gameVersion.getGameId(), gameVersion.getVersionNo());
        }
        List<GameVersion> resultList = new ArrayList<GameVersion>();
        for (Games games : gameList) {
            GameVersion gameVersion = new GameVersion();
            gameVersion.setGameId(games.getGameId());
            String versionNo = (String)gameVersionMap.get(games.getGameId());
            gameVersion.setVersionNo(versionNo == null ? "" : versionNo);
            resultList.add(gameVersion);
        }
        int count = FacadeFactory.INSTANCE.getGamesBo().count(queryGame);
        Sheet sheet = new Sheet(count, resultList);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }
    public void setVersionSIList(List<SelectItem> versionSIList) {
        this.versionSIList = versionSIList;
    }

    public String addGameOfficialTemplate()
    {
        String gameId = findParameter("gameId");
        String versionNo = findParameter("versionNo");
        String isPreview = findParameter("isPreview");
        VersionInfo versionInfo = FacadeFactory.INSTANCE.getVersionInfoBo().find(versionNo);
        if (versionInfo == null) {
            return "";
        }
        UserInfo user = currentUserInfo();
        TemplateSchema templateSchema = new TemplateSchema();
        templateSchema.setTemplateid(versionInfo.getTemplateId());
        templateSchema.setIspreview(Boolean.valueOf("true".equals(isPreview)));
        templateSchema.setExecstatus(Boolean.valueOf(false));
        templateSchema.setSchematime(sdf.format(new Date()));
        templateSchema.setInputtime(sdf.format(new Date()));
        templateSchema.setInputby(user.getTrueName());
        templateSchema.setExt1(gameId);
        templateSchema.setExt2(versionInfo.getColorCode());
        templateSchema.setIsexecuted(Boolean.valueOf(false));
        FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
        return "";
    }

    public String addGameAdviceTemplate()
    {
        String gameId = findParameter("gameId");
        String versionNo = findParameter("versionNo");
        String isPreview = findParameter("isPreview");
        VersionInfo versionInfo = FacadeFactory.INSTANCE.getVersionInfoBo().find(versionNo);
        if (versionInfo == null) {
            return "";
        }
        if (StringTools.isEmpty(versionInfo.getArticleTemplateId())) return "";
        UserInfo user = currentUserInfo();
        TemplateSchema templateSchema = new TemplateSchema();
        templateSchema.setTemplateid(versionInfo.getArticleTemplateId());
        templateSchema.setIspreview(Boolean.valueOf("true".equals(isPreview)));
        templateSchema.setExecstatus(Boolean.valueOf(false));
        templateSchema.setSchematime(sdf.format(new Date()));
        templateSchema.setInputtime(sdf.format(new Date()));
        templateSchema.setInputby(user.getTrueName());
        templateSchema.setExt1(gameId);
        templateSchema.setExt2(versionInfo.getColorCode());
        templateSchema.setIsexecuted(Boolean.valueOf(false));
        FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(templateSchema);
        return "";
    }

    public String resetVersion()
    {
        String gameId = findParameter("gameId");
        String versionNo = findParameter("versionNo");

        GameVersion gameVersion = FacadeFactory.INSTANCE.getGameVersionBo().find(gameId);
        if (gameVersion == null) {
            gameVersion = new GameVersion();
            gameVersion.setGameId(gameId);
            gameVersion.setVersionNo(versionNo);
            FacadeFactory.INSTANCE.getGameVersionBo().insert(gameVersion);
        } else {
            gameVersion.setVersionNo(versionNo);
            FacadeFactory.INSTANCE.getGameVersionBo().update(gameVersion);
        }
        return "";
    }
}