package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.GameShowCategory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

public class GameShowCategoryManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(GameShowCategoryManagedBean.class.getName());
    private BaseSo baseSo;
    private int rownum = 0;
    private static final Page page = new Page();
    private static Map<String, String> gameShowCategoryMap;
    private static List<SelectItem> gameShowCategoryList;
    private UploadedFile upfile;

    public GameShowCategoryManagedBean()
    {
        this.baseSo = FacadeFactory.INSTANCE.getBaseSo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
        page.setPageNo(1);
        page.setPageSize(1);
    }

    public int getRownum() {
        return this.rownum++;
    }
    public UploadedFile getUpfile() {
        return this.upfile;
    }
    public void setUpfile(UploadedFile upfile) {
        this.upfile = upfile;
    }
    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public Map<String, String> getgameShowCategoryMap()
    {
        if (gameShowCategoryMap == null) {
            initGameShowCategoryMap();
        }
        return gameShowCategoryMap;
    }
    public String uploadFile() {
        String filename = null;
        if (this.upfile != null) {
            try {
                filename = FileUploadUtil.upLoadFile(this.upfile);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filename;
    }

    public void initGameShowCategoryMap() {
        Map tempMap = new HashMap();
        GameShowCategory query = new GameShowCategory();
        Page mypage = new Page();
        mypage.addOrder("inputTime", OrderType.DESC);
        List<GameShowCategory> bplist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, mypage);
        if (bplist != null) {
            for (GameShowCategory type : bplist) {
                tempMap.put(type.getCategoryId(), type.getCategoryName());
            }
        }
        gameShowCategoryMap = tempMap;
    }

    public List<SelectItem> getgameShowCategoryList() {
        if (gameShowCategoryList == null) {
            initGameShowCategoryList();
        }
        return gameShowCategoryList;
    }

    private List<SelectItem> getGameShowCategoryList()
    {
        String gameId = findParameter("gameId");
        LinkInfo query = new LinkInfo();
        query.setLinklocid("827");
        query.setGameid(gameId);
        List siList = new ArrayList();
        List<LinkInfo> infoList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (LinkInfo info : infoList) {
            String data = (String)gameShowCategoryMap.get(info.getExt1());
            if (data != null) {
                siList.add(new SelectItem(info.getExt1(), data));
            }
        }
        return siList;
    }

    private void initGameShowCategoryList() {
        GameShowCategory query = new GameShowCategory();
        List<GameShowCategory> bplist = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        List siList = new ArrayList();
        for (GameShowCategory type : bplist) {
            siList.add(new SelectItem(type.getCategoryId(), type.getCategoryName()));
        }
        gameShowCategoryList = siList;
    }

    public String getQueryGameShowCategoryList()
    {
        logger.info("开始展示类别查询");
        authenticateRun();
        GameShowCategory query = (GameShowCategory)findBean(GameShowCategory.class, "gameshowcategory");
        PagedFliper pagedFliper = getFliper();
        int count = this.baseSo.countObject(query);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = this.baseSo.findObjects(query, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    public String add()
    {
        logger.info("开始展示类别信息添加");
        authenticateAdd();
        GameShowCategory type = (GameShowCategory)findBean(GameShowCategory.class, "gameshowcategory");
        try {
            if (type == null) {
                logger.info("展示类别信息为空");
                throw new XLRuntimeException("展示类别信息为空");
            }
            GameShowCategory query = new GameShowCategory();
            query.setCategoryId(type.getCategoryId());
            GameShowCategory rtype = (GameShowCategory)this.baseSo.findObject(query);
            if (rtype != null) {
                logger.info("该展示类别已经存在");
                throw new XLRuntimeException("该展示类别已经存在");
            }
            type.setInputTime(now());
            type.setInputBy(currentUserLogo());
            this.baseSo.addObject(type);
            initGameShowCategoryMap();
            initGameShowCategoryList();
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String edit()
    {
        logger.info("开始展示类别信息修改");
        authenticateEdit();
        GameShowCategory type = (GameShowCategory)findBean(GameShowCategory.class, "gameshowcategory");
        try {
            if (type == null) {
                logger.info("展示类别信息为空");
                throw new XLRuntimeException("展示类别信息为空");
            }
            GameShowCategory query = new GameShowCategory();
            query.setCategoryId(type.getCategoryId());
            GameShowCategory myprice = (GameShowCategory)this.baseSo.findObject(query);
            if ((myprice != null) &&
                    (myprice.getSeqId() != type.getSeqId())) {
                logger.info("该展示类别已经存在");
                throw new XLRuntimeException("该展示类别已经存在");
            }

            type.setEditTime(now());
            type.setEditBy(currentUserLogo());
            this.baseSo.updateObjectById(type);
            initGameShowCategoryMap();
            initGameShowCategoryList();
        } catch (Exception e) {
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete()
    {
        logger.info("开始展示类别信息删除");
        authenticateDel();
        String delseqids = findParameter("delseqids");
        try {
            String[] ids = delseqids.split(",");
            for (String id : ids)
                this.baseSo.deleteById(GameShowCategory.class, id);
        }
        catch (Exception e) {
            logger.error("删除失败", e);
            mergeJsmessage("删除失败，原因：" + e.getMessage());
        }
        return "";
    }
}