package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServerStatusSwitchRecord;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;
import com.xunlei.niux.manager.web.util.PageUtil;

/**
 * 游戏信息
 * @author admin
 *
 */
public class GameServerStatusSwitchManagedBean extends BaseManagedBean{
	/**
	 * 查询游戏信息
	 * @return
	 */
	public String getQueryGameServerStatusSwitchRecordList(){
		this.authenticateRun();//验证运行权限
		GameServerStatusSwitchRecord record=this.findBean(GameServerStatusSwitchRecord.class, "gameServerStatusSwitchRecord");
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(record);
		if(count==0){
			this.mergePagedDataModel(count, new ArrayList<GameServerStatusSwitchRecord>());
			return "";
		}
		Page page=PageUtil.formatPage(this.getFliper(), "inputBy","desc");
		List<GameServerStatusSwitchRecord> list=FacadeFactory.INSTANCE.getBaseSo().findObjects(record, page);
		this.mergePagedDataModel(count, list);
		return "";
	}
	public String add(){
		this.authenticateAdd();
		UserInfo user=this.currentUserInfo();
		GameServerStatusSwitchRecord record=this.findBean(GameServerStatusSwitchRecord.class, "gameServerStatusSwitchRecord");
		record.setSwitchNo(System.currentTimeMillis()+"");
		record.setInputBy(user.getTrueName());
		record.setInputTime(sdf_time.format(new Date()));
		if("KAIQU".equals(record.getSwitchType())){
			record.setEndTime(record.getBeginTime());
		}
		FacadeFactory.INSTANCE.getBaseSo().addObject(record);
		if("KAIQU".equals(record.getSwitchType())){
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getBeginTime(),"3");
		}else{
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getBeginTime(),"1");
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getEndTime(),"2");
		}
		return "";
	}
	public String edit(){
		this.authenticateEdit();
		UserInfo user=this.currentUserInfo();
		GameServerStatusSwitchRecord record=this.findBean(GameServerStatusSwitchRecord.class, "gameServerStatusSwitchRecord");
		record.setEditBy(user.getTrueName());
		record.setEditTime(sdf_time.format(new Date()));
		if("KAIQU".equals(record.getSwitchType())){
			record.setEndTime(record.getBeginTime());
		}
		FacadeFactory.INSTANCE.getBaseSo().updateObjectById(record);
		if("KAIQU".equals(record.getSwitchType())){
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getBeginTime(),"3");
		}else{
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getBeginTime(),"1");
			addTemplateSchema(record.getSwitchNo(),record.getGameId(),record.getEndTime(),"2");
		}
		return "";
	}
	public String delete(){
		this.authenticateDel();
		String paramseqids = findParameter("delseqids");
	    String[] params = paramseqids.split(",");
	    for(int i=0;i<params.length;i++){
	    	String param=params[i];
	    	FacadeFactory.INSTANCE.getBaseSo().deleteById(GameServerStatusSwitchRecord.class, param);
	    }
	    alertJS("删除成功!");
		return "";
	}
	private void addTemplateSchema(String seqId,String gameId,String schemaTime,String direct){
		String nowStr=sdf_time.format(new Date());
    	//添加执行计划
		TemplateSchema ts=new TemplateSchema();
		ts.setTemplateid("000045");
		ts.setSchematime(schemaTime);
		ts.setIsexecuted(false);
		ts.setInputby("系统");
		ts.setInputtime(nowStr);
		ts.setIspreview(false);
		ts.setExt1(gameId);
		ts.setExt2(seqId);
		ts.setExt3(direct);
		FacadeFactory.INSTANCE.getTemplateSchemaBo().insert(ts);
	}
}
