package com.xunlei.niux.manager.web.model;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.GameCategoryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameCategory;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 通用游戏和分类关系业务处理类
 * @author lisu
 *  2013-01-10
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMECATEGORY)
public class GameCategoryManagedBean extends BaseManagedBean {

	 //官网首页游戏分类
    private Map<Integer,String> gameCategoryMap;   
    
	private static final Logger logger = Logger.getLogger(GameCategoryManagedBean.class.getName());
	private GameCategoryBo gameCategoryBo = null;	
	private int rownum = 0;
	
	public  GameCategoryManagedBean(){
		gameCategoryBo = FacadeFactory.INSTANCE.getGameCategoryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
    
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	 /**
     * 从基础数组数据中取得游戏集合
     * @return
     */
    public Map<Integer, String> getGameCategoryMap() {
    	String keyword = findParameter("keyword");
        if(gameCategoryMap==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo(keyword);
            if(list!=null){           	
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.valueOf(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            gameCategoryMap=tempMap;
        }
        return gameCategoryMap;

    }
	
	 
//	 public List<SelectItem> getGameCategoryList() {
//	        List<SelectItem> tempList = new ArrayList<SelectItem>();
//	        SelectItem sm = new SelectItem();
//	        sm.setLabel("=请选择=");
//	        sm.setValue(0);
//	        tempList.add(sm);
//	        tempList.addAll(getGameCategory());
//	        return tempList;
//	}
	 
	 /**
	  * 获得基础数组中配置的游戏信息
	  * @return
	  */
	 public List getGameCategory(){
		    //String keyword = findParameter("keyword");
	        List list = (List)getRequestAttribute("gameCategory");
	        if(list == null)
	        {
	            List datas = LibClassM.getLibClassDList("gamecategory");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("gameCategory", list);
	        }
	        return list;
	 }
	 
	 
	/**
	 * 新增游戏和分类关系
	 * @return
	 */
	public String add(){
		logger.info("开始游戏和分类关系添加");
		this.authenticateAdd();//添加权限	
		int type = findParamInt("one_type");		
		GameCategory gameCategory = this.findBean(GameCategory.class,"gamecategory");				
		try{
			if(gameCategory==null){
				logger.info("游戏和分类为空");
				throw new XLRuntimeException("游戏和分类关系为空");
			}
			String gameid = gameCategory.getGameid();
			Integer categoryid = gameCategory.getCategoryid();
			if(isExist(gameid,categoryid)){
				logger.info("该游戏与分类已经分配过，不能重复分配");
				throw new XLRuntimeException("该游戏与分类已经分配过，不能重复分配");
			}
			gameCategory.setEditby(currentUserLogo());
			gameCategory.setEdittime(now());
			gameCategory.setType(type);
			gameCategoryBo.insert(gameCategory);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改游戏和分类关系
	 * @return
	 */
	public String edit(){
		logger.info("开始游戏和分类关系修改");
		this.authenticateEdit();//编辑权限
		GameCategory gameCategory = this.findBean(GameCategory.class,"gamecategory");	
		try{
			if(gameCategory==null){
				logger.info("游戏和分类关系为空");
				throw new XLRuntimeException("游戏和分类关系为空");
			}
			String gameid = gameCategory.getGameid();
			Integer categoryid = gameCategory.getCategoryid();
			if(isExiste(gameid,categoryid,gameCategory.getSeqid())){
				logger.info("该游戏已经分配过类型，不能重复分配");
				throw new XLRuntimeException("该游戏已经分配过类型，不能重复分配");
			}
			gameCategoryBo.update(gameCategory);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 获得游戏和分类关系
	 * @return
	 */
	public String getQueryGameCategoryList(){
		logger.info("开始游戏和分类关系查询");
        this.authenticateRun();//验证运行权限
		GameCategory gameCategory = this.findBean(GameCategory.class,"gamecategory");		
		PagedFliper pagedFliper = this.getFliper();    
        int count = gameCategoryBo.count(gameCategory);    
        pagedFliper.setRecordCount(count);
        List<GameCategory> list = new ArrayList<GameCategory>();  
		 if (count > 0) {
	        	rownum = 1;
	        	Page page=new Page();
	        	page.setPageNo(pagedFliper.getPageNo());
	        	page.setPageSize(pagedFliper.getPageSize());
	        	page.addOrder("seqid", OrderType.DESC);
	            list = gameCategoryBo.find(gameCategory,page.getPageNo(),page.getPageSize());
	        } 
	        Sheet<GameCategory> sheet = new Sheet<GameCategory>(count, list);     
	        this.mergePagedDataModel(sheet, pagedFliper);
	        return "";
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExist(String gameid,Integer categoryid){
		String sql = "select count(*) from gamecategory where gameid=? and categoryid=?";		
		int count = gameCategoryBo.count(sql, new Object[]{gameid,categoryid});
		return count>0?true:false;
	}
	
	/**
	 * 查询该记录是否存在
	 * @return
	 */
	public boolean isExiste(String gameid,Integer categoryid,long seqid){
		String sql = "select count(*) from gamecategory where gameid=? and categoryid=? and seqid <> ?";		
		int count = gameCategoryBo.count(sql, new Object[]{gameid,categoryid,seqid});
		return count>0?true:false;
	}
	
	/**
	 * 删除游戏和分类关系
	 * @return
	 */
	public String delete(){
		logger.info("开始游戏和分类关系删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{			
			String ids[] = delseqids.split(",");
			for(String id:ids)
				gameCategoryBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}

	public void setGameCategoryMap(Map<Integer, String> gameCategoryMap) {
		this.gameCategoryMap = gameCategoryMap;
	}

}
