package com.xunlei.niux.manager.web.model;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.GameActivityXmlMetaBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.facade.IFacade;
import com.xunlei.niux.data.vipgame.vo.GameActivityXmlMeta;
import com.xunlei.niux.manager.web.file.XmlUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

/**
 * 活动页充值配置业务处理类
 * @author lisu
 *  2013-06-21
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_GAMEACTIVITYXML)
public class GameActivityXmlMetaManagedBean extends BaseManagedBean
{
    private static final Logger logger = Logger.getLogger(GameActivityXmlMetaManagedBean.class.getName());
    private static String BASEPATH = "/usr/local/ly_gameservers/ly_authserver/pay/";
    private static String JINZUAN_BASEPATH = "/usr/local/ly_gameservers/jinzuan/activity/";
    private static final String SYNCPICCOMMOND = "rsync_game_activity_xml_to_14332.sh";
    private static final String BACKCOMMOND = "rsync_game_activity_xml_from_14332.sh";
    private static final String JINZUAN_SYNCPICCOMMOND = "rsync_game_activity_xml_to_tw06161s1.sh";
    private static final String JINZUAN_BACKCOMMOND = "rsync_game_activity_xml_from_tw06161s1.sh";
    private GameActivityXmlMetaBo gameActivityXmlMetaBo;
    private int rownum = 0;

    public GameActivityXmlMetaManagedBean()
    {
        this.gameActivityXmlMetaBo = FacadeFactory.INSTANCE.getGameActivityXmlMetaBo();

        int pageNo = getFliper().getPageNo();
        int pageSize = getFliper().getPageSize();
        this.rownum = (this.rownum + (pageNo - 1) * pageSize + 1);
    }

    public int getRownum()
    {
        return this.rownum++;
    }

    public void setRownum(int rownum) {
        this.rownum = rownum;
    }

    public String getQueryActivityGameXmlMetaList()
    {
        logger.info("开始活动页充值配置xml查询");
        authenticateRun();
        GameActivityXmlMeta meta = (GameActivityXmlMeta)findBean(GameActivityXmlMeta.class, "gameactivityxmlmeta");
        int type = findParamInt("type");
        PagedFliper pagedFliper = getFliper();
        meta.setType(Integer.valueOf(type));
        int count = this.gameActivityXmlMetaBo.count(meta);
        pagedFliper.setRecordCount(count);
        List list = new ArrayList();
        if (count > 0) {
            this.rownum = 1;
            Page page = new Page();
            page.setPageNo(pagedFliper.getPageNo());
            page.setPageSize(pagedFliper.getPageSize());
            page.addOrder("inputTime", OrderType.DESC);
            list = this.gameActivityXmlMetaBo.find(meta, page);
        }
        Sheet sheet = new Sheet(count, list);
        mergePagedDataModel(sheet, new PagedFliper[] { pagedFliper });
        return "";
    }

    /**
     * 新增活动页充值配置xml
     * @return
     */
    public String add()
    {
        logger.info("开始活动页充值配置xml添加");
        GameActivityXmlMeta meta = (GameActivityXmlMeta)findBean(GameActivityXmlMeta.class, "gameactivityxmlmeta");
        int type = findParamInt("type2");
        try {
            if (meta == null) {
                logger.info("游戏活动页充值配置xml为空");
                throw new XLRuntimeException("游戏活动页充值配置xml为空");
            }
            meta.setType(Integer.valueOf(type));
            String callbackURL = meta.getCallbackURL();
            if (callbackURL.indexOf("&") > -1) {
                callbackURL = callbackURL.replaceAll("&", "&amp;");
            }

            String fileName = "activityConfig.xml";
            makeActivitPayXmlFile((meta.getType().intValue() == 1 ? BASEPATH : JINZUAN_BASEPATH) + fileName, meta);

            meta.setInputBy(currentUserLogo());
            meta.setInputTime(now());
            this.gameActivityXmlMetaBo.insert(meta);
        } catch (Exception e) {
            logger.error("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }
        return "";
    }

    /**
     * 生成活动页充值相关的配置文件
     * @param fileName  第一级子标签名称
     * @param gaxm 活动页实体
     * @throws Exception
     */
    private void makeActivitPayXmlFile(String fileName, GameActivityXmlMeta gaxm)
            throws Exception
    {
        String keyName = "actno";
        String keyValue = gaxm.getActno();
        String tagName = "activity";
        Map attMap = new LinkedHashMap();
        attMap.put("name", gaxm.getActname());
        attMap.put("actno", gaxm.getActno().trim());
        Map<String,String> proMap = new LinkedHashMap<String,String>();
        proMap.put("open", gaxm.getIspen().toString());
        proMap.put("callbackURL", gaxm.getCallbackURL());
        proMap.put("startTime", gaxm.getStartTime());
        proMap.put("endTime", gaxm.getEndTime());
        proMap.put("vipRebates", gaxm.getIsvipRebates().toString());
        proMap.put("notice", gaxm.getIsnotice().toString());
        proMap.put("key", gaxm.getPrivateKey());

        XmlUtil.commonOneLevelXml(fileName, tagName, keyName, keyValue, attMap, proMap);
    }

    /**
     * 修改活动页充值配置xml
     * @return
     */
    public String edit()
    {
        logger.info("开始活动页充值配置xml修改");
        authenticateEdit();
        GameActivityXmlMeta meta = (GameActivityXmlMeta)findBean(GameActivityXmlMeta.class, "gameactivityxmlmeta");
        try {
            if (meta == null) {
                logger.info("活动页充值配置xml为空");
                throw new XLRuntimeException("活动页充值配置xml为空");
            }
            String callbackURL = meta.getCallbackURL();
            if (callbackURL.indexOf("&") > -1) {
                callbackURL = callbackURL.replaceAll("&", "&amp;");
            }

            String fileName = "activityConfig.xml";
            makeActivitPayXmlFile((meta.getType().intValue() == 1 ? BASEPATH : JINZUAN_BASEPATH) + fileName, meta);

            meta.setEditBy(currentUserLogo());
            meta.setEditTime(now());
            this.gameActivityXmlMetaBo.update(meta);
        } catch (Exception e) {
            logger.error("修改失败", e);
            mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String synch()
    {
        String typeStr = findParameter("type");
        if (typeStr == null) {
            typeStr = findParameter("type2");
        }
        if (typeStr == null) return "";
        int type = Integer.parseInt(typeStr);
        System.out.println("synch type=" + type);
        System.out.println("synch type=" + type);
        System.out.println("synch type=" + type);
        System.out.println("synch type=" + type);
        System.out.println("synch type=" + type);
        synchGame();
        return "";
    }


    /**
     * 同步游戏xml
     * @throws Exception
     */
    private void synchGame()
    {
        try
        {
            String commandCmd = getCommandCmd(1);
            if (commandCmd == null) return;
            logger.info("开始同步新游接入的相关xml文件,地址:/usr/local/bin/" + commandCmd);
            Runtime.getRuntime().exec("/usr/local/bin/" + commandCmd);
            logger.info("新游接入xml同步成功！");
        } catch (IOException e) {
            logger.info(e.getMessage());
        }
    }

    public String location() {
        String typeStr = findParameter("type");
        if (typeStr == null) {
            typeStr = findParameter("type2");
        }
        if (typeStr == null) return "";
        int type = Integer.parseInt(typeStr);
        System.out.println("back type=" + type);
        System.out.println("back type=" + type);
        System.out.println("back type=" + type);
        System.out.println("back type=" + type);
        System.out.println("back type=" + type);
        back();
        return "";
    }

    public String backup() {
        String typeStr = findParameter("type");
        if (typeStr == null) {
            typeStr = findParameter("type2");
        }
        if (typeStr == null) return "";
        int type = Integer.parseInt(typeStr);
        System.out.println("copy type=" + type);
        System.out.println("copy type=" + type);
        System.out.println("copy type=" + type);
        System.out.println("copy type=" + type);
        System.out.println("copy type=" + type);
        copy();
        return "";
    }

    private String getPath() {
        int type = findParamInt("type");
        return type == 1 ? BASEPATH : JINZUAN_BASEPATH;
    }

    private String getCommandCmd(int optype)
    {
        int type = findParamInt("type");
        switch (optype) {
            case 1:
                return type == 1 ? "rsync_game_activity_xml_to_14332.sh" : "rsync_game_activity_xml_to_tw06161s1.sh";
            case 2:
                return type == 1 ? "rsync_game_activity_xml_from_14332.sh" : "rsync_game_activity_xml_from_tw06161s1.sh";
        }
        return null;
    }

    private void back()
    {
        try
        {
            String cmd = getCommandCmd(2);
            if (cmd == null) return;
            logger.info("开始拉回新游接入的相关xml文件,地址:/usr/local/bin/" + cmd);
            Runtime.getRuntime().exec("/usr/local/bin/" + cmd);
            logger.info("新游接入xml拉回成功！");
        } catch (IOException e) {
            logger.info(e.getMessage());
        }
    }

    private void copy()
    {
        try
        {
            logger.info("开始备份文件");
            File file = new File(getPath());
            if (file.isDirectory()) {
                File[] subfiles = file.listFiles();
                for (File subfile : subfiles) {
                    if (subfile.isDirectory()) {
                        File[] twofiles = subfile.listFiles();
                        for (File twofile : twofiles) {
                            if ((!twofile.isFile()) ||
                                    (twofile.getName().indexOf(".bak") != -1)) continue;
                            File newfile = new File(twofile.getAbsolutePath() + ".bak");
                            if (!newfile.exists()) {
                                newfile.createNewFile();
                            }
                            copyFile(twofile, newfile);
                        }
                    }
                    else
                    {
                        if ((!subfile.isFile()) ||
                                (subfile.getName().indexOf(".bak") != -1)) continue;
                        File newfile = new File(subfile.getAbsolutePath() + ".bak");
                        if (!newfile.exists()) {
                            newfile.createNewFile();
                        }
                        copyFile(subfile, newfile);
                    }
                }

            }

            logger.info("文件备份成功！");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(File sourceFile, File targetFile)
            throws IOException
    {
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
        try
        {
            inBuff = new BufferedInputStream(new FileInputStream(sourceFile));

            outBuff = new BufferedOutputStream(new FileOutputStream(targetFile));

            byte[] b = new byte[5120];
            int len;
            while ((len = inBuff.read(b)) != -1)
            {
                outBuff.write(b, 0, len);
            }

            outBuff.flush();
        }
        finally
        {
            if (inBuff != null)
                inBuff.close();
            if (outBuff != null)
                outBuff.close();
        }
    }
}