package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.FortuneGift;
import com.xunlei.niux.data.vipgame.vo.FortuneGiftLot;
import com.xunlei.niux.manager.web.util.PageUtil;

@FunRef("fortunegift")
public class FortuneGiftManagedBean extends BaseManagedBean {
	//查询人品奖品记录
	public String getQueryFortuneGifts(){
		FortuneGift query=this.findBean(FortuneGift.class, "fortunegift");
		String fortuneGiftId=this.findParameter("fortuneGiftId");
		if(fortuneGiftId!=null&&!"".equals(fortuneGiftId)){
			query.setFortuneGiftLotId(Long.valueOf(fortuneGiftId));
		}
		if(query.getFortuneGiftLotId()!=null&&query.getFortuneGiftLotId()==0){
			query.setFortuneGiftLotId(null);
		}
		if(query.getGiftId()!=null&&query.getGiftId()==0){
			query.setGiftId(null);
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		List<FortuneGift> giftList=new ArrayList<FortuneGift>();
		if(count>0){
			Page page=PageUtil.formatPage(this.getFliper(), "fortuneGiftLotId","desc","displaySort","asc");
			giftList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		this.mergePagedDataModel(count, giftList);
		return "";
	}
	public String getQueryFortuneGiftLots(){
		FortuneGiftLot query=this.findBean(FortuneGiftLot.class, "fortunegiftlot");
		String fortuneGiftId=this.findParameter("fortuneGiftId");
		if(fortuneGiftId!=null&&!"".equals(fortuneGiftId)){
			query.setFortuneGiftLotId(Long.valueOf(fortuneGiftId));
		}
		if(query.getFortuneGiftLotId()!=null&&query.getFortuneGiftLotId()==0){
			query.setFortuneGiftLotId(null);
		}
		int count=FacadeFactory.INSTANCE.getBaseSo().countObject(query);
		List<FortuneGiftLot> giftLotList=new ArrayList<FortuneGiftLot>();
		if(count>0){
			Page page=PageUtil.formatPage(this.getFliper(), "fortuneGiftLotId","desc");
			giftLotList=FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
		}
		this.mergePagedDataModel(count, giftLotList);
		return "";
	}
	public String editLot(){
		FortuneGiftLot fortuneGiftLot=this.findBean(FortuneGiftLot.class, "fortunegiftlot");
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(fortuneGiftLot);
		}catch(Exception e){
			logger.error("编辑fortunegift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String addLot(){
		FortuneGiftLot fortuneGiftLot=this.findBean(FortuneGiftLot.class, "fortunegiftlot");
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(fortuneGiftLot);
		}catch(Exception e){
			logger.error("编辑fortunegift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String edit(){
		FortuneGift fortuneGift=this.findBean(FortuneGift.class, "fortunegift");
		UserInfo userInfo=this.currentUserInfo();
		fortuneGift.setEditBy(userInfo.getTrueName());
		fortuneGift.setEditTime(sdf_time.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().updateObjectById(fortuneGift);
		}catch(Exception e){
			logger.error("编辑fortunegift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
	public String add(){
		FortuneGift fortuneGift=this.findBean(FortuneGift.class, "fortunegift");
		UserInfo userInfo=this.currentUserInfo();
		fortuneGift.setInputBy(userInfo.getTrueName());
		fortuneGift.setInputTime(sdf_time.format(new Date()));
		try{
			FacadeFactory.INSTANCE.getBaseSo().addObject(fortuneGift);
		}catch(Exception e){
			logger.error("编辑fortunegift失败",e);
			this.mergeJsmessage("编辑失败，原因："+e.getMessage());
		}
		return "";
	}
}
