package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.CustomerTotalBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerTotal;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;
import com.xunlei.niux.manager.web.util.ExcelUtil;

/**
 * 客户查询业务处理类
 * @author lisu
 * 2013-02-20
 */
public class CustomerTotalManagedBean extends BaseManagedBean {
    private CustomerTotalBo customerTotalBo;
    private static final Logger logger = Logger.getLogger(CustomerTotalManagedBean.class.getName());
    private int rownum = 0;
    
	public CustomerTotalManagedBean(){
		customerTotalBo =  FacadeFactory.INSTANCE.getCustomerTotalBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询客户
	 * @return
	 */
	public String getQueryCustomerTotalList(){
		logger.info("开始客户查询");
        this.authenticateRun();//验证运行权限
        String username = this.currentUserLogo();
        int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
        CustomerTotal total = findBean(CustomerTotal.class, "customertotal");
        PagedFliper pagedFliper = this.getFliper();
        Integer vipGrade = total.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		total.setVipGrade(null);
        	}
        }
        total.setCustomerVipGrade(customerVipGrade);
        int count = customerTotalBo.count(total);
        pagedFliper.setRecordCount(count);
        List<CustomerTotal> list = new ArrayList<CustomerTotal>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
        	page.addOrder("vipGrade", OrderType.ESC);
            list = customerTotalBo.find(total,page);
        }

        Sheet<CustomerTotal> sheet = new Sheet<CustomerTotal>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始客户统计导出到excel文件");
        String username = this.currentUserLogo();
        int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
    	//获得页面查询的数据
    	CustomerTotal customer = findBean(CustomerTotal.class, "customertotal");	
    	Integer vipGrade = customer.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		customer.setVipGrade(null);
        	}
        }
        customer.setCustomerVipGrade(customerVipGrade);
        Page page = new Page();
        page.addOrder("daytime", OrderType.DESC);
        page.addOrder("vipGrade", OrderType.ESC);
    	List<CustomerTotal> crlist = customerTotalBo.find(customer,page);
    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
	    if(customer.getVipGrade() != null){
	    	if(customer.getVipGrade() == 100){
	    		sb.append("汇总");
	    	}else{
	    		sb.append("等级为"+customer.getVipGrade()+"的");
	    	}
	    	
	    }else{
	    	sb.append("所有");
	    }
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"客户统计";	    
 	    
 	    List datas = new ArrayList();
 	    String[] columnName = null;
 	    if(customer.getVipGrade()==null){
 	    	for(CustomerTotal cr:crlist){
 	 	    	List list = new ArrayList();
 	 	    	list.add(cr.getDaytime());
 	 	    	list.add(cr.getVipGrade()==100?"汇总":cr.getVipGrade());
 	 	    	list.add(cr.getCustomertotal());
 	 	    	list.add(cr.getPersisttotal());
 	 	    	list.add(cr.getAddcustomertotal());
 	 	    	list.add(cr.getPromotetotal());
 	 	    	list.add(cr.getReducetotal());
 	 	    	list.add(cr.getLostcustomertotal());
 	 	    	list.add(cr.getBacktotal());
 	 	    	list.add(cr.getPaytotal());
 	 	    	list.add(cr.getAddpaytotal());
 	 	    	datas.add(list);
 	 	    }	    
 	 	    //生成数据到excel中
 			columnName = new String[]{"日期","VIP等级", "累计用户总数", "保有用户总数", "新增用户数","晋级增加用户数","晋级减少用户数","流失用户数","回流用户数","用户付费总额","新增用户付费金额"};
 	    }else{
 	    	for(CustomerTotal cr:crlist){
 	 	    	List list = new ArrayList();
 	 	    	list.add(cr.getDaytime());
 	 	    	list.add(cr.getCustomertotal());
 	 	    	list.add(cr.getPersisttotal());
 	 	    	list.add(cr.getAddcustomertotal());
 	 	    	list.add(cr.getPromotetotal());
 	 	    	list.add(cr.getReducetotal());
 	 	    	list.add(cr.getLostcustomertotal());
 	 	    	list.add(cr.getBacktotal());
 	 	    	list.add(cr.getPaytotal());
 	 	    	list.add(cr.getAddpaytotal());
 	 	    	datas.add(list);
 	 	    }	    
 	 	    //生成数据到excel中
 			columnName = new String[]{"日期", "累计用户总数", "保有用户总数", "新增用户数","晋级增加用户数","晋级减少用户数","流失用户数","回流用户数","用户付费总额","新增用户付费金额"};
 	    }
 	    
		String filePath = "/tmp/customerdetailquery.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("客户统计",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_customertotal.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
}
