package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerRole;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 客户系统角色业务处理类
 * @author lisu
 *  2013-09-12
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CUSTOMERROLE)
public class CustomerRoleManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerRoleManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	
	
	public CustomerRoleManagedBean(){
		baseBo = FacadeFactory.INSTANCE.getBaseSo();

		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询客户系统角色
	 * @return
	 */
	public String getQueryCustomerRoleList(){
		logger.info("开始客户系统角色查询");
        this.authenticateRun();//验证运行权限
        CustomerRole role = findBean(CustomerRole.class, "customerrole");
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(role);
        pagedFliper.setRecordCount(count);
        List<CustomerRole> list = new ArrayList<CustomerRole>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("vipGrade", OrderType.DESC);
            list = baseBo.findObjects(role, page);
        }
        Sheet<CustomerRole> sheet = new Sheet<CustomerRole>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增客户系统角色
	 * @return
	 */
	public String add(){
		logger.info("开始客户系统角色添加");	
		this.authenticateAdd();//新增权限
		 CustomerRole role = findBean(CustomerRole.class, "customerrole");	
		try{
			if(role==null){
				logger.info("客户系统角色为空");
				throw new XLRuntimeException("客户系统角色为空");
			}		
			CustomerRole cr = new CustomerRole();
			cr.setRoleNo(role.getRoleNo());
			CustomerRole customerRole = baseBo.findObject(cr);
			if(customerRole != null){
				throw new XLRuntimeException("编号为:"+customerRole.getRoleNo()+"已经存在，请不要重复添加");
			}
			role.setInputBy(this.currentUserLogo());
			role.setInputTime(now());
			baseBo.addObject(role);			
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 修改客户系统角色
	 * @return
	 */
	public String edit(){
		logger.info("开始客户系统角色修改");
		this.authenticateEdit();//编辑权限
		 CustomerRole role = findBean(CustomerRole.class, "customerrole");	
		try{
			if(role==null){
				logger.info("客户系统角色为空");
				throw new XLRuntimeException("客户系统角色为空");
			}	
			role.setEditBy(this.currentUserLogo());
			role.setEditTime(now());
			baseBo.updateObjectById(role);		
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除客户系统角色
	 * @return
	 */
	public String delete(){	
		logger.info("开始客户系统角色删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				baseBo.deleteById(CustomerRole.class, id);		
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
}
