package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerNewPersist;
import com.xunlei.niux.data.vipgame.vo.CustomerPersist;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.cache.GameCache;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.util.GameUtil;
import com.xunlei.niux.manager.web.vo.CustomerPayVo;

/**
 * 客户保有数分析业务处理类
 * @author lisu
 * 2013-02-22
 */
public class CustomerPersistManagedBean extends BaseManagedBean {
    private BaseSo baseSo;
    private static final Logger logger = Logger.getLogger(CustomerPersistManagedBean.class.getName());

	public CustomerPersistManagedBean(){
		baseSo =  FacadeFactory.INSTANCE.getBaseSo();
	}
	
	
	/**
	 * 查询客户保有数分析
	 * @return
	 */
	public String getQueryCustomerPersistList(){	
		logger.info("开始客户保有数分析查询");
		this.authenticateRun();//验证运行权限
		String username = this.currentUserLogo();
		int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
		CustomerNewPersist persist = findBean(CustomerNewPersist.class, "customernewpersist");
		if(customerVipGrade<=1){
			persist.setVip1(-1L);
		}
        PagedFliper pagedFliper = this.getFliper();
        int count = baseSo.countObject(persist);
        pagedFliper.setRecordCount(count);
        List<CustomerNewPersist> list = new ArrayList<CustomerNewPersist>();
        if (count > 0) {       	
        	Page page=new Page();     
           	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("daytime", OrderType.DESC);
        	page.addOrder("gameId", OrderType.ESC);
            list = baseSo.findObjects(persist, page);
        }
        Sheet<CustomerNewPersist> sheet = new Sheet<CustomerNewPersist>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 行列转换 ，默认设置vip等级有10级，从 1-10
	 * @param list
	 * @return
	 */
	private List<CustomerPayVo> changeData(List<CustomerPersist> list){
		List<CustomerPayVo> cpvlist = new ArrayList<CustomerPayVo>();
		if(list == null || list.size() == 0)return null;
		CustomerPersist cp = list.get(0);
		String daytime = cp.getDaytime();//默认时间
		CustomerPayVo vo = new CustomerPayVo();
		int i = 0;
		for(CustomerPersist persist:list){
			i++;
			String cdaytime = persist.getDaytime();//日期			
			if(daytime.equals(cdaytime)){
				switch(persist.getVipGrade()){
				   case 1:vo.setVip1Amt(persist.getPeopleCount());vo.setDaytime(cdaytime);break;
				   case 2:vo.setVip2Amt(persist.getPeopleCount());break;
				   case 3:vo.setVip3Amt(persist.getPeopleCount());break;
				   case 4:vo.setVip4Amt(persist.getPeopleCount());break;
				   case 5:vo.setVip5Amt(persist.getPeopleCount());break;
				   case 6:vo.setVip6Amt(persist.getPeopleCount());break;
				   case 7:vo.setVip7Amt(persist.getPeopleCount());break;
				   case 8:vo.setVip8Amt(persist.getPeopleCount());break;
				   case 9:vo.setVip9Amt(persist.getPeopleCount());break;
				   case 10:vo.setVip10Amt(persist.getPeopleCount());				          		           
				           break;				   
				}
			}else{	
				vo.setPayTotalAmt((vo.getVip1Amt()==null?0:vo.getVip1Amt())+(vo.getVip2Amt()==null?0:vo.getVip2Amt())+(vo.getVip3Amt()==null?0:vo.getVip3Amt())+(vo.getVip4Amt()==null?0:vo.getVip4Amt())+(vo.getVip5Amt()==null?0:vo.getVip5Amt())+(vo.getVip6Amt()==null?0:vo.getVip6Amt())+(vo.getVip7Amt()==null?0:vo.getVip7Amt())+(vo.getVip8Amt()==null?0:vo.getVip8Amt())+(vo.getVip9Amt()==null?0:vo.getVip9Amt())+(vo.getVip10Amt()==null?0:vo.getVip10Amt()));				           		
				cpvlist.add(vo);
				daytime = cdaytime;
				vo = new CustomerPayVo();
				vo.setDaytime(cdaytime);
				vo.setVip1Amt(persist.getPeopleCount());
			}
			if(i == list.size()){
				vo.setDaytime(cdaytime);
				vo.setPayTotalAmt((vo.getVip1Amt()==null?0:vo.getVip1Amt())+(vo.getVip2Amt()==null?0:vo.getVip2Amt())+(vo.getVip3Amt()==null?0:vo.getVip3Amt())+(vo.getVip4Amt()==null?0:vo.getVip4Amt())+(vo.getVip5Amt()==null?0:vo.getVip5Amt())+(vo.getVip6Amt()==null?0:vo.getVip6Amt())+(vo.getVip7Amt()==null?0:vo.getVip7Amt())+(vo.getVip8Amt()==null?0:vo.getVip8Amt())+(vo.getVip9Amt()==null?0:vo.getVip9Amt())+(vo.getVip10Amt()==null?0:vo.getVip10Amt()));				           		
				cpvlist.add(vo);
			}
		}
		return cpvlist;
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始客户付费分布导出到excel文件");
    	String username = this.currentUserLogo();
		int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
    	//获得页面查询的数据
		CustomerNewPersist customer = findBean(CustomerNewPersist.class, "customernewpersist");	
    	Page page = new Page();
        page.addOrder("daytime", OrderType.DESC);
    	page.addOrder("gameId", OrderType.ESC);
    	if(customerVipGrade<=1){
    		customer.setVip1(-1L);
    	}
    	List<CustomerNewPersist> cpvlist = baseSo.findObjects(customer, page);
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
		if(customer.getFromdaytime() != null&&!"".equals(customer.getFromdaytime())){
			if(customer.getTodaytime() != null&&!"".equals(customer.getTodaytime())){
				sb.append(customer.getFromdaytime()).append("-").append(customer.getTodaytime()).append("日");
			}else{
				sb.append(customer.getFromdaytime()).append("-").append("至今");
			}
		}else{
             if(customer.getTodaytime() != null&&!"".equals(customer.getTodaytime())){
				sb.append("截止").append(customer.getTodaytime()).append("日");
			}else{
				sb.append("所有");
			}
		}
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"客户保有数分析";	    
 	    List datas = new ArrayList();
 	    for(CustomerNewPersist cr:cpvlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getDaytime());
 	    	list.add(GameUtil.getGameName(cr.getGameId()));
 	    	list.add(cr.getPeopleCount());
 	    	list.add(cr.getVip1());
 	    	list.add(cr.getVip2());
 	    	list.add(cr.getVip3());
 	    	list.add(cr.getVip4());
 	    	list.add(cr.getVip5());
 	    	list.add(cr.getVip6());
 	    	list.add(cr.getVip7());
 	    	list.add(cr.getVip8());
 	    	list.add(cr.getVip9());
 	    	list.add(cr.getVip10());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"日期", "游戏", "保有用户总数", "VIP1保有数", "VIP2保有数","VIP3保有数","VIP4保有数","VIP5保有数","VIP6保有数","VIP7保有数","VIP8保有数","VIP9保有数","VIP10保有数"};
		String filePath = "/tmp/customerpersist.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("客户保有数分析",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_customerpersist.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
   
}
