package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerPeopleCount;



/**
 * 客户付费统计业务处理类
 * @author lisu
 *  2014-08-15
 */
public class CustomerPeopleCountManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerPeopleCountManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	
	public CustomerPeopleCountManagedBean(){ 
		baseBo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询客户付费统计
	 * @return
	 */
	public String getQueryCustomerPeopleCountList(){
		logger.info("开始客户付费统计查询");
        this.authenticateRun();//验证运行权限
        CustomerPeopleCount user = findBean(CustomerPeopleCount.class, "customerpeoplecount");
        if(user.getVipGrade()!=null&&user.getVipGrade().intValue()==0){
        	user.setVipGrade(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(user);
        pagedFliper.setRecordCount(count);
        List<CustomerPeopleCount> list = new ArrayList<CustomerPeopleCount>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("dayTime", OrderType.DESC);
        	page.addOrder("vipGrade", OrderType.ESC);
            list = baseBo.findObjects(user, page);
        }
        Sheet<CustomerPeopleCount> sheet = new Sheet<CustomerPeopleCount>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 导出到excel
	 */
	public void export(){
		
		
	}
	
}
