package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerNewUserPay;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.util.ExcelUtil;



/**
 * 新用户大额充值统计业务处理类
 * @author lisu
 *  2014-12-05
 */
public class CustomerNewUserPayManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CustomerNewUserPayManagedBean.class.getName());
	private BaseSo baseBo;
	private int rownum = 0;
	private static final Page page =  new Page();
	
	public CustomerNewUserPayManagedBean(){ 
		baseBo = FacadeFactory.INSTANCE.getBaseSo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询新用户大额充值
	 * @return
	 */
	public String getQueryCustomerNewUserPayList(){
		logger.info("开始新用户大额充值查询");
        this.authenticateRun();//验证运行权限
        CustomerNewUserPay user = findBean(CustomerNewUserPay.class, "customernewuserpay");
        if(user.getVipGrade()!=null&&user.getVipGrade().intValue()==0){
        	user.setVipGrade(null);
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = baseBo.countObject(user);
        pagedFliper.setRecordCount(count);
        List<CustomerNewUserPay> list = new ArrayList<CustomerNewUserPay>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("toTime", OrderType.DESC);
        	page.addOrder("vipGrade", OrderType.ESC);
            list = baseBo.findObjects(user, page);
        }
        Sheet<CustomerNewUserPay> sheet = new Sheet<CustomerNewUserPay>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 导出到excel
	 */
	public void export(){
	     logger.info("开始新用户大额充值导出到excel文件");   	
		 CustomerNewUserPay user = findBean(CustomerNewUserPay.class, "customernewuserpay");
	     if(user.getVipGrade()!=null&&user.getVipGrade().intValue()==0){
	     	user.setVipGrade(null);
	     }
    	List<CustomerNewUserPay> crlist = baseBo.findObjects(user, page);    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"新用户大额充值";	    
 	    Games games = new Games();
 	    Page page = new Page();
 	    List<Games> gamelist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page);
 	    List datas = new ArrayList();
 	    for(CustomerNewUserPay cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUid());
 	    	list.add(cr.getFromTime());
 	    	list.add(cr.getToTime());
 	    	list.add(cr.getVipGrade());
 	    	list.add(cr.getCustomerService());
 	    	list.add(cr.getCallCount());
 	    	list.add(cr.getLastCaller());
 	    	list.add(cr.getPayAmt());
 	    	list.add(cr.getSaleAmt());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"UID", "开始日期", "结束日期", "vip等级","专属客服","外呼次数","最后外呼人","累计充值金额","累计销售金额"};
		String filePath = "/tmp/customernewuserpay.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("新用户大额充值",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_customernewuserpay.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	  
		
	}
	
}
