package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CustomerGradeBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;

/**
 * 充值金额档设置业务处理类
 * @author lisu
 * 2012-11-21
 */
public class CustomerGradeManagedBean extends BaseManagedBean {
    private CustomerGradeBo customerGradeBo;
    private static final Logger logger = Logger.getLogger(CustomerGradeManagedBean.class.getName());
 
	public CustomerGradeManagedBean(){
		customerGradeBo =  FacadeFactory.INSTANCE.getCustomerGradeBo();
	}

	
	/**
	 * 查询客户金额等级
	 * @return
	 */
	public String getQueryCustomerGradeList(){
		logger.info("开始客户金额等级查询");
        this.authenticateRun();//验证运行权限
        CustomerGrade grade = findBean(CustomerGrade.class, "customergrade");
        PagedFliper pagedFliper = this.getFliper();
        int count = customerGradeBo.count(grade);
        pagedFliper.setRecordCount(count);
        List<CustomerGrade> list = new ArrayList<CustomerGrade>();
        if (count > 0) {
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("vipGrade", OrderType.ESC);
            list = customerGradeBo.find(grade,page);
        }
        for(CustomerGrade bcg:list){
        	if(bcg.getAmountTo() < 1000000){
        		bcg.setEditBy(bcg.getAmountFrom()+"-"+bcg.getAmountTo());
        	}else{
        		bcg.setEditBy(bcg.getAmountFrom()+"+");
        	}
        	
        }
        Sheet<CustomerGrade> sheet = new Sheet<CustomerGrade>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	  * 获得客户金额等级下拉列表
	  * @return
	  */
	 public List getCustomerGradeCollection(){		
	        List list = (List)getRequestAttribute("customerGradeList");
	        if(list == null){
	        	List<CustomerGrade> datas = customerGradeBo.findCustomerGradeList();
	            list = new ArrayList(datas.size());
	            String username = this.currentUserLogo();
	            int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
	            for(int i = 0; i < datas.size(); i++){
	            	CustomerGrade customer = datas.get(i);
	            	int vipGrade = customer.getVipGrade();
	            	if(vipGrade <= customerVipGrade)
	            	    list.add(new SelectItem(customer.getVipGrade(), "VIP"+customer.getVipGrade())); 	
	            }	                
	            setRequestAttribute("customerGradeList", list);
	        }
	        return list;
	 }
	
	/**
	 * 新增客户金额等级
	 * @return
	 */
	public void add(){
		logger.info("开始客户金额等级添加");
		this.authenticateAdd();//添加权限	
		try{
		    CustomerGrade grade = findBean(CustomerGrade.class, "customergrade");				
			if(grade==null){
				logger.info("客户金额等级为空");
				throw new XLRuntimeException("客户金额等级为空");
			}
			
			//限制充值金额档不能重复
			String disSql = "select count(*) from customergrade where vipgrade=?";
			int discount = customerGradeBo.queryForInt(disSql, new Object[]{grade.getVipGrade()});
			if(discount > 0){
				logger.info("金额等级:"+grade.getVipGrade()+" 已存在");
				throw new XLRuntimeException("金额等级:"+grade.getVipGrade()+" 已存在");
			}
			grade.setInputBy(currentUserLogo());
			grade.setInputTime(now());
			customerGradeBo.insert(grade);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 修改客户金额等级
	 * @return
	 */
	public String edit(){
		logger.info("开始客户金额等级修改");
		this.authenticateEdit();//编辑权限
		CustomerGrade grade = findBean(CustomerGrade.class, "customergrade");
		try{
			if(grade==null){
				logger.info("客户金额等级为空");
				throw new XLRuntimeException("客户金额等级为空");
			}		
			
			//限制充值金额档不能重复
			String sql = "select count(1) from customergrade where vipgrade=? and seqid<>?";
			int count = customerGradeBo.queryForInt(sql, new Object[]{grade.getVipGrade(),grade.getSeqId()});
			if(count > 0){
				logger.info("金额等级:"+grade.getVipGrade()+" 已存在");
				throw new XLRuntimeException("金额等级:"+grade.getVipGrade()+" 已存在");
			}
			grade.setEditBy(this.currentUserLogo());
			grade.setEditTime(now());
			customerGradeBo.update(grade);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除大客户金额等级
	 * @return
	 */
	public String delete(){	
		logger.info("开始客户金额等级删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				customerGradeBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
