package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.CustomerBigPayQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerBigPayQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.proxy.CustomerUserProxy;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;

/**
 * 大额充值查询业务处理类
 * @author lisu
 * 2013-02-20
 */
public class CustomerBigPayQueryManagedBean extends BaseManagedBean {
    private CustomerBigPayQueryBo customerBigPayQueryBo;
    private static final Logger logger = Logger.getLogger(CustomerBigPayQueryManagedBean.class.getName());
    private int rownum = 0;
    
	public CustomerBigPayQueryManagedBean(){
		customerBigPayQueryBo =  FacadeFactory.INSTANCE.getCustomerBigPayQueryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询大额客户
	 * @return
	 */
	public String getQueryCustomerBigPayQueryList(){	
		logger.info("===开始大额充值客户查询===");
		this.authenticateRun();//验证运行权限
		String username = this.currentUserLogo();
		int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);
        CustomerBigPayQuery customer = findBean(CustomerBigPayQuery.class, "customerbigpayquery");  
        String phone = findParameter("phone");
        String contactNumber = findParameter("contactNumber");
        Integer vipGrade = customer.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		customer.setVipGrade(null);
        	}
        }
        String bigPayAmt = findParameter("bigPayAmt");
        System.out.println("payTotalAmt:"+bigPayAmt);		
        System.out.println("payTotalAmt:"+bigPayAmt);	
        System.out.println("payTotalAmt:"+bigPayAmt);	
        StringBuffer sb = new StringBuffer();
        sb.append("select count(*) from customerbigpayquery where 1 = 1");
        sb.append(" and   vipGrade <=").append(customerVipGrade);
        if(customer.getUid() != null && !"".equals(customer.getUid())){
        	sb.append(" and uid = "+customer.getUid());
        }
        if(!StringTools.isEmpty(bigPayAmt)){
        	sb.append(" and bigPayAmt >= "+bigPayAmt);
        }
        if(customer.getFromdaytime() != null && !"".equals(customer.getFromdaytime())){
        	sb.append(" and daytime >= '"+customer.getFromdaytime()+"'");
        }        
        if(customer.getTodaytime() != null && !"".equals(customer.getTodaytime())){
        	sb.append(" and daytime < '"+customer.getTodaytime()+"'");
        }
        if(vipGrade !=null && !"".equals(vipGrade)){
        	if(vipGrade.intValue() != 0)
        	   sb.append(" and vipGrade="+vipGrade);
        }  
        if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	sb.append(" and phone <> ''");
            }else{
            	sb.append(" and phone = ''");
            }
        }        
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	sb.append(" and contactNumber <> ''");
            }else{
            	sb.append(" and contactNumber = ''");
            }
        }    
        if(customer.getGameId() != null && !"".equals(customer.getGameId())){//如果选择了游戏
        	sb.append("  and gameId = '"+customer.getGameId()+"'");
        }
        System.out.println("sb:"+sb);
        PagedFliper pagedFliper = this.getFliper();      
        int count = customerBigPayQueryBo.count(sb.toString(), null);      
        System.out.println("count:"+count);
        pagedFliper.setRecordCount(count);
        List<CustomerBigPayQuery> list = new ArrayList<CustomerBigPayQuery>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	if(pagedFliper.isNotEmptySortColumn()){ 
        		String str[] = pagedFliper.getSortColumn().split(" ");
        		if(!"daytime".equals(str[0].trim())){
        			page.addOrder("daytime", OrderType.DESC);
        		}
        		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
        	}else{
        		page.addOrder("daytime", OrderType.DESC);
        		page.addOrder("vipGrade", OrderType.DESC);
        	}
        	StringBuffer sqlsb = new StringBuffer();
        	sqlsb.append(" and  vipGrade <=").append(customerVipGrade);
        	if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
                if("1".equals(phone.trim())){//如果选择的是有安全手机的
                	sqlsb.append(" and phone <> ''");
                }else{
                	sqlsb.append(" and phone = ''");
                }
            }        
            if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
                if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
                	sqlsb.append(" and contactNumber <> ''");
                }else{
                	sqlsb.append(" and contactNumber = ''");
                }
            }      
            if(!StringTools.isEmpty(bigPayAmt)){
            	sqlsb.append(" and bigPayAmt >= "+bigPayAmt);
            }
            list = customerBigPayQueryBo.find(customer, sqlsb.toString(), page);
        }

        Sheet<CustomerBigPayQuery> sheet = new Sheet<CustomerBigPayQuery>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	 /**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始客户查询导出到excel文件");
    	String username = this.currentUserLogo();
		int customerVipGrade = CustomerUserProxy.getInstance().getVipGrade(username);

    	//获得页面查询的数据
    	CustomerBigPayQuery customer = findBean(CustomerBigPayQuery.class, "customerbigpayquery");	
    	Integer vipGrade = customer.getVipGrade();
        if(vipGrade != null){
        	if(vipGrade.intValue() == 0){
        		customer.setVipGrade(null);
        	}
        }
        String phone = findParameter("phone");
        String contactNumber = findParameter("contactNumber");
        String bigPayAmt = findParameter("bigPayAmt");
        PagedFliper pagedFliper = this.getFliper();
        Page page = new Page();
        if(pagedFliper.isNotEmptySortColumn()){ 
    		String str[] = pagedFliper.getSortColumn().split(" ");
    		if(!"daytime".equals(str[0].trim())){
    			page.addOrder("daytime", OrderType.DESC);
    		}
    		page.addOrder(str[0].trim(), str[1].trim().equals("asc")?OrderType.ESC:OrderType.DESC);
    	}else{
    		page.addOrder("daytime", OrderType.DESC);
    		page.addOrder("vipGrade", OrderType.DESC);
    	}
    	StringBuffer sqlsb = new StringBuffer();
    	sqlsb.append(" and  vipGrade <=").append(customerVipGrade);
    	if(phone != null && !"".equals(phone) && !"-1".equals(phone.trim())){
            if("1".equals(phone.trim())){//如果选择的是有安全手机的
            	sqlsb.append(" and phone <> ''");
            }else{
            	sqlsb.append(" and phone = ''");
            }
        }        
        if(!StringTools.isEmpty(bigPayAmt)){
        	sqlsb.append(" and bigPayAmt >= "+bigPayAmt);
        }
        if(contactNumber != null && !"".equals(contactNumber) && !"-1".equals(contactNumber.trim())){
            if("1".equals(contactNumber.trim())){//如果选择的是有安全手机的
            	sqlsb.append(" and contactNumber <> ''");
            }else{
            	sqlsb.append(" and contactNumber = ''");
            }
        }        
    	List<CustomerBigPayQuery> crlist = customerBigPayQueryBo.find(customer, sqlsb.toString(), page);
    	   	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
	    if(customer.getVipGrade() != null){
	    	sb.append("等级为"+customer.getVipGrade()+"的");
	    }else{
	    	sb.append("所有");
	    }
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"大额充值客户";	    
 	    List datas = new ArrayList();
 	    Games games = new Games();
	    Page page2 = new Page();
	    List<Games> gamelist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page2);
 	    for(CustomerBigPayQuery cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUid());
 	    	list.add(cr.getAccount());
 	    	list.add(cr.getVipGrade());
 	    	list.add(cr.getVipStatus()==1?"保有":"流失");
 	    	list.add(cr.getGameCount());
 	    	list.add(cr.getPayCount());
 	    	list.add(cr.getPayTotalAmt());
 	    	list.add(cr.getLastPayTime());
 	    	list.add(cr.getLastLoginTime());
 	    	list.add(cr.getCallCount());
 	    	list.add(cr.getIntegral());
 	    	list.add(cr.getBigPayAmt());
 	    	list.add(getGameName(cr.getGameId(),gamelist));
 	    	list.add(cr.getServerIds());
 	    	list.add(cr.getPhone());
 	    	list.add(cr.getContactNumber());
 	    	list.add(cr.getQq());
 	    	list.add(cr.getEmail());
 	    	list.add(cr.getLastCaller());
 	    	list.add(cr.getLastCallTime());
 	    	list.add(cr.getCustomerService());
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"UID", "迅雷账号", "VIP等级", "VIP状态","激活游戏数","充值游戏数","付费总金额","最后充值时间","最后登录时间","外呼次数","平台总积分","大额充值","充值游戏","充值区服","安全手机号","联系电话","QQ","邮箱","最后外呼人","最后外呼时间","专属客服"};
		String filePath = "/tmp/customerbigpayquery.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("大额充值客户",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_customerbigpaydata.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    /**
     * 根据游戏id查询游戏名称
     * @param gameId
     * @param gameList
     * @return
     */
    private String getGameName(String gameId,List<Games> gameList){
    	if(gameId == null||gameList==null)return "";
    	for(Games games:gameList){
    		if(games.getGameId().trim().equals(gameId.trim())){
    			return games.getGameName();
    		}
    	}
    	return "";
    }
}
