package com.xunlei.niux.manager.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.niux.data.vipgame.bo.businesss.CorporationInfoBo;
import com.xunlei.niux.data.vipgame.bo.businesss.ResponsiblePeopleBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.business.CorporationInfo;
import com.xunlei.niux.data.vipgame.vo.business.ResponsiblePeople;
import com.xunlei.niux.manager.web.util.DateUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CORPORATIONINFO)
public class CorporationDetailManagedBean extends BaseManagedBean {

    private static final Logger logger = Logger.getLogger(CorporationDetailManagedBean.class);


    public String getQueryDetail() {
        this.authenticateRun();//验证运行权限

        String productno = findParameter("productno");
        if (productno == null) {
            throw new RuntimeException("缺少参数productno");
        }

        CorporationInfo corporationInfo = FacadeFactory.INSTANCE.getCorporationInfoBo().findById(productno);
        if (corporationInfo == null) {
            throw new RuntimeException("错误的productno:" + productno);
        }


        mergeBean(corporationInfo);

        PagedFliper pagedFliper = this.getFliper();
        pagedFliper.setRecordCount(1);

        List<CorporationInfo> list = new ArrayList<CorporationInfo>();
        list.add(corporationInfo);

        Sheet<CorporationInfo> sheet = new Sheet<CorporationInfo>(1, list);
        this.mergePagedDataModel(sheet, pagedFliper);

        PagedFliper pagedFliper2 = this.getFliper();
        pagedFliper2.setRecordCount(1);
        pagedFliper2.setIndex(2);
        this.mergePagedDataModel(sheet, pagedFliper2);

        ResponsiblePeopleBo peopleBo = FacadeFactory.INSTANCE.getResponsiblePeopleBo();
        ResponsiblePeople people = new ResponsiblePeople();
        people.setProductno(productno);

        PagedFliper pagedFliper3 = this.getFliper();
        int count = peopleBo.count(people);
        pagedFliper3.setRecordCount(count);
        pagedFliper3.setIndex(3);


        List<ResponsiblePeople> peopleList = new ArrayList<ResponsiblePeople>();
        if (count > 0) {
            peopleList = peopleBo.find(people,
                    pagedFliper3.getPageNo(), pagedFliper3.getPageSize());
        }
        Sheet<ResponsiblePeople> sheet3 = new Sheet<ResponsiblePeople>(count, peopleList);
        this.mergePagedDataModel(sheet3, pagedFliper3);

        return "";
    }

    /**
     * 合作公司修改
     *
     * @return
     */
    public String cpEdit() {
        this.authenticateRun();

        CorporationInfo corporationInfo = findBean(CorporationInfo.class, "corporationinfo");
        if (corporationInfo == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            String productno = corporationInfo.getProductno();
            CorporationInfoBo corporationInfoBo = FacadeFactory.INSTANCE.getCorporationInfoBo();
            CorporationInfo temp = corporationInfoBo.findById(productno);
            if (corporationInfo == null) {
                throw new RuntimeException("错误的productno:" + productno);
            }


            temp.setShortcompany(corporationInfo.getShortcompany());
            temp.setCompanyaddress(corporationInfo.getCompanyaddress());
            temp.setPostcode(corporationInfo.getPostcode());

            UserInfo user=this.currentUserInfo();
            temp.setEditby(user.getTrueName());
            temp.setEdittime(DateUtil.formatNowByDefault());

            corporationInfoBo.update(temp);
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }


        return "";
    }

    /**
     * 结算方式说明
     *
     * @return
     */
    public String bankEdit() {
        this.authenticateRun();

        CorporationInfo corporationInfo = findBean(CorporationInfo.class, "corporationinfo");
        if (corporationInfo == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }

        try {
            String productno = corporationInfo.getProductno();
            CorporationInfoBo corporationInfoBo = FacadeFactory.INSTANCE.getCorporationInfoBo();
            CorporationInfo temp = corporationInfoBo.findById(productno);
            if (corporationInfo == null) {
                throw new RuntimeException("错误的productno:" + productno);
            }


            temp.setBankaccount(corporationInfo.getBankaccount());
            temp.setBankname(corporationInfo.getBankname());
            temp.setBalancedesc(corporationInfo.getBalancedesc());
            temp.setTestaccount(corporationInfo.getTestaccount());

            UserInfo user=this.currentUserInfo();
            temp.setEditby(user.getTrueName());
            temp.setEdittime(DateUtil.formatNowByDefault());

            corporationInfoBo.update(temp);
        } catch (Exception e) {
            logger.error("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }


        return "";
    }


    public String addPeopel() {
        this.authenticateAdd();//添加权限

        ResponsiblePeople people = findBean(ResponsiblePeople.class, "responsiblepeople");
        if (people == null) {
            logger.debug("添加内容为空");
            mergeJsmessage("添加失败，原因：编辑内容为空");
            return "";
        }

        try {
            final ResponsiblePeopleBo peopleBo = FacadeFactory.INSTANCE.getResponsiblePeopleBo();



            UserInfo user=this.currentUserInfo();
            people.setInputby(user.getTrueName());
            people.setInputtime(DateUtil.formatNowByDefault());


            peopleBo.insert(people);
        } catch (Exception e) {
            logger.debug("添加失败", e);
            mergeJsmessage("添加失败，原因：" + e.getMessage());
        }

        return "";
    }

    public String editPeople() {
        this.authenticateEdit();

        ResponsiblePeople people = findBean(ResponsiblePeople.class, "responsiblepeople");
        if (people == null) {
            logger.debug("编辑内容为空");
            mergeJsmessage("编辑失败，原因：编辑内容为空");
            return "";
        }


        try {
            final ResponsiblePeopleBo peopleBo = FacadeFactory.INSTANCE.getResponsiblePeopleBo();
            ResponsiblePeople temp = peopleBo.findById(people.getSeqid());
            if (temp == null) {
                logger.debug("编辑内容为空");
                mergeJsmessage("编辑失败，原因：编辑内容为空");
                return "";
            }



            UserInfo user=this.currentUserInfo();
            people.setInputby(temp.getInputby());
            people.setInputtime(temp.getInputtime());
            people.setEditby(user.getTrueName());
            people.setEdittime(DateUtil.formatNowByDefault());


            peopleBo.update(people);
        } catch (Exception e) {
            logger.debug("编辑失败", e);
            mergeJsmessage("编辑失败，原因：" + e.getMessage());
        }

        return "";
    }

    public String delete() {
        this.authenticateDel();// 添加权限

        long seqids[] = this.findParamSeqids();

        try {
            for (Long seqId : seqids) {
                logger.debug("=======seqId" + seqId);
                FacadeFactory.INSTANCE.getResponsiblePeopleBo().delete(seqId.intValue());
            }

            alertJS("删除成功");
        } catch (Exception e) {
            logger.info("删除失败", e);
            alertJS("删除失败，原因：" + e.getMessage());
        }

        return "";
    }
}
