package com.xunlei.niux.manager.web.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.myfaces.custom.fileupload.UploadedFile;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.CheckUserBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CheckUser;
import com.xunlei.niux.manager.web.util.FileUploadUtil;
import com.xunlei.niux.manager.web.util.NiUxFunctionConstant;

/**
 * 美女直播间检查用户业务处理类
 * @author lisu
 *  2013-06-06
 */
@FunRef(NiUxFunctionConstant.NIUX_FUNCTION_CHECKUSER)
public class CheckUserManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CheckUserManagedBean.class.getName());
	private static final String FILEPATH = IFacadeCommon.INSTANCE.getLibconfigValueByConfigNo("uploadPicStorePath");//文件上传路径
	private CheckUserBo checkUserBo;
	private int rownum = 0;	
	private UploadedFile upfile;
	
	public UploadedFile getUpfile() {
		return upfile;
	}
	public void setUpfile(UploadedFile upfile) {
		this.upfile = upfile;
	}
	
	public CheckUserManagedBean(){
		checkUserBo = FacadeFactory.INSTANCE.getCheckUserBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	/**
	 * 查询美女直播间检查用户 
	 * @return
	 */
	public String getQueryCheckUserList(){
		logger.info("开始自动发放奖品总数量查询");
        this.authenticateRun();//验证运行权限
        CheckUser user = findBean(CheckUser.class, "checkuser");
        PagedFliper pagedFliper = this.getFliper();
        int count = checkUserBo.count(user);
        pagedFliper.setRecordCount(count);
        List<CheckUser> list = new ArrayList<CheckUser>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputTime", OrderType.DESC);
            list = checkUserBo.findCheckUser(user, page);
        }
        Sheet<CheckUser> sheet = new Sheet<CheckUser>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增美女直播间检查用户
	 * @return
	 */
	public String add(){
		logger.info("开始美女直播间检查用户添加");		
		CheckUser user = this.findBean(CheckUser.class,"checkuser");	
		try{
			if(user==null){
				logger.info("美女直播间检查用户为空");
				throw new XLRuntimeException("美女直播间检查用户为空");
			}		
            user.setInputBy(currentUserLogo());
            user.setInputTime(now());
			checkUserBo.insert(user);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 导入数据
	 */
	public void uploadFile(){
		logger.info("开始美女直播间检查用户导入...");		
		String filename = null;
		BufferedReader br = null;
		if(upfile!=null){
			try {
				String type = this.findParameter("one_type");
				filename=FileUploadUtil.upLoadFile(upfile);
				if(filename.indexOf(".txt")==-1){
					throw new XLRuntimeException("只能上传txt文件");
				}
				filename = FILEPATH+filename;
				
				br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filename))));
				String uid = br.readLine();
				Page page = new Page();
				while(uid != null){
					CheckUser checkuser = new CheckUser();
					checkuser.setUid(uid.trim());
					//导入时过滤重复的uid
					List<CheckUser> list = checkUserBo.findCheckUser(checkuser, page);
					if(list != null&& list.size()>=1){
						uid = br.readLine();
						continue;
					}
					checkuser.setType(Integer.parseInt(type));
					checkuser.setInputBy(this.currentUserLogo());
					checkuser.setInputTime(now());
					checkUserBo.insert(checkuser);
					logger.info("import checkuser uid="+uid+",type="+type);
					uid = br.readLine();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}finally{
				try{
					if(br != null){
						br.close();
						br = null;
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			
		}
	}
	
	/**
	 * 删除美女直播间检查用户
	 * @return
	 */
	public String delete(){	
		logger.info("开始自动发放奖品信息总数量");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				checkUserBo.delete(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
