package com.xunlei.niux.manager.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.niux.data.vipgame.bo.ChargeAmountProfileSettingsBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.ChargeAmountProfileSettings;

/**
 * 充值金额档设置业务处理类
 * @author lisu
 * 2012-11-21
 */
public class ChargeAmountProfileSettingsManagedBean extends BaseManagedBean {
    private ChargeAmountProfileSettingsBo chargeAmountProfileSettingsBo;
    private static final Logger logger = Logger.getLogger(ChargeAmountProfileSettingsManagedBean.class.getName());
    private int rownum = 0;
    
    
	public ChargeAmountProfileSettingsManagedBean(){
		chargeAmountProfileSettingsBo =  FacadeFactory.INSTANCE.getChargeAmountProfileSettingsBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	
	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	/**
	 * 查询充值金额档
	 * @return
	 */
	public String getQueryChargeAmountProfileSettingsList(){
		logger.info("开始充值金额档查询");
        this.authenticateRun();//验证运行权限
        ChargeAmountProfileSettings settings = findBean(ChargeAmountProfileSettings.class, "chargeamountprofilesettings");
        PagedFliper pagedFliper = this.getFliper();
        int count = chargeAmountProfileSettingsBo.count(settings);
        pagedFliper.setRecordCount(count);
        List<ChargeAmountProfileSettings> list = new ArrayList<ChargeAmountProfileSettings>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputtime", OrderType.DESC);
            list = chargeAmountProfileSettingsBo.find(settings,page.getPageNo(),page.getPageSize());
        }
        Sheet<ChargeAmountProfileSettings> sheet = new Sheet<ChargeAmountProfileSettings>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增充值金额档
	 * @return
	 */
	public void add(){
		logger.info("开始充值金额档添加");
		this.authenticateAdd();//添加权限
		String limit = findParameter("limit2");		
		try{
			int limitInt = 0;
			if(limit == null||"".equals(limit)){
				limitInt = 4;
			}else{
				limitInt = Integer.parseInt(limit);
			}
		    ChargeAmountProfileSettings settings = findBean(ChargeAmountProfileSettings.class, "chargeamountprofilesettings");				
			if(settings==null){
				logger.info("充值金额档为空");
				throw new XLRuntimeException("充值金额档为空");
			}
			
			//限制充值金额档的个数
			String sql = "select count(*) from chargeamountprofilesettings";
			int count = chargeAmountProfileSettingsBo.queryForInt(sql, new Object[]{});
			if(count>=limitInt){
				logger.info("充值金额档最多只能添加"+limitInt+"条记录");
				throw new XLRuntimeException("充值金额档最多只能添加"+limitInt+"条记录");
			}
			
			//限制充值金额档不能重复
			String disSql = "select count(*) from chargeamountprofilesettings where amount=?";
			int discount = chargeAmountProfileSettingsBo.queryForInt(disSql, new Object[]{settings.getAmount()});
			if(discount > 0){
				logger.info("充值金额档:"+settings.getAmount()+" 已存在");
				throw new XLRuntimeException("充值金额档:"+settings.getAmount()+" 已存在");
			}
			settings.setInputby(currentUserLogo());
			settings.setInputtime(now());
			chargeAmountProfileSettingsBo.insert(settings);
		}catch(Exception e){
			logger.error("添加失败", e);
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
	}
	
	/**
	 * 修改接口人信息
	 * @return
	 */
	public String edit(){
		logger.info("开始充值金额档修改");
		this.authenticateEdit();//编辑权限
		ChargeAmountProfileSettings settings = findBean(ChargeAmountProfileSettings.class, "chargeamountprofilesettings");
		try{
			if(settings==null){
				logger.info("充值金额档为空");
				throw new XLRuntimeException("充值金额档为空");
			}		
			
			//限制充值金额档不能重复
			String sql = "select count(1) from chargeamountprofilesettings where amount=? and seqid<>?";
			int count = chargeAmountProfileSettingsBo.queryForInt(sql, new Object[]{settings.getAmount(),settings.getSeqid()});
			if(count > 0){
				logger.info("充值金额档:"+settings.getAmount()+" 已存在");
				throw new XLRuntimeException("充值金额档:"+settings.getAmount()+" 已存在");
			}
			settings.setEditby(this.currentUserLogo());
			settings.setEdittime(now());
			chargeAmountProfileSettingsBo.update(settings);			
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	/**
	 * 删除接口人信息
	 * @return
	 */
	public String delete(){	
		logger.info("开始充值金额档删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			for(String id:ids)
				chargeAmountProfileSettingsBo.deleteById(new Long(id));			
		}catch(Exception e){
			logger.error("删除失败", e);
			mergeJsmessage("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
}
