package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.niux.data.vipgame.bo.CardRecordDetailBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CardRecordDetail;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.niux.manager.web.vo.CardBiziVo;


/**
 * 会员卡使用记录详情处理类
 * @author lisu
 *  2013-03-13
 */

public class CardRecordDetailManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CardRecordDetailManagedBean.class.getName());
	private CardRecordDetailBo cardRecordDetailBo;
	private int rownum = 0;
	
	public CardRecordDetailManagedBean(){
		cardRecordDetailBo = FacadeFactory.INSTANCE.getCardRecordDetailBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	
	/**
	 * 查询会员卡使用记录详情
	 * @return
	 */
	public String getQueryCardRecordDetailList(){
		logger.info("开始会员卡使用记录详情查询");
        this.authenticateRun();//验证运行权限
        String daytime = findParameter("daytime");
        CardRecordDetail cardRecordDetail = findBean(CardRecordDetail.class, "cardrecorddetail");
        if(daytime != null && !"".equals(daytime))
           cardRecordDetail.setDaytime(daytime);
        PagedFliper pagedFliper = this.getFliper();
        int count = 0;
        List<CardRecordDetail> list = new ArrayList<CardRecordDetail>();

    	rownum = 1;
    	Page page=new Page();
    	page.addOrder("daytime",OrderType.DESC);
    	page.addOrder("actNo",OrderType.ESC);
        list = cardRecordDetailBo.find(cardRecordDetail, page);
        
        if(list == null || list.size()==0)return "";
        CardRecordDetail cardrecorddetail = list.get(0);
        String actNo = cardrecorddetail.getActNo();
        String mydaytime = cardrecorddetail.getDaytime();
        CardBiziVo  card = new CardBiziVo();
        long allCount = 0L;
        List<CardBiziVo> vlist = new ArrayList<CardBiziVo>();
        int i = 0;
        for(CardRecordDetail crd:list){   //行列转换
        	if(!mydaytime.equals(crd.getDaytime())){   
        		vlist.add(card);
        		mydaytime = crd.getDaytime();
        		card = new CardBiziVo();   
        		allCount = 0L;
        	}
        	if(!actNo.equals(crd.getActNo())){
        		vlist.add(card);
                actNo = crd.getActNo();
        		card = new CardBiziVo();  
        		allCount = 0L;
    		}
    		card.setActNo(crd.getActNo());
    		card.setActName(crd.getActName());
    		allCount += crd.getLiveUsedCount();
    		card.setAllCount(allCount);
        	if(crd.getCardType().intValue() == 1){
        		card.setLeaveone(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 2){
        		card.setLeavetwo(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 3){
        		card.setLeavethree(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 5){
        		card.setLeavefive(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 10){
        		card.setLeaveten(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 99){
        		card.setLeaveninenine(crd.getLiveUsedCount());
        	}else if(crd.getCardType().intValue() == 149){
        		card.setLeavefourteennine(crd.getLiveUsedCount());
        	} 
        	
        	if(i==list.size()-1){
        		vlist.add(card);
        	}
        	i++;
        }
        if(vlist == null) count=0;
        else count = vlist.size();
        int pageNo = pagedFliper.getPageNo();
        int pageSize = pagedFliper.getPageSize();
        if(pageNo<=0)pageNo = 1;
        
        pagedFliper.setRecordCount(count);
        
        List<CardBiziVo> result = new ArrayList<CardBiziVo>();
        int pageTotal = count%pageSize==0?count/pageSize:count/pageSize+1;      
        if(pageTotal <= 1){
        	for(int ii=0;ii<count;ii++){
        		result.add(vlist.get(ii));
        	}
        }else{
        	int addcount = count%pageSize==0?pageSize:count%pageSize;
        	if(pageNo <= pageTotal-1)addcount = pageSize;       	
        	for(int ii = (pageNo-1)*pageSize;ii<((pageNo-1)*pageSize+addcount);ii++){
            	result.add(vlist.get(ii));
            }
        }
        
        Sheet<CardBiziVo> sheet = new Sheet<CardBiziVo>(count, result);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始会员卡使用记录详情导出到excel文件");    	
    	//获得页面查询的数据
    	CardRecordDetail cardRecordDetail = findBean(CardRecordDetail.class, "cardrecorddetail");
    	String daytime = findParameter("daytimea");
        if(daytime != null && !"".equals(daytime))
            cardRecordDetail.setDaytime(daytime);
        Page page=new Page();
        page.addOrder("daytime",OrderType.DESC);
    	page.addOrder("actNo",OrderType.ESC);
        List<CardRecordDetail> list = cardRecordDetailBo.find(cardRecordDetail, page);
        List<CardBiziVo> result = new ArrayList<CardBiziVo>();
        if(list != null && list.size()>0){
        	 CardRecordDetail cardrecorddetail = list.get(0);
             String actNo = cardrecorddetail.getActNo();
             String mydaytime = cardrecorddetail.getDaytime();
             CardBiziVo  card = new CardBiziVo();
             long allCount = 0L;
             int i = 0;
             for(CardRecordDetail crd:list){   //行列转换
             	if(!mydaytime.equals(crd.getDaytime())){   
             		result.add(card);
             		mydaytime = crd.getDaytime();
             		card = new CardBiziVo();   
             		allCount = 0L;
             	}
             	if(!actNo.equals(crd.getActNo())){
             		result.add(card);
             		actNo = crd.getActNo();
             		card = new CardBiziVo();  
             		allCount = 0L;
         		}
         		card.setActNo(crd.getActNo());
         		card.setActName(crd.getActName());
         		allCount += crd.getLiveUsedCount();
        		card.setAllCount(allCount);
             	if(crd.getCardType().intValue() == 1){
             		card.setLeaveone(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 2){
             		card.setLeavetwo(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 3){
             		card.setLeavethree(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 5){
             		card.setLeavefive(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 10){
             		card.setLeaveten(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 99){
             		card.setLeaveninenine(crd.getLiveUsedCount());
             	}else if(crd.getCardType().intValue() == 149){
             		card.setLeavefourteennine(crd.getLiveUsedCount());
             	} 
             	
             	if(i==list.size()-1){
         		   result.add(card);
             	}
             	i++;
             } 
        }      
        
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = "会员卡使用记录详情";	    
 	    
 	    List datas = new ArrayList();
 	    String[] columnName = {"业务编号", "业务名称", "1元使用", "2元使用", "3元使用", "5元使用", "10元使用", "9.9元使用", "14.9元使用","共计"};
 	    for(CardBiziVo cur:result){
 	    	List lista = new ArrayList();
 	    	lista.add(cur.getActNo());
 	    	lista.add(cur.getActName());
 	    	lista.add(cur.getLeaveone());
 	    	lista.add(cur.getLeavetwo());
 	    	lista.add(cur.getLeavethree());
 	    	lista.add(cur.getLeavefive());
 	    	lista.add(cur.getLeaveten());
 	    	lista.add(cur.getLeaveninenine());
 	    	lista.add(cur.getLeavefourteennine());
 	    	lista.add(cur.getAllCount());
 	    	datas.add(lista);
 	    }
 	    
		String filePath = "/tmp/cardrecorddetail.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("会员卡使用记录详情",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now()+"_cardrecorddetail.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
	
		
		
}
