package com.xunlei.niux.manager.web.model;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.xunlei.niux.gameoffical.template.v2.builder.DataUtil;
import com.xunlei.niux.manager.web.util.DateUtil;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.common.vo.LibClassM;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.CallRecordBo;
import com.xunlei.niux.data.vipgame.bo.CustomerDetailQueryBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CallRecord;
import com.xunlei.niux.data.vipgame.vo.CustomerBigPayQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerQuery;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.manager.web.util.ExcelUtil;
import com.xunlei.util.StringTools;


/**
 * 外呼记录业务处理类
 * @author lisu
 *
 */
public class CallRecordManagedBean extends BaseManagedBean {
	private static final Logger logger = Logger.getLogger(CallRecordManagedBean.class.getName());
	private CallRecordBo callRecordBo;
	private CustomerDetailQueryBo customerDetailQueryBo;
	private int rownum = 0;
	 //外呼类别
    private Map<Integer,String> callTypeMap;  
	//接听状态
    private Map<Integer,String> listenStatusMap;
    private Map<String,Object> callRecordMap = null;
    private BaseSo baseSo = null;
    private static final Page bigpage = new Page();
    
	
	public CallRecordManagedBean(){
		callRecordBo = FacadeFactory.INSTANCE.getCallRecordBo();
		baseSo = FacadeFactory.INSTANCE.getBaseSo();
		customerDetailQueryBo = FacadeFactory.INSTANCE.getCustomerDetailQueryBo();
		//初始化行号
		int pageNo=this.getFliper().getPageNo();
		int pageSize=this.getFliper().getPageSize();
		rownum=rownum+(pageNo-1)*pageSize+1;
	}
	

	public int getRownum() {
		return rownum++;
	}

	public void setRownum(int rownum) {
		this.rownum = rownum;
	}
	
	public Map getCallRecordData(){
		long seqid = this.findParamLong("seqid");
		CallRecord cr = callRecordBo.findById(seqid);
		if(cr ==null )return null;
		HttpServletRequest request = getHttpServletRequest();
		HttpSession session = request.getSession();
		callRecordMap = (Map)session.getAttribute("callrecorddata");
		if(callRecordMap == null){
			callRecordMap = new HashMap<String,Object>();
			callRecordMap.put("seqid", cr.getSeqid());
			callRecordMap.put("uid", cr.getUid());
			callRecordMap.put("account", cr.getAccount());
			callRecordMap.put("gameId", cr.getGameId());
			callRecordMap.put("callTime", cr.getCallTime());
			callRecordMap.put("customerServiceName", cr.getCustomerServiceName());
			callRecordMap.put("callType", cr.getCallType());
			callRecordMap.put("listenStatus", cr.getListenStatus());
			callRecordMap.put("serverId", cr.getServerId());
			callRecordMap.put("roleName", cr.getRoleName());
			callRecordMap.put("roleGrade", cr.getRoleGrade());
			callRecordMap.put("lastLoginTime", cr.getLastLoginTime());
			callRecordMap.put("leaveGameReason", cr.getLeaveGameReason());
			callRecordMap.put("gift", cr.getGift());
			callRecordMap.put("suggest", cr.getSuggest());
			callRecordMap.put("question", cr.getQuestion());
			callRecordMap.put("remark", cr.getRemark());
			session.setAttribute("callrecorddata", callRecordMap);
		}else{
			long cseqid = (Long)(callRecordMap.get("seqid"));
			if(cseqid == seqid)return callRecordMap;
			else{
				callRecordMap = new HashMap<String,Object>();
				callRecordMap.put("seqid", cr.getSeqid());
				callRecordMap.put("uid", cr.getUid());
				callRecordMap.put("account", cr.getAccount());
				callRecordMap.put("gameId", cr.getGameId());
				callRecordMap.put("callTime", cr.getCallTime());
				callRecordMap.put("customerServiceName", cr.getCustomerServiceName());
				callRecordMap.put("callType", cr.getCallType());
				callRecordMap.put("listenStatus", cr.getListenStatus());
				callRecordMap.put("serverId", cr.getServerId());
				callRecordMap.put("roleName", cr.getRoleName());
				callRecordMap.put("roleGrade", cr.getRoleGrade());
				callRecordMap.put("lastLoginTime", cr.getLastLoginTime());
				callRecordMap.put("leaveGameReason", cr.getLeaveGameReason());
				callRecordMap.put("gift", cr.getGift());
				callRecordMap.put("suggest", cr.getSuggest());
				callRecordMap.put("question", cr.getQuestion());
				callRecordMap.put("remark", cr.getRemark());
				session.setAttribute("callrecorddata", callRecordMap);
			}
		}
		return callRecordMap;
	}
	
	/**
	 * 查询外呼记录
	 * @return
	 */
	public String getQueryCallRecordList(){
		logger.info("开始外呼记录查询");
        this.authenticateRun();//验证运行权限
        CallRecord record = findBean(CallRecord.class, "callrecord");
        if(record !=null){
        	if(record.getCallType() != null && record.getCallType().intValue()==0){
        		record.setCallType(null);
        	}
        	if(record.getListenStatus() != null && record.getListenStatus().intValue()==0){
        		record.setListenStatus(null);
        	}
        	if(record.getSeqid() != null&&record.getSeqid().longValue()==0){
        		record.setSeqid(null);
        	}
        }
        PagedFliper pagedFliper = this.getFliper();
        int count = callRecordBo.count(record);
        pagedFliper.setRecordCount(count);
        List<CallRecord> list = new ArrayList<CallRecord>();
        if (count > 0) {
        	rownum = 1;
        	Page page=new Page();
        	page.setPageNo(pagedFliper.getPageNo());
        	page.setPageSize(pagedFliper.getPageSize());
        	page.addOrder("inputtime", OrderType.DESC);
            list = callRecordBo.find(record,page.getPageNo(),page.getPageSize());
        }
        Sheet<CallRecord> sheet = new Sheet<CallRecord>(count, list);
        this.mergePagedDataModel(sheet, pagedFliper);
        return "";
	}
	
	/**
	 * 新增外呼记录
	 * @return
	 */
	public String add(){
		logger.info("开始外呼记录添加");
		this.authenticateAdd();//添加权限
		CallRecord record=this.findBean(CallRecord.class,"callrecord");		
		try{
			if(record==null){
				logger.info("外呼记录为空");
				throw new XLRuntimeException("外呼记录为空");
			}
			String one_listenStatus = findParameter("one_listenStatus");
			record.setListenStatus(Integer.parseInt(one_listenStatus));		
			record.setCallTime(now());
			//处理用户请求
			processUser(record);					
		}catch(Exception e){
			logger.error("添加失败", e);
			e.printStackTrace();
			mergeJsmessage("添加失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	private List<String> processUser(CallRecord record) throws XLRuntimeException{
		  String uid = record.getUid().trim();		
		  List<String> list = new ArrayList<String>(); 
		  StringBuilder builder = new StringBuilder("(");
		  gather(uid,builder,list);
		  List<CustomerDetailQuery> cdqlist = queryInCustomerDetailQuery(builder);
	      String notCustomerService = findNotCustomerService(list,cdqlist);
	      if(notCustomerService.length()>0){
	    	  throw new XLRuntimeException("uid："+notCustomerService+"，不是自己专属的客户");
	      }else if((notCustomerService=hasCall(list,cdqlist)).length()>0){
              throw new XLRuntimeException("uid："+notCustomerService+"，15天内有其他人外呼记录");
          }else{
	    	  insertOrUpdate(cdqlist,record);
	      }
	    return list;
	}
	
	
	private void insertOrUpdate(List<CustomerDetailQuery> cdqlist, CallRecord record){
		for(CustomerDetailQuery cdq:cdqlist){
			String uid = cdq.getUid();
			record.setCustomerServiceName(currentUserInfo().getTrueName());
			record.setInputby(currentUserLogo());
			record.setInputtime(now());
			record.setUid(uid);
			callRecordBo.insert(record);
			
			//更新客户查询中的外呼记录			
			CallRecord callRecord = new CallRecord();
			callRecord.setUid(uid);
			int count = callRecordBo.count(callRecord);
			
			//更新大客户中的最后外呼信息
			updateCustomerDetailQuery(cdq,record,count);
			
			//更新新增查询中时间最大的那条外呼记录
			updateAddCustomer(uid,count);
		    
		    //更新最后外呼时间到大额充值中
			updateBigPay(cdq.getUid(),record);
		}
	}
	
	
	private List<CustomerDetailQuery> queryInCustomerDetailQuery(StringBuilder builder){
		  String sql = "select * from customerdetailquery where uid in "+builder;
	      List<CustomerDetailQuery> cdqlist  = FacadeFactory.INSTANCE.getCustomerDetailQueryBo().findBySql(CustomerDetailQuery.class, sql, new ArrayList());
	      return cdqlist;
	}
	
	private void gather(String uid, StringBuilder builder,List<String> list){
		  uid = uid.replaceAll("，", ",");
	      if(uid.indexOf(",")==-1){
	    	  builder.append("'").append(uid).append("'");
	    	  list.add(uid);
	      }else{
	    	  String ids[] = uid.split(",");
		      for(String id:ids){
		    	  if(StringTools.isEmpty(id))continue;		
		    	  builder.append("'").append(id.trim()).append("',");
		    	  list.add(id.trim());
		      }
		      builder.append("''"); 
	      }
	      builder.append(")");	      
	}
	
	
	private String findNotCustomerService(List<String> list,List<CustomerDetailQuery> cdqlist){
		   StringBuilder builder = new StringBuilder();
		   if(cdqlist != null&&cdqlist.size()==1)return builder.toString();//单个录入，不需要验证专属客户
		   String userName = this.currentUserInfo().getTrueName();
		   for(String li:list){
			     boolean flag = false;
		    	  for(CustomerDetailQuery cdq:cdqlist){
		    		  if(cdq.getUid().trim().equals(li.trim())){
		    			  String customerService = cdq.getCustomerService();
		    			  if(!StringTools.isEmpty(customerService)){
		    				  if(customerService.equals(userName)){//如果添加者和专属客服是同一人
				    			  flag = true;
		    				  }
		    			  }else{//如果没有录入专属客服
		    				  flag = true;
		    			  }
		    		  }
		    	  }
		    	  if(!flag){
		    		  builder.append(li).append(",");
		    	  }
		    }
	    return builder.toString();
	}

    /**
     * 有专属且15天内有外呼记录的玩家不可再次添加外呼记录
     */
	private String hasCall(List<String> list,List<CustomerDetailQuery> cdqlist){
		   StringBuilder builder = new StringBuilder();
		   for(String li:list){
		    	  for(CustomerDetailQuery cdq:cdqlist){
		    		  if(cdq.getUid().trim().equals(li.trim())){
		    			  String lastCallTime = cdq.getLastCallTime();
                          String cs = cdq.getCustomerService();
		    			  if(StringTools.isNotEmpty(lastCallTime)
                                  && StringTools.isNotEmpty(cs)
                                  && !cs.equals(this.currentUserInfo().getTrueName())
                                  && DateUtil.compareTime(DateUtil.formatNowByDefault(),lastCallTime)<=15){
                              builder.append(li).append(",");
                          }
                      }
                  }
           }
	    return builder.toString();
	}
		
	private void updateCustomerDetailQuery(CustomerDetailQuery cdq,CallRecord record,int count){
		cdq.setCallCount(count);//外呼次数
		cdq.setLastCaller(record.getCustomerServiceName());//最后外呼人
		cdq.setLastCallTime(record.getCallTime());//最后外呼时间

        //专属客服自动默认为对当前账号有3个外呼记录且最后外呼人的客服所有
        CallRecord crQuery = new CallRecord();
        crQuery.setUid(record.getUid());
        crQuery.setCustomerServiceName(record.getCustomerServiceName());
        if(baseSo.countObject(crQuery)>=3){
            cdq.setCustomerService(record.getCustomerServiceName());
        }

		customerDetailQueryBo.update(cdq);		
	}
	
	private void updateAddCustomer(String uid,int count){
		CustomerQuery query = new CustomerQuery();
		query.setType(new Integer(1));
		query.setUid(uid);
	    Page page = new Page();
	    page.addOrder("daytime", OrderType.DESC);
	    List<CustomerQuery> cqlist = baseSo.findObjects(query, page);
		if(cqlist != null&&cqlist.size()>0){
			CustomerQuery cq = cqlist.get(0);
			cq.setCallCount(count);//外呼次数
			baseSo.updateObjectById(cq);
		}			
	}
	
	private void updateBigPay(String uid,CallRecord record){
		    CustomerBigPayQuery cbpq = new CustomerBigPayQuery();
		    cbpq.setUid(uid);
		    bigpage.addOrder("daytime", OrderType.DESC);
		    List<CustomerBigPayQuery> cbpqlist = baseSo.findObjects(cbpq, bigpage);
		    int index = 0;
		    for(CustomerBigPayQuery cb:cbpqlist){
		    	if(index>5)break;
		    	cb.setLastCallTime(record.getCallTime());
		    	cb.setLastCaller(record.getCustomerServiceName());
		    	baseSo.updateObjectById(cb);
		    	index++;
		    }
	}
	
	
	/**
	 * 修改接口人信息
	 * @return
	 */
	public String edit(){
		logger.info("开始外呼记录修改");
		this.authenticateEdit();//编辑权限
		CallRecord record=this.findBean(CallRecord.class,"callrecord");
		try{
			if(record==null){
				logger.info("外呼记录为空");
				throw new XLRuntimeException("外呼记录为空");
			}	
			
			String one_listenStatus = findParameter("one_listenStatus");
			record.setListenStatus(Integer.parseInt(one_listenStatus));
		    String uid = record.getUid().trim();			
		    Page page = new Page();
			//查询客户
			CustomerDetailQuery customer = new CustomerDetailQuery();
			customer.setUid(uid);
			List<CustomerDetailQuery> cdqlist = customerDetailQueryBo.find(customer, page);
			if(cdqlist == null || cdqlist.size()==0){
				logger.info("增加外呼记录时填写的UID，在系统中不存在");
				throw new XLRuntimeException("增加外呼记录时填写的UID，在系统中不存在");
			}
			
			record.setEditby(this.currentUserLogo());
			record.setEdittime(now());
			callRecordBo.update(record);		
			
			//更新客户查询中的外呼记录			
			CustomerDetailQuery cdq = cdqlist.get(0);
			updateCustomerDetailQuery(cdq,record,cdq.getCallCount().intValue());
			 //更新最后外呼时间到大额充值中
			updateBigPay(cdq.getUid(),record);
		}catch(Exception e){
			logger.error("修改失败", e);
			mergeJsmessage("修改失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	private void checkDelUser(String []ids) throws XLRuntimeException{
        if("wuzhenli".equals(this.currentUserLogo())){
            return;
        }
        for(String id:ids){
            CallRecord record = FacadeFactory.INSTANCE.getBaseSo().findById(CallRecord.class, id);
            if(record == null)continue;
            String userName = this.currentUserInfo().getTrueName();
			if(!record.getCustomerServiceName().equals(userName)){
				throw new XLRuntimeException("非自己外呼的单不能删除");
			}
		}
	}
	
	/**
	 * 删除接口人信息
	 * @return
	 */
	public String delete(){	
		logger.info("开始外呼记录删除");
		this.authenticateDel();//删除权限
		String delseqids = findParameter("delseqids");		
		try{
			String ids[] = delseqids.split(",");
			checkDelUser(ids);
			for(String id:ids){
				  callRecordBo.deleteById(new Long(id));			
			}		 
		}catch(Exception e){
			logger.error("删除失败", e);
			alertJS("删除失败，原因：" + e.getMessage());
		}
		return "";
	}
	
	
	/**
	 * 更新外呼后登录时间 和 充值金额
	 * @return
	 */
	public String update(){
		logger.info("开始外呼记录一键添加");
		this.authenticateEdit();//编辑权限
		String updateseqid = this.findParameter("updateseqid");		
		CallRecord record = callRecordBo.findById(Long.parseLong(updateseqid));
        try {
        	if(record == null){
        		throw new XLRuntimeException("该外呼记录不存在");
        	}
        	record.setSeqid(null);
        	record.setCallTime(now());
        	processUser(record);
        }catch(Exception e){
        	mergeJsmessage("一键添加失败，原因：" + e.getMessage());
        }      
		return "";
	}
	
	 /**
	  * 获得基础数组中配置的外呼类别列表
	  * @return
	  */
	 public List getCallType(){
	        List list = (List)getRequestAttribute("callType");
	        if(list == null){
	            List datas = LibClassM.getLibClassDList("callType");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("callType", list);
	        }
	        return list;
	 }
	
	 /**
     * 从基础数组数据中取得外呼类别
     * @return
     */
    public Map<Integer, String> getCallTypeMap() {
        if(callTypeMap==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("callType");
            if(list!=null){           	
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.parseInt(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            callTypeMap=tempMap;
        }
        return callTypeMap;

    }
    
    /**
	  * 获得基础数组中配置的接听状态列表
	  * @return
	  */
	 public List getListenStatus(){
	        List list = (List)getRequestAttribute("listenStatus");
	        if(list == null){
	            List datas = LibClassM.getLibClassDList("listenStatus");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	String itemno = ((LibClassD)datas.get(i)).getItemno();
	            	int id = Integer.parseInt(itemno);
	            	if(id<=9)
	            	   list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("listenStatus", list);
	        }
	        return list;
	 }
	 public List getListenStatus2(){
	        List list = (List)getRequestAttribute("listenStatus2");
	        if(list == null){
	            List datas = LibClassM.getLibClassDList("listenStatus");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	String itemno = ((LibClassD)datas.get(i)).getItemno();
	            	int id = Integer.parseInt(itemno);
	            	if(id>=10)
	            	   list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("listenStatus2", list);
	        }
	        return list;
	 }
    
	 public List getListenStatusAll(){
	        List list = (List)getRequestAttribute("listenStatusAll");
	        if(list == null){
	            List datas = LibClassM.getLibClassDList("listenStatus");
	            list = new ArrayList(datas.size());
	            for(int i = 0; i < datas.size(); i++){
	            	String itemno = ((LibClassD)datas.get(i)).getItemno();
	            	int id = Integer.parseInt(itemno);
	            	if(id == 9){
	            		list.add(new SelectItem("", "--------------")); 	
	            	}
	            	list.add(new SelectItem(((LibClassD)datas.get(i)).getItemno(), ((LibClassD)datas.get(i)).getItemname())); 	
	            }	                
	            setRequestAttribute("listenStatusAll", list);
	        }
	        return list;
	 }
	 
    /**
     * 从基础数组数据中取得接听状态
     * @return
     */
    public Map<Integer, String> getListenStatusMap() {
        if(listenStatusMap==null){
            Map<Integer, String> tempMap=new HashMap<Integer,String>();
            List<LibClassD> list=IFacadeCommon.INSTANCE.getLibClassDByClassNo("listenStatus");
            if(list!=null){           	
                for(LibClassD libClassD:list){
                    tempMap.put(Integer.parseInt(libClassD.getItemno()), libClassD.getItemname());
                }
            }
            listenStatusMap=tempMap;
        }
        return listenStatusMap;

    }
    
    
    /**
     * 将查询的数据导到excel中
     */
    public void export(){
    	logger.info("开始外呼记录导出到excel文件");
    	
    	//获得页面查询的数据
    	CallRecord record = findBean(CallRecord.class, "callrecord");	
    	if(record !=null){
        	if(record.getCallType() != null && record.getCallType().intValue()==0){
        		record.setCallType(null);
        	}
        	if(record.getListenStatus() != null && record.getListenStatus().intValue()==0){
        		record.setListenStatus(null);
        	}
        	if(record.getSeqid() != null&&record.getSeqid().longValue()==0){
        		record.setSeqid(null);
        	}
        }
    	List<CallRecord> crlist = callRecordBo.find(record, 0, 0);
    	
    	//获得系统当前时间
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
		String now = sdf.format(new Date()); 
		StringBuffer sb = new StringBuffer();
		if(record.getFromcallTime() != null&&!"".equals(record.getFromcallTime())){
			if(record.getTocallTime() != null&&!"".equals(record.getTocallTime())){
				sb.append(record.getFromcallTime()).append("-").append(record.getTocallTime()).append("日");
			}else{
				sb.append(record.getFromcallTime()).append("-").append("至今");
			}
		}else{
             if(record.getTocallTime() != null&&!"".equals(record.getTocallTime())){
				sb.append("截止").append(record.getTocallTime()).append("日");
			}else{
				sb.append("所有");
			}
		}
    	FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse) facesContext.getExternalContext().getResponse();
		//更新标题
 	    String title = sb+"外呼记录";	    
 	    Map<Integer, String> listenStatusMap = getListenStatusMap();
 	    Map<Integer, String> callTypeMap = getCallTypeMap();
 	    Games games = new Games();
 	    Page page = new Page();
 	    List<Games> gamelist = FacadeFactory.INSTANCE.getGamesBo().findGames(games, page);
 	    List datas = new ArrayList();
 	    for(CallRecord cr:crlist){
 	    	List list = new ArrayList();
 	    	list.add(cr.getUid());
 	    	list.add(cr.getAccount());
 	    	list.add(getGameName(cr.getGameId(),gamelist));
 	    	list.add(callTypeMap.get(cr.getCallType()));
 	    	list.add(listenStatusMap.get(cr.getListenStatus()));
 	    	list.add(cr.getCallTime());
 	    	list.add(cr.getInputtime());
 	    	list.add(cr.getCustomerServiceName());
 	    	list.add(cr.getEdittime());
 	    	list.add(cr.getEditby());
 	    	list.add(cr.getRebateCount());
 	    	list.add(cr.getMoney());
 	    	list.add(cr.getRebateMoney());
 	    	list.add(cr.getServerId());
 	    	list.add(cr.getRoleName());
 	    	list.add(cr.getRoleGrade());
 	    	list.add(cr.getLastLoginTime());
 	    	list.add(cr.getLeaveGameReason());
 	    	list.add(cr.getGift());
 	    	list.add(cr.getSuggest());
 	    	list.add(cr.getQuestion());
 	    	list.add(cr.getRemark());	 
 	    	datas.add(list);
 	    }	    
 	    //生成数据到excel中
		String[] columnName = {"UID", "迅雷账号", "游戏", "外呼类别","接听状态","外呼时间","记录添加时间","外呼人","修改时间","修改人","返利笔数","充值总金额","返利总金额","服务器编号","角色名称","等级","最后登录时间","离开游戏原因","赠送礼包","玩家建议","玩家问题与需求","备注"};
		String filePath = "/tmp/callrecord.xls";
		long beginTime = System.currentTimeMillis();
		Workbook wb = ExcelUtil.create("外呼记录",title,columnName,filePath,datas);
		long endTime = System.currentTimeMillis();
		logger.info("生成excel文件花费："+(endTime-beginTime)+"ms");
    	
        //弹出下载窗口
		response.setHeader("Content-disposition", "attachment;filename="+now+"_callrecorddata.xls"); 
		response.setContentType("application/x-download");
		OutputStream ouputStream = null;
		try {
			ouputStream = response.getOutputStream();
			wb.write(ouputStream);  
		} catch (IOException e) {
			e.printStackTrace();
		}   						
		FacesContext.getCurrentInstance().responseComplete();	   
    }
    
    /**
     * 根据游戏id查询游戏名称
     * @param gameId
     * @param gameList
     * @return
     */
    private String getGameName(String gameId,List<Games> gameList){
    	if(gameId == null||gameList==null)return "";
    	for(Games games:gameList){
    		if(games.getGameId().trim().equals(gameId.trim())){
    			return games.getGameName();
    		}
    	}
    	return "";
    }
    
    static class CallRecordJson{
    	private String logintime;
    	private long paytotal;
		public String getLogintime() {
			return logintime;
		}
		public void setLogintime(String logintime) {
			this.logintime = logintime;
		}
		public long getPaytotal() {
			return paytotal;
		}
		public void setPaytotal(long paytotal) {
			this.paytotal = paytotal;
		}	
    }

	public Map<String, Object> getCallRecordMap() {
		return callRecordMap;
	}


	public void setCallRecordMap(Map<String, Object> callRecordMap) {
		this.callRecordMap = callRecordMap;
	}

}
